package com.ejianc.business.promaterial.order.api;

import com.ejianc.business.promaterial.order.hystrix.OrderHystrix;
import com.ejianc.business.promaterial.order.vo.WriteBackVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@FeignClient(
        name = "ejc-promaterial-web",
        url = "${common.env.feign-client-url}",
        path = "ejc-promaterial-web",
        fallback = OrderHystrix.class
)
public interface IOrderApi {

    /**
     * 回写占用量
     * @param vo
     * @return
     */
    @RequestMapping(value = {"/api/order/writeBackOccupyNum"}, method = {RequestMethod.POST})
    CommonResponse<String> writeBackOccupyNum(@RequestBody WriteBackVO vo);
}
