package com.ejianc.business.promaterial.out.vo;

import com.ejianc.business.promaterial.check.vo.WeighUnitEnum;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 领料方式，1-分包领料,2-内部领料
 */
public enum ClaimTypeEnum {

    分包领料(1,"分包领料"),
    内部领料(2,"内部领料");


    private Integer code;
    private String description;
    private static Map<Integer, ClaimTypeEnum> enumMap = new HashMap<>();

    ClaimTypeEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }


    public String getDescription() {return description;}
    public Integer getCode() {
        return code;
    }

    static {
        enumMap = EnumSet.allOf(ClaimTypeEnum.class).stream().collect(Collectors.toMap(ClaimTypeEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static ClaimTypeEnum getEnumByStateCode(Integer code) {
        return enumMap.get(code);
    }


}

