package com.ejianc.business.promaterial.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;


/**
 * 物资月计划子表
 * 
 * @author generator
 * 
 */
public class MonthPlanDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long materialMonthPlanId; // 所属总计划Id
    private Long materialCategoryId; // 物资分类Id
    private String materialCategoryName; // 物资分类名称
    private Long materialId; // 物资Id
    private String materialName; // 物资名称
    private String spec; // 规格型号
    private String unit; // 计量单位
    private BigDecimal monthPlanNum; // 月计划数量
    private BigDecimal monthPlanPrice; // 月计划单价
    private BigDecimal monthPlanMny; // 月计划金额
    private Integer sourceType; // 来源类型 1：总计划，2：物料档案
    private Integer sourceName; // 来源名称 1：总计划，2：物料档案
    private String remark; // 备注
    @ApiModelProperty("参照树名称(月份+编码)")
    private String name;
    private String materialCode; // 物料编码
    private BigDecimal surplusNums; // 剩余数量
    private Long sourceId; // 来源Id
    private Long unitId; // 计量单位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 需用日期
    private String construction; // 使用部位
    private Integer firstState; // 是否为一级采购目录清单：0-否，1-是
    private String texture; // 材质
    private String itemDesc; // 物料描述
    private String planCode; // 计划编号

    private String errorMessage;// 导入失败原因
    public String onlyKey;// 唯一的key需要使用方自己构建
    private Integer matchStatus; // 匹配状态：0-未匹配，1-已匹配，2-模糊匹配，
    private String matchStatusDescription;


    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public BigDecimal getSurplusNums() {
        return surplusNums;
    }

    public void setSurplusNums(BigDecimal surplusNums) {
        this.surplusNums = surplusNums;
    }
    /**
     * 物资编码
     */
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public Integer getSourceName() {
        return sourceName;
    }

    public void setSourceName(Integer sourceName) {
        this.sourceName = sourceName;
    }

    /**
     * 参照树名称
     */
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    /**
     * 所属总计划Id
     */
    public Long getMaterialMonthPlanId() {
        return materialMonthPlanId;
    }

    /**
     * 所属总计划Id
     */
    public void setMaterialMonthPlanId(Long materialMonthPlanId) {
        this.materialMonthPlanId = materialMonthPlanId;
    }
    /**
     * 物资分类Id
     */
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    /**
     * 物资分类Id
     */
    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    /**
     * 物资分类名称
     */
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    /**
     * 物资分类名称
     */
    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    /**
     * 物资Id
     */
    @ReferSerialTransfer(referCode = "Material001")
    public Long getMaterialId() {
        return materialId;
    }

    /**
     * 物资Id
     */
    @ReferDeserialTransfer
    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 规格型号
     */
    public String getSpec() {
        return spec;
    }

    /**
     * 规格型号
     */
    public void setSpec(String spec) {
        this.spec = spec;
    }
    /**
     * 计量单位
     */
    public String getUnit() {
        return unit;
    }

    /**
     * 计量单位
     */
    public void setUnit(String unit) {
        this.unit = unit;
    }
    /**
     * 月计划数量
     */
    public BigDecimal getMonthPlanNum() {
        return monthPlanNum;
    }

    /**
     * 月计划数量
     */
    public void setMonthPlanNum(BigDecimal monthPlanNum) {
        this.monthPlanNum = monthPlanNum;
    }
    /**
     * 月计划单价
     */
    public BigDecimal getMonthPlanPrice() {
        return monthPlanPrice;
    }

    /**
     * 月计划单价
     */
    public void setMonthPlanPrice(BigDecimal monthPlanPrice) {
        this.monthPlanPrice = monthPlanPrice;
    }
    /**
     * 月计划金额
     */
    public BigDecimal getMonthPlanMny() {
        return monthPlanMny;
    }

    /**
     * 月计划金额
     */
    public void setMonthPlanMny(BigDecimal monthPlanMny) {
        this.monthPlanMny = monthPlanMny;
    }

    /**
     * 物资来源
     */
    public Integer getSourceType() {
        return sourceType;
    }
    /**
     * 物资来源
     */
    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }

    /**
     * 备注
     */
    public String getRemark() {
        return remark;
    }

    /**
     * 备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }

    public Integer getFirstState() {
        return firstState;
    }

    public void setFirstState(Integer firstState) {
        this.firstState = firstState;
    }

    public String getTexture() {
        return texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public String getItemDesc() {
        return itemDesc;
    }

    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getOnlyKey() {
        return onlyKey;
    }

    public void setOnlyKey(String onlyKey) {
        this.onlyKey = onlyKey;
    }

    public Integer getMatchStatus() {
        return matchStatus;
    }

    public void setMatchStatus(Integer matchStatus) {
        this.matchStatus = matchStatus;
    }

    public String getMatchStatusDescription() {
        return matchStatusDescription;
    }

    public void setMatchStatusDescription(String matchStatusDescription) {
        this.matchStatusDescription = matchStatusDescription;
    }
}
