package com.ejianc.business.promaterial.plan.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 单项采购计划子表
 * 
 * @author generator
 * 
 */
public class SinglePlanDetailVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Long planId; // 主表主键
    private Long materialCategoryId; // 物资分类Id
    private String materialCategoryName; // 物资分类名称
    private Long materialId; // 物料Id
    private String materialName; // 物料名称
    private String materialCode; // 物料编码
    private String spec; // 规格型号
    private String unit; // 计量单位
    private Long unitId; // 计量单位Id
    private BigDecimal nums; // 采购计划量
    private Long sourceType; // 来源类型 0：总计划，1：月计划 2:物料档案
    private Long sourceId; // 来源Id
    private String memo; // 备注
    private BigDecimal checkNum; // 累计进场数量
    private BigDecimal occupyNums; // 占用数量
    private BigDecimal actualNums; // 实际数量
    private BigDecimal surplusNums; // 剩余数量
    private BigDecimal planSurplusNums; // 计划剩余数量（总计划/月计划-数量）
    private BigDecimal price; // 计划单价
    private Long constructionId; // 使用部位主键
    private String construction; // 使用部位
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 需用日期                      -- 到货日期
    private Integer firstState; // 是否为一级采购目录清单：0-否，1-是
    private String texture; // 材质
    private String standard; // 技术标准
    private String planCode; // 需用计划编号
    private Long buyerId; // 采购员
    private String buyerName; // 采购员名称

    private BigDecimal planNumsSum; // 需求数量
    private BigDecimal occupyNumsSum; // 占用数量
    private BigDecimal surplusNumsSum; // 剩余数量
    private Long parentId; // parent_id
    private Long tid;
    private BigDecimal taxPrice; // 单价
    private BigDecimal taxRate; // 税率
    private BigDecimal mny; // 金额(无税)
    private BigDecimal taxMny; // 金额
    private BigDecimal planNum; // 需用计划量

    private List<SinglePlanDetailVO> planDetail = new ArrayList<>();
    

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public BigDecimal getNums() {
        return nums;
    }

    public void setNums(BigDecimal nums) {
        this.nums = nums;
    }
    public Long getSourceType() {
        return sourceType;
    }

    public void setSourceType(Long sourceType) {
        this.sourceType = sourceType;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }
    public BigDecimal getOccupyNums() {
        return occupyNums;
    }

    public void setOccupyNums(BigDecimal occupyNums) {
        this.occupyNums = occupyNums;
    }
    public BigDecimal getSurplusNums() {
        return surplusNums;
    }

    public void setSurplusNums(BigDecimal surplusNums) {
        this.surplusNums = surplusNums;
    }
    public BigDecimal getPlanSurplusNums() {
        return planSurplusNums;
    }

    public void setPlanSurplusNums(BigDecimal planSurplusNums) {
        this.planSurplusNums = planSurplusNums;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getConstructionId() {
        return constructionId;
    }

    @ReferDeserialTransfer
    public void setConstructionId(Long constructionId) {
        this.constructionId = constructionId;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    public Integer getFirstState() {
        return firstState;
    }

    public void setFirstState(Integer firstState) {
        this.firstState = firstState;
    }

    public String getTexture() {
        return texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public String getStandard() {
        return standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getBuyerId() {
        return buyerId;
    }

    @ReferDeserialTransfer
    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public BigDecimal getPlanNumsSum() {
        return planNumsSum;
    }

    public void setPlanNumsSum(BigDecimal planNumsSum) {
        this.planNumsSum = planNumsSum;
    }

    public BigDecimal getOccupyNumsSum() {
        return occupyNumsSum;
    }

    public void setOccupyNumsSum(BigDecimal occupyNumsSum) {
        this.occupyNumsSum = occupyNumsSum;
    }

    public BigDecimal getActualNums() {
        return actualNums;
    }

    public void setActualNums(BigDecimal actualNums) {
        this.actualNums = actualNums;
    }

    public BigDecimal getSurplusNumsSum() {
        return surplusNumsSum;
    }

    public void setSurplusNumsSum(BigDecimal surplusNumsSum) {
        this.surplusNumsSum = surplusNumsSum;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public BigDecimal getPlanNum() {
        return planNum;
    }

    public void setPlanNum(BigDecimal planNum) {
        this.planNum = planNum;
    }

    public List<SinglePlanDetailVO> getPlanDetail() {
        return planDetail;
    }

    public void setPlanDetail(List<SinglePlanDetailVO> planDetail) {
        this.planDetail = planDetail;
    }
}
