package com.ejianc.business.promaterial.plan.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;


/**
 * 使用计划实体
 * 
 * @author generator
 * 
 */
public class SinglePlanDetailRefVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private Long parentId; // parent_id
    private Long tid;
    private String planName; // 使用计划名称
    private String planBillCode; // 计划编码
    private String planEmployeeName;//经办人
    private Long planDetailId;//子表明细
    private String billStateName; // 单据名称
    private Long projectId; // 项目
    private Long materialId; // 物资主键
    private String projectName; // 项目名称
    private Long orgId; // 组织
    private String orgName; // 组织名称
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate; // 计划使用日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate; // 创建日期
    private Long constructionId; // 使用部位主键
    private String construction; // 施工部位
    private String memo; // 备注
    private String materialName; // 物资名称
    private Integer billState; // 单据状态（审批必须字段）
    private Long planId; // 主表主键ID
    private Long materialTypeId; // 物资类别
    private String materialTypeName; // 物资类别名称
    private String materialCode; // 物料编码
    private String unit; // 单位
    private String spec; // 规格型号
    private BigDecimal planNumsSum; // 需求数量
    private BigDecimal occupyNums; // 占用数量
    private BigDecimal surplusNumsSum; // 剩余数量
    private BigDecimal orderNumsSum; // 订单数量
    private String sourceName; // 来源
    private Long unitId; // 计量单位
    private Integer firstState; // 是否为一级采购目录清单：0-否，1-是
    private String texture; // 材质
    private String standard; // 技术标准
    private String planCode; // 需用计划编号
    private Date orderExpiryDate; // 到货日期
    private Long buyerId; // 采购员
    private String buyerName; // 采购员名称
    private BigDecimal taxPrice; // 单价
    private BigDecimal taxRate; // 税率
    private BigDecimal mny; // 金额(无税)
    private BigDecimal taxMny; // 金额


    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getSourceName() {
        return sourceName;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public BigDecimal getOrderNumsSum() {
        return orderNumsSum;
    }

    public void setOrderNumsSum(BigDecimal orderNumsSum) {
        this.orderNumsSum = orderNumsSum;
    }

    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getTid() {
        return tid;
    }

    public void setTid(Long tid) {
        this.tid = tid;
    }

    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }


    public BigDecimal getOccupyNums() {
        return occupyNums;
    }

    public void setOccupyNums(BigDecimal occupyNums) {
        this.occupyNums = occupyNums;
    }

    public BigDecimal getPlanNumsSum() {
        return planNumsSum;
    }

    public void setPlanNumsSum(BigDecimal planNumsSum) {
        this.planNumsSum = planNumsSum;
    }

    public BigDecimal getSurplusNumsSum() {
        return surplusNumsSum;
    }

    public void setSurplusNumsSum(BigDecimal surplusNumsSum) {
        this.surplusNumsSum = surplusNumsSum;
    }

    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }

    // 设备明细子表
    private List<SinglePlanDetailVO> planDetail = new ArrayList<>();

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    /**
     * 使用计划名称
     */
    public String getPlanName() {
        return planName;
    }

    /**
     * 使用计划名称
     */
    public void setPlanName(String planName) {
        this.planName = planName;
    }
    /**
     * 计划编码
     */
    public String getPlanBillCode() {
        return planBillCode;
    }

    public void setPlanBillCode(String planBillCode) {
        this.planBillCode = planBillCode;
    }

    public String getPlanEmployeeName() {
        return planEmployeeName;
    }

    public void setPlanEmployeeName(String planEmployeeName) {
        this.planEmployeeName = planEmployeeName;
    }

    public Long getPlanDetailId() {
        return planDetailId;
    }

    public void setPlanDetailId(Long planDetailId) {
        this.planDetailId = planDetailId;
    }

    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    /**
     * 经办人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 计划使用日期
     */
    public Date getPlanDate() {
        return planDate;
    }

    /**
     * 计划使用日期
     */
    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }

    @ReferSerialTransfer(referCode = "subject-project-wbs-ref")
    public Long getConstructionId() {
        return constructionId;
    }

    @ReferDeserialTransfer
    public void setConstructionId(Long constructionId) {
        this.constructionId = constructionId;
    }

    /**
     * 施工部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 施工部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 物资名称
     */
    public String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
//    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }

//    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
//    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

//    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public Integer getFirstState() {
        return firstState;
    }

    public void setFirstState(Integer firstState) {
        this.firstState = firstState;
    }

    public String getTexture() {
        return texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public String getStandard() {
        return standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    public void setOrderExpiryDate(Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }

    public Long getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }

    public List<SinglePlanDetailVO> getPlanDetail() {
        return planDetail;
    }

    public void setPlanDetail(List<SinglePlanDetailVO> planDetail) {
        this.planDetail = planDetail;
    }
}
