package com.ejianc.business.promaterial.sync.vo;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @Author: caojie
 * @CreateTime:2025-03-14 17:31
 * @Version: 1.0
 */
public class PlanDetailDto implements Serializable {

    private static final long serialVersionUID = 4297588598284239794L;

    private String outPlanLineNo; // 外部系统采购需求计划明细唯一标识,${单位标识}_${数据唯一标识}
    private String outPlanNo; //外部系统采购需求计划唯一标识
    private String title; //采购需求计划名称
    private String planType; //计划类型（值集）3-框架协议采购计划 如果是年度计划、临时计划传空
    private String category;//物料小类编码
    private String categoryName; //物料小类名称
    private String itemId; //物料编码（8位集团要求标砖物料编码 ）
    private String itemDesc; //物料描述
    private String itemDescMore; //物料信息长描述
    private BigDecimal qty; //数量（保留4位小数）

    /**
     * 值集：
     * T-吨
     * EA-个
     * 套-套
     * KG-千克
     * M-米
     * 副-副
     * 盒-盒
     * M2-平方米
     * M3-立方米
     * 双-双
     * g-克
     * EA-套
     * L-升
     * 项-项
     * kWh-千瓦时
     * KG-个
     * EA-米
     * EA-盒
     * EA-千克
     * 套-个
     * M -个
     * M2-个
     */
    private String itemUom; //计量单位编码
    private String currencyCode; //币种编码，默认CNY-人民币
    private BigDecimal budgetAtm; //预算金额（保留2位小数）
    private BigDecimal budgetPrice; //单价（保留2位小数）
    private String purcType; //采购类型：1-工程采购，2-物资采购，3-服务采购
    /**
     * 采购子类型
     * 11-工程发包
     * 12-专业分包
     * 13-劳务分包
     * 21-材料
     * 22-设备
     * 31-服务
     * 当采购类型purcType为【1-工程采购】时【采购子类型】传
     * 11-工程发包
     * 12-专业分包
     * 13-劳务分包
     * 当采购类型purcType为【2-物资采购】时【采购子类型】传
     * 21-材料
     * 22-设备
     * 当采购类型purcType为【3-服务采购】时【采购子类型】传
     * 31-服务
     *
     */
    private String purcSubtype;//采购子类型

    private String requireDate; //需用日期（采购类型PurcType是物资采购必填，格式类型：YYYYMMDD）
    private String endDate; //计划结束日期(采购类型PurcType是工程采购、服务采购必填，格式类型：YYYYMMDD)
    private String startDate; //计划开始日期(采购类型PurcType是工程采购、服务采购必填，格式类型：YYYYMMDD)
    private String isConstructionProject;//是否工程建设项目 0否 1是
    private String projectNo;//项目编码 为保证项目编号唯一性，取nc系统内的 系统项目编号例如PM2022xxxxxxx
    private String projectName;//项目名称
    private String taxMark; //含税标识（默认含税）默认1-含税 0-不含税
    private String partUsed; //使用部位（用途）
    private String urgencyType; //是否紧急采购  1-是 0-否
    private String urgentReason;//紧急采购原因（是否紧急采购为1-是，必填）
    private String isPiecemeal;//是否零星采购 0-否 1-是
    private String tprnd01Status;//采购需求计划明细状态 40 -审批通过
    private String remark;//备注
    private String itemName;//物料名称
    private String reqUser;//申请人编号 各成员单位实际申请人编号
    private String reqName;//申请人姓名 各成员单位实际申请人姓名
    private String applyDeptId;//需用部门编号 各单位虚拟部门id
    private String applyDeptName;//需用部门名称 各单位虚拟部门名称
    private String applyOrgId;//需用单位编码 各单位虚拟单位id
    private String applyOrgName;//需用单位名称 各单位虚拟单位名称
    private String createUser;//创建人账号 各单位虚拟账号
    private String createUserName;//创建人账号名称 各单位虚拟账号名称
    private String createOrgCode;//创建人组织编号 各单位虚拟组织编号
    private String createOrgName;//创建人组织名称 各单位虚拟组织名称
    private String createDate;// 创建时间
    private String createDeptCode;// 创建者部门编号
    private String createDeptName;// 创建者部门名称
    private String actualDemandPlanOrgCode;// 实际需用计划提报组织编码
    private String actualDemandPlanOrgName;// 实际需用计划提报组织名称
    private String actualDemandPlanDeptCode;// 实际需用计划提报部门编码
    private String actualDemandPlanDeptName;// 实际需用计划提报部门名称
    private String actualDemandPlanPlanner;// 实际需用计划提报计划员
    private String actualDemandPlanPlannerCode;// 实际需用计划提报计划员编码
    private String sysCode;// 系统编码 固定传HJJC
    private String createPlateCode;// 创建者板块编号
    private String createPlateName;// 创建者板块名称
    private String focusPurOrgForm;// 值集 10-直接 20-组织 30-授权 固定传10


    public String getOutPlanLineNo() {
        return outPlanLineNo;
    }

    public void setOutPlanLineNo(String outPlanLineNo) {
        this.outPlanLineNo = outPlanLineNo;
    }

    public String getOutPlanNo() {
        return outPlanNo;
    }

    public void setOutPlanNo(String outPlanNo) {
        this.outPlanNo = outPlanNo;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getPlanType() {
        return planType;
    }

    public void setPlanType(String planType) {
        this.planType = planType;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public String getItemId() {
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public String getItemDesc() {
        return itemDesc;
    }

    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc;
    }

    public String getItemDescMore() {
        return itemDescMore;
    }

    public void setItemDescMore(String itemDescMore) {
        this.itemDescMore = itemDescMore;
    }

    public BigDecimal getQty() {
        return qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public String getItemUom() {
        return itemUom;
    }

    public void setItemUom(String itemUom) {
        this.itemUom = itemUom;
    }

    public String getCurrencyCode() {
        return currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public BigDecimal getBudgetAtm() {
        return budgetAtm;
    }

    public void setBudgetAtm(BigDecimal budgetAtm) {
        this.budgetAtm = budgetAtm;
    }

    public BigDecimal getBudgetPrice() {
        return budgetPrice;
    }

    public void setBudgetPrice(BigDecimal budgetPrice) {
        this.budgetPrice = budgetPrice;
    }

    public String getPurcType() {
        return purcType;
    }

    public void setPurcType(String purcType) {
        this.purcType = purcType;
    }

    public String getPurcSubtype() {
        return purcSubtype;
    }

    public void setPurcSubtype(String purcSubtype) {
        this.purcSubtype = purcSubtype;
    }

    public String getRequireDate() {
        return requireDate;
    }

    public void setRequireDate(String requireDate) {
        this.requireDate = requireDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public String getIsConstructionProject() {
        return isConstructionProject;
    }

    public void setIsConstructionProject(String isConstructionProject) {
        this.isConstructionProject = isConstructionProject;
    }

    public String getProjectNo() {
        return projectNo;
    }

    public void setProjectNo(String projectNo) {
        this.projectNo = projectNo;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getTaxMark() {
        return taxMark;
    }

    public void setTaxMark(String taxMark) {
        this.taxMark = taxMark;
    }

    public String getPartUsed() {
        return partUsed;
    }

    public void setPartUsed(String partUsed) {
        this.partUsed = partUsed;
    }

    public String getUrgencyType() {
        return urgencyType;
    }

    public void setUrgencyType(String urgencyType) {
        this.urgencyType = urgencyType;
    }

    public String getUrgentReason() {
        return urgentReason;
    }

    public void setUrgentReason(String urgentReason) {
        this.urgentReason = urgentReason;
    }

    public String getIsPiecemeal() {
        return isPiecemeal;
    }

    public void setIsPiecemeal(String isPiecemeal) {
        this.isPiecemeal = isPiecemeal;
    }

    public String getTprnd01Status() {
        return tprnd01Status;
    }

    public void setTprnd01Status(String tprnd01Status) {
        this.tprnd01Status = tprnd01Status;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getItemName() {
        return itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public String getReqUser() {
        return reqUser;
    }

    public void setReqUser(String reqUser) {
        this.reqUser = reqUser;
    }

    public String getReqName() {
        return reqName;
    }

    public void setReqName(String reqName) {
        this.reqName = reqName;
    }

    public String getApplyDeptId() {
        return applyDeptId;
    }

    public void setApplyDeptId(String applyDeptId) {
        this.applyDeptId = applyDeptId;
    }

    public String getApplyDeptName() {
        return applyDeptName;
    }

    public void setApplyDeptName(String applyDeptName) {
        this.applyDeptName = applyDeptName;
    }

    public String getApplyOrgId() {
        return applyOrgId;
    }

    public void setApplyOrgId(String applyOrgId) {
        this.applyOrgId = applyOrgId;
    }

    public String getApplyOrgName() {
        return applyOrgName;
    }

    public void setApplyOrgName(String applyOrgName) {
        this.applyOrgName = applyOrgName;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser;
    }

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    public String getCreateOrgCode() {
        return createOrgCode;
    }

    public void setCreateOrgCode(String createOrgCode) {
        this.createOrgCode = createOrgCode;
    }

    public String getCreateOrgName() {
        return createOrgName;
    }

    public void setCreateOrgName(String createOrgName) {
        this.createOrgName = createOrgName;
    }

    public String getCreateDate() {
        return createDate;
    }

    public void setCreateDate(String createDate) {
        this.createDate = createDate;
    }

    public String getCreateDeptCode() {
        return createDeptCode;
    }

    public void setCreateDeptCode(String createDeptCode) {
        this.createDeptCode = createDeptCode;
    }

    public String getCreateDeptName() {
        return createDeptName;
    }

    public void setCreateDeptName(String createDeptName) {
        this.createDeptName = createDeptName;
    }

    public String getActualDemandPlanOrgCode() {
        return actualDemandPlanOrgCode;
    }

    public void setActualDemandPlanOrgCode(String actualDemandPlanOrgCode) {
        this.actualDemandPlanOrgCode = actualDemandPlanOrgCode;
    }

    public String getActualDemandPlanOrgName() {
        return actualDemandPlanOrgName;
    }

    public void setActualDemandPlanOrgName(String actualDemandPlanOrgName) {
        this.actualDemandPlanOrgName = actualDemandPlanOrgName;
    }

    public String getActualDemandPlanDeptCode() {
        return actualDemandPlanDeptCode;
    }

    public void setActualDemandPlanDeptCode(String actualDemandPlanDeptCode) {
        this.actualDemandPlanDeptCode = actualDemandPlanDeptCode;
    }

    public String getActualDemandPlanDeptName() {
        return actualDemandPlanDeptName;
    }

    public void setActualDemandPlanDeptName(String actualDemandPlanDeptName) {
        this.actualDemandPlanDeptName = actualDemandPlanDeptName;
    }

    public String getActualDemandPlanPlanner() {
        return actualDemandPlanPlanner;
    }

    public void setActualDemandPlanPlanner(String actualDemandPlanPlanner) {
        this.actualDemandPlanPlanner = actualDemandPlanPlanner;
    }

    public String getActualDemandPlanPlannerCode() {
        return actualDemandPlanPlannerCode;
    }

    public void setActualDemandPlanPlannerCode(String actualDemandPlanPlannerCode) {
        this.actualDemandPlanPlannerCode = actualDemandPlanPlannerCode;
    }

    public String getSysCode() {
        return sysCode;
    }

    public void setSysCode(String sysCode) {
        this.sysCode = sysCode;
    }

    public String getCreatePlateCode() {
        return createPlateCode;
    }

    public void setCreatePlateCode(String createPlateCode) {
        this.createPlateCode = createPlateCode;
    }

    public String getCreatePlateName() {
        return createPlateName;
    }

    public void setCreatePlateName(String createPlateName) {
        this.createPlateName = createPlateName;
    }

    public String getFocusPurOrgForm() {
        return focusPurOrgForm;
    }

    public void setFocusPurOrgForm(String focusPurOrgForm) {
        this.focusPurOrgForm = focusPurOrgForm;
    }
}
