package com.ejianc.business.promaterial.plan.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.promaterial.plan.vo.ConcretePlanDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

/**
 * 混凝土需用计划-主表
 * 
 * @author generator
 * 
 */
public class ConcretePlanVO extends BaseVO {

    private static final long serialVersionUID = -910089664010594845L;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("单据编码")
    private String billCode;
    @ApiModelProperty("所属项目部Id")
    private Long orgId;
    @ApiModelProperty("所属项目部名称")
    private String orgName;
    @ApiModelProperty("组织ID")
    private Long parentOrgId;
    @ApiModelProperty("组织编码")
    private String parentOrgCode;
    @ApiModelProperty("组织名称")
    private String parentOrgName;
    @ApiModelProperty("经办部门Id")
    private Long departmentId;
    @ApiModelProperty("经办部门名称")
    private String departmentName;
    @ApiModelProperty("项目Id")
    private Long projectId;
    @ApiModelProperty("项目名称")
    private String projectName;
    @ApiModelProperty("项目编码")
    private String projectCode;
    @ApiModelProperty("申请人id")
    private Long employeeId;
    @ApiModelProperty("申请人名称")
    private String employeeName;
    @ApiModelProperty("申请日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planDate;
    @ApiModelProperty("使用部位")
    private String construction;
    @ApiModelProperty("编制日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date createDate;
    @ApiModelProperty("计划进场日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEnterDate;
    @ApiModelProperty("物料名称集合")
    private String materialName;
    @ApiModelProperty("是否开启计划 0-正常，1-已关闭")
    private Integer planFlag;
    @ApiModelProperty("备注")
    private String memo;
    private String orgCode; // 所属项目部编码

    private String billStateName;

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    @ApiModelProperty("混凝土-需用计划子表")
    private List<ConcretePlanDetailVO> planDetailList = new ArrayList<>();

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 单据状态
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 单据编码
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编码
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 所属项目部Id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属项目部Id
     */
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属项目部名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属项目部名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织ID
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 组织ID
     */
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 经办部门Id
     */
    public Long getDepartmentId() {
        return departmentId;
    }

    /**
     * 经办部门Id
     */
    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    /**
     * 经办部门名称
     */
    public String getDepartmentName() {
        return departmentName;
    }

    /**
     * 经办部门名称
     */
    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    /**
     * 项目Id
     */
//    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目Id
     */
//    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 项目编码
     */
    public String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 申请人id
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 申请人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 申请人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 申请人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 申请日期
     */
    public Date getPlanDate() {
        return planDate;
    }

    /**
     * 申请日期
     */
    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    /**
     * 使用部位
     */
    public String getConstruction() {
        return construction;
    }

    /**
     * 使用部位
     */
    public void setConstruction(String construction) {
        this.construction = construction;
    }
    /**
     * 编制日期
     */
    public Date getCreateDate() {
        return createDate;
    }

    /**
     * 编制日期
     */
    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }
    /**
     * 计划进场日期
     */
    public Date getPlanEnterDate() {
        return planEnterDate;
    }

    /**
     * 计划进场日期
     */
    public void setPlanEnterDate(Date planEnterDate) {
        this.planEnterDate = planEnterDate;
    }
    /**
     * 物料名称集合
     */
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }

    /**
     * 是否开启计划 0-正常，1-已关闭
     */
    public Integer getPlanFlag() {
        return planFlag;
    }

    /**
     * 是否开启计划 0-正常，1-已关闭
     */
    public void setPlanFlag(Integer planFlag) {
        this.planFlag = planFlag;
    }
    /**
     * 备注
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 备注
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }

    /**
     * 消耗材-需用计划子表
     */
    public List<ConcretePlanDetailVO> getPlanDetailList() {
        return planDetailList;
    }
    /**
     * 消耗材-需用计划子表
     */
    public void setPlanDetailList(List<ConcretePlanDetailVO> planDetailList) {
        this.planDetailList = planDetailList;
    }
}
