package com.ejianc.business.promaterial.contract.vo;

import com.ejianc.business.contractpub.util.ConvertField;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author nfy
 * @date 2025/4/22
 */
public class ImportContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty("采购类型 1-自采，2-集采")
    private String purchaseType;
    @ApiModelProperty("集采/自采")
    private String purchaseTypeName;
    @ApiModelProperty("定标结果Id")
    private Long targetResultId;
    @ApiModelProperty("定标结果名称")
    private String targetResultName;
    @ApiModelProperty("项目Id")
    @ConvertField
    private Long projectId;
    @ApiModelProperty("项目名称")
    @ConvertField
    private String projectName;
    @ApiModelProperty("项目地点")
    private String projectPlace;
    @ApiModelProperty("单据编号")
    @ConvertField(targetField = "contractCode")
    private String billCode;
    @ApiModelProperty("合同名称")
    @ConvertField
    private String contractName;
    @ApiModelProperty("合同类别Id")
    @ConvertField(targetField = "categoryId")
    private Long contractCategoryId;
    @ApiModelProperty("合同类别名称")
    @ConvertField(targetField = "categoryName")
    private String contractCategoryName;
    private String contractPropertyCode; // 采购类别code
    private String contractPropertyName; // 采购类别名称
    @ApiModelProperty("甲方Id")
    @ConvertField(targetField = "partyaId")
    private Long customerId;
    @ApiModelProperty("甲方名称")
    @ConvertField(targetField = "partyaName")
    private String customerName;
    @ApiModelProperty("乙方Id")
    @ConvertField(targetField = "partybId")
    private Long supplierId;
    @ApiModelProperty("乙方名称")
    @ConvertField(targetField = "partybName")
    private String supplierName;
    @ApiModelProperty("签订日期")
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate;
    @ApiModelProperty("签约地点")
    @ConvertField
    private String signPlace;
    @ApiModelProperty("签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章")
    private String signatureStatus;
    @ApiModelProperty("合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】")
    @ConvertField
    private String performanceStatus;
    @ApiModelProperty("经办人")
    @ConvertField
    private Long employeeId;
    @ApiModelProperty("经办人名称")
    @ConvertField
    private String employeeName;
    @ApiModelProperty("合同税率")
    @ConvertField
    private BigDecimal taxRate;
    @ApiModelProperty("合同支付比例")
    private BigDecimal payScale;
    @ApiModelProperty("甲方经办人Id")
    private Long customerEmployeeId;
    @ApiModelProperty("甲方经办人名称")
    private String customerEmployeeName;
    @ApiModelProperty("甲方经办人电话")
    private String customerEmployeeMobile;
    @ApiModelProperty("乙方经办人名称")
    @ConvertField(targetField = "supplierProjectManagerName")
    private String supplierEmployeeName;
    @ApiModelProperty("乙方经办人电话")
    @ConvertField(targetField = "supplierProjectManagerLink")
    private String supplierEmployeeMobile;
    @ApiModelProperty("计价方式：1-固定单价、2-浮动单价、3-固定总价")
    @ConvertField
    private String pricingType;
    @ApiModelProperty("起草方式：1、在线起草，2、上传合同，3、线下签订")
    private String draftType;
    @ApiModelProperty("合同附件路径")
    private String contractFilePath;
    @ApiModelProperty("合同附件Id")
    private Long contractFileId;
    @ApiModelProperty("合同模板Id")
    private Long contractTemplateId;
    @ApiModelProperty("合同模板名称")
    private String contractTemplateName;
    @ApiModelProperty("合同附件版本Id")
    private Long contractFileVersionId;
    @ApiModelProperty("合同附件版本")
    private Long contractFileVersion;
    @ApiModelProperty("合同金额")
    @ConvertField
    private BigDecimal contractTaxMny;
    @ApiModelProperty("合同金额（无税）")
    @ConvertField
    private BigDecimal contractMny;
    @ApiModelProperty("合同税额")
    @ConvertField
    private BigDecimal contractTax;
    @ApiModelProperty("清单金额")
    private BigDecimal detailTaxMny;
    @ApiModelProperty("清单金额（无税）")
    private BigDecimal detailMny;
    @ApiModelProperty("清单税额")
    private BigDecimal detailTax;
    @ApiModelProperty("其他费用金额")
    private BigDecimal freeTaxMny;
    @ApiModelProperty("其他费用金额（无税）")
    private BigDecimal freeMny;
    @ApiModelProperty("其他费用税额")
    private BigDecimal freeTax;
    @ApiModelProperty("单据状态")
    private Integer billState;
    @ApiModelProperty("提交日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate;
    @ApiModelProperty("提交人名称")
    private String commitUserName;
    @ApiModelProperty("提交人账号")
    private String commitUserCode;
    @ApiModelProperty("生效日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate;
    @ApiModelProperty("项目部Id")
    @ConvertField
    private Long orgId;
    @ApiModelProperty("项目部名称")
    @ConvertField
    private String orgName;
    @ApiModelProperty("项目部上级组织Id")
    @ConvertField
    private Long parentOrgId;
    @ApiModelProperty("项目部上级组织名称")
    @ConvertField
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    @ConvertField
    private String parentOrgCode;
    @ApiModelProperty("合同高亮附件路径")
    private String contractFileHighlightPath;
    @ApiModelProperty("合同高亮附件Id")
    private Long contractFileHighlightId;
    @ApiModelProperty("初始版本金额")
    private BigDecimal baseMoney;
    @ApiModelProperty("初始版本(含税)金额")
    private BigDecimal baseMoneyWithTax;
    @ApiModelProperty("变更前金额")
    private BigDecimal beforeChangeMny;
    @ApiModelProperty("变更前金额（含税）")
    private BigDecimal beforeChangeMnyWithTax;
    @ApiModelProperty("变更中金额")
    private BigDecimal changingMny;
    @ApiModelProperty("变更中金额（含税）")
    private BigDecimal changingMnyWithTax;
    @ApiModelProperty("变更单号")
    private String changeCode;
    @ApiModelProperty("变更版本")
    private Integer changeVersion;
    @ApiModelProperty("变更主键")
    private Long changeId;
    @ApiModelProperty("变更状态(1-未变更 2-变更中 3-已变更)")
    @ConvertField
    private Integer changeStatus;
    @ApiModelProperty("是否补充协议(1:是，0：否)")
    @ConvertField
    private Integer supplementFlag;
    @ApiModelProperty("主合同Id")
    @ConvertField
    private Long mainContractId;
    @ApiModelProperty("主合同编码")
    @ConvertField
    private String mainContractCode;
    @ApiModelProperty("主合同名称")
    @ConvertField
    private String mainContractName;
    @ApiModelProperty("补充项描述")
    private String supplementDescribe;
    @ApiModelProperty("主合同创建日期(用于合同、补充协议排序)")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mainContractCreateDate;
    @ApiModelProperty("变更日期")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate;
    @ApiModelProperty("变更合同签章状态")
    private Integer changeContractSignatureStatus;
    @ApiModelProperty("变更起草方式：1-上传附件，2-线下签订")
    private String changeDraftType;
    @ApiModelProperty("变更附件Id")
    private Long changeFileId;
    @ApiModelProperty("变更合同名称")
    private String changeContractName;
    @ApiModelProperty("签章完成合同文件Id")
    private Long signedFileId;
    @ApiModelProperty("累计预付款金额")
    private BigDecimal totalPrepayMny;
    @ApiModelProperty("累计付款金额")
    private BigDecimal totalPayMny;
    @ApiModelProperty("累计冲抵金额")
    private BigDecimal totalOffsetMny;
    @ApiModelProperty("累计结算金额(不含税)")
    private BigDecimal totalSettlementMny;
    @ApiModelProperty("累计结算金额")
    private BigDecimal totalSettlementTaxMny;
    @ApiModelProperty("累计收票金额(不含税)")
    private BigDecimal totalInvoiceMny;
    @ApiModelProperty("累计收票金额")
    private BigDecimal totalInvoiceTaxMny;
    @ApiModelProperty("备注")
    private String memo;
    @ApiModelProperty("数据来源 0-定标结果")
    private Integer systemType;
    private Long contractId;

    private String settlementPayment; // 结算付款
    private String priceFloatType; // 单价浮动方式

    /**
     * 单据状态名称（不入库） ：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
     */
    private String billStateName;
    @ApiModelProperty("合同类型（0-物资采购合同，1-混凝土合同）")
    private Integer contractType; // 合同类型（0-物资采购合同，1-混凝土合同）

    /**
     * 线上起草，审批中修改的合同是否已重新进行合同编辑
     */
    private Boolean contractFileSyncFlag = true;

    /**
     * 发票类型Id
     */
    private Long invoiceTypeId;

    /**
     * 发票类型名称
     */
    private String invoiceTypeName;

    @ConvertField(targetField = "sourceId,contractId,id")
    private Long id;

    @ConvertField
    private Integer dr;

    /**
     * 完工结算单生效日期
     */
    @ConvertField
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date finishSettleDate;

    private Long watermarkContractFileId;
    @ConvertField
    private String orgCode; // 项目部编码
    @ConvertField
    private Integer filingStatus;//是否归档 1：是；0：否
    @ConvertField
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否

    private BigDecimal contractNum;// 合同数量
    private String bpoId; // 集采系统-合同编号
    private String orderId; // 集采系统-订单号
    private Long syncContractId;// 集采系统合同主键

    private String syncContractName;

    // 导入失败原因
    private String errorMessage;

    public String getErrorMessage() {
        return errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getSyncContractName() {
        return syncContractName;
    }

    public void setSyncContractName(String syncContractName) {
        this.syncContractName = syncContractName;
    }

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }

    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    public Long getTargetResultId() {
        return targetResultId;
    }

    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectPlace() {
        return projectPlace;
    }

    public void setProjectPlace(String projectPlace) {
        this.projectPlace = projectPlace;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }

    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }

    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }

    public String getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }

    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    public Long getCustomerEmployeeId() {
        return customerEmployeeId;
    }

    public void setCustomerEmployeeId(Long customerEmployeeId) {
        this.customerEmployeeId = customerEmployeeId;
    }

    public String getCustomerEmployeeName() {
        return customerEmployeeName;
    }

    public void setCustomerEmployeeName(String customerEmployeeName) {
        this.customerEmployeeName = customerEmployeeName;
    }

    public String getCustomerEmployeeMobile() {
        return customerEmployeeMobile;
    }

    public void setCustomerEmployeeMobile(String customerEmployeeMobile) {
        this.customerEmployeeMobile = customerEmployeeMobile;
    }

    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }

    public String getSupplierEmployeeMobile() {
        return supplierEmployeeMobile;
    }

    public void setSupplierEmployeeMobile(String supplierEmployeeMobile) {
        this.supplierEmployeeMobile = supplierEmployeeMobile;
    }

    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }

    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }

    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }

    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }

    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }

    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }

    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }

    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }

    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }

    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }

    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }

    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }

    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }

    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }

    public BigDecimal getFreeTaxMny() {
        return freeTaxMny;
    }

    public void setFreeTaxMny(BigDecimal freeTaxMny) {
        this.freeTaxMny = freeTaxMny;
    }

    public BigDecimal getFreeMny() {
        return freeMny;
    }

    public void setFreeMny(BigDecimal freeMny) {
        this.freeMny = freeMny;
    }

    public BigDecimal getFreeTax() {
        return freeTax;
    }

    public void setFreeTax(BigDecimal freeTax) {
        this.freeTax = freeTax;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }

    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }

    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }

    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }

    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }

    public BigDecimal getBaseMoneyWithTax() {
        return baseMoneyWithTax;
    }

    public void setBaseMoneyWithTax(BigDecimal baseMoneyWithTax) {
        this.baseMoneyWithTax = baseMoneyWithTax;
    }

    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }

    public BigDecimal getBeforeChangeMnyWithTax() {
        return beforeChangeMnyWithTax;
    }

    public void setBeforeChangeMnyWithTax(BigDecimal beforeChangeMnyWithTax) {
        this.beforeChangeMnyWithTax = beforeChangeMnyWithTax;
    }

    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }

    public BigDecimal getChangingMnyWithTax() {
        return changingMnyWithTax;
    }

    public void setChangingMnyWithTax(BigDecimal changingMnyWithTax) {
        this.changingMnyWithTax = changingMnyWithTax;
    }

    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }

    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }

    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }

    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }

    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }

    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }

    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }

    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }

    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }

    public Integer getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(Integer changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }

    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }

    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }

    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }

    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }

    public BigDecimal getTotalPrepayMny() {
        return totalPrepayMny;
    }

    public void setTotalPrepayMny(BigDecimal totalPrepayMny) {
        this.totalPrepayMny = totalPrepayMny;
    }

    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }

    public BigDecimal getTotalOffsetMny() {
        return totalOffsetMny;
    }

    public void setTotalOffsetMny(BigDecimal totalOffsetMny) {
        this.totalOffsetMny = totalOffsetMny;
    }

    public BigDecimal getTotalSettlementMny() {
        return totalSettlementMny;
    }

    public void setTotalSettlementMny(BigDecimal totalSettlementMny) {
        this.totalSettlementMny = totalSettlementMny;
    }

    public BigDecimal getTotalSettlementTaxMny() {
        return totalSettlementTaxMny;
    }

    public void setTotalSettlementTaxMny(BigDecimal totalSettlementTaxMny) {
        this.totalSettlementTaxMny = totalSettlementTaxMny;
    }

    public BigDecimal getTotalInvoiceMny() {
        return totalInvoiceMny;
    }

    public void setTotalInvoiceMny(BigDecimal totalInvoiceMny) {
        this.totalInvoiceMny = totalInvoiceMny;
    }

    public BigDecimal getTotalInvoiceTaxMny() {
        return totalInvoiceTaxMny;
    }

    public void setTotalInvoiceTaxMny(BigDecimal totalInvoiceTaxMny) {
        this.totalInvoiceTaxMny = totalInvoiceTaxMny;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public Integer getSystemType() {
        return systemType;
    }

    public void setSystemType(Integer systemType) {
        this.systemType = systemType;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getSettlementPayment() {
        return settlementPayment;
    }

    public void setSettlementPayment(String settlementPayment) {
        this.settlementPayment = settlementPayment;
    }

    public String getPriceFloatType() {
        return priceFloatType;
    }

    public void setPriceFloatType(String priceFloatType) {
        this.priceFloatType = priceFloatType;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Boolean getContractFileSyncFlag() {
        return contractFileSyncFlag;
    }

    public void setContractFileSyncFlag(Boolean contractFileSyncFlag) {
        this.contractFileSyncFlag = contractFileSyncFlag;
    }

    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }

    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    @Override
    public Long getId() {
        return id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getDr() {
        return dr;
    }

    @Override
    public void setDr(Integer dr) {
        this.dr = dr;
    }

    public Date getFinishSettleDate() {
        return finishSettleDate;
    }

    public void setFinishSettleDate(Date finishSettleDate) {
        this.finishSettleDate = finishSettleDate;
    }

    public Long getWatermarkContractFileId() {
        return watermarkContractFileId;
    }

    public void setWatermarkContractFileId(Long watermarkContractFileId) {
        this.watermarkContractFileId = watermarkContractFileId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public BigDecimal getContractNum() {
        return contractNum;
    }

    public void setContractNum(BigDecimal contractNum) {
        this.contractNum = contractNum;
    }

    public String getBpoId() {
        return bpoId;
    }

    public void setBpoId(String bpoId) {
        this.bpoId = bpoId;
    }

    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public Long getSyncContractId() {
        return syncContractId;
    }

    public void setSyncContractId(Long syncContractId) {
        this.syncContractId = syncContractId;
    }
}
