package com.ejianc.business.promaterial.sync.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.promaterial.sync.vo.SyncContractDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 招采平台合同
 * 
 * @author generator
 * 
 */
public class SyncContractVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String purchaseType; // 采购类型 1-自采，2-集采
    private String purchaseTypeName; // 集采/自采
    private Long targetResultId; // 定标结果Id
    private String targetResultName; // 定标结果名称
    private Long projectId; // 项目Id
    private String projectName; // projectName
    private String projectPlace; // 项目地点
    private String billCode; // 单据编号
    private String contractName; // contractName
    private Long contractCategoryId; // 合同类别Id
    private String contractCategoryName; // 合同类别名称
    private Long customerId; // 甲方Id
    private String customerName; // customerName
    private Long supplierId; // 乙方Id
    private String supplierName; // supplierName
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date signDate; // 签订日期
    private String signPlace; // 签约地点
    private String signatureStatus; // 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
    private String performanceStatus; // 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
    private Long employeeId; // 经办人
    private String employeeName; // 经办人名称
    private BigDecimal taxRate; // 合同税率
    private BigDecimal payScale; // 合同支付比例
    private Long customerEmployeeId; // 甲方经办人Id
    private String customerEmployeeName; // 甲方经办人名称
    private String customerEmployeeMobile; // 甲方经办人电话
    private String supplierEmployeeName; // 乙方经办人名称
    private String supplierEmployeeMobile; // 乙方经办人电话
    private String pricingType; // 计价方式：1-固定单价、2-浮动单价、3-固定总价
    private String draftType; // 起草方式：1、在线起草，2、上传合同，3、线下签订
    private String contractFilePath; // 合同附件路径
    private Long contractFileId; // 合同附件Id
    private Long contractTemplateId; // 合同模板Id
    private String contractTemplateName; // 合同模板名称
    private Long contractFileVersionId; // 合同附件版本Id
    private Long contractFileVersion; // 合同附件版本
    private BigDecimal contractTaxMny; // 合同金额
    private BigDecimal contractMny; // 合同金额（无税）
    private BigDecimal contractTax; // 合同税额
    private BigDecimal detailTaxMny; // 清单金额
    private BigDecimal detailMny; // 清单金额（无税）
    private BigDecimal detailTax; // 清单税额
    private BigDecimal freeTaxMny; // 其他费用金额
    private BigDecimal freeMny; // 其他费用金额（无税）
    private BigDecimal freeTax; // 其他费用税额
    private Integer billState; // 单据状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date commitDate; // 提交日期
    private String commitUserName; // 提交人名称
    private String commitUserCode; // 提交人账号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date effectiveDate; // 生效日期
    private Long orgId; // 项目部Id
    private String orgName; // orgName
    private String orgCode; // 项目部编码
    private Long parentOrgId; // 项目部上级组织Id
    private String parentOrgName; // parentOrgName
    private String parentOrgCode; // 项目部上级组织编码
    private String contractFileHighlightPath; // 合同高亮附件路径
    private Long contractFileHighlightId; // 合同高亮附件Id
    private BigDecimal baseMoney; // 初始版本金额
    private BigDecimal baseMoneyWithTax; // 初始版本(含税)金额
    private BigDecimal beforeChangeMny; // 变更前金额
    private BigDecimal beforeChangeMnyWithTax; // 变更前金额（含税）
    private BigDecimal changingMny; // 变更中金额
    private BigDecimal changingMnyWithTax; // 变更中金额（含税）
    private String changeCode; // 变更单号
    private Integer changeVersion; // 变更版本
    private Long changeId; // 变更主键
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    private Long mainContractId; // 主合同Id
    private String mainContractCode; // 主合同编码
    private String mainContractName; // 主合同名称
    private String supplementDescribe; // 补充项描述
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date mainContractCreateDate; // 主合同创建日期(用于合同、补充协议排序)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date changeDate; // 变更日期
    private Integer changeContractSignatureStatus; // 变更合同签章状态
    private String changeDraftType; // 变更起草方式：1-上传附件，2-线下签订
    private Long changeFileId; // 变更附件Id
    private String changeContractName; // 变更合同名称
    private Long signedFileId; // 签章完成合同文件Id
    private BigDecimal totalPrepayMny; // 累计预付款金额
    private BigDecimal totalPayMny; // 累计付款金额
    private BigDecimal totalOffsetMny; // 累计冲抵金额
    private BigDecimal totalSettlementMny; // 累计结算金额(不含税)
    private BigDecimal totalSettlementTaxMny; // 累计结算金额
    private BigDecimal totalInvoiceMny; // 累计收票金额(不含税)
    private BigDecimal totalInvoiceTaxMny; // 累计收票金额
    private String memo; // 备注
    private String contractPropertyCode; // 采购类别编码
    private String contractPropertyName; // 采购类别名称
    private Integer contractType; // 合同类型（0-物资采购合同，1-混凝土合同）
    private Integer contractFileSyncFlag; // 线上起草合同，审批中修改的合同是否已重新进行合同编辑,默认为已同步
    private Long invoiceTypeId; // 发票类型Id
    private String invoiceTypeName; // 发票类型名称
    private Long watermarkContractFileId; // 水印合同附件Id
    private String settlementPayment; // 结算付款
    private String priceFloatType; // 单价浮动方式
    private Integer filingStatus; // 是否归档 1：是；0：否；2归档中
    private Integer filingRef; // 是否归档引用0：否（无默认 签章完成修改 ）
    private String bpoId; // 集采系统-合同编号
    private String orderId; // 集采系统-订单编号
    private String syncResult; // 集采系统-合同数据
    
    private List<SyncContractDetailVO> detailList = new ArrayList<>(); // 招采平台合同明细

    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }

    @ReferSerialTransfer(referCode="refStuffsupplierData")
    public Long getTargetResultId() {
        return targetResultId;
    }

    @ReferDeserialTransfer
    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }

    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }

    @ReferSerialTransfer(referCode="project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectPlace() {
        return projectPlace;
    }

    public void setProjectPlace(String projectPlace) {
        this.projectPlace = projectPlace;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="contractCategory")
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    @ReferDeserialTransfer
    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }

    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getCustomerId() {
        return customerId;
    }

    @ReferDeserialTransfer
    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    @ReferSerialTransfer(referCode="support-supplier")
    public Long getSupplierId() {
        return supplierId;
    }

    @ReferDeserialTransfer
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    public String getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getCustomerEmployeeId() {
        return customerEmployeeId;
    }

    @ReferDeserialTransfer
    public void setCustomerEmployeeId(Long customerEmployeeId) {
        this.customerEmployeeId = customerEmployeeId;
    }

    public String getCustomerEmployeeName() {
        return customerEmployeeName;
    }

    public void setCustomerEmployeeName(String customerEmployeeName) {
        this.customerEmployeeName = customerEmployeeName;
    }
    public String getCustomerEmployeeMobile() {
        return customerEmployeeMobile;
    }

    public void setCustomerEmployeeMobile(String customerEmployeeMobile) {
        this.customerEmployeeMobile = customerEmployeeMobile;
    }
    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }
    public String getSupplierEmployeeMobile() {
        return supplierEmployeeMobile;
    }

    public void setSupplierEmployeeMobile(String supplierEmployeeMobile) {
        this.supplierEmployeeMobile = supplierEmployeeMobile;
    }
    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }
    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }
    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }
    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }
    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }
    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }
    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }
    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    public BigDecimal getFreeTaxMny() {
        return freeTaxMny;
    }

    public void setFreeTaxMny(BigDecimal freeTaxMny) {
        this.freeTaxMny = freeTaxMny;
    }
    public BigDecimal getFreeMny() {
        return freeMny;
    }

    public void setFreeMny(BigDecimal freeMny) {
        this.freeMny = freeMny;
    }
    public BigDecimal getFreeTax() {
        return freeTax;
    }

    public void setFreeTax(BigDecimal freeTax) {
        this.freeTax = freeTax;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }
    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    public BigDecimal getBaseMoneyWithTax() {
        return baseMoneyWithTax;
    }

    public void setBaseMoneyWithTax(BigDecimal baseMoneyWithTax) {
        this.baseMoneyWithTax = baseMoneyWithTax;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeMnyWithTax() {
        return beforeChangeMnyWithTax;
    }

    public void setBeforeChangeMnyWithTax(BigDecimal beforeChangeMnyWithTax) {
        this.beforeChangeMnyWithTax = beforeChangeMnyWithTax;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getChangingMnyWithTax() {
        return changingMnyWithTax;
    }

    public void setChangingMnyWithTax(BigDecimal changingMnyWithTax) {
        this.changingMnyWithTax = changingMnyWithTax;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }
    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public Integer getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(Integer changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }
    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }
    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }
    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }
    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }
    public BigDecimal getTotalPrepayMny() {
        return totalPrepayMny;
    }

    public void setTotalPrepayMny(BigDecimal totalPrepayMny) {
        this.totalPrepayMny = totalPrepayMny;
    }
    public BigDecimal getTotalPayMny() {
        return totalPayMny;
    }

    public void setTotalPayMny(BigDecimal totalPayMny) {
        this.totalPayMny = totalPayMny;
    }
    public BigDecimal getTotalOffsetMny() {
        return totalOffsetMny;
    }

    public void setTotalOffsetMny(BigDecimal totalOffsetMny) {
        this.totalOffsetMny = totalOffsetMny;
    }
    public BigDecimal getTotalSettlementMny() {
        return totalSettlementMny;
    }

    public void setTotalSettlementMny(BigDecimal totalSettlementMny) {
        this.totalSettlementMny = totalSettlementMny;
    }
    public BigDecimal getTotalSettlementTaxMny() {
        return totalSettlementTaxMny;
    }

    public void setTotalSettlementTaxMny(BigDecimal totalSettlementTaxMny) {
        this.totalSettlementTaxMny = totalSettlementTaxMny;
    }
    public BigDecimal getTotalInvoiceMny() {
        return totalInvoiceMny;
    }

    public void setTotalInvoiceMny(BigDecimal totalInvoiceMny) {
        this.totalInvoiceMny = totalInvoiceMny;
    }
    public BigDecimal getTotalInvoiceTaxMny() {
        return totalInvoiceTaxMny;
    }

    public void setTotalInvoiceTaxMny(BigDecimal totalInvoiceTaxMny) {
        this.totalInvoiceTaxMny = totalInvoiceTaxMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }
    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }
    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }
    public Integer getContractFileSyncFlag() {
        return contractFileSyncFlag;
    }

    public void setContractFileSyncFlag(Integer contractFileSyncFlag) {
        this.contractFileSyncFlag = contractFileSyncFlag;
    }
    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }

    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }
    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }
    public Long getWatermarkContractFileId() {
        return watermarkContractFileId;
    }

    public void setWatermarkContractFileId(Long watermarkContractFileId) {
        this.watermarkContractFileId = watermarkContractFileId;
    }
    public String getSettlementPayment() {
        return settlementPayment;
    }

    public void setSettlementPayment(String settlementPayment) {
        this.settlementPayment = settlementPayment;
    }
    public String getPriceFloatType() {
        return priceFloatType;
    }

    public void setPriceFloatType(String priceFloatType) {
        this.priceFloatType = priceFloatType;
    }
    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }
    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }
    public String getBpoId() {
        return bpoId;
    }

    public void setBpoId(String bpoId) {
        this.bpoId = bpoId;
    }
    public String getOrderId() {
        return orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }
    public String getSyncResult() {
        return syncResult;
    }

    public void setSyncResult(String syncResult) {
        this.syncResult = syncResult;
    }

    public List<SyncContractDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<SyncContractDetailVO> detailList) {
        this.detailList = detailList;
    }
}
