package com.ejianc.business.promaterial.pricelib.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import com.ejianc.business.promaterial.pricelib.vo.PriceGuideDetailVO;

/**
 * 物资指导价主表
 * 
 * @author generator
 * 
 */
@ApiModel("物资指导价主表")
public class PriceGuideVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    @ApiModelProperty("主题")
    private String theme;
    @ApiModelProperty("组织")
    private Long orgId;
    @ApiModelProperty("组织名称")
    private String orgName;
    @ApiModelProperty("组织编码")
    private String orgCode;
    @ApiModelProperty("父级组织")
    private Long parentOrgId;
    @ApiModelProperty("父级组织名称")
    private String parentOrgName;
    @ApiModelProperty("项目部上级组织编码")
    private String parentOrgCode;
    @ApiModelProperty("发布人id")
    private Long employeeId;
    @ApiModelProperty("发布人名称")
    private String employeeName;
    @ApiModelProperty("发布日期")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date publishDate;
    @ApiModelProperty("开启状态(0-开启,1-关闭)")
    private Integer flag;
    private String  flagName;
    @ApiModelProperty("描述")
    private String memo;
    @ApiModelProperty("单据编号")
    private String billCode;
    @ApiModelProperty("单据状态（审批必须字段）")
    private Integer billState;
    private String billStateName;
    
    @ApiModelProperty("材料指导价子表")
    private List<PriceGuideDetailVO> priceGuideDetailList = new ArrayList<>();

    public String getFlagName() {
        return flagName;
    }

    public void setFlagName(String flagName) {
        this.flagName = flagName;
    }

    public String getBillStateName() {
        return billStateName;
    }

    public void setBillStateName(String billStateName) {
        this.billStateName = billStateName;
    }

    /**
     * 主题
     */
    public String getTheme() {
        return theme;
    }

    /**
     * 主题
     */
    public void setTheme(String theme) {
        this.theme = theme;
    }
    /**
     * 组织
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 组织编码
     */
    public String getOrgCode() {
        return orgCode;
    }

    /**
     * 组织编码
     */
    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    /**
     * 父级组织
     */
    public Long getParentOrgId() {
        return parentOrgId;
    }

    /**
     * 父级组织
     */
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    /**
     * 父级组织名称
     */
    public String getParentOrgName() {
        return parentOrgName;
    }

    /**
     * 父级组织名称
     */
    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    /**
     * 项目部上级组织编码
     */
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    /**
     * 项目部上级组织编码
     */
    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    /**
     * 发布人id
     */
    @ReferSerialTransfer(referCode = "idm-employee")
    public Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 发布人id
     */
    @ReferDeserialTransfer
    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 发布人名称
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /**
     * 发布人名称
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 发布日期
     */
    public Date getPublishDate() {
        return publishDate;
    }

    /**
     * 发布日期
     */
    public void setPublishDate(Date publishDate) {
        this.publishDate = publishDate;
    }
    /**
     * 开启状态(0-开启,1-关闭)
     */
    public Integer getFlag() {
        return flag;
    }

    /**
     * 开启状态(0-开启,1-关闭)
     */
    public void setFlag(Integer flag) {
        this.flag = flag;
    }
    /**
     * 描述
     */
    public String getMemo() {
        return memo;
    }

    /**
     * 描述
     */
    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    
     /**
      * 材料指导价子表
      */
      public List<PriceGuideDetailVO> getPriceGuideDetailList() {
         return priceGuideDetailList;
      }
     /**
      * 材料指导价子表
      */
     public void setPriceGuideDetailList(List<PriceGuideDetailVO> priceGuideDetailList) {
         this.priceGuideDetailList = priceGuideDetailList;
     }
}
