package com.ejianc.business.promaterial.different.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.different.bean.DifferentDetailEntity;
import com.ejianc.business.promaterial.different.vo.DifferentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.different.mapper.DifferentMapper;
import com.ejianc.business.promaterial.different.bean.DifferentEntity;
import com.ejianc.business.promaterial.different.service.IDifferentService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 调差单主表
 * 
 * @author generator
 * 
 */
@Service("differentService")
public class DifferentServiceImpl extends BaseServiceImpl<DifferentMapper, DifferentEntity> implements IDifferentService{
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Value("${common.env.base-host}")
    private String BaseHost;

    private static final String BILL_CODE = "DC_CODE";//此处需要根据实际修改
    @Autowired
    private SessionManager sessionManager;
    @Override
    public CommonResponse<DifferentVO> saveOrUpdate(DifferentVO saveOrUpdateVO) {
        DifferentEntity entity = BeanMapper.map(saveOrUpdateVO, DifferentEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        super.saveOrUpdate(entity, false);
        DifferentVO vo = BeanMapper.map(entity, DifferentVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<DifferentVO> pushCost(DifferentVO differentVO) {
        DifferentEntity differentEntity = baseMapper.selectById(differentVO.getId());
        if (CollectionUtils.isNotEmpty(differentVO.getDifferentDetailList())) {
            List<DifferentDetailEntity> differentDetailEntityList = BeanMapper.mapList(differentVO.getDifferentDetailList(), DifferentDetailEntity.class);
            differentEntity.setDifferentDetailList(differentDetailEntityList);
        }
        super.saveOrUpdate(differentEntity, false);
        //推送数据
        costPush(differentEntity);
        return CommonResponse.success(BeanMapper.map(differentEntity, DifferentVO.class));
    }

    private void costPush(DifferentEntity differentEntity) {
        logger.info("开始costPush");
        //1.判断结算单所有子表是否全部关联科目
        List<DifferentDetailEntity> differentDetailEntityList = differentEntity.getDifferentDetailList();
        String newRelationFlag = "1";
        if (CollectionUtils.isNotEmpty(differentDetailEntityList)) {
            for (DifferentDetailEntity differentDetailEntity : differentDetailEntityList) {
                if(BigDecimal.ZERO.equals(differentDetailEntity.getDetailCostMny()) || BigDecimal.ZERO.equals(differentDetailEntity.getDetailCostTaxMny())){
                    continue;
                }

                if (null == differentDetailEntity.getSubjectId() || null == differentDetailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(differentDetailEntityList)) {
            newRelationFlag = "0";
        }

        //更新是否关联
        LambdaUpdateWrapper<DifferentEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(DifferentEntity::getId, differentEntity.getId());
        updateWrapper.set(DifferentEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = differentEntity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(differentEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                costDetailApi.deleteSubject(differentEntity.getId());
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                //税率
                saveCost(differentEntity);
            }
        }
    }

    private void saveCost(DifferentEntity differentEntity) {
        //对账单类型（0-物资采购结算单，1-混凝土结算单）
        Integer settlementType = differentEntity.getSettlementType();
        String sourceType = settlementType == 0 ? "PROMATERIAL_DIFFERENT" : "CONCRETE_PROMATERIAL_DIFFERENT";
        String sourceTabType = settlementType == 0 ? "PROMATERIAL_DIFFERENT_DETAIL" : "CONCRETE_PROMATERIAL_DIFFERENT_DETAIL";
        String billName = settlementType == 0 ? SourceTypeEnum.消耗材调差单.getTypeName() : SourceTypeEnum.混凝土调差单.getTypeName();
        String url = settlementType == 0 ?"/ejc-promaterial-frontend/#/different/card?id=":"/ejc-promaterial-frontend/#/differentConcrete/card?id=";
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<DifferentDetailEntity> differentDetailEntityList = differentEntity.getDifferentDetailList();
        if (CollectionUtils.isNotEmpty(differentDetailEntityList)) {
            for (DifferentDetailEntity differentDetailEntity : differentDetailEntityList) {
                if (BigDecimal.ZERO.equals(differentDetailEntity.getDetailCostMny()) || BigDecimal.ZERO.equals(differentDetailEntity.getDetailCostTaxMny())){
                    continue;
                }
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSourceBillCode(differentEntity.getBillCode());
                costDetailVO.setSourceBillName(billName);
                costDetailVO.setSourceBillUrl( url+differentEntity.getId());
                costDetailVO.setSubjectId(differentDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(differentDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(differentDetailEntity.getSubjectName());
                costDetailVO.setWbsId(differentDetailEntity.getWbsId());
                costDetailVO.setWbsCode(differentDetailEntity.getWbsCode());
                costDetailVO.setWbsName(differentDetailEntity.getWbsName());
                costDetailVO.setSourceId(differentDetailEntity.getDifferentId());
                costDetailVO.setSourceDetailId(differentDetailEntity.getId());
                costDetailVO.setHappenTaxMny(differentDetailEntity.getDetailCostTaxMny());
                costDetailVO.setHappenMny(differentDetailEntity.getDetailCostMny());
                costDetailVO.setHappenDate(differentEntity.getDifferentDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType(sourceType);
                costDetailVO.setSourceTabType(sourceTabType);
                costDetailVO.setProjectId(differentEntity.getProjectId());
                costDetailVO.setMaterialId(differentDetailEntity.getMaterialId());
                costDetailVO.setMaterialName(differentDetailEntity.getMaterialName());
                costDetailVO.setMaterialCode(differentDetailEntity.getMaterialCode());
                costDetailVO.setMaterialTypeId(differentDetailEntity.getMaterialTypeId());
                costDetailVO.setMaterialTypeName(differentDetailEntity.getMaterialTypeName());
                costDetailVO.setSpec(differentDetailEntity.getSpec());
                costDetailVO.setUnit(differentDetailEntity.getUnit());
                costDetailVO.setUnitId(differentDetailEntity.getUnitId());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}
