package com.ejianc.business.promaterial.electronicFence.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.enums.FenceConfigChangeStatusEnum;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.electronicFence.vo.ElectronicFenceConfigChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.electronicFence.mapper.ElectronicFenceConfigChangeMapper;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigChangeEntity;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigChangeService;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 电子围栏变更
 * 
 * @author generator
 * 
 */
@Service("electronicFenceConfigChangeService")
public class ElectronicFenceConfigChangeServiceImpl extends BaseServiceImpl<ElectronicFenceConfigChangeMapper, ElectronicFenceConfigChangeEntity> implements IElectronicFenceConfigChangeService{

    @Autowired
    private IElectronicFenceConfigService electronicFenceConfigService;

    @Override
    public ElectronicFenceConfigChangeVO insertOrUpdate(ElectronicFenceConfigChangeVO saveOrUpdateVO) {
        ElectronicFenceConfigEntity sourceEntity = electronicFenceConfigService.selectById(saveOrUpdateVO.getSourceConfigId());

        ElectronicFenceConfigChangeEntity changeEntity = BeanMapper.map(saveOrUpdateVO, ElectronicFenceConfigChangeEntity.class);

        //查询是否存在未生效的变更单
        QueryWrapper<ElectronicFenceConfigChangeEntity> query = new QueryWrapper<>();
        query.eq("source_config_id", saveOrUpdateVO.getSourceConfigId());
        query.notIn("bill_state", new Integer[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()});
        if(null != saveOrUpdateVO.getId()) {
            query.ne("id", saveOrUpdateVO.getId());
        }

        int num = super.count(query);
        if(num > 0) {
            throw new BusinessException("操作失败，该电子围栏设置单在未生效的变更单");
        }

        if(null == changeEntity.getId()) {
            changeEntity.setId(IdWorker.getId());
            if(changeEntity.getChangeVersion() < 10) {
                changeEntity.setChangeCode(sourceEntity.getBillCode() + "-0" + changeEntity.getChangeVersion());
            } else {
                changeEntity.setChangeCode(sourceEntity.getBillCode() + "-" + changeEntity.getChangeVersion());
            }

            if(CollectionUtils.isNotEmpty(changeEntity.getDetailList())) {
                changeEntity.getDetailList().forEach(item -> {
                    item.setPid(changeEntity.getId());
                });
            }

            sourceEntity.setChangeDate(changeEntity.getChangeDate());
            sourceEntity.setChangeCode(changeEntity.getChangeCode());
            sourceEntity.setChangeId(changeEntity.getId());
            sourceEntity.setBeforeChangeStatus(sourceEntity.getChangeStatus());
            sourceEntity.setChangeStatus(FenceConfigChangeStatusEnum.变更中.getCode());
        }

        electronicFenceConfigService.saveOrUpdate(sourceEntity, false);
        super.saveOrUpdate(changeEntity, false);
        return BeanMapper.map(changeEntity, ElectronicFenceConfigChangeVO.class);
    }

    @Override
    public void removeConfigByIds(List<Long> ids) {
        QueryWrapper<ElectronicFenceConfigChangeEntity> query = new QueryWrapper<>();
        query.in("id", ids);
        List<ElectronicFenceConfigChangeEntity> changeList = super.list(query);

        List<Long> sourceConfigIds = changeList.stream().map(ElectronicFenceConfigChangeEntity::getSourceConfigId).collect(Collectors.toList());

        QueryWrapper<ElectronicFenceConfigEntity> sourceQuery = new QueryWrapper<>();
        sourceQuery.in("id", sourceConfigIds);
        List<ElectronicFenceConfigEntity> sourceList = electronicFenceConfigService.list(sourceQuery);

        sourceList.stream().forEach(sourceConfig -> {
            sourceConfig.setChangeId(null);
            sourceConfig.setChangeCode(null);
            sourceConfig.setChangeDate(null);
            sourceConfig.setChangeStatus(sourceConfig.getBeforeChangeStatus());
        });

        electronicFenceConfigService.saveOrUpdateBatch(sourceList, sourceList.size(), false);

        for(Long id : ids) {
            super.removeById(id, false);
        }
    }
}
