package com.ejianc.business.promaterial.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderAdmixtureEntity;
import com.ejianc.business.promaterial.order.vo.*;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.order.mapper.ConcreteOrderMapper;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderEntity;
import com.ejianc.business.promaterial.order.service.IConcreteOrderService;
import org.springframework.web.bind.annotation.RequestMethod;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 混凝土-订单实体
 * 
 * @author generator
 * 
 */
@Service("concreteOrderService")
public class ConcreteOrderServiceImpl extends BaseServiceImpl<ConcreteOrderMapper, ConcreteOrderEntity> implements IConcreteOrderService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    @Autowired
    private IPushMessageApi pushMessageApi;

    @Autowired
    private ISystemDataPushService systemDataPushService;

    private final String OPERATE = "CONCRETE_ORDER_SYNC";

    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/concreteOrder/saveOrUpdate";

    private final String UPDATE_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/concreteOrder/updateOrderCloseFlag";

    private static final String BILL_CODE = "CONCRETE_ORDER";//此处需要根据实际修改

    @Override
    public ConcreteOrderVO queryDetail(Long id) {
        ConcreteOrderEntity entity = super.selectById(id);
        ConcreteOrderVO vo = BeanMapper.map(entity, ConcreteOrderVO.class);
        //处理供应商子表信息
        List<ConcreteOrderDetailVO> concreteOrderDetailList = vo.getConcreteOrderDetailList();
        List<ConcreteOrderAdmixtureEntity> concreteOrderAdmixtureList = entity.getConcreteOrderAdmixtureList();
        if (CollectionUtils.isNotEmpty(concreteOrderAdmixtureList)){
            List<ConcreteOrderAdmixtureVO> listVO = BeanMapper.mapList(concreteOrderAdmixtureList,ConcreteOrderAdmixtureVO.class);
            Map<Long, List<ConcreteOrderAdmixtureVO>> bidderMap = listVO.stream().
                    collect(Collectors.groupingBy(ConcreteOrderAdmixtureVO::getDetailId));
            if (CollectionUtils.isNotEmpty(concreteOrderDetailList)){
                for (ConcreteOrderDetailVO concreteOrderDetailVO : concreteOrderDetailList){
                    List<ConcreteOrderAdmixtureVO> admixtureVOList = bidderMap.get(concreteOrderDetailVO.getId());
                    if (CollectionUtils.isNotEmpty(admixtureVOList)){
                        concreteOrderDetailVO.setConcreteOrderAdmixtureList(admixtureVOList);
                    }
                }
                vo.setConcreteOrderDetailList(concreteOrderDetailList);
            }
        }
        return vo;
    }

    @Override
    public ConcreteOrderVO saveOrUpdates(ConcreteOrderVO saveOrUpdateVO) {
        List<ConcreteOrderDetailVO> concreteOrderDetailList = saveOrUpdateVO.getConcreteOrderDetailList();
        List<ConcreteOrderAdmixtureEntity> admixtureArrayList = new ArrayList<ConcreteOrderAdmixtureEntity>();
        StringBuffer materialName = new StringBuffer();
        if (CollectionUtils.isNotEmpty(concreteOrderDetailList)){
            for (ConcreteOrderDetailVO concreteOrderDetailVO : concreteOrderDetailList){
                if(!"del".equals(concreteOrderDetailVO.getRowState())){
                    materialName.append(concreteOrderDetailVO.getMaterialName()+",");
                }
                if (concreteOrderDetailVO.getId() == null){
                    long id = IdWorker.getId();
                    concreteOrderDetailVO.setId(id);
                }
                List<ConcreteOrderAdmixtureVO> admixtureVOList = concreteOrderDetailVO.getConcreteOrderAdmixtureList();
                if(CollectionUtils.isNotEmpty(admixtureVOList)){
                    for (ConcreteOrderAdmixtureVO concreteOrderAdmixtureVO : admixtureVOList){
                        concreteOrderAdmixtureVO.setDetailId(concreteOrderDetailVO.getId());
                        ConcreteOrderAdmixtureEntity concreteOrderAdmixtureEntity = BeanMapper.map(concreteOrderAdmixtureVO, ConcreteOrderAdmixtureEntity.class);
                        admixtureArrayList.add(concreteOrderAdmixtureEntity);
                    }
                }
            }
        }

        ConcreteOrderEntity entity = BeanMapper.map(saveOrUpdateVO, ConcreteOrderEntity.class);
        entity.setOrderFlag(0);
        if (CollectionUtils.isNotEmpty(admixtureArrayList)){
            entity.setConcreteOrderAdmixtureList(admixtureArrayList);
        }
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        String materialNames = materialName.substring(0, materialName.length() - 1);
        entity.setMaterialName(materialNames);
        super.saveOrUpdate(entity, false);
        ConcreteOrderVO vo = BeanMapper.map(entity, ConcreteOrderVO.class);
        return queryDetail(entity.getId());
    }

    @Override
    public CommonResponse<String> updateOrderFlag(ConcreteOrderVO orderVO) {
        ConcreteOrderEntity orderEntity = super.getById(orderVO.getId());
        CommonResponse<String> res = updatePushBill(orderEntity,"BT220223000000001",UPDATE_BILL_SERVER_URL);
        orderEntity.setOrderFlag(1);
        super.updateById(orderEntity);
        return  CommonResponse.success("关闭成功");
    }

    @Override
    public CommonResponse<OrderVO> updateReceived(SupConcreteOrderVO orderVO) {
        ConcreteOrderEntity orderEntity = super.getById(orderVO.getId());
        if(null!=orderEntity&&null!=orderEntity.getReceiveState()&&orderEntity.getReceiveState()>0&&4!=orderVO.getReceiveState()){
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }

        // TO DO 消息发送
        List<String> messageType = new ArrayList<>();
        messageType.add("sys");
        List<String> sender = new ArrayList<>();
        sender.add(String.valueOf(orderEntity.getCommitId()));
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }

        logger.info("发送信息给发布人:>----------" + sender+frontendBaseHost);
        String formurl = frontendBaseHost+"ejc-promaterial-frontend/#/concreteOrder/card?id="+orderEntity.getId();
        String subject = "";
        String content = "";
        //全部接收
        if(1==orderVO.getReceiveState()){
            orderEntity.setReceiveState(1);//全部接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】全部接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】全部接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            orderEntity.getConcreteOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(vo.getOrderNumsSum());//接收数量
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        }else if(2==orderVO.getReceiveState()){
            //部分接收
            orderEntity.setReceiveState(2);//部分接收
            orderEntity.setDeliverState(0);//待发货
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】部分接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            if(org.apache.commons.collections.CollectionUtils.isNotEmpty(orderVO.getConcreteOrderDetailList())){
                //拆分接收数量
                Map<Long, BigDecimal> map = orderVO.getConcreteOrderDetailList().stream().collect(Collectors.toMap(SupConcreteOrderDetailVO::getId,SupConcreteOrderDetailVO::getReceiveNumsSum));
                logger.debug("map------"+map);
                orderEntity.getConcreteOrderDetailList().forEach(vo -> {
                    vo.setReceiveNumsSum(map.get(vo.getId()));
                    logger.debug("ReceiveNumsSum------"+vo.getReceiveNumsSum());
                    vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
                });
            }
        }else if(3==orderVO.getReceiveState()){
            //已拒绝
            orderEntity.setReceiveState(3);//拒绝
            orderEntity.setReceiveReason(orderVO.getReceiveReason());
            subject = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】拒绝接收。";
            content = "您的订单【"+orderEntity.getProjectName()+"--"+orderEntity.getMaterialName()+"】已经在"+DateFormater.getInstance().format(DateFormater.SHORT_FORMAT)+"被供应商【"+orderEntity.getSupplierName()+"】拒绝接收。<a href=" + '"' + formurl + '"' + ">前往点击</a>";
            //拆分接收数量
            orderEntity.getConcreteOrderDetailList().forEach(vo -> {
                vo.setReceiveNumsSum(BigDecimal.ZERO);//接收数量
                vo.setDeliverNumsSum(BigDecimal.ZERO);//发货数量
            });
        }
        this.sendMsg(messageType, sender, "notice", subject, content,String.valueOf(orderEntity.getTenantId()),orderEntity);
        logger.debug("-----主键"+orderEntity.getId());
        super.saveOrUpdate(orderEntity, false);
        return CommonResponse.success("操作成功");
    }

    @Override
    public CommonResponse<OrderVO> updateDeliverState(SupConcreteOrderVO orderVO) {
        ConcreteOrderEntity orderEntity = super.getById(orderVO.getId());
        if(null==orderEntity){
            return CommonResponse.error("该订单已被操作,请刷新后重试");
        }else{
            orderEntity.setDeliverState(orderVO.getDeliverState());
            super.updateById(orderEntity);
            return CommonResponse.success("操作成功");
        }
    }

    @Override
    public boolean pushBillToSupCenter(ConcreteOrderEntity concreteOrderEntity, String billTypeCode) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + concreteOrderEntity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", concreteOrderEntity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        concreteOrderEntity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("transData", JSONObject.toJSONString(BeanMapper.map(concreteOrderEntity,SupConcreteOrderVO.class)));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(concreteOrderEntity.getId(), "BT220223000000001", "concrete-order-attaches", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送计量单据参数-{}", concreteOrderEntity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        concreteOrderEntity.getSupplierId().toString(),
                        files);
                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
//                if (syncReqResp.isSuccess()) {
//                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
//                    if (billPushResp.isSuccess()) {
//                        syncFlag = true;
//                    } else {
//                        logger.error("供方id-{}处理推送订单单据id-{}失败, {}", concreteOrderEntity.getSupplierId(), concreteOrderEntity.getId(), billPushResp.getMsg());
//                    }
//                } else {
//                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", concreteOrderEntity.getId(), concreteOrderEntity.getSupplierId(), syncReqResp.getMsg());
//                }
            } else {
                logger.error("获取订单单据id-{}对应附件信息失败, {}", concreteOrderEntity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送订单单据id-{}给供方id-{} 异常，", concreteOrderEntity.getId(), concreteOrderEntity.getSupplierId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    @Override
    public CommonResponse<String> updatePushBill(ConcreteOrderEntity concreteOrderEntity, String billTypeCode,String url) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + concreteOrderEntity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", concreteOrderEntity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        concreteOrderEntity.setSystemId(ejcCloudSystemCode.getData());
        CommonResponse<String> syncReqResp = null;
        CommonResponse<String> supHandleResp = null;
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", concreteOrderEntity.getId().toString());
            paramMap.put("systemId", concreteOrderEntity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", concreteOrderEntity.getSupplierId(), concreteOrderEntity.getId());

            //推送单据到指定的供方
            syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    concreteOrderEntity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return CommonResponse.success();
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", concreteOrderEntity.getSupplierId(), concreteOrderEntity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", concreteOrderEntity.getSupplierId(), concreteOrderEntity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error(syncReqResp.getMsg()+"////////"+supHandleResp.getMsg());
            logger.error("通知供方单据id-{}作废异常，", concreteOrderEntity.getId(), e);
            throw new BusinessException(supHandleResp.getMsg());
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content,String tenantId,ConcreteOrderEntity orderEntity) {
        logger.info("发送消息开始！===========");
        PushMsgParameter parameter = new PushMsgParameter();
        List<String> channel = new ArrayList<>();
        if (messageType.contains("sys")) {
            // 系统消息
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);// 收信人
        parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);// 标题
        parameter.setContent(content);// 内容
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());


//        if (messageType.contains("wjy")) {
//            JSONObject wjyMsgParams  = new JSONObject();
//            wjyMsgParams.put("appid", appid);
//            wjyMsgParams.put("from", "供方平台");
//            wjyMsgParams.put("msg", subject);
//            wjyMsgParams.put("url", wjyPath+"cscec5b-wzxt-mobile/#/orderIndex/orderDetails?id="+orderEntity.getId()+"&userid={userid}");
//            parameter.setWjyMsgParams(wjyMsgParams);
//        }

        try {
            CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                logger.error("消息发送成功---------------->" + result.getMsg());
            } else {
                logger.error("消息发送失败---------------->" + result.getMsg());
            }
        } catch (Exception e) {
            logger.error("调用消息中心RPC服务异常--------------" + e);
        }
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }
}
