package com.ejianc.business.promaterial.out.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.SubOutStoreEntity;
import com.ejianc.business.promaterial.out.service.ISubOutStoreService;
import com.ejianc.business.promaterial.out.vo.ExportOutStoreVO;
import com.ejianc.business.promaterial.out.vo.SubOutStoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 分包盘点出库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("subOutStore")
@Api(value = "分包盘点出库", tags = {"分包盘点出库"})
public class SubOutStoreController implements Serializable {
	private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ISubOutStoreService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private IProSupplierApi proSupplierApi;

    private final String billTypeCode = "BT220215000000004";

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SubOutStoreVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody SubOutStoreVO saveOrUpdateVO) {
    	return service.saveOrUpdate(saveOrUpdateVO);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SubOutStoreVO> queryDetail(@RequestParam Long id) {
    	SubOutStoreEntity entity = service.selectById(id);
    	SubOutStoreVO vo = BeanMapper.map(entity, SubOutStoreVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SubOutStoreVO> vos) {
        return service.del(vos);
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SubOutStoreVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("subSupplierName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subEmployeeName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("useFor");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<SubOutStoreEntity> page = service.queryPage(param,false);
        IPage<SubOutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubOutStoreVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("subSupplierName");
        fuzzyFields.add("subContractName");
        fuzzyFields.add("subEmployeeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        //查询本下
        Long orgId = InvocationInfoProxy.getOrgId();
        //若当前上下文为项目部，则根据项目部Id来进行查询
        if(OrgVO.ORG_TYPE_DEPARTMENT.equals(Integer.valueOf(InvocationInfoProxy.getOrgType()))) {
            param.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
        } else {
            CommonResponse<List<OrgVO>> orgResp = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
            if(!orgResp.isSuccess()) {
                logger.error("分页查询失败，获取当前本下组织信息失败, {}", orgResp.getMsg());
                throw new BusinessException("查询失败，获取组织信息失败！");
            }
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN,
                    orgResp.getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        List<SubOutStoreEntity> list = service.queryList(param);
        List<ExportOutStoreVO> listVO = new ArrayList<>();
        //todo:字段翻译等等
       if(CollectionUtils.isNotEmpty(list)){
           for (SubOutStoreEntity entity : list) {
               ExportOutStoreVO storeVO = BeanMapper.map(entity, ExportOutStoreVO.class);
               switch (entity.getBillState()){
                   case 0: storeVO.setBillState("自由态");break;
                   case 1: storeVO.setBillState("已提交");break;
                   case 2: storeVO.setBillState("审批中");break;
                   case 3: storeVO.setBillState("审批通过");break;
                   case 4: storeVO.setSignStatus("审批驳回");break;
                   case 5: storeVO.setBillState("审批中");break;
               }
               if(entity.getSignStatus()!=null){
                   switch (entity.getSignStatus()){
                       case 0: storeVO.setSignStatus("未签字");break;
                       case 1: storeVO.setSignStatus("已签字");break;
                   }
               }
               if(entity.getAttrFlag()!=null){
                   switch (entity.getAttrFlag()){
                       case 1: storeVO.setSignStatus("自购材");break;
                       case 2: storeVO.setSignStatus("甲供材");break;
                   }
               }
               if(entity.getOutDate()!=null){
                   storeVO.setOutDate(DateFormatUtil.formatDate("yyyy-MM-dd", entity.getOutDate()));
               }
               listVO.add(storeVO);
           }
       }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVO);
        ExcelExport.getInstance().export("OutStore-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOutStoreData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SubOutStoreVO>> refOutStoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<SubOutStoreEntity> page = service.queryPage(param,false);
        IPage<SubOutStoreVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), SubOutStoreVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
