package com.ejianc.business.promaterial.contract.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.contract.bean.ContractChangeDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractChangeFeeEntity;
import com.ejianc.business.promaterial.contract.bean.ContractChangeStageEntity;
import com.ejianc.business.promaterial.contract.bean.ContractChangeClauseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 变更-合同实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_contract_change")
public class ContractChangeEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="purchase_type")
    private String purchaseType; // 采购类型 1-自采，2-集采
    @TableField(value="purchase_type_name")
    private String purchaseTypeName; // 集采/自采
    @TableField(value="target_result_id")
    private Long targetResultId; // 定标结果Id
    @TableField(value="target_result_name")
    private String targetResultName; // 定标结果名称
    @TableField(value="project_id")
    private Long projectId; // 项目Id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_place")
    private String projectPlace; // 项目地点
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_category_id")
    private Long contractCategoryId; // 合同类别Id
    @TableField(value="contract_category_name")
    private String contractCategoryName; // 合同类别名称
    @TableField(value="contract_property_code")
    private String contractPropertyCode; // 采购类别code
    @TableField(value="contract_property_name")
    private String contractPropertyName; // 采购类别名称
    @TableField(value="customer_id")
    private Long customerId; // 甲方Id
    @TableField(value="customer_name")
    private String customerName; // 甲方名称
    @TableField(value="supplier_id")
    private Long supplierId; // 乙方Id
    @TableField(value="supplier_name")
    private String supplierName; // 乙方名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="sign_date")
    private Date signDate; // 签订日期
    @TableField(value="sign_place")
    private String signPlace; // 签约地点
    @TableField(value="signature_status")
    private String signatureStatus; // 签章状态：1、未签章；2、待乙方签章；3、待甲方签章；4、已签章；  单据新增后默认为未签章
    @TableField(value="performance_status")
    private String performanceStatus; // 合同履约状态：1、未签订；2、履约中；3、已封账；4、已解除；   默认为未签定，签章状态为已签章时，状态自动更改为【履约中】。当合同存在生效的最终结算时，状态自动改为【已封账】
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 合同税率
    @TableField(value="pay_scale")
    private BigDecimal payScale; // 合同支付比例
    @TableField(value="customer_employee_id")
    private Long customerEmployeeId; // 甲方经办人Id
    @TableField(value="customer_employee_name")
    private String customerEmployeeName; // 甲方经办人名称
    @TableField(value="customer_employee_mobile")
    private String customerEmployeeMobile; // 甲方经办人电话
    @TableField(value="supplier_employee_name")
    private String supplierEmployeeName; // 乙方经办人名称
    @TableField(value="supplier_employee_mobile")
    private String supplierEmployeeMobile; // 乙方经办人电话
    @TableField(value="pricing_type")
    private String pricingType; // 计价方式：1-固定单价、2-浮动单价、3-固定总价
    @TableField(value="draft_type")
    private String draftType; // 起草方式：1、在线起草，2、上传合同，3、线下签订
    @TableField(value="contract_file_path")
    private String contractFilePath; // 合同附件路径
    @TableField(value="contract_file_id")
    private Long contractFileId; // 合同附件Id
    @TableField(value="contract_template_id")
    private Long contractTemplateId; // 合同模板Id
    @TableField(value="contract_template_name")
    private String contractTemplateName; // 合同模板名称
    @TableField(value="contract_file_version_id")
    private Long contractFileVersionId; // 合同附件版本Id
    @TableField(value="contract_file_version")
    private Long contractFileVersion; // 合同附件版本
    @TableField(value="contract_tax_mny")
    private BigDecimal contractTaxMny; // 合同金额
    @TableField(value="contract_mny")
    private BigDecimal contractMny; // 合同金额（无税）
    @TableField(value="contract_tax")
    private BigDecimal contractTax; // 合同税额
    @TableField(value="detail_tax_mny")
    private BigDecimal detailTaxMny; // 清单金额
    @TableField(value="detail_mny")
    private BigDecimal detailMny; // 清单金额（无税）
    @TableField(value="detail_tax")
    private BigDecimal detailTax; // 清单税额
    @TableField(value="free_tax_mny")
    private BigDecimal freeTaxMny; // 其他费用金额
    @TableField(value="free_mny")
    private BigDecimal freeMny; // 其他费用金额（无税）
    @TableField(value="free_tax")
    private BigDecimal freeTax; // 其他费用税额
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="commit_date")
    private Date commitDate; // 提交日期
    @TableField(value="commit_user_name")
    private String commitUserName; // 提交人名称
    @TableField(value="commit_user_code")
    private String commitUserCode; // 提交人账号
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="effective_date")
    private Date effectiveDate; // 生效日期
    @TableField(value="org_id")
    private Long orgId; // 项目部Id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="contract_file_highlight_path")
    private String contractFileHighlightPath; // 合同高亮附件路径
    @TableField(value="contract_file_highlight_id")
    private Long contractFileHighlightId; // 合同高亮附件Id
    @TableField(value="base_money")
    private BigDecimal baseMoney; // 初始版本金额
    @TableField(value="base_money_with_tax")
    private BigDecimal baseMoneyWithTax; // 初始版本(含税)金额
    @TableField(value="before_change_mny")
    private BigDecimal beforeChangeMny; // 变更前金额
    @TableField(value="before_change_mny_with_tax")
    private BigDecimal beforeChangeMnyWithTax; // 变更前金额（含税）

    @TableField(value="before_change_tax")
    private BigDecimal beforeChangeTax; // 变更前税额

    @TableField(value="changing_mny")
    private BigDecimal changingMny; // 变更中金额
    @TableField(value="changing_mny_with_tax")
    private BigDecimal changingMnyWithTax; // 变更中金额（含税）
    @TableField(value="change_code")
    private String changeCode; // 变更单号
    @TableField(value="change_version")
    private Integer changeVersion; // 变更版本
    @TableField(value="change_id")
    private Long changeId; // 变更主键
    @TableField(value="change_status")
    private Integer changeStatus; // 变更状态(1-未变更 2-变更中 3-已变更)
    @TableField(value="supplement_flag")
    private Integer supplementFlag; // 是否补充协议(1:是，0：否)
    @TableField(value="main_contract_id")
    private Long mainContractId; // 主合同Id
    @TableField(value="main_contract_code")
    private String mainContractCode; // 主合同编码
    @TableField(value="main_contract_name")
    private String mainContractName; // 主合同名称
    @TableField(value="supplement_describe")
    private String supplementDescribe; // 补充项描述
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value="main_contract_create_date")
    private Date mainContractCreateDate; // 主合同创建日期(用于合同、补充协议排序)
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="change_date")
    private Date changeDate; // 变更日期
    @TableField(value="change_contract_signature_status")
    private Integer changeContractSignatureStatus; // 变更合同签章状态
    @TableField(value="change_draft_type")
    private String changeDraftType; // 变更起草方式：1-上传附件，2-线下签订
    @TableField(value="change_file_id")
    private Long changeFileId; // 变更附件Id
    @TableField(value="change_contract_name")
    private String changeContractName; // 变更合同名称
    @TableField(value="signed_file_id")
    private Long signedFileId; // 签章完成合同文件Id
    @TableField(value="before_contract_name")
    private String beforeContractName; // 变更前合同名称
    @TableField(value="change_items")
    private String changeItems; // 变更项：用、号隔开。如：数量、单价、税率、甲方、乙方；
    @TableField(value="change_operator_id")
    private Long changeOperatorId; // 经办人
    @TableField(value="change_operator_name")
    private String changeOperatorName; // 变更经办人名称
    @TableField(value="change_money")
    private BigDecimal changeMoney; // 本次变更金额
    @TableField(value="change_scale")
    private BigDecimal changeScale; // 本次变更比例
    @TableField(value="change_rate")
    private BigDecimal changeRate; // 本次变更税率
    @TableField(value="change_reason")
    private String changeReason; // 变更原因描述
    @TableField(value="change_file_path")
    private String changeFilePath; // 变更附件路径
    @TableField(value="memo")
    private String memo; // 备注

    @TableField(value="contract_type")
    private Integer contractType; // 合同类型（0-物资采购合同，1-混凝土合同）

    /**
     * 发票类型Id
     */
    @TableField(value = "invoice_type_id")
    private Long invoiceTypeId;

    /**
     * 发票类型名称
     */
    @TableField(value = "invoice_type_name")
    private String invoiceTypeName;

    @TableField(value="settlement_payment")
    private String settlementPayment; // 结算付款
    @TableField(value="price_float_type")
    private String priceFloatType; // 单价浮动方式

    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    @TableField("filing_status")
    private Integer filingStatus;//是否归档 1：是；0：否
    @TableField("change_filing_status")
    private Integer changeFilingStatus;//是否归档 1：是；0：否
    @TableField("filing_ref")
    private Integer filingRef;//是否被归档引用 归档 1：是；0：否
    /**
     * 水印附件id
     */
    @TableField("watermark_contract_file_id")
    private Long watermarkContractFileId;

    @TableField(value="purchase_id")
    private String purchaseId; // 供货内容id
    @TableField(value="purchase_name")
    private String purchaseName; // 供货内容名称
    
    @TableField(exist=false)
    @SubEntity(serviceName="contractChangeDetailService",pidName = "changeId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractChangeDetailEntity> contractDetailList = new ArrayList<>(); // 变更-合同明细实体
    @TableField(exist=false)
    @SubEntity(serviceName="contractChangeFeeService",pidName = "changeId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractChangeFeeEntity> contractFeeList = new ArrayList<>(); // 变更-合同其他费用实体
    @TableField(exist=false)
    @SubEntity(serviceName="contractChangeStageService",pidName = "changeId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractChangeStageEntity> contractStageList = new ArrayList<>(); // 变更-合同付款阶段实体
    @TableField(exist=false)
    @SubEntity(serviceName="contractChangeClauseService",pidName = "changeId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractChangeClauseEntity> contractClauseList = new ArrayList<>(); // 变更-合同条款实体
    @TableField(exist=false)
    @SubEntity(serviceName="contractChangeAdmixtureService",pidName = "changeId")//此处有pid="xxx"，默认值pid="pid"
    private List<ContractChangeAdmixtureEntity> contractAdmixtureList = new ArrayList<>(); // 主合同外加剂实体

    public String getPurchaseId() {
        return purchaseId;
    }

    public void setPurchaseId(String purchaseId) {
        this.purchaseId = purchaseId;
    }

    public String getPurchaseName() {
        return purchaseName;
    }

    public void setPurchaseName(String purchaseName) {
        this.purchaseName = purchaseName;
    }

    public Long getWatermarkContractFileId() {
        return watermarkContractFileId;
    }

    public void setWatermarkContractFileId(Long watermarkContractFileId) {
        this.watermarkContractFileId = watermarkContractFileId;
    }

    public Integer getFilingStatus() {
        return filingStatus;
    }

    public void setFilingStatus(Integer filingStatus) {
        this.filingStatus = filingStatus;
    }

    public Integer getChangeFilingStatus() {
        return changeFilingStatus;
    }

    public void setChangeFilingStatus(Integer changeFilingStatus) {
        this.changeFilingStatus = changeFilingStatus;
    }

    public Integer getFilingRef() {
        return filingRef;
    }

    public void setFilingRef(Integer filingRef) {
        this.filingRef = filingRef;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getSettlementPayment() {
        return settlementPayment;
    }

    public void setSettlementPayment(String settlementPayment) {
        this.settlementPayment = settlementPayment;
    }

    public String getPriceFloatType() {
        return priceFloatType;
    }

    public void setPriceFloatType(String priceFloatType) {
        this.priceFloatType = priceFloatType;
    }

    public Integer getContractType() {
        return contractType;
    }

    public void setContractType(Integer contractType) {
        this.contractType = contractType;
    }

    public Long getInvoiceTypeId() {
        return invoiceTypeId;
    }

    public void setInvoiceTypeId(Long invoiceTypeId) {
        this.invoiceTypeId = invoiceTypeId;
    }

    public String getInvoiceTypeName() {
        return invoiceTypeName;
    }

    public void setInvoiceTypeName(String invoiceTypeName) {
        this.invoiceTypeName = invoiceTypeName;
    }

    public List<ContractChangeAdmixtureEntity> getContractAdmixtureList() {
        return contractAdmixtureList;
    }

    public void setContractAdmixtureList(List<ContractChangeAdmixtureEntity> contractAdmixtureList) {
        this.contractAdmixtureList = contractAdmixtureList;
    }

    public String getContractPropertyCode() {
        return contractPropertyCode;
    }

    public void setContractPropertyCode(String contractPropertyCode) {
        this.contractPropertyCode = contractPropertyCode;
    }

    public String getContractPropertyName() {
        return contractPropertyName;
    }

    public void setContractPropertyName(String contractPropertyName) {
        this.contractPropertyName = contractPropertyName;
    }

    public BigDecimal getBeforeChangeTax() {
        return beforeChangeTax;
    }

    public void setBeforeChangeTax(BigDecimal beforeChangeTax) {
        this.beforeChangeTax = beforeChangeTax;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getPurchaseType() {
        return purchaseType;
    }

    public void setPurchaseType(String purchaseType) {
        this.purchaseType = purchaseType;
    }
    public String getPurchaseTypeName() {
        return purchaseTypeName;
    }

    public void setPurchaseTypeName(String purchaseTypeName) {
        this.purchaseTypeName = purchaseTypeName;
    }
    public Long getTargetResultId() {
        return targetResultId;
    }

    public void setTargetResultId(Long targetResultId) {
        this.targetResultId = targetResultId;
    }
    public String getTargetResultName() {
        return targetResultName;
    }

    public void setTargetResultName(String targetResultName) {
        this.targetResultName = targetResultName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectPlace() {
        return projectPlace;
    }

    public void setProjectPlace(String projectPlace) {
        this.projectPlace = projectPlace;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getContractCategoryId() {
        return contractCategoryId;
    }

    public void setContractCategoryId(Long contractCategoryId) {
        this.contractCategoryId = contractCategoryId;
    }
    public String getContractCategoryName() {
        return contractCategoryName;
    }

    public void setContractCategoryName(String contractCategoryName) {
        this.contractCategoryName = contractCategoryName;
    }
    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }
    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Date getSignDate() {
        return signDate;
    }

    public void setSignDate(Date signDate) {
        this.signDate = signDate;
    }
    public String getSignPlace() {
        return signPlace;
    }

    public void setSignPlace(String signPlace) {
        this.signPlace = signPlace;
    }
    public String getSignatureStatus() {
        return signatureStatus;
    }

    public void setSignatureStatus(String signatureStatus) {
        this.signatureStatus = signatureStatus;
    }
    public String getPerformanceStatus() {
        return performanceStatus;
    }

    public void setPerformanceStatus(String performanceStatus) {
        this.performanceStatus = performanceStatus;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public BigDecimal getPayScale() {
        return payScale;
    }

    public void setPayScale(BigDecimal payScale) {
        this.payScale = payScale;
    }
    public Long getCustomerEmployeeId() {
        return customerEmployeeId;
    }

    public void setCustomerEmployeeId(Long customerEmployeeId) {
        this.customerEmployeeId = customerEmployeeId;
    }
    public String getCustomerEmployeeName() {
        return customerEmployeeName;
    }

    public void setCustomerEmployeeName(String customerEmployeeName) {
        this.customerEmployeeName = customerEmployeeName;
    }
    public String getCustomerEmployeeMobile() {
        return customerEmployeeMobile;
    }

    public void setCustomerEmployeeMobile(String customerEmployeeMobile) {
        this.customerEmployeeMobile = customerEmployeeMobile;
    }
    public String getSupplierEmployeeName() {
        return supplierEmployeeName;
    }

    public void setSupplierEmployeeName(String supplierEmployeeName) {
        this.supplierEmployeeName = supplierEmployeeName;
    }
    public String getSupplierEmployeeMobile() {
        return supplierEmployeeMobile;
    }

    public void setSupplierEmployeeMobile(String supplierEmployeeMobile) {
        this.supplierEmployeeMobile = supplierEmployeeMobile;
    }
    public String getPricingType() {
        return pricingType;
    }

    public void setPricingType(String pricingType) {
        this.pricingType = pricingType;
    }
    public String getDraftType() {
        return draftType;
    }

    public void setDraftType(String draftType) {
        this.draftType = draftType;
    }
    public String getContractFilePath() {
        return contractFilePath;
    }

    public void setContractFilePath(String contractFilePath) {
        this.contractFilePath = contractFilePath;
    }
    public Long getContractFileId() {
        return contractFileId;
    }

    public void setContractFileId(Long contractFileId) {
        this.contractFileId = contractFileId;
    }
    public Long getContractTemplateId() {
        return contractTemplateId;
    }

    public void setContractTemplateId(Long contractTemplateId) {
        this.contractTemplateId = contractTemplateId;
    }
    public String getContractTemplateName() {
        return contractTemplateName;
    }

    public void setContractTemplateName(String contractTemplateName) {
        this.contractTemplateName = contractTemplateName;
    }
    public Long getContractFileVersionId() {
        return contractFileVersionId;
    }

    public void setContractFileVersionId(Long contractFileVersionId) {
        this.contractFileVersionId = contractFileVersionId;
    }
    public Long getContractFileVersion() {
        return contractFileVersion;
    }

    public void setContractFileVersion(Long contractFileVersion) {
        this.contractFileVersion = contractFileVersion;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public BigDecimal getContractTax() {
        return contractTax;
    }

    public void setContractTax(BigDecimal contractTax) {
        this.contractTax = contractTax;
    }
    public BigDecimal getDetailTaxMny() {
        return detailTaxMny;
    }

    public void setDetailTaxMny(BigDecimal detailTaxMny) {
        this.detailTaxMny = detailTaxMny;
    }
    public BigDecimal getDetailMny() {
        return detailMny;
    }

    public void setDetailMny(BigDecimal detailMny) {
        this.detailMny = detailMny;
    }
    public BigDecimal getDetailTax() {
        return detailTax;
    }

    public void setDetailTax(BigDecimal detailTax) {
        this.detailTax = detailTax;
    }
    public BigDecimal getFreeTaxMny() {
        return freeTaxMny;
    }

    public void setFreeTaxMny(BigDecimal freeTaxMny) {
        this.freeTaxMny = freeTaxMny;
    }
    public BigDecimal getFreeMny() {
        return freeMny;
    }

    public void setFreeMny(BigDecimal freeMny) {
        this.freeMny = freeMny;
    }
    public BigDecimal getFreeTax() {
        return freeTax;
    }

    public void setFreeTax(BigDecimal freeTax) {
        this.freeTax = freeTax;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Date getCommitDate() {
        return commitDate;
    }

    public void setCommitDate(Date commitDate) {
        this.commitDate = commitDate;
    }
    public String getCommitUserName() {
        return commitUserName;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }
    public String getCommitUserCode() {
        return commitUserCode;
    }

    public void setCommitUserCode(String commitUserCode) {
        this.commitUserCode = commitUserCode;
    }
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getContractFileHighlightPath() {
        return contractFileHighlightPath;
    }

    public void setContractFileHighlightPath(String contractFileHighlightPath) {
        this.contractFileHighlightPath = contractFileHighlightPath;
    }
    public Long getContractFileHighlightId() {
        return contractFileHighlightId;
    }

    public void setContractFileHighlightId(Long contractFileHighlightId) {
        this.contractFileHighlightId = contractFileHighlightId;
    }
    public BigDecimal getBaseMoney() {
        return baseMoney;
    }

    public void setBaseMoney(BigDecimal baseMoney) {
        this.baseMoney = baseMoney;
    }
    public BigDecimal getBaseMoneyWithTax() {
        return baseMoneyWithTax;
    }

    public void setBaseMoneyWithTax(BigDecimal baseMoneyWithTax) {
        this.baseMoneyWithTax = baseMoneyWithTax;
    }
    public BigDecimal getBeforeChangeMny() {
        return beforeChangeMny;
    }

    public void setBeforeChangeMny(BigDecimal beforeChangeMny) {
        this.beforeChangeMny = beforeChangeMny;
    }
    public BigDecimal getBeforeChangeMnyWithTax() {
        return beforeChangeMnyWithTax;
    }

    public void setBeforeChangeMnyWithTax(BigDecimal beforeChangeMnyWithTax) {
        this.beforeChangeMnyWithTax = beforeChangeMnyWithTax;
    }
    public BigDecimal getChangingMny() {
        return changingMny;
    }

    public void setChangingMny(BigDecimal changingMny) {
        this.changingMny = changingMny;
    }
    public BigDecimal getChangingMnyWithTax() {
        return changingMnyWithTax;
    }

    public void setChangingMnyWithTax(BigDecimal changingMnyWithTax) {
        this.changingMnyWithTax = changingMnyWithTax;
    }
    public String getChangeCode() {
        return changeCode;
    }

    public void setChangeCode(String changeCode) {
        this.changeCode = changeCode;
    }
    public Integer getChangeVersion() {
        return changeVersion;
    }

    public void setChangeVersion(Integer changeVersion) {
        this.changeVersion = changeVersion;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public Integer getChangeStatus() {
        return changeStatus;
    }

    public void setChangeStatus(Integer changeStatus) {
        this.changeStatus = changeStatus;
    }
    public Integer getSupplementFlag() {
        return supplementFlag;
    }

    public void setSupplementFlag(Integer supplementFlag) {
        this.supplementFlag = supplementFlag;
    }
    public Long getMainContractId() {
        return mainContractId;
    }

    public void setMainContractId(Long mainContractId) {
        this.mainContractId = mainContractId;
    }
    public String getMainContractCode() {
        return mainContractCode;
    }

    public void setMainContractCode(String mainContractCode) {
        this.mainContractCode = mainContractCode;
    }
    public String getMainContractName() {
        return mainContractName;
    }

    public void setMainContractName(String mainContractName) {
        this.mainContractName = mainContractName;
    }
    public String getSupplementDescribe() {
        return supplementDescribe;
    }

    public void setSupplementDescribe(String supplementDescribe) {
        this.supplementDescribe = supplementDescribe;
    }
    public Date getMainContractCreateDate() {
        return mainContractCreateDate;
    }

    public void setMainContractCreateDate(Date mainContractCreateDate) {
        this.mainContractCreateDate = mainContractCreateDate;
    }
    public Date getChangeDate() {
        return changeDate;
    }

    public void setChangeDate(Date changeDate) {
        this.changeDate = changeDate;
    }
    public Integer getChangeContractSignatureStatus() {
        return changeContractSignatureStatus;
    }

    public void setChangeContractSignatureStatus(Integer changeContractSignatureStatus) {
        this.changeContractSignatureStatus = changeContractSignatureStatus;
    }
    public String getChangeDraftType() {
        return changeDraftType;
    }

    public void setChangeDraftType(String changeDraftType) {
        this.changeDraftType = changeDraftType;
    }
    public Long getChangeFileId() {
        return changeFileId;
    }

    public void setChangeFileId(Long changeFileId) {
        this.changeFileId = changeFileId;
    }
    public String getChangeContractName() {
        return changeContractName;
    }

    public void setChangeContractName(String changeContractName) {
        this.changeContractName = changeContractName;
    }
    public Long getSignedFileId() {
        return signedFileId;
    }

    public void setSignedFileId(Long signedFileId) {
        this.signedFileId = signedFileId;
    }
    public String getBeforeContractName() {
        return beforeContractName;
    }

    public void setBeforeContractName(String beforeContractName) {
        this.beforeContractName = beforeContractName;
    }
    public String getChangeItems() {
        return changeItems;
    }

    public void setChangeItems(String changeItems) {
        this.changeItems = changeItems;
    }
    public Long getChangeOperatorId() {
        return changeOperatorId;
    }

    public void setChangeOperatorId(Long changeOperatorId) {
        this.changeOperatorId = changeOperatorId;
    }
    public String getChangeOperatorName() {
        return changeOperatorName;
    }

    public void setChangeOperatorName(String changeOperatorName) {
        this.changeOperatorName = changeOperatorName;
    }
    public BigDecimal getChangeMoney() {
        return changeMoney;
    }

    public void setChangeMoney(BigDecimal changeMoney) {
        this.changeMoney = changeMoney;
    }
    public BigDecimal getChangeScale() {
        return changeScale;
    }

    public void setChangeScale(BigDecimal changeScale) {
        this.changeScale = changeScale;
    }
    public BigDecimal getChangeRate() {
        return changeRate;
    }

    public void setChangeRate(BigDecimal changeRate) {
        this.changeRate = changeRate;
    }
    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }
    public String getChangeFilePath() {
        return changeFilePath;
    }

    public void setChangeFilePath(String changeFilePath) {
        this.changeFilePath = changeFilePath;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<ContractChangeDetailEntity> getContractDetailList() {
        return contractDetailList;
    }

    public void setContractDetailList(List<ContractChangeDetailEntity> contractDetailList) {
        this.contractDetailList = contractDetailList;
    }

    public List<ContractChangeFeeEntity> getContractFeeList() {
        return contractFeeList;
    }

    public void setContractFeeList(List<ContractChangeFeeEntity> contractFeeList) {
        this.contractFeeList = contractFeeList;
    }

    public List<ContractChangeStageEntity> getContractStageList() {
        return contractStageList;
    }

    public void setContractStageList(List<ContractChangeStageEntity> contractStageList) {
        this.contractStageList = contractStageList;
    }

    public List<ContractChangeClauseEntity> getContractClauseList() {
        return contractClauseList;
    }

    public void setContractClauseList(List<ContractChangeClauseEntity> contractClauseList) {
        this.contractClauseList = contractClauseList;
    }
}
