package com.ejianc.business.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.*;
import com.ejianc.business.promaterial.contract.service.IContractAsyncService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkConfigVO;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

@Service("contract") 
public class ContractBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
	@Autowired
	private IContractAsyncService contractAsyncService;
	@Autowired
	ISignatureCommonApi signatureCommonApi;
	@Autowired
	private IParamConfigApi paramConfigApi;

	@Autowired
	private IBillTypeApi billTypeApi;

	@Autowired
	private IOrgApi orgApi;

	@Autowired
	private IContractService contractService;

	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IAttachmentApi attachmentApi;

	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		ContractEntity e = contractService.selectById(billId);

//		if(!(DraftTypeEnum.线下签订.getCode().toString()).equals(e.getDraftType()) && (null == e.getContractFileId())) {
//			//确保线上起草方式时，用户已编辑合同文件
//			return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
//		}
		if(DraftTypeEnum.线上起草.getCode().toString().equals(e.getDraftType())
				|| DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(e.getDraftType())) {
			if(null == e.getContractFileId()) {
				//确保线上起草方式时，用户已编辑合同文件
				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
			}
			if(!e.getContractFileSyncFlag()) {
				return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		ContractEntity e = contractService.selectById(billId);
		logger.info("审批节点审批中时节点审批前回调:  当前数据-{}", JSONObject.toJSONString(e));
		//线上起草且文件未同步
		if((DraftTypeEnum.线上起草.getCode().toString().equals(e.getDraftType())
				|| DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(e.getDraftType()))
				&& !e.getContractFileSyncFlag()) {
			return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
		}
		return CommonResponse.success("审批处理成功！");
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		/*
			起草方式为线下签订则不需要签章
			当不使用电子签章时：创建时默认为未签章，单据审批通过后自动更改为【已签章】
			当签章状态变为【已签章】时，合同状态变为【履约中】
		 */
		ContractEntity contractEntity = contractService.selectById(billId);
		if (contractEntity != null){
			if ((DraftTypeEnum.线下签订.getCode().toString()).equals(contractEntity.getDraftType())) {
				//线下签订合同无需进行签章操作，则审批通过后直接置为已生效状态
				logger.info("合同id-{}为线下签订直接修改为签章状态并设置为履约中", billId);
				contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
				contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
				//合同已生效，添加生效时间
				contractEntity.setEffectiveDate(new Date());
			}
			// 线上起草不使用电子签章，并且已经编辑过合同，审批通过后变为已签章履约中
			else if (DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contractEntity.getDraftType())
					&& contractEntity.getContractFileId() != null && contractEntity.getContractFileSyncFlag()) {
				//线上起草不使用电子签章合同无需进行签章操作，则审批通过后直接置为已生效状态
				logger.info("合同id-{}为线上起草不使用电子签章直接修改为签章状态并设置为履约中", billId);
				contractEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
				contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
				//合同已生效，添加生效时间
				contractEntity.setEffectiveDate(new Date());
			}
//			else if (null == contractEntity.getContractFileId()) {
//				//确保线上起草方式时，用户已编辑合同文件
//				return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
//			}

			if(DraftTypeEnum.线上起草.getCode().toString().equals(contractEntity.getDraftType())
					|| DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contractEntity.getDraftType())) {
				if(null == contractEntity.getContractFileId()) {
					//确保线上起草方式时，用户已编辑合同文件
					return CommonResponse.error("请编辑合同文件并保存后再执行此操作！");
				}
				if(!contractEntity.getContractFileSyncFlag()) {
					return CommonResponse.error("请重新进行合同编辑，同步单据信息到合同文件！");
				}
			}

			// 检查附件
			this.checkContractFile(contractEntity);
		}
		contractService.saveOrUpdate(contractEntity);
		// 生成水印
		contractService.asyncWatermarkById(billId);

		// 推送项目池
		contractService.pushContract(BeanMapper.map(contractEntity, ContractVO.class));
		return CommonResponse.success("合同审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		/*
			弃审逻辑：
			1、审批过程中，支持后台弃审；
			2、当审批通过，且没有走签章流程且没有下游业务时，支持后台弃审；
		 */
		ContractEntity contractEntity = contractService.selectById(billId);
//		if (!(SignatureStatusEnum.未签章.getCode().equals(contractEntitiy.getSignatureStatus()))){
//			return CommonResponse.error("当前单据已有签章流程，暂不支持回退功能！");
//		}
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());

		//使用电子签章且已有签章流程则不允许撤回
		if (DraftTypeEnum.线上起草.getCode().toString().equals(contractEntity.getDraftType())
				|| DraftTypeEnum.上传合同.getCode().toString().equals(contractEntity.getDraftType())) {
			if (!statusList.contains(contractEntity.getSignatureStatus())) {
				return CommonResponse.error("当前单据已有签章流程，不能撤回！");
			}
		}
		else if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureStatus())) {
			contractEntity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
		}
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());
		if (res.isSuccess()) {
			//上级的集采合同不允许被撤回
			Long conorgid = contractEntity.getParentOrgId();//合同组织主键
			CommonResponse<OrgVO> conResp = orgApi.getOneById(conorgid);
			if (!conResp.isSuccess() || !conResp.isSuccess()) {
				return CommonResponse.error("查询合同组织信息失败！");
			}
			Long currentOrg = InvocationInfoProxy.getOrgId();
			String innerCode = conResp.getData().getInnerCode();
//			if(("2".equals(contractEntity.getPurchaseType()) || ("1".equals(contractEntity.getPurchaseType()) &&
//			contractEntity.getReplaceSignFlag() == 1))
			if ((PurchaseTypeEnum.公司集采.getCode().equals(contractEntity.getPurchaseType()))
					&& !innerCode.contains(String.valueOf(currentOrg))) {
				//说明-A组织innerCode包含了B主键，说明B是A的上级
				return CommonResponse.error("当前集采合同编制组织是【" + contractEntity.getParentOrgName() + "】，不可撤回！");
			}
			// 补充协议不允许撤回
//			if (contractEntitiy.getSupplementFlag() == 1) {
//				return CommonResponse.error("补充协议不可撤回");
//			}
			// 允许撤回后，删除合同池中数据
			contractService.pushDelContract(BeanMapper.map(contractEntity, ContractVO.class));

			// 删除文件中心水印文件
			if(contractEntity.getWatermarkContractFileId() != null) {
				boolean delWatermarkflag = contractService.delWatermarkContractFile(contractEntity.getWatermarkContractFileId());
				if (delWatermarkflag) {
					contractEntity.setWatermarkContractFileId(null);
				}
			}

			contractEntity.setPerformanceStatus(PerformanceStatusEnum.未签订.getCode());
			contractEntity.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());
			contractService.saveOrUpdate(contractEntity, false);
			return CommonResponse.success();
		}else{
			return CommonResponse.error(res.getMsg());
		}
//		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		/**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		 if(!resp.isSuccess()){
		 return CommonResponse.error("无法撤回！"+resp.getMsg());
		 }*/
		return CommonResponse.success();
	}


	/**
	 * 检查合同文件
	 *
	 * @param contractEntity
	 */
	private void checkContractFile(ContractEntity contractEntity) {
		//查询合同对饮附件是否存在
		CommonResponse<AttachmentVO> attachResp = attachmentApi
				.queryDetail(contractEntity.getContractFileId().toString());
		if (!attachResp.isSuccess() || null == attachResp.getData()) {
			String sourceType = "mContractFile";
			String billType = BillTypeEnum.消耗材合同.getCode();
			if (MaterialContractTypeEnum.混凝土.getCode().equals(contractEntity.getContractType())) {
				sourceType = "mContractFile"; // 消耗材混凝土文件sourceType目前一致，不做修改
				billType = BillTypeEnum.混凝土合同.getCode();
			}
			logger.info("合同存储文件Id-{}在文件中心不存在，根据参数sourceId-{}, sourceType-{}, billType-{} 查询对应文件信息",
					contractEntity.getContractFileId(), contractEntity.getId(), sourceType, billType);
			//合同附件不存在，根据合同Id、业务类型、查询是否存在对应的文件信息，若存在则更新到合同中，否则抛出异常
			CommonResponse<List<AttachmentVO>> attachListResp = attachmentApi
					.queryListBySourceId(contractEntity.getId(), billType, sourceType, "desc");

			logger.info("根据参数sourceId-{}, sourceType-{}, billType-{} 查询对应文件信息结果：{}",
					contractEntity.getId(), sourceType, billType, JSONObject.toJSONString(attachListResp));
			if (attachListResp.isSuccess() || CollectionUtils.isEmpty(attachListResp.getData())) {
				AttachmentVO attachmentVO = attachListResp.getData().get(0);
				logger.info("将合同id-{}对应合同文件Id-{}改为{}", contractEntity.getId(),
						contractEntity.getContractFileId(), attachmentVO.getId());
				contractEntity.setContractFileId(attachmentVO.getId());
				contractEntity.setContractFilePath(attachmentVO.getTruePath());
			}
			else {
				throw new BusinessException("审批失败，获取合同文件信息失败, 请检查合同文件！");
			}
		}
	}

	@Override
	public CommonResponse<JSONObject> getBpmVariable(Long billId, String billTypeCode) {
		ContractEntity e = contractService.selectById(billId);
		ParamsCheckVO paramsCheckVO = contractService.priceCheckParams(BeanMapper.map(e,ContractVO.class));
		JSONObject object = new JSONObject();
		if(null!=paramsCheckVO&&CollectionUtils.isNotEmpty(paramsCheckVO.getDataSource())){
			object.put("priceFlag","是");//是单价异常
		}else{
			object.put("priceFlag","否");//否 单价异常
		}
		return CommonResponse.success(object);
	}
}
