package com.ejianc.business.promaterial.different.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.promaterial.different.bean.DifferentDetailEntity;
/**
 * 调差单主表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_different")
public class DifferentEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_id")
    private Long projectId; // 项目
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织名称
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="different_date")
    private Date differentDate; // 调整日期
    @TableField(value="cost_type")
    private Integer costType; // 实际成本 0-未分摊，1-已分摊
    @TableField(value="settlement_id")
    private Long settlementId; // 结算主键ID
    @TableField(value="settlement_code")
    private String settlementCode; // 结算单据编号
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资类别名称
    @TableField(value="diff_mny")
    private BigDecimal diffMny; // 调差金额(无税)
    @TableField(value="diff_tax_mny")
    private BigDecimal diffTaxMny; // 调差金额
    @TableField(value="diff_tax")
    private BigDecimal diffTax; // 调差税额
    @TableField(value="cost_mny")
    private BigDecimal costMny; // 成本金额(无税)
    @TableField(value="cost_tax_mny")
    private BigDecimal costTaxMny; // 成本金额
    @TableField(value="settlement_type")
    private Integer settlementType; // 对账单类型（0-物资采购结算单，1-混凝土结算单）
    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    
    @TableField(exist=false)
    @SubEntity(serviceName="differentDetailService",pidName = "differentId")//此处有pid="xxx"，默认值pid="pid"
    private List<DifferentDetailEntity> differentDetailList = new ArrayList<>(); // 调差单子表

    @TableField(value="org_code")
    private String orgCode; // 组织名称

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public Integer getSettlementType() {
        return settlementType;
    }

    public void setSettlementType(Integer settlementType) {
        this.settlementType = settlementType;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public Long getContractId() {
        return contractId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Date getDifferentDate() {
        return differentDate;
    }

    public void setDifferentDate(Date differentDate) {
        this.differentDate = differentDate;
    }
    public Integer getCostType() {
        return costType;
    }

    public void setCostType(Integer costType) {
        this.costType = costType;
    }
    public Long getSettlementId() {
        return settlementId;
    }

    public void setSettlementId(Long settlementId) {
        this.settlementId = settlementId;
    }
    public String getSettlementCode() {
        return settlementCode;
    }

    public void setSettlementCode(String settlementCode) {
        this.settlementCode = settlementCode;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public BigDecimal getDiffMny() {
        return diffMny;
    }

    public void setDiffMny(BigDecimal diffMny) {
        this.diffMny = diffMny;
    }
    public BigDecimal getDiffTaxMny() {
        return diffTaxMny;
    }

    public void setDiffTaxMny(BigDecimal diffTaxMny) {
        this.diffTaxMny = diffTaxMny;
    }
    public BigDecimal getDiffTax() {
        return diffTax;
    }

    public void setDiffTax(BigDecimal diffTax) {
        this.diffTax = diffTax;
    }
    public BigDecimal getCostMny() {
        return costMny;
    }

    public void setCostMny(BigDecimal costMny) {
        this.costMny = costMny;
    }
    public BigDecimal getCostTaxMny() {
        return costTaxMny;
    }

    public void setCostTaxMny(BigDecimal costTaxMny) {
        this.costTaxMny = costTaxMny;
    }
    
    public List<DifferentDetailEntity> getDifferentDetailList() {
        return differentDetailList;
    }

    public void setDifferentDetailList(List<DifferentDetailEntity> differentDetailList) {
        this.differentDetailList = differentDetailList;
    }
}
