package com.ejianc.business.promaterial.doc.mapper;

import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 废旧物资档案分类
 * 
 * @author generator
 * 
 */
@Mapper
public interface WasteCategoryMapper {

    List<WasteCategoryEntity> queryList(Map<String, Object> condition);

    WasteCategoryEntity queryDetail(@Param("tenantId") Long tenantId, @Param("id") Long id);

    void update(WasteCategoryEntity entity);

    List<WasteCategoryEntity> queryByInnerCodes(@Param("tenantId") Long tenantId, @Param("ids")List<Long> ids);

    void updateSubject(@Param("tenantId") Long tenantId,@Param("subjectId") Long subjectId,@Param("subjectName") String subjectName,@Param("ids") List<Long> ids);

    void insert(WasteCategoryEntity entity);

    void insertBatch(@Param("tenantId") Long tenantId,@Param("list") List<WasteCategoryEntity> list);

    List<WasteCategoryEntity> queryListByPid(@Param("tenantId") Long tenantId, @Param("id") Long id);

    List<WasteCategoryEntity> queryListAllByPid(@Param("tenantId") Long tenantId, @Param("id") Long id);

    void delete(@Param("tenantId") Long tenantId,@Param("id") Long id);

    void updateEnabled(@Param("enabled") Integer enabled,@Param("tenantId") Long tenantId,@Param("innerCode") String innerCode);

    List<WasteCategoryEntity>  queryByCode(@Param("tenantId") Long tenantId, @Param("code") String code);

    List<WasteCategoryEntity>  queryByName(@Param("tenantId") Long tenantId, @Param("name") String name);

    void insertCategoryListFromPlatform(@Param("tenantId") Long tenantId);

    List<WasteCategoryEntity> queryListTree(Map<String, Object> params);

    WasteCategoryEntity queryBySourceId(@Param("sourceId") String sourceId,@Param("tenantId") Long tenantId);

    List<WasteCategoryEntity> queryListByInnerCode(Map<String, Object> params);

    List<WasteCategoryEntity> queryListByIds(Map<String, Object> params);
}
