package com.ejianc.business.promaterial.doc.mapper;

import com.ejianc.business.promaterial.doc.vo.WasteItemVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.promaterial.doc.bean.WasteItemEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 废旧物资档案
 * 
 * @author generator
 * 
 */
@Mapper
public interface WasteItemMapper extends BaseCrudMapper<WasteItemEntity> {

    int updateCategoryCodeByCategoryId(@Param("tenantId") Long tenantId, @Param("categoryId") Long categoryId, @Param("categoryCode") String categoryCode);

    int updateByCategoryId(@Param("tenantId") Long tenantId,@Param("categoryId") Long categoryId,@Param("subjectId") Long subjectId,@Param("subjectName") String subjectName);

    List<WasteItemEntity> queryListByCategoryId(@Param("tenantId") Long tenantId, @Param("categoryId") Long categoryId);

    List<WasteItemEntity> queryList(Map<String, Object> condition);

    Long queryCount(Map<String, Object> condition);

    WasteItemEntity queryDetail(@Param("tenantId") Long tenantId, @Param("id") Long id);

    List<WasteItemEntity> queryItem(@Param("tenantId") Long tenantId, @Param("ids") List<Long> ids);

    void updateStateByCategoryId(@Param("tenantId") Long tenantId, @Param("ids") List<Long> ids, @Param("state") Integer state);

    void save(WasteItemVO materialVo);

    void insertBatch(@Param("tenantId") Long tenantId, @Param("list") List<WasteItemVO> list);

    void update(WasteItemVO uniqueBean);

    void amend(@Param("id") Long id, @Param("property") Long property, @Param("propertyName") String propertyName, @Param("tenantId") Long tenantId);

    void delete(@Param("tenantId") Long tenantId, @Param("id") Long id);

    WasteItemVO queryExitFlag(@Param("tenantId") Long tenantId, @Param("name") String name, @Param("spec") String spec, @Param("unitName") String unitName, @Param("categoryId") Long categoryId);

    List<WasteItemVO> queryExcelFlag(@Param("tenantId") Long tenantId, @Param("name") String name,@Param("spec") String spec,@Param("unitName") String unitName,@Param("categoryName") String categoryName);

    WasteItemVO queryByCode(@Param("tenantId") Long tenantId, @Param("code") String code);

    List<WasteItemEntity> queryExportList(Map<String, Object> condition);

    void insertMaterialListFromPlatform(@Param("tenantId") Long tenantId);

    List<WasteItemEntity> queryRefMaterialList(Map<String, Object> params);

    Long queryRefMaterialCount(Map<String, Object> params);

    WasteItemEntity queryBySourceId(@Param("sourceId") String sourceId,@Param("tenantId") Long tenantId);

    List<WasteItemEntity> queryMaterialByIds(@Param("ids") List<Long> ids, @Param("tenantId") Long tenantId);


    List<WasteItemEntity> queryZjwjRefMaterialList(Map<String, Object> params);

    Long queryZjwjRefMaterialCount(Map<String, Object> params);

    List<WasteItemEntity> queryMaterialListByCodes(Map<String, Object> params);

    void insertBatch1(@Param("tenantId") Long tenantId, @Param("list") List<WasteItemVO> list);

    WasteItemVO queryAllByTenantIdAndNameAndTypeAndSpecAndUnitName(@Param("tenantId") Long tenantId, @Param("categoryId") Long categoryId, @Param("name") String name, @Param("type") Integer type, @Param("spec") String spec, @Param("unitName") String unitName, @Param("quality") String quality, @Param("operativeNorm") String operativeNorm);

    void allowIn(@Param("tenantId") Long tenantid, @Param("ids") List<Long> ids);

    List<Map<String, Object>> queryUnit(@Param("tenantId")Long tenantid,  @Param("unitNameList")Set<String> unitNameList);
}
