package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.plan.bean.*;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanChangeHisMapper;
import com.ejianc.business.promaterial.plan.mapper.MasterPlanDetailChangeMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailChangeService;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.plan.utils.TreeNodeBUtil;
import com.ejianc.business.promaterial.plan.vo.*;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckCodeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.share.api.IPriceDepotParamSetApi;
import com.ejianc.foundation.share.consts.PrinceDepotEnum;
import com.ejianc.foundation.share.vo.dto.PriceDepotParamSetDTO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.plan.mapper.MasterPlanChangeMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanChangeService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 消耗材总计划变更
 *
 * @author generator
 */
@Service("masterPlanChangeService")
public class MasterPlanChangeServiceImpl extends BaseServiceImpl<MasterPlanChangeMapper, MasterPlanChangeEntity> implements IMasterPlanChangeService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private MasterPlanChangeMapper planChangeMapper;
    @Autowired
    private MasterPlanDetailChangeMapper masterPlanDetailChangeMapper;
    @Autowired
    private MasterPlanChangeHisMapper masterPlanChangeHisMapper;
    @Autowired
    private IMasterPlanDetailChangeService masterPlanDetailChangeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExecutionApi executionApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Value("${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IMasterPlanChangeService service;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IPriceDepotParamSetApi priceDepotParamSetApi;

    @Override
    public MasterPlanChangeEntity getUnFinishedChange(Long sourcePlanId) {
        QueryWrapper<MasterPlanChangeEntity> query = new QueryWrapper<>();
        query.eq("source_plan_id", sourcePlanId);
        List<Integer> billStates = new ArrayList<>();
        billStates.add(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_HAS_STATE.getBillStateCode());
        billStates.add(BillStateEnum.UNAPPROVED.getBillStateCode());
        billStates.add(BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        query.in("bill_state", billStates);
        return planChangeMapper.selectOne(query);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public MasterPlanChangeEntity saveOrUpdatePlanChange(MasterPlanChangeEntity saveEntity) {
        if (CollectionUtils.isNotEmpty(saveEntity.getMasterPlanDetailList())) {
            //更新子表信息 不需要删子表
            /*if(null != saveEntity.getId()) {
                masterPlanDetailChangeMapper.delByPlanId(saveEntity.getId());
            }*/
        }
        super.saveOrUpdate(saveEntity, false);

        MasterPlanEntity planEntity = masterPlanService.selectById(saveEntity.getSourcePlanId());
        if (1 != planEntity.getChangeState()) {
            planEntity.setChangeState(1);
            planEntity.setCurChangingPlanId(saveEntity.getId());
            masterPlanService.saveOrUpdate(planEntity, false);
        }
        return saveEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteChangePlan(List<Long> changeIds) {
        List<MasterPlanChangeEntity> changeList = planChangeMapper.selectBatchIds(changeIds);
        List<Long> planIds = changeList.stream().map(MasterPlanChangeEntity::getSourcePlanId).collect(Collectors.toList());

        QueryWrapper<MasterPlanEntity> planQuery = new QueryWrapper<>();
        planQuery.in("id", planIds);
        List<MasterPlanEntity> planList = masterPlanService.list(planQuery);

        //查询已有的变更历史记录
        QueryWrapper<MasterPlanChangeHisEntity> query = new QueryWrapper<>();
        query.select("ifnull(count(1), 0) as hisNum, source_plan_id as planId");
        query.in("source_plan_id", planIds);
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.groupBy("source_plan_id");

        List<Map<String, Object>> queryResult = masterPlanChangeHisMapper.selectMaps(query);
        Map<Long, Integer> hisCountNumMap = new HashMap<>();
        queryResult.stream().forEach(m -> {
            hisCountNumMap.put(Long.valueOf(m.get("planId").toString()), Integer.valueOf(m.get("hisNum").toString()));
        });

        for (MasterPlanEntity plan : planList) {
            plan.setChangeState((null != hisCountNumMap.get(plan.getId()) && hisCountNumMap.get(plan.getId()) > 0) ? 2 : 0); //未变更
            plan.setCurChangingPlanId(null);
        }

        masterPlanService.saveOrUpdateBatch(planList, planList.size());

        super.removeByIds(changeList.stream().map(MasterPlanChangeEntity::getId).collect(Collectors.toList()), false);
    }

    @Override
    public List<MasterPlanChangeHisVO> queryDetailRecord(Long id) {
        LambdaQueryWrapper<MasterPlanChangeEntity> lambda = Wrappers.<MasterPlanChangeEntity>lambdaQuery();
        lambda.eq(MasterPlanChangeEntity::getSourcePlanId, id);
        lambda.in(MasterPlanChangeEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        List<MasterPlanChangeEntity> entities = super.list(lambda);
        List<MasterPlanChangeHisVO> recordVOList = BeanMapper.mapList(entities, MasterPlanChangeHisVO.class);
        recordVOList.forEach(recordVO -> {
                    if (recordVO.getChangeVersion() < 10) {
                        recordVO.setHistoryCode(recordVO.getPlanCode() + "-0" + recordVO.getChangeVersion());
                    }
                    else {
                        recordVO.setHistoryCode(recordVO.getPlanCode() + "-" + recordVO.getChangeVersion());
                    }
                }
        );
        return recordVOList;
    }

    @Override
    public MasterPlanChangeVO queryDetail(Long id, boolean detailHasChildren) {
        MasterPlanChangeEntity masterPlanChangeEntity = super.selectById(id);
        MasterPlanChangeVO masterPlanChangeVO = BeanMapper.map(masterPlanChangeEntity, MasterPlanChangeVO.class);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("materialMasterPlanId", new Parameter(QueryParam.EQ, id));
        queryParam.getOrderMap().put("treeIndex", "asc");
        List<MasterPlanDetailChangeEntity> masterPlanDetailChangeEntities = masterPlanDetailChangeService.queryList(queryParam, false);
        List<MasterPlanDetailChangeEntity> detailEntityList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(masterPlanDetailChangeEntities)) {
            masterPlanDetailChangeEntities.forEach(entity -> {
                if (null == entity.getChangeType() || 2 != entity.getChangeType()) {
                    detailEntityList.add(entity);
                }
            });
        }
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            for (MasterPlanDetailChangeEntity cdEntity : detailEntityList) {
                if (cdEntity.getMaterialId() == null) {//如果是分类  tid = 分类id pid = null
                    cdEntity.setTid(cdEntity.getMaterialCategoryId().toString());
                    cdEntity.setTpid("999");
                }
                else {//如果是物资  tid = 物资id pid = 分类id
                    cdEntity.setTid(cdEntity.getMaterialId().toString());
                    cdEntity.setTpid(cdEntity.getMaterialCategoryId().toString());
                }
//                cdEntity.setTid(cdEntity.getId().toString());
//                cdEntity.setTpid(cdEntity.getParentId()!= null&&cdEntity.getParentId()>0?cdEntity.getParentId().toString():"");
                cdEntity.setRowState("edit");
            }
            List<MasterPlanDetailChangeVO> resultMapList = BeanMapper.mapList(detailEntityList, MasterPlanDetailChangeVO.class);
            if (detailHasChildren) {
                masterPlanChangeVO.setMasterPlanDetailList(TreeNodeBUtil.buildTree(resultMapList));
            }
            else {
                masterPlanChangeVO.setMasterPlanDetailList(resultMapList);
            }
        }
        else {
            masterPlanChangeVO.setMasterPlanDetailList(BeanMapper.mapList(detailEntityList, MasterPlanDetailChangeVO.class));
        }

        return masterPlanChangeVO;
    }

    @Override
    public CommonResponse<MasterPlanChangeVO> saveOrUpdateMasterPlan(MasterPlanChangeVO planVo, Boolean isControl) {
        //校验项目是否存在未完成的变更计划单存在
        MasterPlanChangeEntity planChangeEntity = service.getUnFinishedChange(planVo.getSourcePlanId());

        if (null != planChangeEntity && (null == planVo.getId() || !planChangeEntity.getId().equals(planVo.getId()))) {
            throw new BusinessException("保存失败，该项目存在未完成的变更计划！");
        }

        MasterPlanEntity masterPlan = masterPlanService.getById(planVo.getSourcePlanId());
        UserContext userContext = sessionManager.getUserContext();
        MasterPlanChangeEntity saveEntity = null;
        if (null == planVo.getId()) {
            saveEntity = BeanMapper.map(planVo, MasterPlanChangeEntity.class);
            saveEntity.setId(IdWorker.getId());
            //设置为自由态
            saveEntity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            //变更版本号
            saveEntity.setChangeVersion(masterPlan.getChangeVersion() + 1);
            saveEntity.setCommitUserName(userContext.getUserName());
            //设置变更人
            saveEntity.setChangeUserName(userContext.getUserName());

            saveEntity.setPlanCode(masterPlan.getPlanCode());
            saveEntity.setProjectName(masterPlan.getProjectName());
            saveEntity.setOrgName(masterPlan.getOrgName());
            saveEntity.setOrgId(masterPlan.getOrgId());
            saveEntity.setCreateUserName(userContext.getUserName());

        }
        else {
            saveEntity = service.getById(planVo.getId());
            saveEntity.setProjectId(planVo.getProjectId());
            saveEntity.setProjectName(planVo.getProjectName());
            saveEntity.setRemark(planVo.getRemark());
            saveEntity.setPlanCode(planVo.getPlanCode());
            saveEntity.setTotalPlanAmt(planVo.getTotalPlanAmt());
            saveEntity.setModifyUserName(userContext.getUserName());
            saveEntity.setMasterPlanDetailList(BeanMapper.mapList(planVo.getMasterPlanDetailList(), MasterPlanDetailChangeEntity.class));
        }

        if (null == saveEntity.getTotalPlanAmt()) {
            saveEntity.setTotalPlanAmt(BigDecimal.ZERO.setScale(8));
        }

        //保存前清空主键和父主键，重新生成
        List<MasterPlanDetailChangeEntity> beforeDetails = saveEntity.getMasterPlanDetailList();
        if (CollectionUtils.isNotEmpty(beforeDetails) && null == saveEntity.getId()) {
            for (MasterPlanDetailChangeEntity cdEntity : beforeDetails) {
                cdEntity.setId(null);
                cdEntity.setParentId(null);
            }
        }

        //目标成本删除之前数据
        //判断是否是第一次变更
        if (!isControl) {
            if (null == planVo.getId()) {
                QueryWrapper<MasterPlanChangeEntity> wrapper = new QueryWrapper<>();
                wrapper.eq("source_plan_id", planVo.getSourcePlanId()).eq("dr", 0).orderByDesc("change_version");
                List<MasterPlanChangeEntity> list = service.list(wrapper);
                List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
                ExecutionVO executionVO1;
                String billType;
                if (list.size() > 0) {
                    if (list.get(0).getPlanType() == 0) {
                        billType = BillTypeEnum.消耗材总计划变更.getCode();
                    }
                    else {
                        billType = BillTypeEnum.混凝土总计划变更.getCode();
                    }
                    executionVO1 = masterPlanService.targetCost(BeanMapper.map(list.get(0), MasterPlanVO.class), "", billType, list.get(0).getPlanType());
                }
                else {
                    MasterPlanEntity masterPlanEntity = masterPlanService.selectById(saveEntity.getSourcePlanId());
                    if (masterPlanEntity.getPlanType() == 0) {
                        billType = BillTypeEnum.消耗材总计划.getCode();
                    }
                    else {
                        billType = BillTypeEnum.混凝土总计划.getCode();
                    }
                    executionVO1 = masterPlanService.targetCost(BeanMapper.map(masterPlanEntity, MasterPlanVO.class), "", billType, masterPlanEntity.getPlanType());
                }
                totalExecutionVOList.add(executionVO1.getTotalVO());
                logger.info("目标成本删除数据" + JSON.toJSONString(totalExecutionVOList));
                CommonResponse<String> response1 = executionApi.aggDel(totalExecutionVOList);
                if (!response1.isSuccess()) {
                    throw new BusinessException("目标成本推送失败," + response1.getMsg());
                }
            }
            saveEntity = service.saveOrUpdatePlanChange(saveEntity);
            List<MasterPlanDetailChangeEntity> changeDetailEntities = saveEntity.getMasterPlanDetailList();
            if (CollectionUtils.isNotEmpty(changeDetailEntities)) {
                Map<String, Long> idMap = new HashMap<>();
                for (MasterPlanDetailChangeEntity cdEntity : changeDetailEntities) {
                    idMap.put(cdEntity.getTid(), cdEntity.getId());
                }
                for (MasterPlanDetailChangeEntity cdEntity : changeDetailEntities) {
                    if (StringUtils.isNotEmpty(cdEntity.getTpid())) {
                        cdEntity.setParentId(idMap.get(cdEntity.getTpid()));
                    }
                }
                List<Map> resultMapList = BeanMapper.mapList(changeDetailEntities, Map.class);
                List<Map<String, Object>> treeData = ResultAsTree.createTreeData(resultMapList);

                List<Map<String, Object>> ListCodeDate = creatInnerCode(treeData, null);
                List<MasterPlanDetailChangeEntity> saveEntities = new ArrayList<>();
                treeToList(ListCodeDate, saveEntities);
                masterPlanDetailChangeService.saveOrUpdateBatch(saveEntities, saveEntities.size(), false);
            }
        }

        MasterPlanChangeVO masterPlanChangeVO = null;
        //推送目标成本
        //新推数据
        if (!isControl) {
            String linkUrl;
            String billType;
            String frontendBaseHost="";
            if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
                frontendBaseHost = BASE_HOST_FRONTEND;
            }else{
                frontendBaseHost = baseHost;
            }
            if (saveEntity.getPlanType() == 0) {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + saveEntity.getId();
                billType = BillTypeEnum.消耗材总计划变更.getCode();
            }
            else {
                linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + saveEntity.getId();
                billType = BillTypeEnum.混凝土总计划变更.getCode();
            }
            ExecutionVO executionVO = masterPlanService.targetCost(BeanMapper.map(saveEntity, MasterPlanVO.class), linkUrl, billType, saveEntity.getPlanType());
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
            masterPlanChangeVO = service.queryDetail(saveEntity.getId(), true);
        }
        else {
            masterPlanChangeVO = BeanMapper.map(saveEntity, MasterPlanChangeVO.class);
        }
        return CommonResponse.success("保存成功！", masterPlanChangeVO);
    }

    /**
     * 生成内码
     *
     * @param list
     * @param innerCode
     * @return
     */
    private List<Map<String, Object>> creatInnerCode(List<Map<String, Object>> list, String innerCode) {
        for (int i = 0; i < list.size(); i++) {
            Map<String, Object> ypd = list.get(i);
            // 生成内码
            /*if (StringUtils.isNotEmpty(innerCode)) {
                ypd.put("innerCode", innerCode + "&&" + ypd.get("id"));
            } else {
                ypd.put("innerCode", ypd.get("id"));
            }*/

            if (ypd.get("children") != null) {
                List<Map<String, Object>> child = creatInnerCode((List) ypd.get("children"), null);
                ypd.put("children", child);
                ypd.put("leafFlag", false);
            }
            else {
                ypd.put("leafFlag", true);
            }
        }
        return list;
    }

    private void treeToList(List<Map<String, Object>> list, List<MasterPlanDetailChangeEntity> entities) {
        for (Map<String, Object> ypd : list) {
            if (ypd.get("children") != null) {
                treeToList((List) ypd.get("children"), entities);
            }
            entities.add(BeanMapper.map(ypd, MasterPlanDetailChangeEntity.class));
        }
    }

    @Override
    public ParamsCheckVO targetCostCtrl(MasterPlanChangeVO masterPlanVO) {
        CommonResponse<MasterPlanChangeVO> masterPlanVOCommonResponse = saveOrUpdateMasterPlan(masterPlanVO, true);
        MasterPlanChangeVO planVO = masterPlanVOCommonResponse.getData();
        String linkUrl;
        String billType;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        if (masterPlanVO.getPlanType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + planVO.getId();
            billType = BillTypeEnum.消耗材总计划变更.getCode();
        }
        else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + planVO.getId();
            billType = BillTypeEnum.混凝土总计划变更.getCode();
        }
        //目标成本推送
        if (null == masterPlanVO.getId()) {
            QueryWrapper<MasterPlanChangeEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("source_plan_id", planVO.getSourcePlanId()).eq("dr", 0).orderByDesc("change_version");
            List<MasterPlanChangeEntity> list = service.list(wrapper);
            if (list.size() > 0) {
                planVO.setSourcePlanId(list.get(0).getId());
            }
        }
        MasterPlanVO masterPlanVO1 = BeanMapper.map(planVO, MasterPlanVO.class);
        masterPlanVO1.setMasterPlanDetailList(BeanMapper.mapList(planVO.getMasterPlanDetailList(), MasterPlanDetailVO.class));
        ExecutionVO executionVO = masterPlanService.targetCost(masterPlanVO1, linkUrl, billType, planVO.getPlanType());
        logger.error("目标成本控制推送数据" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = response.getData();
//        if (CollectionUtils.isEmpty(data.getDataSource())) {
//            data.setWarnType("none");
//        }
        logger.info("目标成本控制返回信息："+JSONObject.toJSONString(response));
        //参数控制
        ParamsCheckVO paramsCheckVO = checkParams(planVO, response.getData());
        return data;
    }

    //单据参数控制
    public ParamsCheckVO checkParams(MasterPlanChangeVO masterPlanVO, ParamsCheckVO paramsCheckVO2){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
        ParamsCheckVO priceParam = this.priceCheckParams(masterPlanVO);
        if(priceParam!=null){//价格库控制
            paramsCheckVOS.add(priceParam);
        }

        if(paramsCheckVO2!=null){//组合成本参数
            paramsCheckVOS.add(paramsCheckVO2);
        }
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    @Override
    public ParamsCheckVO priceCheckParams(MasterPlanChangeVO masterPlanVO) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<>();
        //招标立项
        if(CollectionUtil.isNotEmpty(masterPlanVO.getMasterPlanDetailList())){
            for (MasterPlanDetailChangeVO detailVO : masterPlanVO.getMasterPlanDetailList()) {
                if(!"del".equals(detailVO.getRowState()) && detailVO.getMaterialId()!=null){
                    MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                    priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                    priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                    priceHistoryApiVO.setSpec(detailVO.getSpec());
                    priceHistoryApiVO.setPrice(detailVO.getPrice());
//                        priceHistoryApiVO.setTaxPrice(detailVO.getTaxPrice());
                    priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                    priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                    priceHistoryApiVO.setGuideTaxPriceArea(detailVO.getGuideTaxPriceArea());
                    priceHistoryApiVO.setGuidePriceArea(detailVO.getGuidePriceArea());
                    materialPriceHistoryApiVOS.add(priceHistoryApiVO);
                }
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(masterPlanVO.getOrgId());
        ParamsCheckVO paramsCheckVO = priceCheckParams(materialPriceHistoryApiVO);
        return  paramsCheckVO;
    }

    public ParamsCheckVO priceCheckParams(MaterialPriceHistoryApiVO materialPriceHistoryApiVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        List<MaterialPriceHistoryApiVO> detailList = materialPriceHistoryApiVO.getMaterialPriceHistoryApiVOList();
        if(CollectionUtils.isEmpty(detailList)){//传入集合为空直接返回结果
            logger.info("detailList为空直接返回结果");
            return paramsCheckVO;
        }
        String MAX_CODE = MaterialPriceCheckCodeEnum.材料总计划最高价.getCode();
        String MIN_CODE =MaterialPriceCheckCodeEnum.材料总计划最低价.getCode();
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if(null==orgId){
            logger.info("orgId为空");
            return paramsCheckVO;
        }
        //查询高价比例
//        CommonResponse<BillParamVO> maxParamByCode = paramConfigApi.getBillParamByCode(MAX_CODE);
        CommonResponse<List<BillParamVO>> maxParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE,orgId);
        if(!maxParamByCode.isSuccess() && null == maxParamByCode.getData()){
            logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
//            throw new BusinessException("获取历史高价控制参数失败");
        }
        //查询高价比例
//        CommonResponse<BillParamVO> minParamByCode = paramConfigApi.getBillParamByCode(MIN_CODE);
        CommonResponse<List<BillParamVO>> minParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MIN_CODE,orgId);
        if(!minParamByCode.isSuccess() && null == minParamByCode.getData()){
            logger.info(minParamByCode.getMsg());
            return paramsCheckVO;
//            throw new BusinessException("获取历史低价控制参数失败");
        }
        List<BillParamVO> maxParamVOS = maxParamByCode.getData();//校验结果
        List<BillParamVO> minParamVOS = minParamByCode.getData();
        logger.info("材料高价控制信息返回："+JSONObject.toJSONString(maxParamVOS));
        logger.info("材料低价控制信息返回："+JSONObject.toJSONString(minParamVOS));
        //todo 取优先级
        boolean flag = true;
        logger.info("传入参数--{}",JSONObject.toJSONString(PrinceDepotEnum.材料价格库.getCode()));
        CommonResponse<List<PriceDepotParamSetDTO>> commonResponse = priceDepotParamSetApi.queryPriceDepotParamSetList(PrinceDepotEnum.材料价格库.getCode());
        if(!commonResponse.isSuccess()){
            throw new BusinessException(commonResponse.getMsg());
        }
        List<PriceDepotParamSetDTO> data = commonResponse.getData();
        Integer priorityFlag = data.get(0).getPriorityFlag();
        if(null!=priorityFlag&&2==priorityFlag){
            //指导价优先
            flag = false;
        }
        if(CollectionUtils.isNotEmpty(maxParamVOS)){//遍历高价
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOMax = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();//高价校验比例
                paramsCheckVOMax.setWarnType(paramsArray[maxParamVO.getControlType()]);//高价赋值控制类型
                for (MaterialPriceHistoryApiVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("物资：{}--高价：{}---低价：{}",detailVO.getMaterialName()+detailVO.getSpec(),split[1],split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                        BigDecimal maxPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(maxPrice, roleValueMax), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if (price.compareTo(maxPriceParam) >0) {
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("材料单价大于历史最高价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("材料单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最高价*").append(roleValueMax).append("%:").append(maxPriceParam)
                                    .append("，超出最高价：").append(ComputeUtil.safeSub(price,maxPriceParam).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMax.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMax.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOMax);
            }
        }
        if(CollectionUtils.isNotEmpty(minParamVOS)){//遍历低价
            for (BillParamVO minParamVO : minParamVOS) {
                ParamsCheckVO paramsCheckVOMin = new ParamsCheckVO();//高价
                List<ParamsCheckDsVO> checkDsVOSMin = new ArrayList<>();
                BigDecimal roleValueMin = minParamVO.getRoleValue();//低价校验比例
                paramsCheckVOMin.setWarnType(paramsArray[minParamVO.getControlType()]);//低价赋值控制类型
                for (MaterialPriceHistoryApiVO  detailVO: detailList) {//遍历明细
                    //根据优先级取价格
                    String getHistoryPriceArea = "";
                    if(flag){
                        //历史价格优先   先去历史价  为空再取  指导价
                        getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getGuidePriceArea();
                        }
                    }else{
                        //指导价优先   先去指导价  为空再取  历史价
                        getHistoryPriceArea = detailVO.getGuidePriceArea();
                        if(com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(getHistoryPriceArea)){
                            getHistoryPriceArea = detailVO.getHistoryPriceArea();
                        }
                    }
                    if(getHistoryPriceArea!=null && !getHistoryPriceArea.isEmpty()){//历史区间不为空"-"
                        String[] split = getHistoryPriceArea.split("-");//截取高低价
                        BigDecimal maxPrice = new BigDecimal(split[1]);
                        BigDecimal minPrice =new BigDecimal(split[0]);
                        logger.info("物资：{}--高价：{}---低价：{}",detailVO.getMaterialName()+detailVO.getSpec(),split[1],split[0]);
                        if(maxPrice.compareTo(minPrice)==0){//相等跳过循环
                            continue;
                        }
                        BigDecimal price = detailVO.getPrice()==null?BigDecimal.ZERO:detailVO.getPrice().setScale(4, BigDecimal.ROUND_HALF_UP);//物资单价
                        BigDecimal minPriceParam = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(minPrice, roleValueMin), new BigDecimal("100")).setScale(4, BigDecimal.ROUND_HALF_UP);
                        if(price.compareTo(minPriceParam) < 0){
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(minParamVO.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName()+(detailVO.getSpec()==null ? "" : "+"+detailVO.getSpec()));
                            paramsCheckDsVO.setWarnName("材料单价小于历史最低价");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("材料单价：").append(price)
                                    .append("，历史价格区间:(").append(getHistoryPriceArea)
                                    .append("),历史最低价*").append(roleValueMin).append("%:").append(minPriceParam)
                                    .append("，低于最低价：").append(ComputeUtil.safeSub(minPriceParam,price).setScale(4,BigDecimal.ROUND_HALF_UP));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOSMin.add(paramsCheckDsVO);
                        }
                    }
                }
                paramsCheckVOMin.setDataSource(checkDsVOSMin);
                paramsCheckVOS.add(paramsCheckVOMin);
            }
        }
        /*添加参数控制区域---*/
        String[] paramsArr = {"alert", "warn", "none"};
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        if(org.apache.commons.collections.CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArr) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(org.apache.commons.collections.CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else{
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        MasterPlanChangeVO planVO = queryDetail(id, true);
        String linkUrl;
        String billType;
        String frontendBaseHost="";
        if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
            frontendBaseHost = BASE_HOST_FRONTEND;
        }else{
            frontendBaseHost = baseHost;
        }
        if (planVO.getPlanType() == 0) {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/masterPlan/changeCard?id=" + planVO.getId();
            billType = BillTypeEnum.消耗材总计划变更.getCode();
        }
        else {
            linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/concreteMasterPlan/changeCard?id=" + planVO.getId();
            billType = BillTypeEnum.混凝土总计划变更.getCode();
        }
        //目标成本推送
        ExecutionVO executionVO = masterPlanService.targetCost(BeanMapper.map(planVO, MasterPlanVO.class), linkUrl, billType, planVO.getPlanType());
        logger.error("目标成本控制推送数据" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO data = response.getData();
        if (CollectionUtils.isEmpty(data.getDataSource())) {
            data.setWarnType("none");
        }
        return data;
    }
}
