/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.electronicFence.service.impl;

import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigChangeEntity;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigDetailEntity;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigRecordEntity;
import com.ejianc.business.promaterial.electronicFence.enums.FenceConfigChangeStatusEnum;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigChangeService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigRecordService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="electronicFenceConfigChange")
public class ElectronicFenceConfigChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IElectronicFenceConfigService electronicFenceConfigService;
    @Autowired
    private IElectronicFenceConfigChangeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IElectronicFenceConfigRecordService electronicFenceConfigRecordService;

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        ElectronicFenceConfigChangeEntity e = (ElectronicFenceConfigChangeEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ElectronicFenceConfigChangeEntity e = (ElectronicFenceConfigChangeEntity)((Object)this.service.selectById(billId));
        ElectronicFenceConfigEntity sourceConfig = (ElectronicFenceConfigEntity)((Object)this.electronicFenceConfigService.selectById(e.getSourceConfigId()));
        ElectronicFenceConfigRecordEntity record = this.generateRecord(sourceConfig);
        this.updateChangeInfo2SourceConfig(sourceConfig, e);
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            e.setCommitDate(new Date());
            e.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            e.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        e.setEffectiveDate(new Date());
        this.electronicFenceConfigRecordService.saveOrUpdate((Object)record, false);
        this.electronicFenceConfigService.saveOrUpdate((Object)sourceConfig, false);
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }

    private void updateChangeInfo2SourceConfig(ElectronicFenceConfigEntity sourceConfig, ElectronicFenceConfigChangeEntity e) {
        sourceConfig.setEnable(e.getEnable());
        sourceConfig.getDetailList().stream().forEach(item -> item.setRowState("del"));
        sourceConfig.getDetailList().addAll(BeanMapper.mapList(e.getDetailList(), ElectronicFenceConfigDetailEntity.class));
        sourceConfig.setChangeVersion(e.getChangeVersion());
        sourceConfig.setChangeId(null);
        sourceConfig.setChangeCode(null);
        sourceConfig.setChangeDate(null);
        sourceConfig.setChangeStatus(FenceConfigChangeStatusEnum.\u5df2\u53d8\u66f4.getCode());
    }

    private ElectronicFenceConfigRecordEntity generateRecord(ElectronicFenceConfigEntity sourceConfig) {
        ElectronicFenceConfigRecordEntity record = (ElectronicFenceConfigRecordEntity)((Object)BeanMapper.map((Object)((Object)sourceConfig), ElectronicFenceConfigRecordEntity.class));
        record.setSourceConfigId(record.getId());
        record.setId(IdWorker.getId());
        record.getDetailList().stream().forEach(detail -> {
            detail.setSourcePid(sourceConfig.getId());
            detail.setSourceSubId(detail.getId());
            detail.setId(detail.getId());
            detail.setPid(record.getId());
        });
        return record;
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u53d8\u66f4\u5df2\u751f\u6548\uff01");
    }
}

