package com.ejianc.business.promaterial.scrap.controller;

import java.io.Serializable;

import com.ejianc.business.promaterial.scrap.bean.ScrapMaterialApplicationEntity;
import com.ejianc.business.promaterial.scrap.bean.ScrapMaterialApplicationManifestContentEntity;
import com.ejianc.business.promaterial.scrap.service.IScrapMaterialApplicationService;
import com.ejianc.business.promaterial.scrap.vo.ScrapMaterialApplicationVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;


/**
 * 废旧物资处置申请
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("scrapMaterialApplication")
public class ScrapMaterialApplicationController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "SCRAP_MATERIAL_APPLICATION";//此处需要根据实际修改

    @Autowired
    private IScrapMaterialApplicationService service;

    @Autowired
    private SessionManager sessionManager;
    private BigDecimal estimatedAmount;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ScrapMaterialApplicationVO> saveOrUpdate(@RequestBody ScrapMaterialApplicationVO saveOrUpdateVO) {
    	ScrapMaterialApplicationEntity entity = BeanMapper.map(saveOrUpdateVO, ScrapMaterialApplicationEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        List<ScrapMaterialApplicationManifestContentEntity> scrapMaterialApplicationManifestContentList = entity.getScrapMaterialApplicationManifestContentList();
            estimatedAmount = BigDecimal.ZERO;
            scrapMaterialApplicationManifestContentList.forEach(item -> {
            estimatedAmount= estimatedAmount.add(item.getEstimateMny());
        });
        entity.setEstimatedAmount(estimatedAmount);
        if (entity.getPricingType()==3||entity.getPricingType()==4)
            if (entity.getScrapMaterialApplicationInviteContentList() == null || entity.getScrapMaterialApplicationInviteContentList().size() < 3)
                throw new BusinessException("请至少选择三个拟邀请单位");
        if (entity.getIsUsed() == null)
            entity.setIsUsed(0);
    	service.saveOrUpdate(entity, false);
    	ScrapMaterialApplicationVO vo = BeanMapper.map(entity, ScrapMaterialApplicationVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ScrapMaterialApplicationVO> queryDetail(Long id) {
    	ScrapMaterialApplicationEntity entity = service.selectById(id);
    	ScrapMaterialApplicationVO vo = BeanMapper.map(entity, ScrapMaterialApplicationVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ScrapMaterialApplicationVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ScrapMaterialApplicationVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ScrapMaterialApplicationVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ScrapMaterialApplicationVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("mainMaterialName");
        fuzzyFields.add("scrapTypeName");
        fuzzyFields.add("compiler");
        fuzzyFields.add("applyTime");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ScrapMaterialApplicationEntity> page = service.queryPage(param,false);
        IPage<ScrapMaterialApplicationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScrapMaterialApplicationVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("parentOrgName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("mainMaterialName");
        fuzzyFields.add("scrapTypeName");
        fuzzyFields.add("compiler");
        fuzzyFields.add("applyTime");
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ScrapMaterialApplicationEntity> pageData = service.queryPage(param, false);

        Map<String, Object> beans = new HashMap<String, Object>();
        if (pageData.getRecords() != null && CollectionUtils.isNotEmpty(pageData.getRecords())) {
            List<ScrapMaterialApplicationVO> list = BeanMapper.mapList(pageData.getRecords(), ScrapMaterialApplicationVO.class);
            list.forEach(e -> {
                e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
                if (e.getScrapType() == 0){
                    e.setScrapTypeName("损毁材料、边角料");
                }
                else if (e.getScrapType() == 1){
                    e.setScrapTypeName("报废设备配件");
                }
                else if (e.getScrapType() == 2){
                    e.setScrapTypeName("各类包装物品");
                }
                else if (e.getScrapType() == 3){
                    e.setScrapTypeName("闲置无法调剂物资");
                }
                else if (e.getScrapType() == 4){
                    e.setScrapTypeName("其他");
                }
            });
            beans.put("records", list);
            ExcelExport.getInstance().export("ScrapMaterialApplication-export.xlsx", beans, response);
        }
    }
    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refScrapMaterialApplicationData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ScrapMaterialApplicationVO>> refScrapMaterialApplicationData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("isUsed", new Parameter(QueryParam.NE, 99));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));

        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }
        IPage<ScrapMaterialApplicationEntity> page = service.queryPage(param,false);
        IPage<ScrapMaterialApplicationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ScrapMaterialApplicationVO.class));
        pageData.getRecords().forEach(e -> {
            if (e.getIsUsed() == 1)
            e.setIsUsedName("已使用");
            else
            e.setIsUsedName("未使用");
        });
        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
