/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.doc.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.promaterial.doc.bean.WasteCategoryEntity;
import com.ejianc.business.promaterial.doc.service.IWasteCategoryService;
import com.ejianc.business.promaterial.doc.service.IWasteItemService;
import com.ejianc.business.promaterial.doc.vo.WasteCategoryVO;
import com.ejianc.business.promaterial.doc.vo.WasteItemVO;
import com.ejianc.business.promaterial.doc.vo.WasteMaterialCategoryImportVO;
import com.ejianc.business.promaterial.utils.WasteMaterialCategoryAsTree;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"wasteCategory"})
public class WasteCategoryController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String MATERIAL_CATEGORY_BILL_CODE = "WASTE_MATERIAL_CATEGORY";
    @Value(value="${oms.tenantid}")
    private String OMS_TENANT;
    @Autowired
    private IWasteCategoryService materialCategoryService;
    @Autowired
    private IWasteItemService materialService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IThirdSystemApi thirdSystemApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveOrUpdate(@RequestBody WasteCategoryVO materialCategoryVo) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (materialCategoryVo.getId() != null && materialCategoryVo.getId() > 0L) {
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{materialCategoryVo.getCode()})) {
                List<WasteCategoryEntity> codeData = this.materialCategoryService.queryByCode(materialCategoryVo.getCode());
                if (codeData != null && codeData.size() > 0 && !materialCategoryVo.getId().equals(codeData.get(0).getId())) {
                    throw new BusinessException("\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
                }
            } else {
                throw new BusinessException("\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            WasteCategoryVO uniqueBean = this.materialCategoryService.queryDetail(materialCategoryVo.getId());
            if (StringUtils.isNotBlank((CharSequence)materialCategoryVo.getCode()) && !materialCategoryVo.getCode().equals(uniqueBean.getCode())) {
                this.materialService.updateCategoryCodeByCategoryId(materialCategoryVo.getId(), materialCategoryVo.getCode());
            }
            uniqueBean.setCode(materialCategoryVo.getCode());
            uniqueBean.setName(materialCategoryVo.getName());
            uniqueBean.setUnitId(materialCategoryVo.getUnitId());
            uniqueBean.setUnitName(materialCategoryVo.getUnitName());
            uniqueBean.setDescription(materialCategoryVo.getDescription());
            uniqueBean.setSequence(materialCategoryVo.getSequence());
            uniqueBean.setUpdateUserCode(InvocationInfoProxy.getUsercode());
            uniqueBean.setUpdateTime(materialCategoryVo.getUpdateTime());
            uniqueBean.setSubjectId(materialCategoryVo.getSubjectId());
            uniqueBean.setSubjectName(materialCategoryVo.getSubjectName());
            uniqueBean.setSequence(materialCategoryVo.getSequence());
            WasteCategoryEntity entity = (WasteCategoryEntity)((Object)BeanMapper.map((Object)uniqueBean, WasteCategoryEntity.class));
            this.materialCategoryService.update(entity);
            return CommonResponse.success((String)"\u4fee\u6539\u6210\u529f");
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{materialCategoryVo.getCode()})) {
            List<WasteCategoryEntity> codeData = this.materialCategoryService.queryByCode(materialCategoryVo.getCode());
            if (codeData != null && codeData.size() > 0) {
                throw new BusinessException("\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728,\u8bf7\u91cd\u65b0\u586b\u5199");
            }
        } else {
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(MATERIAL_CATEGORY_BILL_CODE, tenantId);
            if (codeBatchByRuleCode.isSuccess()) {
                materialCategoryVo.setCode((String)codeBatchByRuleCode.getData());
            }
        }
        WasteCategoryEntity entity = (WasteCategoryEntity)((Object)BeanMapper.map((Object)materialCategoryVo, WasteCategoryEntity.class));
        entity.setId(IdWorker.getId());
        if (entity.getParentId() != null && entity.getParentId() > 0L) {
            WasteCategoryVO uniqueBean = this.materialCategoryService.queryDetail(entity.getParentId());
            entity.setInnerCode(uniqueBean.getInnerCode() + "|" + entity.getId());
        } else {
            entity.setInnerCode(entity.getId().toString());
        }
        entity.setEnabled(1);
        entity.setCreateUserCode(InvocationInfoProxy.getUsercode());
        entity.setCreateTime(new Date());
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        this.materialCategoryService.save(entity);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> queryList(@RequestBody QueryParam queryParam) {
        List<WasteCategoryEntity> dataList = this.materialCategoryService.queryList(queryParam);
        List resultMapList = BeanMapper.mapList(dataList, Map.class);
        resultMapList.forEach(l -> {
            if (l.get("isLeaf").equals(false)) {
                l.put("children", new ArrayList());
            }
        });
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("data", (Object)ResultAsTree.createTreeData((List)resultMapList));
        return CommonResponse.success((Object)jsonObject);
    }

    @RequestMapping(value={"/bandSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> bandSubject(@RequestBody Map map) {
        List ids = (List)map.get("ids");
        Long subjectId = Long.valueOf(map.get("subjectId").toString());
        String subjectName = (String)map.get("subjectName");
        this.materialCategoryService.updateSubject(subjectId, subjectName, ids);
        return CommonResponse.success((String)"\u7ed1\u5b9a\u6210\u529f!");
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WasteCategoryVO> queryDetail(@RequestParam Long id) {
        WasteCategoryVO materialCategoryVo = this.materialCategoryService.queryDetail(id);
        return CommonResponse.success((Object)materialCategoryVo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<Long> ids) {
        if (ListUtil.isNotEmpty(ids)) {
            for (Long id : ids) {
                WasteCategoryVO materialCategoryVO = this.materialCategoryService.queryDetail(id);
                List<WasteItemVO> materialList = this.materialService.queryListByCategoryId(id);
                if (materialList != null && materialList.size() > 0) {
                    return CommonResponse.error((String)("\u5206\u7c7b\u3010" + materialCategoryVO.getName() + "\u3011\u4e0b\u6709\u7269\u6599\u4e86\uff0c\u4e0d\u5141\u8bb8\u5220\u9664"));
                }
                List<WasteCategoryVO> children = this.materialCategoryService.queryListByPid(id);
                if (children == null || children.size() <= 0) continue;
                for (WasteCategoryVO child : children) {
                    if (ids.contains(child.getId())) continue;
                    return CommonResponse.error((String)("\u5206\u7c7b\u3010" + materialCategoryVO.getName() + "\u3011\u4e0b\u6709\u5b50\u5206\u7c7b\u4e0d\u5141\u8bb8\u5220\u9664"));
                }
            }
        } else {
            return CommonResponse.error((String)"\u5220\u9664\u5931\u8d25\uff1a\u4e3b\u952e\u4e3a\u7a7a!");
        }
        this.materialCategoryService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f");
    }

    @RequestMapping(value={"/enabled/update"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> updateEnabled(@RequestBody WasteCategoryVO materialCategoryVo) {
        WasteCategoryVO condition = this.materialCategoryService.queryDetail(materialCategoryVo.getId());
        this.materialCategoryService.updateEnabled(materialCategoryVo.getEnabled(), condition.getTenantId(), condition.getInnerCode());
        return CommonResponse.success((String)"\u66f4\u65b0\u6210\u529f");
    }

    @RequestMapping(value={"/queryMaterialRefTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<WasteCategoryEntity> queryMaterialRefTree(@RequestParam(required=false) String searchText) {
        List<WasteCategoryEntity> dataList = null;
        long start = System.currentTimeMillis();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                params.put("searchText", searchText);
            }
            params.put("tenantId", InvocationInfoProxy.getTenantid());
            dataList = this.materialCategoryService.queryListEntityTree(params);
            System.out.println("\u67e5\u8be2\u8017\u65f6:" + (System.currentTimeMillis() - start));
            if (dataList != null && dataList.size() > 0) {
                List<WasteCategoryEntity> resultList = WasteMaterialCategoryAsTree.createTreeData(dataList);
                System.out.println("\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
                return resultList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @RequestMapping(value={"/lazyMaterialCategoryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> lazyMaterialCategoryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        List<WasteCategoryVO> dataList = null;
        try {
            JSONObject con;
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (StringUtils.isNotBlank((CharSequence)searchText)) {
                Object categoryIdObj;
                params.put("searchText", searchText);
                params.put("tenantId", InvocationInfoProxy.getTenantid());
                if (StringUtils.isNotBlank((CharSequence)condition) && null != (categoryIdObj = (con = JSONObject.parseObject((String)condition)).get((Object)"categoryId"))) {
                    List<Long> asList = new ArrayList<Long>();
                    String categoryId = (String)categoryIdObj;
                    if (categoryId.indexOf(",") > 0) {
                        String[] strings = categoryId.split(",");
                        for (String str : strings) {
                            asList.add(Long.valueOf(str));
                        }
                    } else {
                        asList.add(Long.valueOf(categoryId));
                    }
                    ArrayList<WasteCategoryVO> categoryList = new ArrayList<WasteCategoryVO>();
                    for (Long parentId : asList) {
                        categoryList.addAll(this.materialCategoryService.queryListByPid(parentId));
                    }
                    asList = categoryList.stream().map(WasteCategoryVO::getId).collect(Collectors.toList());
                    params.put("ids", asList);
                }
                dataList = this.materialCategoryService.queryListTree(params);
            } else {
                Object categoryIdObj;
                dataList = this.materialCategoryService.queryListByPid(pid);
                if (StringUtils.isNotBlank((CharSequence)condition) && null != (categoryIdObj = (con = JSONObject.parseObject((String)condition)).get((Object)"categoryId")) && pid == null) {
                    ArrayList<Long> asList = new ArrayList<Long>();
                    String categoryId = (String)categoryIdObj;
                    if (categoryId.indexOf(",") > 0) {
                        String[] strings;
                        for (String str : strings = categoryId.split(",")) {
                            asList.add(Long.valueOf(str));
                        }
                    } else {
                        asList.add(Long.valueOf(categoryId));
                    }
                    dataList = this.materialCategoryService.queryCategoryListByIds(asList);
                }
            }
            List map = BeanMapper.mapList(dataList, Map.class);
            return ResultAsTree.createTreeData((List)map);
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"material-category-import.xlsx", (String)"\u7269\u6599\u5206\u7c7b\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList successList = new ArrayList();
        ArrayList<WasteMaterialCategoryImportVO> processList = new ArrayList<WasteMaterialCategoryImportVO>();
        ArrayList<WasteMaterialCategoryImportVO> errorList = new ArrayList<WasteMaterialCategoryImportVO>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5206\u7c7b\u6570\u636e\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            HashMap<String, ArrayList<WasteMaterialCategoryImportVO>> mapChildren = new HashMap<String, ArrayList<WasteMaterialCategoryImportVO>>();
            HashMap<String, WasteMaterialCategoryImportVO> codeToData = new HashMap<String, WasteMaterialCategoryImportVO>();
            HashMap codeNotExistData = new HashMap();
            for (int i = 0; i < result.size(); ++i) {
                List datas = (List)result.get(i);
                WasteMaterialCategoryImportVO materialVo = new WasteMaterialCategoryImportVO();
                materialVo.setId(Long.valueOf(IdWorker.getId()));
                materialVo.setCode((String)datas.get(0));
                materialVo.setParentCode((String)datas.get(1));
                materialVo.setName((String)datas.get(2));
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(0)))) {
                    materialVo.setDescription("\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(2)))) {
                    materialVo.setDescription("\u5206\u7c7b\u540d\u79f0\u4e3a\u7a7a\uff01");
                    errorList.add(materialVo);
                    continue;
                }
                List<WasteCategoryEntity> list = this.materialCategoryService.queryByCode(String.valueOf(datas.get(0)));
                if (ListUtil.isEmpty(list)) {
                    List<Object> list1;
                    list = this.materialCategoryService.queryByName(String.valueOf(datas.get(2)));
                    if (ListUtil.isNotEmpty(list)) {
                        materialVo.setDescription("\u5206\u7c7b\u540d\u79f0\u91cd\u590d\uff01");
                        errorList.add(materialVo);
                        continue;
                    }
                    if (StringUtils.isBlank((CharSequence)((CharSequence)datas.get(1)))) {
                        materialVo.setInnerCode(materialVo.getId().toString());
                    }
                    materialVo.setEnabled(Integer.valueOf(1));
                    materialVo.setCreateUserCode(InvocationInfoProxy.getUsercode());
                    materialVo.setCreateTime(new Date());
                    materialVo.setTenantId(InvocationInfoProxy.getTenantid());
                    processList.add(materialVo);
                    codeToData.put(materialVo.getCode(), materialVo);
                    if (StringUtils.isBlank((CharSequence)materialVo.getParentCode())) {
                        list1 = (ArrayList<WasteMaterialCategoryImportVO>)mapChildren.get("null");
                        if (ListUtil.isEmpty((List)list1)) {
                            list1 = new ArrayList<WasteMaterialCategoryImportVO>();
                            mapChildren.put("null", (ArrayList<WasteMaterialCategoryImportVO>)list1);
                        }
                        list1.add(materialVo);
                        continue;
                    }
                    list1 = (List)mapChildren.get(materialVo.getParentCode());
                    if (ListUtil.isEmpty((List)list1)) {
                        list1 = new ArrayList();
                        mapChildren.put(materialVo.getParentCode(), (ArrayList<WasteMaterialCategoryImportVO>)list1);
                    }
                    list1.add(materialVo);
                    continue;
                }
                materialVo.setDescription("\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff01");
                errorList.add(materialVo);
            }
            if (ListUtil.isNotEmpty(processList)) {
                processList.forEach(p -> {
                    if (StringUtils.isNotEmpty((CharSequence)p.getParentCode())) {
                        WasteMaterialCategoryImportVO parentVo = (WasteMaterialCategoryImportVO)codeToData.get(p.getParentCode());
                        if (parentVo == null) {
                            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)codeNotExistData.get(p.getParentCode())))) {
                                p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((WasteMaterialCategoryImportVO)p);
                            } else {
                                List<WasteCategoryEntity> list = this.materialCategoryService.queryByCode(p.getParentCode());
                                if (ListUtil.isEmpty(list)) {
                                    codeNotExistData.put(p.getParentCode(), p.getParentCode());
                                    p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                    errorList.add((WasteMaterialCategoryImportVO)p);
                                } else {
                                    p.setInnerCode(list.get(0).getInnerCode() + "|" + p.getId());
                                    p.setParentId(list.get(0).getId());
                                    successList.add(p);
                                }
                            }
                        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
                            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                                p.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                                errorList.add((WasteMaterialCategoryImportVO)p);
                            } else {
                                p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                                p.setParentId(parentVo.getId());
                                successList.add(p);
                            }
                        } else {
                            p.setInnerCode(parentVo.getInnerCode() + "|" + p.getId());
                            p.setParentId(parentVo.getId());
                            successList.add(p);
                        }
                    } else {
                        successList.add(p);
                    }
                });
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList);
        return CommonResponse.success((Object)json);
    }

    private void setInnerCodeAndParentId(WasteMaterialCategoryImportVO vo, Map<String, WasteMaterialCategoryImportVO> codeToData, Map<String, String> codeNotExistData) {
        WasteMaterialCategoryImportVO parentVo = codeToData.get(vo.getParentCode());
        if (parentVo == null) {
            if (StringUtils.isNotEmpty((CharSequence)codeNotExistData.get(vo.getParentCode()))) {
                vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                List<WasteCategoryEntity> list = this.materialCategoryService.queryByCode(vo.getParentCode());
                if (ListUtil.isEmpty(list)) {
                    codeNotExistData.put(vo.getParentCode(), vo.getParentCode());
                    vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
                } else {
                    vo.setInnerCode(list.get(0).getInnerCode() + "|" + vo.getId());
                    vo.setParentId(list.get(0).getId());
                }
            }
        } else if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
            this.setInnerCodeAndParentId(parentVo, codeToData, codeNotExistData);
            if (StringUtils.isEmpty((CharSequence)parentVo.getInnerCode())) {
                vo.setDescription("\u7236\u5206\u7c7b\u7f16\u7801\u4e0d\u5b58\u5728");
            } else {
                vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
                vo.setParentId(parentVo.getId());
            }
        } else {
            vo.setInnerCode(parentVo.getInnerCode() + "|" + vo.getId());
            vo.setParentId(parentVo.getId());
        }
    }

    @RequestMapping(value={"/saveImportExcelMaterialCategory"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcelMaterialCategory(@RequestBody List<WasteMaterialCategoryImportVO> importVOS) {
        if (ListUtil.isEmpty(importVOS)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<WasteCategoryEntity> toSave = new ArrayList<WasteCategoryEntity>();
        importVOS.forEach(importVO -> toSave.add((WasteCategoryEntity)((Object)BeanMapper.map((Object)importVO, WasteCategoryEntity.class))));
        this.materialCategoryService.insertBatch(toSave);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam queryParam, HttpServletResponse response) {
        queryParam.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        queryParam.getParams().put("queryAll", new Parameter("eq", (Object)"true"));
        List<WasteCategoryEntity> resultList = this.materialCategoryService.queryList(queryParam);
        HashMap<String, List<WasteCategoryEntity>> beans = new HashMap<String, List<WasteCategoryEntity>>();
        beans.put("records", resultList);
        ExcelExport.getInstance().export("materialCategory-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/changeCategoryEnableState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> changeCategoryEnableState(@RequestParam(value="id") Long id, @RequestParam(value="enabled") Integer enabled) {
        this.materialCategoryService.changeCategoryEnableState(id, enabled);
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

