package com.ejianc.business.promaterial.order.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.enums.DeliverStateEnum;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.business.promaterial.order.vo.OrderExportVO;
import com.ejianc.business.promaterial.order.vo.OrderVO;
import com.ejianc.business.promaterial.order.vo.SupOrderVO;
import com.ejianc.business.promaterial.plan.vo.MonthPlanVO;
import com.ejianc.foundation.orgcenter.api.IEmployeeApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 材料订单主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("order")
@Api(value = "材料订单主表", tags = {"材料订单主表"})
public class OrderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IOrderService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IEmployeeApi employeeApi;

    @Autowired
    private IShareCooperateApi shareCooperateApi;

    private final String billTypeCode = "BT220223000000006";

    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/materialOrder/card";

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody OrderVO saveOrUpdateVO) {
          return   service.saveOrUpdate(saveOrUpdateVO);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OrderVO> queryDetail(@RequestParam Long id) {
        return service.queryDetail(id);
    }


    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OrderVO> vos) {
        return service.delete(vos);
    }

    @ApiOperation("获取当前登录人手机号")
    @RequestMapping(value = "/queryPhone", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryPhone() {
        String mobilePhone = employeeApi.getById(sessionManager.getUserContext().getEmployeeId()).getData().getMobilePhone();
        return CommonResponse.success("查询列表数据成功！",mobilePhone);
    }

    @ApiOperation("保存前校验")
    @RequestMapping(value = "/savaHintFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<Map> savaHintFlag(@RequestBody OrderVO orderVO) {
        Map<String, Object> stringObjectMap = service.savaHintFlag(orderVO);
        return CommonResponse.success("查询列表数据成功！",stringObjectMap);
    }
    @ApiOperation("接收")
    @RequestMapping(value = "/updateReceived", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> updateReceived(@RequestBody SupOrderVO supOrderVO){
        return service.updateReceived(supOrderVO);
    }

    @ApiOperation("撤回供方本地测试")
    @RequestMapping(value = "/chgf", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> chgf(@RequestParam Long id){
        OrderEntity orderEntity = service.selectById(id);
        CommonResponse<String> response = service.updatePushBill(orderEntity, "BT220223000000006", "/ejc-supbusiness-web/openapi/materialOrder/deleteOrder");
        return response;
    }


    @ApiOperation("推送供方本地测试")
    @RequestMapping(value = "/tsgf", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> tsgf(@RequestParam Long id){
        OrderEntity orderEntity = service.selectById(id);
        //处理推送数据，只推送子表父级
        if(CollectionUtils.isNotEmpty(orderEntity.getOrderDetailList())){
            List<OrderDetailEntity> orderDetail = new ArrayList<>();
            for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
                if(!orderDetailEntity.getLeafFlag()){//判断是否是父级
                    orderDetail.add(orderDetailEntity);
                }
            }
            orderEntity.setOrderDetailList(orderDetail);
        }
        //推送供方
        Boolean pushFlag = service.pushBillToSupCenter(orderEntity,"BT220223000000006");
        logger.info("获取推送供方结果--"+pushFlag);
        if(pushFlag){
            //推送成功后处理逻辑
            if(BillStateEnum.COMMITED_STATE.getBillStateCode() == 1){
                orderEntity.setCommitId(InvocationInfoProxy.getUserid());
            }
            orderEntity.setReceiveState(0);
            service.saveOrUpdate(orderEntity,false);
        }else{
            return CommonResponse.error("推送供方失败");
        }
        return CommonResponse.success();
    }
    @ApiOperation("修改发货状态")
    @RequestMapping(value = "/updateDeliver", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> updateDeliver(@RequestBody OrderVO orderVO) {
        return service.updateDeliver(orderVO.getId(),orderVO.getDeliverState());
    }
    @ApiOperation("获取最新的计划剩余数量")
    @RequestMapping(value = "/getSurplusNumsSum", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BigDecimal> getSurplusNumsSum(@RequestParam  Long orderDetailId,@RequestParam Long projectId,@RequestParam Long materialId) {
        BigDecimal surplusNumsSum = service.getSurplusNumsSum(orderDetailId, projectId, materialId);
        return CommonResponse.success("获取最新的计划剩余数量成功",surplusNumsSum);
    }
    @ApiOperation("关闭")
    @RequestMapping(value = "/close", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> close(@RequestParam Long orderId){
        return service.close(orderId);
    }
    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        OrderEntity entity = service.selectById(id);
        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), mobileBillShareFrontUrl,null);
    }
    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("parentOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("parentOrgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OrderEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<OrderExportVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (OrderEntity orderEntity : list) {
                OrderExportVO map = BeanMapper.map(orderEntity, OrderExportVO.class);
                map.setBillState(BillStateEnum.getEnumByStateCode(orderEntity.getBillState()).getDescription());
                if(null!=orderEntity.getOrderExpiryDate()){
                    map.setOrderExpiryDate(DateFormatUtil.formatDate("yyyy-MM-dd",orderEntity.getOrderExpiryDate()));
                }
                if(null!=orderEntity.getReceiveState()){
                    switch (orderEntity.getReceiveState()){
                        case  0:map.setReceiveState("待接收");break;
                        case  2:map.setReceiveState("部分接收");break;
                        case  1:map.setReceiveState("全部接收");break;
                        case  3:map.setReceiveState("不予接收");break;
                    }
                }
                if(null!=orderEntity.getDeliverState()){
                    switch (orderEntity.getDeliverState()){
                        case  0:map.setDeliverState("待送货");break;
                        case  1:map.setDeliverState("部分送货");break;
                        case  2:map.setDeliverState("已送货");break;
                    }
                }
                if(null!=orderEntity.getOrderFlag()){
                    switch (orderEntity.getOrderFlag()){
                        case  0:map.setOrderFlag("正常");break;
                        case  1:map.setOrderFlag("已关闭");break;
                    }
                }
                voList.add(map);
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("Order-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refOrderData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OrderVO>> refOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OrderEntity> page = service.queryPage(param,false);
        IPage<OrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OrderVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
