package com.ejianc.business.promaterial.pricelib.mapper;

import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.promaterial.pricelib.bean.PriceSettlementEntity;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.Date;
import java.util.List;

/**
 * 价格库-结算明细
 * 
 * @author generator
 * 
 */
@Mapper
public interface PriceSettlementMapper extends BaseCrudMapper<PriceSettlementEntity> {
    @Select("select * from ejc_promaterial_settlement where create_time >= #{time} or update_time >= #{time}")
    List<SettlementEntity> getSettlementListByTime(Date time);
    @Select({
            "<script>",
            "select * from ejc_promaterial_settlement_detail where settlement_id in",
            "<foreach collection='settlementIdList' item='settlementId' open='(' separator=',' close=')'>",
            "#{settlementId}",
            "</foreach>",
            "</script>"
    })
    List<SettlementDetailEntity> getSettlementDetailListBySettlementId(@Param("settlementIdList") List<Long> settlementIdList);

    @Delete("delete from ejc_promaterial_price_settlement where bill_state not in (1,3)")
    void delPriceSettlementByBillState();

    @Delete({
            "<script>",
            "delete from ejc_promaterial_price_settlement where id in",
            "<foreach collection='ids' item='id' open='(' separator=',' close=')'>",
            "#{id}",
            "</foreach>",
            "</script>"
    })
    void delPriceSettlementByIds(@Param("ids") List<Long> ids);

    @Select({
            "<script>",
            "select * from ejc_promaterial_contract where id in",
            "<foreach collection='contractIds' item='id' open='(' separator=',' close=')'>",
            "#{id}",
            "</foreach>",
            "</script>"
    })
    List<ContractEntity> getContractListByIds(@Param("contractIds") List<Long> contractIds);
}
