package com.ejianc.business.promaterial.scrap.bean;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import org.elasticsearch.search.DocValueFormat;


/**
 * 废旧物资处置申请
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_scrap_material_application")
public class ScrapMaterialApplicationEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="apply_time")
    private Date applyTime; // 申请日期
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="parent_org_name")
    private String parentOrgName; // 父组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 父组织编码
    @TableField(value="other_reason")
    private String otherReason; // 其他原因
    @TableField(value="main_material_name")
    private String mainMaterialName; // 主要物资名称
    @TableField(value="compiler")
    private String compiler; // 编制人
    @TableField(value="disposal_reason")
    private String disposalReason; // 处置原因
    @TableField(value="platform_name")
    private String platformName; // 平台名称
    @TableField(value="not_first_disposal_reason")
    private String notFirstDisposalReason; // 非首次处置原因
    @TableField(value="disposal_number")
    private Integer disposalNumber; // 处置次数
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="scrap_type")
    private Integer scrapType; // 废旧类型
    @TableField(value="disposal_type")
    private Integer disposalType; // 处置方式
    @TableField(value="is_first_disposal")
    private Integer isFirstDisposal; // 是否首次处置
    @TableField(value="is_need_assess")
    private Integer isNeedAssess; // 是否需要评估
    @TableField(value="disposal_platform")
    private Integer disposalPlatform; // 处置平台
    @TableField(value="pricing_type")
    private Integer pricingType; // 定价方式
    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="org_id")
    private Long orgId; // 组织
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 父组织ID
    @TableField(value = "estimated_amount")
    private BigDecimal estimatedAmount; // 估算金额
    @TableField(value = "min_limit_price")
    private BigDecimal minLimitPrice; // 最低限制金额



    @TableField(exist=false)
    @SubEntity(serviceName="scrapMaterialApplicationInviteContentService")
    private List<ScrapMaterialApplicationInviteContentEntity> scrapMaterialApplicationInviteContentList = new ArrayList<>(); // 废旧物资处置申请子表（拟邀请单位）
    @TableField(exist=false)
    @SubEntity(serviceName="scrapMaterialApplicationManifestContentService")
    private List<ScrapMaterialApplicationManifestContentEntity> scrapMaterialApplicationManifestContentList = new ArrayList<>(); // 废旧物资处置申请子表（清单明细）

    @TableField(value = "is_used")
    private Integer isUsed; // 是否已使用

    public Integer getIsUsed() {
        return isUsed;
    }

    public void setIsUsed(Integer isUsed) {
        this.isUsed = isUsed;
    }

    public BigDecimal getEstimatedAmount() {
        return estimatedAmount;
    }

    public void setEstimatedAmount(BigDecimal estimatedAmount) {
        this.estimatedAmount = estimatedAmount;
    }

    public BigDecimal getMinLimitPrice() {
        return minLimitPrice;
    }

    public void setMinLimitPrice(BigDecimal minLimitPrice) {
        this.minLimitPrice = minLimitPrice;
    }
    public Date getApplyTime() {
        return applyTime;
    }

    public void setApplyTime(Date applyTime) {
        this.applyTime = applyTime;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getOtherReason() {
        return otherReason;
    }

    public void setOtherReason(String otherReason) {
        this.otherReason = otherReason;
    }
    public String getMainMaterialName() {
        return mainMaterialName;
    }

    public void setMainMaterialName(String mainMaterialName) {
        this.mainMaterialName = mainMaterialName;
    }
    public String getCompiler() {
        return compiler;
    }

    public void setCompiler(String compiler) {
        this.compiler = compiler;
    }
    public String getDisposalReason() {
        return disposalReason;
    }

    public void setDisposalReason(String disposalReason) {
        this.disposalReason = disposalReason;
    }
    public String getPlatformName() {
        return platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }
    public String getNotFirstDisposalReason() {
        return notFirstDisposalReason;
    }

    public void setNotFirstDisposalReason(String notFirstDisposalReason) {
        this.notFirstDisposalReason = notFirstDisposalReason;
    }
    public Integer getDisposalNumber() {
        return disposalNumber;
    }

    public void setDisposalNumber(Integer disposalNumber) {
        this.disposalNumber = disposalNumber;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Integer getScrapType() {
        return scrapType;
    }

    public void setScrapType(Integer scrapType) {
        this.scrapType = scrapType;
    }
    public Integer getDisposalType() {
        return disposalType;
    }

    public void setDisposalType(Integer disposalType) {
        this.disposalType = disposalType;
    }
    public Integer getIsFirstDisposal() {
        return isFirstDisposal;
    }

    public void setIsFirstDisposal(Integer isFirstDisposal) {
        this.isFirstDisposal = isFirstDisposal;
    }
    public Integer getIsNeedAssess() {
        return isNeedAssess;
    }

    public void setIsNeedAssess(Integer isNeedAssess) {
        this.isNeedAssess = isNeedAssess;
    }
    public Integer getDisposalPlatform() {
        return disposalPlatform;
    }

    public void setDisposalPlatform(Integer disposalPlatform) {
        this.disposalPlatform = disposalPlatform;
    }
    public Integer getPricingType() {
        return pricingType;
    }

    public void setPricingType(Integer pricingType) {
        this.pricingType = pricingType;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    

    public List<ScrapMaterialApplicationInviteContentEntity> getScrapMaterialApplicationInviteContentList() {
        return scrapMaterialApplicationInviteContentList;
    }

    public void setScrapMaterialApplicationInviteContentList(List<ScrapMaterialApplicationInviteContentEntity> scrapMaterialApplicationInviteContentList) {
        this.scrapMaterialApplicationInviteContentList = scrapMaterialApplicationInviteContentList;
    }

    public List<ScrapMaterialApplicationManifestContentEntity> getScrapMaterialApplicationManifestContentList() {
        return scrapMaterialApplicationManifestContentList;
    }

    public void setScrapMaterialApplicationManifestContentList(List<ScrapMaterialApplicationManifestContentEntity> scrapMaterialApplicationManifestContentList) {
        this.scrapMaterialApplicationManifestContentList = scrapMaterialApplicationManifestContentList;
    }
}
