/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.out.service.impl;

import com.ejianc.business.promaterial.out.bean.MonthSumEntity;
import com.ejianc.business.promaterial.out.mapper.MonthSumMapper;
import com.ejianc.business.promaterial.out.service.IMonthSumService;
import com.ejianc.business.promaterial.out.vo.MonthSumDetailVO;
import com.ejianc.business.promaterial.out.vo.MonthSumVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="monthSumService")
public class MonthSumServiceImpl
extends BaseServiceImpl<MonthSumMapper, MonthSumEntity>
implements IMonthSumService {
    @Autowired
    private IShareMaterialApi materialApi;

    @Override
    public MonthSumVO queryDetail(Long id) {
        MonthSumEntity entity = (MonthSumEntity)((Object)super.selectById((Serializable)id));
        MonthSumVO vo = (MonthSumVO)BeanMapper.map((Object)((Object)entity), MonthSumVO.class);
        List detailList = vo.getMonthSumDetailList();
        HashMap<Long, MaterialCategoryVO> categoryVOMap = new HashMap<Long, MaterialCategoryVO>();
        HashMap<String, MonthSumDetailVO> firstMap = new HashMap<String, MonthSumDetailVO>();
        HashMap<String, MonthSumDetailVO> secondMap = new HashMap<String, MonthSumDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            for (MonthSumDetailVO detailVO : detailList) {
                MonthSumDetailVO detail;
                CommonResponse response;
                Long second;
                MaterialCategoryVO categoryVO = null;
                if (!categoryVOMap.containsKey(detailVO.getMaterialCategoryId())) {
                    CommonResponse response2 = this.materialApi.queryCategoryById(detailVO.getMaterialCategoryId());
                    if (response2.isSuccess() && null != response2.getData()) {
                        categoryVO = (MaterialCategoryVO)response2.getData();
                        detailVO.setMaterialCategoryCode(categoryVO.getCode());
                    }
                } else {
                    categoryVO = (MaterialCategoryVO)categoryVOMap.get(detailVO.getMaterialCategoryId());
                    detailVO.setMaterialCategoryCode(categoryVO.getCode());
                }
                categoryVOMap.put(detailVO.getMaterialCategoryId(), categoryVO);
                if (categoryVO == null) continue;
                MaterialCategoryVO firstCategoryVO = null;
                MaterialCategoryVO secondCategoryVO = null;
                String[] parentIds = categoryVO.getInnerCode().split("\\|");
                Long first = Long.valueOf(parentIds[0]);
                Long l = second = parentIds.length > 1 ? Long.valueOf(parentIds[1]) : Long.valueOf(parentIds[0]);
                if (!categoryVOMap.containsKey(parentIds[0])) {
                    response = this.materialApi.queryCategoryById(first);
                    if (response.isSuccess() && null != response.getData()) {
                        firstCategoryVO = (MaterialCategoryVO)response.getData();
                    }
                } else {
                    firstCategoryVO = (MaterialCategoryVO)categoryVOMap.get(first);
                }
                categoryVOMap.put(first, firstCategoryVO);
                if (!categoryVOMap.containsKey(parentIds[1])) {
                    response = this.materialApi.queryCategoryById(second);
                    if (response.isSuccess() && null != response.getData()) {
                        secondCategoryVO = (MaterialCategoryVO)response.getData();
                    }
                } else {
                    secondCategoryVO = (MaterialCategoryVO)categoryVOMap.get(second);
                }
                categoryVOMap.put(second, secondCategoryVO);
                String firstKey = first + "@" + detailVO.getUnit();
                String secondKey = second + "@" + detailVO.getUnit();
                if (!firstMap.containsKey(firstKey)) {
                    detail = new MonthSumDetailVO();
                    detail.setId(Long.valueOf(IdWorker.getId()));
                    detail.setMaterialCategoryCode(firstCategoryVO.getCode());
                    detail.setMaterialCategoryName(firstCategoryVO.getName());
                    detail.setUnit(detailVO.getUnit());
                    detail.setNum(detailVO.getNum());
                    detail.setMoney(detailVO.getMoney());
                    firstMap.put(firstKey, detail);
                } else {
                    detail = (MonthSumDetailVO)firstMap.get(firstKey);
                    detail.setNum(ComputeUtil.safeAdd((BigDecimal)detail.getNum(), (BigDecimal)detailVO.getNum()));
                    detail.setMoney(ComputeUtil.safeAdd((BigDecimal)detail.getMoney(), (BigDecimal)detailVO.getMoney()));
                    firstMap.put(firstKey, detail);
                }
                if (!secondMap.containsKey(secondKey)) {
                    detail = new MonthSumDetailVO();
                    detail.setId(Long.valueOf(IdWorker.getId()));
                    detail.setMaterialCategoryCode(firstCategoryVO.getCode());
                    detail.setMaterialCategoryName(firstCategoryVO.getName());
                    detail.setUnit(detailVO.getUnit());
                    detail.setNum(detailVO.getNum());
                    detail.setMoney(detailVO.getMoney());
                    secondMap.put(secondKey, detail);
                    continue;
                }
                detail = (MonthSumDetailVO)firstMap.get(firstKey);
                detail.setNum(ComputeUtil.safeAdd((BigDecimal)detail.getNum(), (BigDecimal)detailVO.getNum()));
                detail.setMoney(ComputeUtil.safeAdd((BigDecimal)detail.getMoney(), (BigDecimal)detailVO.getMoney()));
                secondMap.put(secondKey, detail);
            }
            if (!firstMap.isEmpty()) {
                vo.setFirstCollectList(new ArrayList(firstMap.values()));
            }
            if (!secondMap.isEmpty()) {
                vo.setSecondCollectList(new ArrayList(secondMap.values()));
            }
        }
        return vo;
    }
}

