package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.promaterial.check.bean.*;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.check.vo.SupplierPushCheckDetailVO;
import com.ejianc.business.promaterial.check.vo.SupplierPushCheckVO;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.order.service.IConcreteOrderDetailService;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Service("concreteCheck") 
public class ConcreteCheckBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IStoreManageApi storeManageApi;
	@Autowired
	private IConcreteCheckService concreteCheckService;
	@Autowired
	private IContractService contractService;
	@Autowired
	private IDeliveryService deliveryService;
	@Autowired
	private ICheckService checkService;
	@Autowired
	private IContractDetailService contractDetailService;
	@Autowired
	private IConcreteOrderDetailService concreteOrderDetailService;
	@Autowired
	private ICostDetailApi costDetailApi;
	@Autowired
	private IProSupplierApi proSupplierApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/concreteCheck/deleteCheck";
	private final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/concreteCheck/saveCheck";
	private static final String BILL_TYPE = "BT220224000000004";//此处需要根据实际修改
	private static final String BILL_CODE = "HNT-CHECK";//此处需要根据实际修改
	private final String OPERATE = "HNT_CHECK_SYNC";
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	@Autowired
	private IElectronicFenceConfigService electronicFenceConfigService;
	@Autowired
	private IAttachmentApi attachmentApi;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		ConcreteCheckEntity e = concreteCheckService.selectById(billId);
		//获取项目电子开启状态
		ElectronicFenceConfigEntity electronicFenceConfig = electronicFenceConfigService.getOneByProjectId(e.getProjectId(), true);
		if(null != electronicFenceConfig && Integer.valueOf(1).equals(electronicFenceConfig.getEnable())) {
			String checkRs = checkHasAbnormalImg(e);
			if(StringUtils.isNotBlank(checkRs)) {
				return CommonResponse.error(checkRs);
			}
		}
		return CommonResponse.success();
	};

	private String checkHasAbnormalImg(ConcreteCheckEntity e) {
		if(CollectionUtils.isNotEmpty(e.getConcreteCheckImgList().stream().filter(item -> Integer.valueOf(0).equals(item.getAbnormalImgFlag())).collect(Collectors.toList()))) {
			return "操作失败，当前验收单存在异常照片！";
		}
		CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(e.getId(), null, "sceneImgs", null);
		if(!fileResp.isSuccess()) {
			return "获取上传图片列表失败，操作失败！";
		}
		List<AttachmentVO> attachs = fileResp.getData();
		if(!CollectionUtils.isNotEmpty(attachs)) {
			List<Long> imgIds = attachs.stream().map(AttachmentVO::getId).collect(Collectors.toList());
			List<ConcreteCheckImgDetailEntity> imgList = e.getConcreteCheckImgList();
			if(CollectionUtils.isEmpty(imgList)) {
				//有上传图片，但是单据中未记录，则这些未记录的图片为异常图片，不能进行提交操作
				return "操作失败，当前验收单存在异常照片！";
			}
			List<Long> detailImgIds = imgList.stream().map(ConcreteCheckImgDetailEntity::getId).collect(Collectors.toList());
			imgIds.removeAll(detailImgIds);
			if(CollectionUtils.isNotEmpty(imgIds)) {
				return "操作失败，当前验收单存在异常照片！";
			}
		}

		return null;
	}

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ConcreteCheckEntity concreteCheckEntity = concreteCheckService.selectById(billId);
		concreteCheckEntity.setCheckState(1);

		if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			//获取项目电子开启状态
			ElectronicFenceConfigEntity electronicFenceConfig = electronicFenceConfigService.getOneByProjectId(concreteCheckEntity.getProjectId(), true);
			if(null != electronicFenceConfig && Integer.valueOf(1).equals(electronicFenceConfig.getEnable())) {
				String checkRs = checkHasAbnormalImg(concreteCheckEntity);
				if(StringUtils.isNotBlank(checkRs)) {
					return CommonResponse.error(checkRs);
				}
			}
		}

		//推送供方处理
		SupplierPushCheckVO supplierPushCheckVO = BeanMapper.map(concreteCheckEntity, SupplierPushCheckVO.class);

		supplierPushCheckVO.setSourceId(concreteCheckEntity.getId());
		List<ConcreteCheckDetailEntity> concreteCheckDetailList = concreteCheckEntity.getConcreteCheckDetailList();
		List<SupplierPushCheckDetailVO> supplierPushCheckDetailVOS = BeanMapper.mapList(concreteCheckDetailList, SupplierPushCheckDetailVO.class);
		supplierPushCheckVO.setCheckDetailList(supplierPushCheckDetailVOS);
		List<SupplierPushCheckDetailVO> checkDetailList = supplierPushCheckVO.getConcreteCheckDetailList();
		for (SupplierPushCheckDetailVO supplierPushCheckDetailVO : checkDetailList){
			supplierPushCheckDetailVO.setSourceId(concreteCheckEntity.getId());
			supplierPushCheckDetailVO.setSourcedetailId(supplierPushCheckDetailVO.getId());
			supplierPushCheckDetailVO.setId(null);
		}

		//设置单据当前系统信息
		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
		if (!ejcCloudSystemCode.isSuccess()) {
//			throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
			logger.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
		}
		else {
			//设置当前系统ID
			supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
			String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);

			//查询该单据是否支持协同分享，则向供方协同服务推送该单据
			CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
			if(!cooperateResp.isSuccess()) {
//				throw new BusinessException("根据单据类型-{}查询其协同配置信息失败，{}" + cooperateResp.getMsg());
				logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE, cooperateResp.getMsg());
			}
			else {
				boolean b = checkService.pushBillToSupCenter(dataInfo, concreteCheckEntity.getSupplierId(), concreteCheckEntity.getId(), BILL_TYPE, cooperateResp.getData(),PUSH_SAVE_URL);
				if (!b){
//					throw new BusinessException("推送供方失败!");
					logger.error("推送供方失败！单据信息：{}", dataInfo);
				}
				else {
					concreteCheckEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
				}
			}
		}
		concreteCheckService.updateById(concreteCheckEntity);

//		if (concreteCheckEntity.getAttrFlag().equals(1)){
//			logger.info("推送成本---");
//			concreteCheckService.costPush(concreteCheckEntity);
//		}

		//入库方式，0-收料入库，1-直入直出
		//调用库存逻辑
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setStoreId(concreteCheckEntity.getStoreId());
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.直入直出入库);
		storeManageVO.setOutEffectiveON(true);
		storeManageVO.setSourceId(concreteCheckEntity.getId());
		ArrayList<FlowVO> flowVOS = new ArrayList<>();
		concreteCheckEntity.getConcreteCheckDetailList().forEach(t->{
			FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.直入直出入库, 0);
			getFlow(concreteCheckEntity, t, flowVO,"混凝土验收");
			flowVOS.add(flowVO);
		});
		storeManageVO.setFlowVOList(flowVOS);
		ArrayList<FlowVO> flowOutS = new ArrayList<>();
		concreteCheckEntity.getConcreteCheckDetailList().forEach(t->{
			FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.直入直出出库, 0);
			getFlow(concreteCheckEntity, t, flowVO,"混凝土出库");
			flowOutS.add(flowVO);
		});
		storeManageVO.setStraightOutFlowVOList(flowOutS);
		String stringInfo = JSONObject.toJSONString(storeManageVO);
		logger.info("混凝土直入直出参数：" +stringInfo);
		CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
		if(!response.isSuccess()) {
			throw new BusinessException("调用库存管理失败,错误信息" +response.getMsg());
		}

		return CommonResponse.success();
	}
		private void getFlow(ConcreteCheckEntity concreteCheckEntity, ConcreteCheckDetailEntity t, FlowVO flowVO,String type) {
			flowVO.setProjectId(concreteCheckEntity.getProjectId());
			flowVO.setTaxRate(t.getTaxRate());
			flowVO.setProjectName(concreteCheckEntity.getProjectName());
			flowVO.setParentOrgId(concreteCheckEntity.getParentOrgId());
			flowVO.setParentOrgName(concreteCheckEntity.getParentOrgName());
			flowVO.setOrgId(concreteCheckEntity.getOrgId());
			flowVO.setOrgName(concreteCheckEntity.getOrgName());
			flowVO.setStoreId(concreteCheckEntity.getStoreId());
			flowVO.setStoreName(concreteCheckEntity.getStoreName());
			flowVO.setEmployeeId(concreteCheckEntity.getEmployeeId());
			flowVO.setEmployeeName(concreteCheckEntity.getEmployeeName());
			flowVO.setMaterialType(concreteCheckEntity.getCheckType());
			flowVO.setMaterialTypeName(concreteCheckEntity.getCheckType());
			flowVO.setSupplierId(concreteCheckEntity.getSupplierId());
			flowVO.setSupplierName(concreteCheckEntity.getSupplierName());
			flowVO.setPurchaseContractId(concreteCheckEntity.getContractId());
			flowVO.setPurchaseContractName(concreteCheckEntity.getContractName());
			flowVO.setMaterialCategoryId(t.getMaterialTypeId());
			flowVO.setMaterialCategoryName(t.getMaterialTypeName());
			flowVO.setMaterialId(t.getMaterialId());
			flowVO.setMaterialName(t.getMaterialName());
			flowVO.setMaterialCode(t.getMaterialCode());
			flowVO.setMaterialSpec(t.getSpec());
			flowVO.setMaterialUnitId(t.getUnitId());
			flowVO.setMaterialUnitName(t.getUnit());
			flowVO.setTaxPrice(t.getCheckTaxPriceOverall() == null ? t.getCheckTaxPrice():t.getCheckTaxPriceOverall());
			flowVO.setPrice(t.getCheckPriceOverall() == null ? t.getCheckPrice():t.getCheckPriceOverall());
			flowVO.setNum(t.getCheckNum());
			flowVO.setTaxMny(t.getCheckTaxMny());
			flowVO.setMny(t.getCheckMny());
			flowVO.setTax(t.getTaxMny());
			flowVO.setPickUnitId(concreteCheckEntity.getSubSupplierId());
			flowVO.setPickUnitName(concreteCheckEntity.getSubSupplierName());
			flowVO.setPickContractId(concreteCheckEntity.getSubContractId());
			flowVO.setPickContractName(concreteCheckEntity.getSubContractName());
			flowVO.setSourceId(concreteCheckEntity.getId());
			flowVO.setSourceDetailId(t.getId());
			flowVO.setSourceBillCode(concreteCheckEntity.getBillCode());
			flowVO.setSourceBillDate(concreteCheckEntity.getCheckDate());
			flowVO.setSourceBillRemark(concreteCheckEntity.getMemo());
			flowVO.setSourceBillDetailRemark(t.getMemo());
			flowVO.setRowState(t.getRowState());
			flowVO.setAdmixtureId(t.getAdmixtureId());
			flowVO.setAdmixtureName(t.getAdmixtureName());
			flowVO.setMaterialType("contractConcrete-1");
			flowVO.setMaterialTypeName("混凝土合同");
			flowVO.setSourceBillTypeName(type);//混凝土出库
			flowVO.setSourceBillTypeCode("BT220224000000004");
			flowVO.setSourceType(concreteCheckEntity.getSourceType());
			flowVO.setPickType(concreteCheckEntity.getSubOutType());
			//1-内部领料,2-分包领料
			if (concreteCheckEntity.getSubOutType() != null && concreteCheckEntity.getSubOutType() == 1){
				flowVO.setPickTypeName("内部领料");
			}
			if (concreteCheckEntity.getSubOutType() != null && concreteCheckEntity.getSubOutType() == 2){
				flowVO.setPickTypeName("分包领料");
			}
			if (concreteCheckEntity.getContractId() != null){
//				if(DeliveryTypeEnum.自制送货单.getCode().equals(concreteCheckEntity.getDeliveryType())){
					ContractEntity contractEntity = contractService.selectById(concreteCheckEntity.getContractId());
					Map<Long, ContractDetailEntity> DetailMaterialIdMap = contractEntity.getContractDetailList().stream().filter(e -> null!=e.getMaterialId()).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity(),(k1,k2)->k2));
					Map<Long, ContractDetailEntity> DetailMaterialIdTypeMap = contractEntity.getContractDetailList().stream().filter(e ->  null==e.getMaterialId()&&  null!=e.getMaterialTypeId()).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity(),(k1,k2)->k2));
					if(MapUtils.isEmpty(DetailMaterialIdMap)){
						DetailMaterialIdMap=new HashMap<>();
					}
					if(MapUtils.isEmpty(DetailMaterialIdTypeMap)){
						DetailMaterialIdTypeMap=new HashMap<>();
					}
					ContractDetailEntity contractDetailEntity = new ContractDetailEntity();
					//2  根据物料id取合同明细行对应的单价  取到--返回  否则  到第3步
					contractDetailEntity = DetailMaterialIdMap.get(t.getMaterialId());
					if(null!=contractDetailEntity){
						flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
						flowVO.setContractPrice(contractDetailEntity.getPrice());
					}else{
						//3  根据材料分类Id 取合同明细行对应的单价  取到--返回  否则  单价设置为0
						contractDetailEntity = DetailMaterialIdTypeMap.get(t.getMaterialTypeId());
						if(null!=contractDetailEntity){
							flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
							flowVO.setContractPrice(contractDetailEntity.getPrice());
						}else{
							flowVO.setContractTaxPrice(BigDecimal.ZERO);
							flowVO.setContractPrice(BigDecimal.ZERO);
						}
					}
//				}else {
//					ContractDetailEntity contractDetailEntity = contractDetailService.getById(t.getSourceId());
//					if(null==contractDetailEntity){
//						ConcreteOrderDetailEntity orderDetailEntity = concreteOrderDetailService.getById(t.getOrderDetailId());
//						contractDetailEntity = contractDetailService.getById(orderDetailEntity.getSourceDetailId());
//					}
//					flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
//					flowVO.setContractPrice(contractDetailEntity.getPrice());
//				}
			}
		}
	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		ConcreteCheckEntity concreteCheckEntity = concreteCheckService.selectById(billId);
		if (concreteCheckEntity.getSignStatus() == 1){
			return CommonResponse.error("供方已签字,无法撤回");
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		ConcreteCheckEntity checkEntity = concreteCheckService.selectById(billId);
		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-验收单Id---{}",checkEntity.getId());
		CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(checkEntity.getId());
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//更新是否关联
		LambdaUpdateWrapper<ConcreteCheckEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(ConcreteCheckEntity::getId, checkEntity.getId());
		updateWrapper.set(ConcreteCheckEntity::getRelationFlag, "0");//(1:是，0：否)
		concreteCheckService.update(updateWrapper);
		if(BillPushStatusEnum.推送成功.getStatus().equals(checkEntity.getBillPushFlag())){
			//推送供方
			//对单据进行加锁
			CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
			if (!ejcCloudSystemCode.isSuccess()) {
				throw new BusinessException("获取当前系统编码失败！");
			}
			Map<String,Object> map = new HashMap<>();
			map.put("sourceId",billId);
			map.put("systemId",ejcCloudSystemCode.getData());
			String dataInfo = JSONObject.toJSONString(map);
			Boolean updateSupplierStatus = deliveryService.updateSupplierStatus(billId, dataInfo,PUSH_DELETE_URL,RequestMethod.POST,
					checkEntity.getSupplierId().toString(),OPERATE,BILL_TYPE);
			if (!updateSupplierStatus){
				throw new BusinessException("单据推送失败！");
			}
			checkEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			concreteCheckService.saveOrUpdate(checkEntity,false);
		}


		//入库方式，0-收料入库，1-直入直出
		if (checkEntity.getStoreType() == 0){
			List<Long> ids = new ArrayList<>();
			ids.add(billId);
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setStoreId(checkEntity.getStoreId());
			storeManageVO.setSourceId(checkEntity.getId());
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.收料入库);
			storeManageVO.setOutEffectiveON(true);

			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("混凝土撤回参数：" +stringInfo);
			CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
			if(!response.isSuccess()) {
				return CommonResponse.error(response.getMsg());
			}else{
				logger.info("hnt推送仓库成功:"+response.getMsg());
			}
		}
		if (checkEntity.getStoreType() == 1){
			List<Long> ids = new ArrayList<>();
			ids.add(billId);
			StoreManageVO storeManageVO = new StoreManageVO();
			storeManageVO.setStoreId(checkEntity.getStoreId());
			storeManageVO.setSourceId(checkEntity.getId());
			storeManageVO.setSourceIdsForRollBack(ids);
			storeManageVO.setInOutTypeEnum(InOutTypeEnum.直入直出入库);
			storeManageVO.setOutEffectiveON(true);
			String stringInfo = JSONObject.toJSONString(storeManageVO);
			logger.info("混凝土撤回参数：" +stringInfo);
			CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
			if(!response.isSuccess()) {
				return CommonResponse.error(response.getMsg());
			}else{
				logger.info("hnt推送仓库成功:"+response.getMsg());
			}
		}

		return CommonResponse.success();
	}

}
