package com.ejianc.business.promaterial.reconciliation.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationDetailEntity;
import com.ejianc.business.promaterial.reconciliation.vo.SupReconciliationCollectVO;
import com.ejianc.business.promaterial.reconciliation.vo.SupReconciliationDetailVO;
import com.ejianc.business.promaterial.reconciliation.vo.SupReconciliationVO;
import com.ejianc.business.promaterial.reconciliation.vo.ReconciliationVO;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.business.store.api.IAccountSettleApi;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreApiVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.promaterial.reconciliation.mapper.ReconciliationMapper;
import com.ejianc.business.promaterial.reconciliation.bean.ReconciliationEntity;
import com.ejianc.business.promaterial.reconciliation.service.IReconciliationService;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 对账单主表
 * 
 * @author generator
 * 
 */
@Service("reconciliationService")
public class ReconciliationServiceImpl extends BaseServiceImpl<ReconciliationMapper, ReconciliationEntity> implements IReconciliationService{
    @Autowired
    private IAccountSettleApi accountSettleApi;
    @Autowired
    private IContractService contractService;//合同
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private final String  OPERATE= "SETTLMENT_JS";
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/reconciliation/saveReconciliation";
    private static final String XHC_BILL_TYPE = "BT220310000000001";//此处需要根据实际修改
    private static final String HNT_BILL_TYPE = "BT220316000000003";//此处需要根据实际修改


    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Override
    public void updateAccount(Integer accountFlag, ReconciliationEntity entity, List<ReconciliationDetailEntity> detailList) {
        StoreApiVO storeApiVO = new StoreApiVO();
        List<FlowVO> flowVOS = new ArrayList<>();
        storeApiVO.setAccountFlag(accountFlag);
        storeApiVO.setAccountId(entity.getId());
        storeApiVO.setAccountDate(entity.getReconciliationDate());
        storeApiVO.setAccountCode(entity.getBillCode());
        for (ReconciliationDetailEntity detailEntity : detailList) {
            FlowVO flowVO = new FlowVO();
            flowVO.setAccountDetailId(detailEntity.getId());
            flowVO.setSourceId(detailEntity.getSourceId());
            flowVO.setSourceDetailId(detailEntity.getSourceDetailId());
            flowVOS.add(flowVO);
        }
        storeApiVO.setDetail(flowVOS);
        logger.info("对账更新信息--"+JSONObject.toJSONString(storeApiVO));
        CommonResponse<String> response = accountSettleApi.changeAccountSettleByType(storeApiVO);
        if (!response.isSuccess()){
            throw new BusinessException("对账状态更新失败");
        }
    }

    @Override
    public void checkContract(ReconciliationEntity entity) {
        if(CollectionUtils.isNotEmpty(entity.getDetailList())){
            ContractEntity contractEntity = contractService.selectById(entity.getContractId());
            List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
            if(CollectionUtils.isEmpty(contractDetailList)){
                throw new BusinessException("对账明细在合同【"+entity.getContractName()+"】中不存在，请变更合同后再对账");
            }
            List<String> materialIds = contractDetailList.stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).map(item->item.getMaterialId().toString()).collect(Collectors.toList());
            List<String> materialTypeIds = contractDetailList.stream().filter(t -> t.getMaterialId() == null && t.getMaterialTypeId()!=null &&!ChangeTypeEnum.中止项.toString().equals(t.getChangeType())).map(item->item.getMaterialTypeId().toString()).collect(Collectors.toList());
            for (ReconciliationDetailEntity detail : entity.getDetailList()) {
                if(!"del".equals(detail.getRowState())){
                    boolean flag = true;
                    String materialTypeId = detail.getMaterialTypeId()==null?"":detail.getMaterialTypeId().toString();
                    String materialId = detail.getMaterialId()==null?"":detail.getMaterialId().toString();
                    if(materialTypeIds.contains(materialTypeId)){//结算明细有合同分类
                        flag = false;
                    }
                    if(materialIds.contains(materialId)){//结算明细有合同明细
                        flag = false;
                    }
                    if(flag){
                        throw new BusinessException("材料【"+detail.getMaterialName()+"】在合同【"+entity.getContractName()+"】中不存在，请变更合同后再对账");
                    }
                }
            }
        }
    }

    @Override
    public IPage<ReconciliationVO> queryData(QueryParam param) {
        IPage<ReconciliationVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<ReconciliationVO> list = baseMapper.queryData(changeToQueryWrapper(param), page);
        IPage<ReconciliationVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }

    /*推送供方*/
    @Override
    public Boolean pushBillToSupCenter(ReconciliationEntity entity, String billTypeCode) {
        String BILL_TYPE;
        if (entity.getReconciliationType()==0){
            BILL_TYPE = XHC_BILL_TYPE;
        }else {
            BILL_TYPE = HNT_BILL_TYPE;
        }
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
            SupReconciliationVO supReconciliationVO = BeanMapper.map(entity, SupReconciliationVO.class);
            List<SupReconciliationDetailVO> supReconciliationDetailVOS = BeanMapper.mapList(entity.getDetailList(), SupReconciliationDetailVO.class);
            List<SupReconciliationCollectVO> supReconciliationCollectVOS = BeanMapper.mapList(entity.getCollectDetailList(), SupReconciliationCollectVO.class);
            supReconciliationVO.setReconciliationDetailList(supReconciliationDetailVOS);
            supReconciliationVO.setReconciliationCollectList(supReconciliationCollectVOS);
            paramMap.put("transData", JSONObject.toJSONString(supReconciliationVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), billTypeCode,"reconciliationProjectFile", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                Map<String, String> fileSourceTypeMap = new HashMap<>();
                List<Long> fileIds = new ArrayList<>();

                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileSourceTypeMap.put(attach.getFileName(), attach.getSourceType());
                    fileIds.add(attach.getId());
                }
                paramMap.put("nameSourceTypeMapping", JSONObject.toJSONString(fileSourceTypeMap));
                //当前单据携带有附件信息
                if (CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送附件参数-{}", entity.getSupplierId(), JSONObject.toJSONString(files));
                logger.info("向供应商-{}推送计量单据参数-{}", entity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        entity.getSupplierId().toString(),
                        files);
//                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送订单单据id-{}失败, {}", entity.getSupplierId(), entity.getId(), billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", entity.getId(), entity.getSupplierId(), syncReqResp.getMsg());
                }
            } else {
                logger.error("获取订单单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送订单单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSupplierId(), e);
//            throw new BusinessException("推送供方异常!");
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    /*
     * 撤回推送供方
     *  */
    @Override
    public CommonResponse<String> updatePushBill(ReconciliationEntity entity, String billTypeCode, String url) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = billTypeCode + "::" + entity.getId().toString();
        String BILL_TYPE;
        if (entity.getReconciliationType()==0){
            BILL_TYPE = XHC_BILL_TYPE;
        }else {
            BILL_TYPE = HNT_BILL_TYPE;
        }
        //删除签字文件
        CommonResponse<List<AttachmentVO>> fileResp = attachmentApi
                .queryListBySourceId(entity.getId(), BILL_TYPE, "reconciliationFile", null);
        // 查询成功并有相应的文件
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty(fileResp.getData())) {
            logger.info("删除文件信息：{}", JSONObject.toJSONString(fileResp.getData()));
            String ids = fileResp.getData().stream().map(AttachmentVO::getId).map(String::valueOf)
                    .collect(Collectors.joining(","));
            attachmentApi.delete(ids);
            entity.setSignStatus(0);
            baseMapper.updateById(entity);
        }

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", entity.getSupplierId(), entity.getId());

            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(url,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    entity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", entity.getId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }

    /*供方签字确认*/
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        ReconciliationEntity reconciliationEntity = super.selectById(billId);
        String BILL_TYPE;
        if (reconciliationEntity.getReconciliationType()==0){
            BILL_TYPE = XHC_BILL_TYPE;
        }else {
            BILL_TYPE = HNT_BILL_TYPE;
        }
        //设置供方签字信息
        reconciliationEntity.setSupOperateTime(supOperateTime);
        reconciliationEntity.setSupOperatorName(supOperatorName);
        reconciliationEntity.setSupOperatorPhone(supOperatorPhone);
        reconciliationEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + reconciliationEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", reconciliationEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, reconciliationEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            reconciliationEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：0-未签字 1-已签字
            // 乙方已签字状态即待甲方签字
            reconciliationEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(reconciliationEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", reconciliationEntity.getId(), e);
            msg = "单据签字信息回写失败！";
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }

    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }

}
