package com.ejianc.business.promaterial.dataModel.consts;

import com.ejianc.foundation.share.consts.PrinceDepotEnum;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 单据类型和单据子表的枚举
 */
public enum DataModelEnum {

    消耗材总计划("BT211224000000003", "masterPlanDetailList"),
    混凝土总计划("BT220211000000002", "masterPlanDetailList"),

    消耗材总计划变更("BT211224000000004", "masterPlanDetailList"),
    混凝土总计划变更("BT220211000000003", "masterPlanDetailList"),

    物资采购合同("BT211227000000003", "contractDetailList"),
    混凝土采购合同("BT220215000000001", "contractDetailList"),

    物资采购合同变更("BT211227000000004", "contractDetailList"),
    混凝土变更合同("BT220215000000002", "contractDetailList"),

    消耗材订单("BT220223000000006", "orderDetailList"),
    混凝土订单("BT220223000000001", "concreteOrderDetailList"),

    混凝土验收("BT220224000000004", "concreteCheckDetailList"),
    材料验收("BT220215000000006", "checkDetailList"),

    消耗材对账单("BT220310000000001", "detailList"),
    混凝土对账单("BT220316000000003", "detailList"),

    材料批次计划("BT211222000000009", "batPlanDetailList"),

    混凝土结算单("BT220316000000005", "settlementDetailList"),
    消耗材结算单("BT220309000000003", "settlementDetailList");


    private String code;

    private String name;
    private String className;

    private static Map<String, DataModelEnum> enumMap = new HashMap();

    private DataModelEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }



    public static void setEnumMap(Map<String, DataModelEnum> enumMap) {
        DataModelEnum.enumMap = enumMap;
    }

    public static DataModelEnum getByCode(String code) {
        return (DataModelEnum)enumMap.get(code);
    }

    static {
        enumMap = (Map) EnumSet.allOf(DataModelEnum.class).stream().collect(Collectors.toMap(DataModelEnum::getCode, Function.identity(), (k1, k2) -> {
            return k2;
        }));
    }
}
