package com.ejianc.business.promaterial.plan.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.business.promaterial.plan.bean.MonthPlanEntity;
import com.ejianc.business.promaterial.plan.vo.MonthPlanVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.IBaseService;

import javax.servlet.http.HttpServletResponse;
import java.util.Date;
import java.util.List;

/**
 * 物资月计划
 * 
 * @author generator
 * 
 */
public interface IMonthPlanService extends IBaseService<MonthPlanEntity> {
    IPage<MonthPlanVO> queryConcreteList(QueryParam param);
    void excelConcreteExport(QueryParam param, HttpServletResponse response);
    boolean monthQueryPlan (Long projectId,Date planMonth,Integer planType,Long id);
    CommonResponse<MonthPlanVO> saveOrUpdate(MonthPlanVO saveorUpdateVO);
    MonthPlanVO queryByCode(String planCode,Integer planType);

    /**
     * 消耗材总计划量控月计划
     *
     * @param monthPlanVO
     * @return
     */
    List<ParamsCheckVO> masterPlanNumCtrl(MonthPlanVO monthPlanVO);

    /**
     * 消耗材总计划单价空月计划
     *
     * @param monthPlanVO
     * @return
     */
    List<ParamsCheckVO> masterPlanPriceCtrl(MonthPlanVO monthPlanVO);
}
