/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.PaymentApplyVO;
import com.ejianc.business.promaterial.contract.bean.ContractChangeEntity;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.bean.ContractRelieveEntity;
import com.ejianc.business.promaterial.contract.enums.BillTypeEnum;
import com.ejianc.business.promaterial.contract.enums.ChangeStatusEnum;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.DraftTypeEnum;
import com.ejianc.business.promaterial.contract.enums.MaterialContractTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.promaterial.contract.enums.SuplementFlagEnum;
import com.ejianc.business.promaterial.contract.mapper.ContractMapper;
import com.ejianc.business.promaterial.contract.service.IContractAsyncService;
import com.ejianc.business.promaterial.contract.service.IContractChangeService;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractFreezeService;
import com.ejianc.business.promaterial.contract.service.IContractRelieveService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractChangeVO;
import com.ejianc.business.promaterial.contract.vo.ContractDetailVO;
import com.ejianc.business.promaterial.contract.vo.ContractMaterialReportVO;
import com.ejianc.business.promaterial.contract.vo.ContractRelieveVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.promaterial.contract.vo.MaterialReportVO;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.plan.service.IMasterPlanService;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceApiVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceCheckCodeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.promaterial.utils.CommonUtils;
import com.ejianc.business.prosub.vo.ContractPaymentResultVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="contractService")
public class ContractServiceImpl
extends BaseServiceImpl<ContractMapper, ContractEntity>
implements IContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PURCHASE_CONTRACT_BILL_CODE = "CONTRACT_MATERIAL";
    private static final String PURCHASE_CONTRACT_CONCRETE_BILL_CODE = "CONTRACT_CONCRETE";
    private static final String PURCHASE_CONTRACT_YNJT = "CONTRACT_MATERIAL_YNJT";
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    private IContractChangeService contractChangeService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IContractService service;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private IContractRelieveService relieveService;
    @Autowired
    private IContractFreezeService freezeService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ITenderApi tenderApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private IMasterPlanService masterPlanService;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IDutyApi iDutyApi;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IContractAsyncService contractAsyncService;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IDutyApi dutyApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    private final String MAIN_CONTRACT_REFCODE = "contractMaterial";
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String M_SUP_CODE = "P-CO2iY888";
    private static final String C_SUP_CODE = "P-K496W490";
    private static final String M_PLAN_CODE = "P-CcZ6rO87";
    private static final String C_PLAN_CODE = "P-00g5A089";
    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134";
    private static final String UPDATE_CON_SIGN_DATE_PARAM_NAME = "P-U9uddl0182";

    @Override
    public CommonResponse<ContractVO> saveOrUpdate(ContractVO contractVo, String authority, Boolean isControl) {
        ContractEntity contract;
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        Object orgResponse;
        Long tenantId = InvocationInfoProxy.getTenantid();
        List entities = null;
        List entitiesc = null;
        if (contractVo.getId() != null && !isControl.booleanValue()) {
            ContractVO delVo = this.queryDetail(contractVo.getId());
            if (PurchaseTypeEnum.\u9879\u76ee\u81ea\u91c7.getCode().equals(delVo.getPurchaseType()) && !delVo.getContractPropertyCode().equals(contractVo.getContractPropertyCode())) {
                ArrayList<TotalExecutionVO> totalExecutionVODelList = new ArrayList<TotalExecutionVO>();
                ExecutionVO executionVODel = this.service.targetCost(delVo, "", 0, delVo.getContractType());
                totalExecutionVODelList.add(executionVODel.getTotalVO());
                this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVODelList));
                CommonResponse response = this.executionApi.aggDel(totalExecutionVODelList);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
        }
        if (contractVo.getOrgId() != null && (StringUtils.isEmpty((String)contractVo.getOrgCode()) || StringUtils.isEmpty((String)contractVo.getParentOrgCode()) || StringUtils.isEmpty((String)contractVo.getOrgName())) && (orgResponse = this.iOrgApi.getOneById(contractVo.getOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            contractVo.setOrgCode(orgVO.getCode());
            if (StringUtils.isEmpty((String)contractVo.getOrgName())) {
                contractVo.setOrgName(orgVO.getName());
            }
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    contractVo.setParentOrgId(parentOrgVO.getId());
                    contractVo.setParentOrgCode(parentOrgVO.getCode());
                    contractVo.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                contractVo.setParentOrgId(contractVo.getOrgId());
                contractVo.setParentOrgCode(contractVo.getOrgCode());
                contractVo.setParentOrgName(contractVo.getOrgName());
            }
        }
        if (contractVo.getTargetResultId() != null && CollectionUtils.isNotEmpty((Collection)contractVo.getContractDetailList())) {
            for (ContractDetailVO detailVO : contractVo.getContractDetailList()) {
                detailVO.setInitNum(detailVO.getNum());
            }
        }
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
        if (!isControl.booleanValue() && StringUtils.isEmpty((String)contractVo.getBillCode())) {
            entity.setBillCode(this.getContractBillCode(contractVo));
        }
        if (entity.getId() == null) {
            if (entity.getFilingStatus() == null) {
                entity.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
            }
            entity.setFilingRef(0);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)contractVo.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setId(IdWorker.getId());
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        if (!(entity.getContractFileId() == null || (contract = (ContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractCategoryId().equals(entity.getContractCategoryId()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFilePath(null);
        }
        if (!isControl.booleanValue()) {
            this.checkDetailTenderNum(contractVo.getContractDetailList(), contractVo.getId(), contractVo.getTargetResultId());
            boolean saveFlag = super.saveOrUpdate((Object)entity, false);
            if (!saveFlag) {
                throw new BusinessException("\u5408\u540c\u4fdd\u5b58\u5931\u8d25\uff01");
            }
            if (contractVo.getId() == null && contractVo.getTargetResultId() != null) {
                this.updateTargetResult(contractVo, 0);
            }
            if (contractVo.getId() != null && contractVo.getTargetResultId() != null) {
                ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractVo.getId()));
                this.updateTargetResult((ContractVO)BeanMapper.map((Object)((Object)contractEntity), ContractVO.class), 1);
                this.updateTargetResult(contractVo, 0);
            }
            if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType())) {
                entity.setContractFileSyncFlag(false);
            }
            if (entity.getPurchaseType().equals("1")) {
                String frontendBaseHost = "";
                frontendBaseHost = StringUtils.isNotBlank((String)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
                String linkUrl = entity.getContractType() == 0 ? frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/card?id=" + entity.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/card?id=" + entity.getId();
                ExecutionVO executionVO = this.service.targetCost((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class), linkUrl, 0, entity.getContractType());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)entity), ContractVO.class));
    }

    private String getContractBillCode(ContractVO contractVo) {
        String contractBillCode;
        this.logger.info("\u751f\u6210\u7f16\u7801\u89c4\u5219\uff0cGenerateBillCodeType=\uff1a{}", (Object)this.GenerateBillCodeType);
        switch (this.GenerateBillCodeType) {
            case "common": {
                BillCodeParam billCodeParam;
                CommonResponse billCode;
                String billCodeStr = PURCHASE_CONTRACT_BILL_CODE;
                if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractVo.getContractType())) {
                    billCodeStr = PURCHASE_CONTRACT_CONCRETE_BILL_CODE;
                }
                if ((billCode = this.billCodeApi.generateBillCode(billCodeParam = BillCodeParam.build((String)billCodeStr, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo))).isSuccess()) {
                    contractBillCode = (String)billCode.getData();
                    break;
                }
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            case "ynjt": {
                BillCodeParam billCodeParamYnjt = BillCodeParam.build((String)PURCHASE_CONTRACT_YNJT, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)contractVo);
                CommonResponse billCodeFirstPart = this.billCodeApi.generateBillCode(billCodeParamYnjt);
                if (!billCodeFirstPart.isSuccess()) {
                    this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                String orgSub = contractVo.getParentOrgCode().substring(contractVo.getParentOrgCode().length() - 3);
                CommonSNVO commonSNVO = new CommonSNVO();
                commonSNVO.setSnLength(Integer.valueOf(4));
                commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                commonSNVO.setDimension(orgSub);
                commonSNVO.setSourceType("YNJTCLCG");
                CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                if (!snResp.isSuccess()) {
                    throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                }
                contractBillCode = (String)billCodeFirstPart.getData() + orgSub + (String)snResp.getData();
                break;
            }
            default: {
                throw new BusinessException("\u7f16\u7801\u751f\u6210\u5931\u8d25\uff01");
            }
        }
        return contractBillCode;
    }

    @Override
    public ContractVO saveOrUpdateSupplement(ContractVO contractVo, String authority, Boolean isControl) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        ContractEntity entity = (ContractEntity)((Object)BeanMapper.map((Object)contractVo, ContractEntity.class));
        List entities = null;
        List entitiesc = null;
        ContractEntity mainContract = (ContractEntity)((Object)this.service.selectById(contractVo.getMainContractId()));
        if (null == mainContract) {
            throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
        }
        if (!isControl.booleanValue() && StringUtils.isEmpty((String)contractVo.getBillCode())) {
            QueryParam billCodeParam = new QueryParam();
            billCodeParam.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVo.getMainContractId()));
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            billCodeParam.getParams().put("bill_state", new Parameter("in", billStateList));
            List billCOdeSupplementList = this.service.queryList(billCodeParam, false);
            String supplementNum = "";
            supplementNum = billCOdeSupplementList.size() < 9 ? supplementNum + "0" + (billCOdeSupplementList.size() + 1) : supplementNum + (billCOdeSupplementList.size() + 1);
            entity.setBillCode(mainContract.getBillCode() + "-2-" + supplementNum);
        }
        if (contractVo.getId() != null && contractVo.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)contractVo.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)contractVo.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)contractVo.getMainContractId()));
            List supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureStatus().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(ContractEntity::getBillCode, (Object)contractVo.getBillCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("bill_code", new Parameter("eq", (Object)contractVo.getBillCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        this.checkContract(contractVo.getMainContractId(), contractVo.getId());
        entity.setBaseMoney(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBaseMoneyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        entity.setBeforeChangeMny(contractVo.getContractMny() == null ? BigDecimal.ZERO : contractVo.getContractMny());
        entity.setBeforeChangeMnyWithTax(contractVo.getContractTaxMny() == null ? BigDecimal.ZERO : contractVo.getContractTaxMny());
        if (FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(entity.getFilingStatus())) {
            entity.setFilingRef(0);
        }
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                ContractEntity contract = (ContractEntity)((Object)super.getById((Serializable)entity.getId()));
                if (contract != null && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                    if (!isControl.booleanValue()) {
                        this.delContractFile(entity.getContractFileId(), authority);
                    }
                    entity.setContractFileId(null);
                    entity.setContractFilePath(null);
                }
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                if (!isControl.booleanValue()) {
                    this.delContractFile(entity.getContractFileId(), authority);
                }
                entity.setContractFileId(null);
                entity.setContractFilePath(null);
            }
        }
        if (!isControl.booleanValue()) {
            super.saveOrUpdate((Object)entity, false);
            if (entity.getPurchaseType().equals("1")) {
                String frontendBaseHost = "";
                frontendBaseHost = StringUtils.isNotBlank((String)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
                String linkUrl = entity.getContractType() == 0 ? frontendBaseHost + "ejc-promaterial-frontend/#/supplement/card?id=" + entity.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/supplementConcrete/card?id=" + entity.getId();
                ExecutionVO executionVO = this.service.targetCost((ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class), linkUrl, 0, entity.getContractType());
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
                }
            }
        }
        return (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
    }

    @Override
    public ContractVO addConvertByConId(Long contractId) {
        ContractEntity contractVO = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        ContractVO supplementVO = new ContractVO();
        supplementVO.setPurchaseType(contractVO.getPurchaseType());
        supplementVO.setPurchaseTypeName(contractVO.getPurchaseTypeName());
        supplementVO.setSignPlace(contractVO.getSignPlace());
        supplementVO.setCustomerEmployeeId(contractVO.getCustomerEmployeeId());
        supplementVO.setCustomerEmployeeName(contractVO.getCustomerEmployeeName());
        supplementVO.setCustomerEmployeeMobile(contractVO.getCustomerEmployeeMobile());
        supplementVO.setSupplierEmployeeName(contractVO.getSupplierEmployeeName());
        supplementVO.setSupplierEmployeeMobile(contractVO.getSupplierEmployeeMobile());
        supplementVO.setPricingType(contractVO.getPricingType());
        supplementVO.setMainContractName(contractVO.getContractName());
        supplementVO.setMainContractCode(contractVO.getBillCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setContractCategoryId(contractVO.getContractCategoryId());
        supplementVO.setContractCategoryName(contractVO.getContractCategoryName());
        supplementVO.setProjectName(contractVO.getProjectName());
        supplementVO.setProjectId(contractVO.getProjectId());
        supplementVO.setProjectPlace(contractVO.getProjectPlace());
        supplementVO.setCustomerId(contractVO.getCustomerId());
        supplementVO.setCustomerName(contractVO.getCustomerName());
        supplementVO.setSupplierId(contractVO.getSupplierId());
        supplementVO.setSupplierName(contractVO.getSupplierName());
        supplementVO.setOrgId(contractVO.getOrgId());
        supplementVO.setOrgName(contractVO.getOrgName());
        supplementVO.setParentOrgId(contractVO.getParentOrgId());
        supplementVO.setParentOrgName(contractVO.getParentOrgName());
        supplementVO.setParentOrgCode(contractVO.getParentOrgCode());
        supplementVO.setSignDate(new Date());
        supplementVO.setSupplementFlag(Integer.valueOf(1));
        supplementVO.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().toString());
        supplementVO.setPerformanceStatus(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().toString());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setContractName(contractVO.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setEmployeeId(this.sessionManager.getUserContext().getEmployeeId());
        supplementVO.setEmployeeName(this.sessionManager.getUserContext().getEmployeeName());
        supplementVO.setMainContractCreateDate(contractVO.getMainContractCreateDate());
        supplementVO.setContractType(contractVO.getContractType());
        supplementVO.setContractPropertyCode(contractVO.getContractPropertyCode());
        supplementVO.setContractPropertyName(contractVO.getContractPropertyName());
        supplementVO.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        return supplementVO;
    }

    @Override
    public ContractVO queryDetail(Long id) {
        ContractEntity entity = (ContractEntity)((Object)super.selectById((Serializable)id));
        entity.setContractDetailList(null);
        ContractVO contractVo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        List details = null;
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(ContractDetailEntity::getContractId, (Object)id);
        lambda.ne(ContractDetailEntity::getChangeType, (Object)ChangeTypeEnum.\u4e2d\u6b62\u9879);
        details = this.contractDetailService.list((Wrapper)lambda);
        if (CollectionUtils.isNotEmpty((Collection)details)) {
            contractVo.setContractDetailList(BeanMapper.mapList((Iterable)details, ContractDetailVO.class));
        }
        return contractVo;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam queryParam) {
        HashMap<String, Object> resp = new HashMap();
        QueryWrapper wrapper = ContractServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        wrapper.select(new String[]{"sum(base_money_with_tax) as baseTaxMoney, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        return resp;
    }

    @Override
    public ContractVO querySupplementRecord(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO recordVO = new ContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        recordVO.setId(id);
        recordVO.setContractTaxMny(contractTaxMny);
        recordVO.setChangeStatus(contractEntity.getChangeStatus());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"signature_status", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        recordVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, ContractVO.class));
        recordVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            allSupplementAmt = supplementEntities.stream().map(e -> e.getContractTaxMny() == null ? BigDecimal.ZERO : e.getContractTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        recordVO.setAllSupplementAmt(allSupplementAmt);
        recordVO.setSupplementAmtRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureStatus()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))) {
            recordVO.setEditFlag(this.addSupplementFlag(id));
        }
        return recordVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean changeSignStatus(Long billId, int status, String refCode) {
        this.logger.info("\u8fdb\u5165\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u4fee\u6539\u65b9\u6cd5\uff0c\u4fee\u6539\u53c2\u6570\uff1abillId:{},status:{},refCode:{}", new Object[]{billId, status, refCode});
        ContractEntity contract = (ContractEntity)((Object)super.selectById((Serializable)billId));
        if (contract != null) {
            if (status == Integer.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode())) {
                contract.setSignatureStatus(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode());
                contract.setPerformanceStatus(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
                contract.setFilingStatus(FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode());
                contract.setFilingRef(0);
                contract.setEffectiveDate(new Date());
                CommonResponse response = this.paramConfigApi.getByCode(UPDATE_CON_SIGN_DATE_PARAM_NAME);
                if (!response.isSuccess()) {
                    this.logger.error("\u67e5\u8be2\u7535\u4e2d\u7b7e\u7ae0\u5408\u540c-\u3010id-{}\u3011\u662f\u5426\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u53c2\u6570\u5931\u8d25\uff0c\u6682\u4e0d\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f: {}", (Object)billId, (Object)JSONObject.toJSONString((Object)response));
                }
                if (null != response.getData() && "1".equals(((ParamRegisterSetVO)response.getData()).getValueData())) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    this.logger.info("\u5408\u540c\u3010id-{}\uff0c\u539f\u7b7e\u8ba2\u65e5\u671f\uff1a{}, \u6839\u636e\u7535\u5b50\u7b7e\u7ae0\u5408\u540c\u66f4\u65b0\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u53c2\u6570:{}\uff0c\u5c06\u5408\u540c\u7b7e\u8ba2\u65e5\u671f\u6539\u4e3a\u5f53\u524d\u7b7e\u7ae0\u5b8c\u6210\u65e5\u671f:{}\u3011", new Object[]{billId, sdf.format(contract.getSignDate()), JSONObject.toJSONString((Object)response.getData()), sdf.format(new Date())});
                    contract.setSignDate(new Date());
                }
            } else {
                contract.setSignatureStatus(String.valueOf(status));
            }
        } else {
            return false;
        }
        super.saveOrUpdate((Object)contract, false);
        this.pushContract((ContractVO)BeanMapper.map((Object)((Object)contract), ContractVO.class));
        this.logger.info("\u4e3b\u5408\u540c\u7b7e\u7ae0\u72b6\u6001\u5df2\u4fee\u6539\uff0c\u4fee\u6539\u540e\u7b7e\u7ae0\u72b6\u6001:{}---------------->", (Object)contract.getSignatureStatus());
        return true;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractEntity.getPerformanceStatus())) {
            return false;
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(ContractEntity::getMainContractId, (Object)id);
        lambda.eq(ContractEntity::getSupplementFlag, (Object)1);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(ContractEntity::getSignatureStatus, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(ContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public ExecutionVO targetCost(ContractVO contractVO, String linkUrl, Integer type, Integer contractType) {
        List contractDetailList;
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getBillCode());
        totalVO.setBillDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)contractVO.getSignDate()));
        if (contractType == 0) {
            if (type == 0) {
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setBillType(BillTypeEnum.\u6d88\u8017\u6750\u5408\u540c.getCode());
            } else {
                contractDetailList = contractVO.getContractDetailList();
                totalVO.setLastSourceId(contractVO.getMainContractId());
                totalVO.setBillType(BillTypeEnum.\u6d88\u8017\u6750\u5408\u540c\u53d8\u66f4.getCode());
            }
        } else if (type == 0) {
            contractDetailList = contractVO.getContractDetailList();
            totalVO.setBillType(BillTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getCode());
        } else {
            contractDetailList = contractVO.getContractDetailList();
            totalVO.setLastSourceId(contractVO.getMainContractId());
            totalVO.setBillType(BillTypeEnum.\u6df7\u51dd\u571f\u53d8\u66f4\u5408\u540c.getCode());
        }
        switch (contractVO.getContractPropertyCode()) {
            case "proMaterial-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-2": {
                totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "proMaterial-3": {
                totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode());
                break;
            }
            case "contractConcrete-1": {
                totalVO.setBussinessType(BussinessTypeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode());
            }
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        if (contractDetailList != null) {
            for (ContractDetailVO planDetailVO : contractVO.getContractDetailList()) {
                if ("del".equals(planDetailVO.getRowState())) continue;
                DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
                detailExecutionVO.setSourceId(Long.valueOf(planDetailVO.getId() == null ? IdWorker.getId() : planDetailVO.getId()));
                detailExecutionVO.setSourceBillId(contractVO.getId());
                detailExecutionVO.setCategoryId(planDetailVO.getMaterialTypeId());
                detailExecutionVO.setCategoryName(planDetailVO.getMaterialTypeName());
                if (planDetailVO.getMaterialId() == null) {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(true));
                    detailExecutionVO.setDocId(planDetailVO.getMaterialTypeId());
                } else {
                    detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
                    detailExecutionVO.setDocId(planDetailVO.getMaterialId());
                }
                detailExecutionVO.setCode(planDetailVO.getMaterialCode());
                detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
                MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(planDetailVO.getMaterialTypeId()).getData();
                if (categoryVO == null) {
                    detailExecutionVO.setCategoryInnerCode(null);
                    detailExecutionVO.setCategoryCode(null);
                } else {
                    detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                    detailExecutionVO.setCategoryCode(categoryVO.getCode());
                }
                detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
                detailExecutionVO.setName(planDetailVO.getMaterialName());
                detailExecutionVO.setUnitId(planDetailVO.getUnitId());
                detailExecutionVO.setUnitName(planDetailVO.getUnitName());
                detailExecutionVO.setNum(planDetailVO.getNum());
                detailExecutionVO.setMoney(planDetailVO.getMoney());
                detailExecutionVO.setSpec(planDetailVO.getSpec());
                detailExecutionVO.setTaxMoney(planDetailVO.getDetailTaxMny());
                detailExecutionVO.setPrice(planDetailVO.getPrice());
                detailExecutionVO.setTaxPrice(planDetailVO.getDetailTaxPrice());
                detailExecutionVO.setTaxRate(planDetailVO.getDetailTaxRate());
                detailList.add(detailExecutionVO);
            }
        }
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    public Boolean delContractFile(Long fileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", fileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public Boolean pushContract(ContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setPurchaseType(Integer.valueOf(contractVO.getPurchaseType()));
            data.setSourceType(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
            int targetType = contractVO.getTargetResultId() == null ? 1 : 0;
            data.setPcCardUrl("/ejc-promaterial-frontend/#/contractMaterial/contractApprove?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&targetType=" + targetType + "&performanceStatus=" + contractVO.getPerformanceStatus());
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractVO.getContractType())) {
                data.setSourceType(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
                data.setPcCardUrl("/ejc-promaterial-frontend/#/contractConcrete/contractApprove?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&targetType=" + targetType + "&performanceStatus=" + contractVO.getPerformanceStatus());
            }
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u5408\u540c\u6c60>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            this.logger.info("\u63a8\u9001\u5408\u540c\u6c60\u7ed3\u675f\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
            return false;
        }
        return true;
    }

    @Override
    public ContractVO syncPushContract(Long id) {
        ContractEntity entity = (ContractEntity)((Object)super.selectById((Serializable)id));
        ContractVO vo = (ContractVO)BeanMapper.map((Object)((Object)entity), ContractVO.class);
        this.pushContract(vo);
        return vo;
    }

    @Override
    public void pushDelContract(ContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setSourceType(ContractTypeEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getTypeCode());
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractVO.getContractType())) {
                data.setSourceType(ContractTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getTypeCode());
            }
            this.logger.info("\u5f00\u59cb\u5220\u9664\u5408\u540c\u6c60\u5408\u540c>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.deleteContract(data);
            this.logger.info("\u5220\u9664\u5408\u540c\u6c60\u5408\u540c\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
        }
    }

    @Override
    public boolean addRelieveFlag(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractEntity.getPerformanceStatus())) {
            return false;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        List relieveEntityList = this.relieveService.queryList(queryParam, false);
        return CollectionUtils.isEmpty((Collection)relieveEntityList);
    }

    @Override
    public boolean checkContract(Long id, Long otherId) {
        List contractChangeEntityList;
        Long orgId;
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(contractEntity.getPurchaseType()) && !(orgId = InvocationInfoProxy.getOrgId()).equals(contractEntity.getOrgId())) {
            throw new BusinessException("\u5f53\u524d\u7ec4\u7ec7\u65e0\u6cd5\u5bf9\u8be5\u5408\u540c\u8fdb\u884c\u64cd\u4f5c\uff01");
        }
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        supplementQueryParam.getParams().put("signatureStatus", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("signatureStatus", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(contractChangeEntityList = this.contractChangeService.queryList(queryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5408\u540c\uff01");
        }
        List relieveEntityList = this.relieveService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)relieveEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u89e3\u9664\u5355\u636e\uff01");
        }
        queryParam.getParams().remove("signatureStatus");
        queryParam.getParams().put("billState", new Parameter("in", billStateList));
        List freezeEntityList = this.freezeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)freezeEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u51bb\u7ed3\u6216\u5408\u540c\u89e3\u51bb\u5355\u636e\uff01");
        }
        return true;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(ContractVO contractVO, String authority) {
        CommonResponse<ContractVO> masterPlanVOCommonResponse = this.saveOrUpdate(contractVO, authority, true);
        ContractVO contractVO1 = (ContractVO)masterPlanVOCommonResponse.getData();
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((String)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
        String linkUrl = contractVO1.getContractType() == 0 ? frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/card?id=" + contractVO1.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/card?id=" + contractVO1.getId();
        this.logger.error("\u76ee\u6807\u6210\u672c\u63a7\u5236\u5408\u540c\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)contractVO1));
        ExecutionVO executionVO = this.service.targetCost(contractVO1, linkUrl, 0, contractVO1.getContractType());
        this.logger.error("\u4fdd\u5b58\u63a8\u9001\u76ee\u6807\u6210\u672c\u63a7\u5236\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a7\u5236\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)response));
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO1, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        ContractVO contractVO = this.queryDetail(id);
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((String)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
        String linkUrl = contractVO.getContractType() == 0 ? frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/card?id=" + contractVO.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/card?id=" + contractVO.getId();
        ExecutionVO executionVO = this.service.targetCost(contractVO, linkUrl, 0, contractVO.getContractType());
        this.logger.error("\u8be6\u60c5\u63a8\u9001\u76ee\u6807\u6210\u672c\u63a7\u5236\u6570\u636e" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a7\u5236\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)response));
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        ExecutionVO executionVO;
        CommonResponse response;
        String linkUrl;
        ContractVO contractVO = this.service.queryDetail(id);
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(contractVO.getPurchaseType())) {
            return CommonResponse.error((String)"\u516c\u53f8\u96c6\u91c7\u4e0d\u652f\u6301\u76ee\u6807\u6210\u672c\u63a8\u9001\uff01");
        }
        if (PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(contractVO.getPerformanceStatus())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"contract_id", (Object)id);
            ContractRelieveEntity contractRelieveEntity = (ContractRelieveEntity)((Object)this.relieveService.getOne((Wrapper)queryWrapper));
            String frontendBaseHost = "";
            frontendBaseHost = StringUtils.isNotBlank((String)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
            linkUrl = contractVO.getContractType() == 0 ? frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/contractRelieve/card?id=" + contractRelieveEntity.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/contractRelieve/card?id=" + contractRelieveEntity.getId();
            ExecutionVO executionVO2 = this.relieveService.targetCost((ContractRelieveVO)BeanMapper.map((Object)((Object)contractRelieveEntity), ContractRelieveVO.class), linkUrl, contractVO.getContractType());
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5408\u540c\u89e3\u9664\u6570\u636e" + JSON.toJSONString((Object)executionVO2));
            response = this.executionApi.aggPush(executionVO2);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getOrderMap().put("createTime", "desc");
        List changeEntityList = this.contractChangeService.queryList(queryParam, false);
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((String)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.BaseHost;
        if (CollectionUtils.isNotEmpty((Collection)changeEntityList)) {
            ContractChangeEntity changeEntity = (ContractChangeEntity)((Object)changeEntityList.get(0));
            ContractChangeVO changeVO = this.contractChangeService.queryDetail(changeEntity.getId());
            linkUrl = changeEntity.getContractType() == 0 ? frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/contractChange/card?id=" + changeEntity.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/contractChange/card?id=" + changeEntity.getId();
            executionVO = this.service.targetCost((ContractVO)BeanMapper.map((Object)changeVO, ContractVO.class), linkUrl, 1, changeEntity.getContractType());
        } else {
            linkUrl = contractVO.getContractType() == 0 ? frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/card?id=" + contractVO.getId() : frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/card?id=" + contractVO.getId();
            executionVO = this.service.targetCost(contractVO, linkUrl, 0, contractVO.getContractType());
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public ParamsCheckVO checkParams(ContractVO vo, ParamsCheckVO paramsCheckVO2) {
        ParamsCheckVO costParams;
        ParamsCheckVO priceParam;
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))) {
            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));
        }
        if (!"proMaterial-2".equals(vo.getContractPropertyCode()) || !MaterialContractTypeEnum.\u6d88\u8017\u6750.getCode().equals(vo.getContractType())) {
            paramsCheckVOS.addAll(this.checkParamsMnyPlan(vo));
        }
        if (vo.getSupplementFlag() != null && Objects.equals(vo.getSupplementFlag(), SuplementFlagEnum.\u662f\u8865\u5145\u534f\u8bae.getCode())) {
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));
        }
        if ((priceParam = this.priceCheckParams(vo)) != null) {
            paramsCheckVOS.add(priceParam);
        }
        if (!"proMaterial-3".equals(vo.getContractPropertyCode()) && (costParams = this.costPriceCheckParams(vo)) != null) {
            paramsCheckVOS.add(costParams);
        }
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnySup(ContractVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(vo.getPurchaseType())) {
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMnySup = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)vo.getMainContractId()));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal totalSupMoney = contractTaxMnySup;
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureStatus", new Parameter("eq", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            for (ContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)totalSupMoney);
            }
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getContractType()) {
            case 0: {
                CHECK_PARAM_CODE = M_SUP_CODE;
                break;
            }
            case 1: {
                CHECK_PARAM_CODE = C_SUP_CODE;
            }
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u8865\u5145\u534f\u8bae\u8d85\u5408\u540c\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8865\u5145\u534f\u8bae\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(contractTaxMnySup.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(totalSupMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSupMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(ContractVO vo) {
        List list;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(vo.getPurchaseType())) {
            return paramsCheckVOS;
        }
        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        BigDecimal planTaxMny = BigDecimal.ZERO;
        BigDecimal totalMoney = contractTaxMny;
        LambdaQueryWrapper planLambda = new LambdaQueryWrapper();
        planLambda.eq(MasterPlanEntity::getProjectId, (Object)vo.getProjectId());
        planLambda.in(MasterPlanEntity::getBillState, new Object[]{1, 3});
        planLambda.eq(BaseEntity::getDr, (Object)0);
        planLambda.eq(MasterPlanEntity::getPlanType, (Object)vo.getContractType());
        List planList = this.masterPlanService.list((Wrapper)planLambda);
        if (!CollectionUtils.isNotEmpty((Collection)planList)) {
            return paramsCheckVOS;
        }
        planTaxMny = planList.stream().filter(e -> e.getTotalPlanAmt() != null).map(MasterPlanEntity::getTotalPlanAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        LambdaQueryWrapper Lambda = new LambdaQueryWrapper();
        Lambda.eq(ContractEntity::getProjectId, (Object)vo.getProjectId());
        Lambda.orderByDesc(BaseEntity::getCreateTime);
        Lambda.eq(ContractEntity::getContractType, (Object)vo.getContractType());
        if (MaterialContractTypeEnum.\u6d88\u8017\u6750.getCode().equals(vo.getContractType())) {
            Lambda.ne(ContractEntity::getContractPropertyCode, (Object)"proMaterial-2");
        }
        if (vo.getId() != null) {
            Lambda.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)Lambda)))) {
            List<Long> collect = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<ContractChangeVO> contractChangeList = ((ContractMapper)this.baseMapper).getContractChangeList(collect);
            Map<Long, ContractChangeVO> mapChange = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(ContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
            List<SettlementVO> settlementList = ((ContractMapper)this.baseMapper).getSettlementList(collect);
            Map<Long, SettlementVO> mapSettle = settlementList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(SettlementVO::getContractId, item -> item, (v1, v2) -> v2));
            for (ContractEntity entity : list) {
                BigDecimal zero = BigDecimal.ZERO;
                if (PerformanceStatusEnum.\u5df2\u5c01\u8d26.getCode().equals(entity.getPerformanceStatus()) || PerformanceStatusEnum.\u5df2\u89e3\u9664.getCode().equals(entity.getPerformanceStatus())) {
                    if (mapSettle.containsKey(entity.getId())) {
                        zero = mapSettle.get(entity.getId()).getCurrentSettlementTaxMny();
                    }
                } else {
                    zero = mapChange.containsKey(entity.getId()) ? mapChange.get(entity.getId()).getContractTaxMny() : entity.getContractTaxMny();
                }
                totalMoney = ComputeUtil.safeAdd((BigDecimal)zero, (BigDecimal)totalMoney);
            }
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getContractType()) {
            case 0: {
                CHECK_PARAM_CODE = M_PLAN_CODE;
                break;
            }
            case 1: {
                CHECK_PARAM_CODE = C_PLAN_CODE;
            }
        }
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u603b\u8ba1\u5212\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)planTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u91c7\u8d2d\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u91c7\u8d2d\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(contractTaxMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5408\u540c\u91d1\u989d\uff1a").append(totalMoney.setScale(2, 4)).append("\u5143\uff0c\u603b\u8ba1\u5212\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(ContractVO vo) {
        CommonResponse response = this.paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getContractTaxMny(), vo.getOrgId());
        this.logger.info("\u65bd\u5de5\u5408\u540c\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u53c2\u6570\u63a7\u5236\u4fe1\u606f\u5931\u8d25!" + response.getMsg());
        }
        return (List)response.getData();
    }

    @Override
    public ParamsCheckVO priceCheckParams(ContractVO vo) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        switch (vo.getContractType()) {
            case 0: {
                materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.\u6d88\u8017\u6750\u5408\u540c.getCode());
                break;
            }
            case 1: {
                materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getCode());
            }
        }
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialPriceHistoryApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getContractDetailList())) {
            for (ContractDetailVO detailVO : vo.getContractDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getDetailTaxPrice());
                priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        ParamsCheckVO paramsCheckVO = this.priceHistoryService.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    public ParamsCheckVO costPriceCheckParams(ContractVO vo) {
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        if (vo.getContractType() == 0) {
            materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.\u6d88\u8017\u6750\u5408\u540c.getCode());
        } else {
            materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.\u6df7\u51dd\u571f\u5408\u540c.getCode());
        }
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialCostPriceApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getContractDetailList())) {
            for (ContractDetailVO detailVO : vo.getContractDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getDetailTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.costPriceParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        CommonResponse addFlagData;
        ContractEntity contractEntity;
        List paymentApplyVOList;
        CommonResponse resultData = this.paymentApplyApi.queryListByContractId(id);
        ContractPaymentResultVO resultVO = new ContractPaymentResultVO();
        if (resultData != null && CollectionUtils.isNotEmpty((Collection)(paymentApplyVOList = (List)resultData.getData()))) {
            resultVO.setTotalApplyMny(paymentApplyVOList.stream().filter(p -> p.getApplyMny() != null).map(PaymentApplyVO::getApplyMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            resultVO.setTotalActualMny(paymentApplyVOList.stream().filter(p -> p.getActualMny() != null).map(PaymentApplyVO::getActualMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            resultVO.setTotalApprovalMny(paymentApplyVOList.stream().filter(p -> p.getApprovalMny() != null).map(PaymentApplyVO::getApprovalMny).reduce(BigDecimal.ZERO, BigDecimal::add));
            paymentApplyVOList.forEach(item -> {
                item.setApplyMny(item.getApplyMny() != null ? item.getApplyMny() : BigDecimal.ZERO);
                item.setActualMny(item.getActualMny() != null ? item.getActualMny() : BigDecimal.ZERO);
                item.setApprovalMny(item.getApprovalMny() != null ? item.getApprovalMny() : BigDecimal.ZERO);
            });
            resultVO.setPaymentApplyList(paymentApplyVOList);
        }
        if (null != (contractEntity = (ContractEntity)((Object)this.service.selectById(id)))) {
            resultVO.setContractId(id);
            resultVO.setAddType(Integer.valueOf(contractEntity.getTargetResultId() == null ? 1 : 0));
            resultVO.setContractFlag(contractEntity.getSupplementFlag());
            resultVO.setContractMny(contractEntity.getContractTaxMny());
            if (null != resultVO.getTotalActualMny()) {
                resultVO.setPaymentRate(resultVO.getTotalActualMny().divide(resultVO.getContractMny(), 8, 5).multiply(new BigDecimal(100)));
            } else {
                resultVO.setPaymentRate(BigDecimal.ZERO);
            }
            resultVO.setTotalApplyMny(null != resultVO.getTotalApplyMny() ? resultVO.getTotalApplyMny() : BigDecimal.ZERO);
            resultVO.setTotalActualMny(null != resultVO.getTotalActualMny() ? resultVO.getTotalActualMny() : BigDecimal.ZERO);
            resultVO.setTotalApprovalMny(null != resultVO.getTotalApprovalMny() ? resultVO.getTotalApprovalMny() : BigDecimal.ZERO);
        }
        if ((addFlagData = this.paymentApplyApi.queryAddFlagContractId(id)) != null && addFlagData.getData() != null && ((String)addFlagData.getData()).equals("1")) {
            resultVO.setAddFlag(Boolean.valueOf(true));
        }
        return resultVO;
    }

    @Override
    public List<MaterialReportVO> quueryMaterialByProject(Page pages, QueryWrapper queryWrapper, Long projectId) {
        List<MaterialReportVO> list = ((ContractMapper)this.baseMapper).quueryMaterialByProject(pages, queryWrapper, projectId);
        CommonResponse resDate = this.iDutyApi.queryDoc(projectId);
        if (!resDate.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u6210\u672c\u6570\u91cf\u4fe1\u606f\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5!");
        }
        Map map = (Map)resDate.getData();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(e -> {
                if (null != map && map.containsKey(e.getMaterialId())) {
                    e.setMbNum(map.get(e.getMaterialId()) == null ? BigDecimal.ZERO : (BigDecimal)map.get(e.getMaterialId()));
                }
            });
        }
        return list;
    }

    @Override
    public List<ContractMaterialReportVO> quueryMaterialByOrg(Page page, QueryWrapper wrapper) {
        List<ContractMaterialReportVO> contractMaterialReportVOList = ((ContractMapper)this.baseMapper).quueryMaterialByOrg(page, wrapper);
        if (CollectionUtils.isNotEmpty(contractMaterialReportVOList)) {
            for (ContractMaterialReportVO contractMaterialReportVO : contractMaterialReportVOList) {
                if (contractMaterialReportVO.getContractNum() == null || BigDecimal.ZERO.compareTo(contractMaterialReportVO.getContractNum()) == 0) {
                    contractMaterialReportVO.setContractTaxPrice(BigDecimal.ZERO);
                } else {
                    contractMaterialReportVO.setContractTaxPrice(contractMaterialReportVO.getContractTaxMny().divide(contractMaterialReportVO.getContractNum(), 8, 5));
                }
                if (contractMaterialReportVO.getContractMny() == null || BigDecimal.ZERO.compareTo(contractMaterialReportVO.getContractMny()) == 0) {
                    contractMaterialReportVO.setContractTaxRate(BigDecimal.ZERO);
                    continue;
                }
                BigDecimal contractTaxRate = contractMaterialReportVO.getContractTaxMny().subtract(contractMaterialReportVO.getContractMny()).divide(contractMaterialReportVO.getContractMny(), 4);
                contractMaterialReportVO.setContractTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
            }
            List<Long> contractIds = contractMaterialReportVOList.stream().map(ContractMaterialReportVO::getContractId).collect(Collectors.toList());
            List<ContractMaterialReportVO> orderList = ((ContractMapper)this.baseMapper).getOrderNum(contractIds);
            List<ContractMaterialReportVO> checkList = ((ContractMapper)this.baseMapper).getCheckNum(contractIds);
            List<ContractMaterialReportVO> settleList = ((ContractMapper)this.baseMapper).getSettleNum(contractIds);
            if (CollectionUtils.isNotEmpty(settleList)) {
                for (ContractMaterialReportVO contractMaterialReportVO : settleList) {
                    if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getSettlementNum()) == 0) {
                        contractMaterialReportVO.setSettlementTaxPrice(BigDecimal.ZERO);
                    } else {
                        contractMaterialReportVO.setSettlementTaxPrice(contractMaterialReportVO.getSettlementTaxMny().divide(contractMaterialReportVO.getSettlementNum(), 8, 5));
                    }
                    if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getSettlementMny()) == 0) {
                        contractMaterialReportVO.setSettlementTaxRate(BigDecimal.ZERO);
                        continue;
                    }
                    BigDecimal contractTaxRate = contractMaterialReportVO.getSettlementTaxMny().subtract(contractMaterialReportVO.getSettlementMny()).divide(contractMaterialReportVO.getSettlementMny(), 4);
                    contractMaterialReportVO.setSettlementTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
                }
            }
            for (ContractMaterialReportVO contractMaterialReportVO : contractMaterialReportVOList) {
                for (ContractMaterialReportVO order : orderList) {
                    if (!contractMaterialReportVO.getContractId().equals(order.getContractId()) || !contractMaterialReportVO.getMaterialId().equals(order.getMaterialId())) continue;
                    contractMaterialReportVO.setOrderNum(order.getOrderNum());
                }
                for (ContractMaterialReportVO check : checkList) {
                    if (!contractMaterialReportVO.getContractId().equals(check.getContractId()) || !contractMaterialReportVO.getMaterialId().equals(check.getMaterialId())) continue;
                    contractMaterialReportVO.setCheckNum(check.getCheckNum());
                    contractMaterialReportVO.setCheckTaxMny(check.getCheckTaxMny());
                    contractMaterialReportVO.setCheckMny(check.getCheckMny());
                    if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getCheckMny()) == 0) {
                        contractMaterialReportVO.setCheckTaxRate(BigDecimal.ZERO);
                    } else {
                        BigDecimal contractTaxRate = contractMaterialReportVO.getCheckTaxMny().subtract(contractMaterialReportVO.getCheckMny()).divide(contractMaterialReportVO.getCheckMny(), 4);
                        contractMaterialReportVO.setCheckTaxRate(contractTaxRate.multiply(new BigDecimal(100)));
                    }
                    if (BigDecimal.ZERO.compareTo(contractMaterialReportVO.getCheckMny()) == 0) {
                        contractMaterialReportVO.setCheckTaxTaxPrice(BigDecimal.ZERO);
                        continue;
                    }
                    contractMaterialReportVO.setCheckTaxTaxPrice(contractMaterialReportVO.getCheckTaxMny().divide(contractMaterialReportVO.getCheckNum(), 8, 5));
                }
                for (ContractMaterialReportVO settle : settleList) {
                    if (!contractMaterialReportVO.getContractId().equals(settle.getContractId()) || !contractMaterialReportVO.getMaterialId().equals(settle.getMaterialId())) continue;
                    contractMaterialReportVO.setSettlementNum(settle.getSettlementNum());
                    contractMaterialReportVO.setSettlementTaxRate(settle.getSettlementTaxRate());
                    contractMaterialReportVO.setSettlementTaxPrice(settle.getSettlementTaxPrice());
                    contractMaterialReportVO.setSettlementTaxMny(settle.getSettlementTaxMny());
                }
            }
        }
        return contractMaterialReportVOList;
    }

    @Override
    public void updateTargetResult(ContractVO vo, Integer type) {
        if (vo.getTargetResultId() == null) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)vo.getContractDetailList())) {
            return;
        }
        TenderPicketageVO picketageVO = new TenderPicketageVO();
        picketageVO.setId(vo.getTargetResultId());
        picketageVO.setContractMoneyTax(vo.getContractTaxMny());
        picketageVO.setContractMoney(vo.getContractMny());
        ArrayList<TenderPicketageDetailVO> list = new ArrayList<TenderPicketageDetailVO>();
        for (ContractDetailVO detailVO : vo.getContractDetailList()) {
            if ("del".equals(detailVO.getRowState())) continue;
            TenderPicketageDetailVO tenderDetailVo = new TenderPicketageDetailVO();
            tenderDetailVo.setId(Long.valueOf(detailVO.getSourceId()));
            tenderDetailVo.setSignNum(detailVO.getNum());
            list.add(tenderDetailVo);
        }
        picketageVO.setTenderPicketageDetailList(list);
        String typeStr = 0 == type ? "\u5360\u7528" : "\u91ca\u653e";
        this.logger.info("{}\u5b9a\u6807\u7ed3\u679c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)typeStr, (Object)JSONObject.toJSONString((Object)picketageVO));
        CommonResponse response = 0 == type ? this.tenderApi.updateStatus(picketageVO) : this.tenderApi.delUpdateStatus(picketageVO);
        this.logger.info("{}\u5b9a\u6807\u7ed3\u679c\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)typeStr, (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            throw new BusinessException(typeStr + "\u5b9a\u6807\u7ed3\u679c\u5931\u8d25\uff01");
        }
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        ArrayList<SignContractVo> rtnList = new ArrayList<SignContractVo>();
        if (CollectionUtils.isEmpty(targetResultIdList)) {
            return rtnList;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter("in", targetResultIdList));
        queryParam.getOrderMap().put("signDate", "desc");
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return rtnList;
        }
        for (ContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getBillCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignDate());
            vo.setBillState(entity.getBillState());
            vo.setLinkUrl(this.getContractLinkUrl(entity.getTargetResultId(), entity.getId(), entity.getSupplementFlag(), entity.getPerformanceStatus(), entity.getContractType()));
            rtnList.add(vo);
        }
        return rtnList;
    }

    private String getContractLinkUrl(Long targetResultId, Long contractId, Integer supplementFlag, String performanceStatus, Integer contractType) {
        int targetType = targetResultId == null ? 1 : 0;
        String url = "/ejc-promaterial-frontend/#/contractMaterial/contractApprove?id=" + contractId + "&supplementFlag=" + supplementFlag + "&targetType=" + targetType + "&performanceStatus=" + performanceStatus;
        if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractType)) {
            url = "/ejc-promaterial-frontend/#/contractConcrete/contractApprove?id=" + contractId + "&supplementFlag=" + supplementFlag + "&targetType=" + targetType + "&performanceStatus=" + performanceStatus;
        }
        return url;
    }

    private void checkDetailTenderNum(List<ContractDetailVO> detailList, Long contractId, Long targetResultId) {
        List detailEntityList;
        if (targetResultId == null) {
            return;
        }
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        for (ContractDetailVO vo : detailList) {
            if (vo.getSignNum() != null && vo.getSignNum().compareTo(vo.getNum()) >= 0) continue;
            throw new BusinessException("\u7b7e\u8ba2\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u53ef\u7b7e\u8ba2\u6570\u91cf");
        }
        List sourceIdList = detailList.stream().map(ContractDetailVO::getSourceId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("sourceId", new Parameter("in", sourceIdList));
        if (contractId != null) {
            detailParam.getParams().put("contractId", new Parameter("ne", (Object)contractId));
        }
        if (CollectionUtils.isEmpty((Collection)(detailEntityList = this.contractDetailService.queryList(detailParam, false)))) {
            return;
        }
        Map<String, List<ContractDetailEntity>> queryMap = detailEntityList.stream().collect(Collectors.groupingBy(ContractDetailEntity::getSourceId));
        for (ContractDetailVO detail : detailList) {
            List<ContractDetailEntity> queryDetailList = queryMap.get(detail.getSourceId());
            BigDecimal tenderNum = CommonUtils.setBigDecimalDefaultValue(detail.getTenderNum());
            if (CollectionUtils.isEmpty(queryDetailList)) continue;
            BigDecimal signTenderNum = BigDecimal.ZERO;
            for (ContractDetailEntity detailEntity : queryDetailList) {
                signTenderNum = signTenderNum.add(CommonUtils.setBigDecimalDefaultValue(detailEntity.getInitNum()));
            }
            BigDecimal sy = tenderNum.subtract(signTenderNum);
            if (sy.compareTo(detail.getNum()) >= 0) continue;
            throw new BusinessException(detail.getMaterialName() + "\u91c7\u8d2d\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7" + sy);
        }
    }

    @Override
    public void asyncWatermarkById(Long id) {
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)id));
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            String billType = "BT211227000000003";
            String sourceType = "contractMaterial";
            if (MaterialContractTypeEnum.\u6df7\u51dd\u571f.getCode().equals(contractEntity.getContractType())) {
                billType = "BT220215000000001";
                sourceType = "contractConcrete";
            }
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(), contractEntity.getBillCode(), billType, sourceType);
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.contractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }

    @Override
    public String getContractFilingCode() {
        CommonResponse response = this.paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        this.logger.info("\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        return StringUtils.isNotEmpty((String)valueData) ? valueData : "0";
    }

    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        ContractEntity contractEntity = (ContractEntity)((Object)super.selectById((Serializable)contractId));
        if ("0".equals(valueData)) {
            return true;
        }
        return FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(contractEntity.getFilingStatus());
    }

    @Override
    public ParamsCheckVO costPriceParams(MaterialCostPriceApiVO materialPriceHistoryApiVO) {
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List detailList = materialPriceHistoryApiVO.getMaterialCostPriceApiVOList();
        Integer priceCheckType = materialPriceHistoryApiVO.getPriceCheckType();
        if (priceCheckType == null) {
            this.logger.info("priceCheckType\u4e3a\u7a7a\u76f4\u63a5\u8fd4\u56de\u7ed3\u679c");
            return paramsCheckVO;
        }
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            this.logger.info("detailList\u4e3a\u7a7a\u76f4\u63a5\u8fd4\u56de\u7ed3\u679c");
            return paramsCheckVO;
        }
        List materialIds = detailList.stream().map(MaterialCostPriceApiVO::getMaterialId).collect(Collectors.toList());
        String MAX_CODE = "";
        String name = MaterialCostPriceCheckTypeEnum.getEnumByCode((Integer)priceCheckType).getDescription();
        switch (priceCheckType) {
            case 1: {
                MAX_CODE = MaterialCostPriceCheckCodeEnum.\u6750\u6599\u91c7\u8d2d\u5408\u540c.getCode();
                break;
            }
            case 2: {
                MAX_CODE = MaterialCostPriceCheckCodeEnum.\u6750\u6599\u91c7\u8d2d\u9a8c\u6536.getCode();
                break;
            }
            case 3: {
                MAX_CODE = MaterialCostPriceCheckCodeEnum.\u6750\u6599\u91c7\u8d2d\u7ed3\u7b97.getCode();
                break;
            }
            case 4: {
                MAX_CODE = MaterialCostPriceCheckCodeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode();
                break;
            }
            case 5: {
                MAX_CODE = MaterialCostPriceCheckCodeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u9a8c\u6536.getCode();
                break;
            }
            case 6: {
                MAX_CODE = MaterialCostPriceCheckCodeEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u7ed3\u7b97.getCode();
            }
        }
        Long orgId = materialPriceHistoryApiVO.getOrgId();
        if (null == orgId) {
            this.logger.info("orgId\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        CommonResponse maxParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MAX_CODE, orgId);
        if (!maxParamByCode.isSuccess() && null == maxParamByCode.getData()) {
            this.logger.info(maxParamByCode.getMsg());
            return paramsCheckVO;
        }
        List maxParamVOS = (List)maxParamByCode.getData();
        this.logger.info(name + "\u4ef7\u683c\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)maxParamVOS));
        CommonResponse dutyRes = this.dutyApi.queryPriceByDocIds(materialPriceHistoryApiVO.getProjectId(), DocTypeEnum.\u7269\u6599\u6863\u6848.getCode(), materialIds);
        if (null == dutyRes) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683c\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        Map dutyMap = (Map)dutyRes.getData();
        if (null == dutyMap) {
            this.logger.info("\u83b7\u53d6\u76ee\u6807\u6210\u672c\u4ef7\u683cmap\u4e3a\u7a7a");
            return paramsCheckVO;
        }
        if (CollectionUtils.isNotEmpty((Collection)maxParamVOS)) {
            for (BillParamVO maxParamVO : maxParamVOS) {
                ParamsCheckVO paramsCheckVOCost = new ParamsCheckVO();
                ArrayList<ParamsCheckDsVO> checkDsVOSMax = new ArrayList<ParamsCheckDsVO>();
                BigDecimal roleValueMax = maxParamVO.getRoleValue();
                paramsCheckVOCost.setWarnType(paramsArray[maxParamVO.getControlType()]);
                for (MaterialCostPriceApiVO detailVO : detailList) {
                    BigDecimal maxPriceParam;
                    BigDecimal maxPrice = dutyMap.get(detailVO.getMaterialId()) == null ? BigDecimal.ZERO : ((BigDecimal)dutyMap.get(detailVO.getMaterialId())).setScale(4, 4);
                    BigDecimal price = detailVO.getPrice() == null ? BigDecimal.ZERO : detailVO.getPrice().setScale(4, 4);
                    if (price.compareTo(maxPriceParam = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)maxPrice, (BigDecimal)roleValueMax), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(maxParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + (detailVO.getSpec() == null ? "" : "+" + detailVO.getSpec()));
                    paramsCheckDsVO.setWarnName(name + "\u5355\u4ef7\u5927\u4e8e\u76ee\u6807\u6210\u672c\u5355\u4ef7");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(name + "\u5355\u4ef7\uff1a").append(price).append("\uff0c\u76ee\u6807\u6210\u672c\u5355\u4ef7:(").append(maxPrice).append("),\u76ee\u6807\u6210\u672c\u5355\u4ef7*").append(roleValueMax).append("%:").append(maxPriceParam).append("\uff0c\u8d85\u51fa\uff1a").append(ComputeUtil.safeSub((BigDecimal)price, (BigDecimal)maxPriceParam).setScale(4, 4));
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOSMax.add(paramsCheckDsVO);
                }
                paramsCheckVOCost.setDataSource(checkDsVOSMax);
                paramsCheckVOS.add(paramsCheckVOCost);
            }
        }
        String[] paramsArr = new String[]{"alert", "warn", "none"};
        HashMap<String, List> map = new HashMap<String, List>();
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArr) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }
}

