/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.electronicFence.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigDetailEntity;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.service.IAmapService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigDetailService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.electronicFence.vo.DistanceVO;
import com.ejianc.business.promaterial.electronicFence.vo.ElectronicFenceConfigVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"electronicFenceConfig"})
public class ElectronicFenceConfigController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "ELECTRONIC_FENCE_CONFIG";
    @Autowired
    private IElectronicFenceConfigService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IElectronicFenceConfigDetailService electronicFenceConfigDetailService;
    @Resource
    private IAmapService amapService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    public CommonResponse<ElectronicFenceConfigVO> saveOrUpdate(@RequestBody ElectronicFenceConfigVO saveOrUpdateVO) {
        ElectronicFenceConfigEntity entity = (ElectronicFenceConfigEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, ElectronicFenceConfigEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            ElectronicFenceConfigEntity dbEntity = this.service.getOneByProjectId(saveOrUpdateVO.getProjectId(), false);
            if (null != dbEntity) {
                return CommonResponse.error((String)"\u5f53\u524d\u9879\u76ee\u5df2\u6709\u7535\u5b50\u56f4\u680f\u8bbe\u7f6e\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0\uff01");
            }
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        ElectronicFenceConfigVO vo = (ElectronicFenceConfigVO)BeanMapper.map((Object)((Object)entity), ElectronicFenceConfigVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    public CommonResponse<ElectronicFenceConfigVO> queryDetail(Long id) {
        ElectronicFenceConfigEntity entity = (ElectronicFenceConfigEntity)((Object)this.service.selectById(id));
        ElectronicFenceConfigVO vo = (ElectronicFenceConfigVO)BeanMapper.map((Object)((Object)entity), ElectronicFenceConfigVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    public CommonResponse<String> delete(@RequestBody List<ElectronicFenceConfigVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        QueryWrapper query = new QueryWrapper();
        query.in((Object)"id", ids);
        query.in((Object)"bill_state", (Object[])new Integer[]{BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode()});
        int num = this.service.count((Wrapper)query);
        if (num > 0) {
            return CommonResponse.error((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u4e0d\u80fd\u5220\u9664\u975e\u81ea\u7531\u6001\u7684\u5355\u636e\uff01");
        }
        this.service.removeByIds(ids, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    public CommonResponse<IPage<ElectronicFenceConfigVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ElectronicFenceConfigVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("projectCode");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List vos = BeanMapper.mapList((Iterable)list, ElectronicFenceConfigVO.class);
        vos.stream().forEach(item -> {
            item.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)item.getBillState()).getDescription());
            item.setEnableName(Integer.valueOf(1).equals(item.getEnable()) ? "\u662f" : "\u5426");
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", vos);
        ExcelExport.getInstance().exportWithTrans("ElectronicFenceConfig-export.xlsx", beans, response);
    }

    @GetMapping(value={"/checkProjectFenceState"})
    public CommonResponse<JSONObject> checkProjectFenceState(@RequestParam Long projectId) {
        ElectronicFenceConfigEntity fence = this.service.getOneByProjectId(projectId, true);
        JSONObject resp = new JSONObject();
        resp.put("enableState", fence == null ? null : fence.getEnable().toString());
        return CommonResponse.success((Object)resp);
    }

    @GetMapping(value={"/checkIsInFenceArea"})
    public CommonResponse<JSONObject> checkIsInFenceArea(@RequestParam Long projectId, @RequestParam String destination) {
        JSONObject resp = new JSONObject();
        ElectronicFenceConfigEntity fence = this.service.getOneByProjectId(projectId, true);
        if (null == fence) {
            resp.put("isInFenceArea", (Object)true);
            resp.put("address", (Object)"");
            resp.put("permission", (Object)true);
            return CommonResponse.success((Object)resp);
        }
        Integer offSiteFlag = fence.getEnable();
        QueryWrapper detailQuery = new QueryWrapper();
        detailQuery.eq((Object)"pid", (Object)fence.getId());
        List detailList = this.electronicFenceConfigDetailService.list((Wrapper)detailQuery);
        String lngLat = detailList.stream().map(ElectronicFenceConfigDetailEntity::getLngLat).collect(Collectors.joining("|"));
        List<DistanceVO> distance = this.amapService.distance(lngLat, destination, "0");
        this.logger.info("\u6821\u9a8c\u8003\u52e4\u8303\u56f4--{}", (Object)JSON.toJSONString(distance, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        Map distanceMap = distance.stream().collect(Collectors.toMap(DistanceVO::getDistance, Function.identity(), (key1, key2) -> key2));
        BigDecimal min = distance.stream().map(d -> new BigDecimal(d.getDistance())).min(Comparator.comparing(x -> x)).orElse(null);
        DistanceVO minDistanceVO = (DistanceVO)distanceMap.get(Objects.requireNonNull(min).toString());
        ElectronicFenceConfigDetailEntity detail = (ElectronicFenceConfigDetailEntity)((Object)detailList.get(Integer.parseInt(minDistanceVO.getOriginId()) - 1));
        if (new BigDecimal(minDistanceVO.getDistance()).compareTo(detail.getEffectiveRange()) < 0) {
            resp.put("isInFenceArea", (Object)true);
            resp.put("address", (Object)detail.getAddress());
            resp.put("permission", (Object)true);
            return CommonResponse.success((Object)resp);
        }
        JSONObject regeo = this.amapService.regeo(destination);
        this.logger.info("\u6821\u9a8c\u8003\u52e4\u8303\u56f4\uff0c\u9006\u5730\u7406\u7f16\u7801--{}", (Object)regeo);
        String formattedAddress = regeo.getString("formatted_address");
        resp.put("address", (Object)formattedAddress);
        resp.put("isInFenceArea", (Object)false);
        if (offSiteFlag == 0) {
            resp.put("permission", (Object)true);
            return CommonResponse.success((Object)resp);
        }
        resp.put("permission", (Object)false);
        return CommonResponse.success((Object)resp);
    }
}

