/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.dataModel.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.contract.mapper.ContractMapper;
import com.ejianc.business.promaterial.dataModel.consts.DataModelEnum;
import com.ejianc.business.promaterial.dataModel.vo.MaterialDataModelVO;
import com.ejianc.business.promaterial.plan.mapper.BatPlanMapper;
import com.ejianc.business.targetcost.api.IDutyApi;
import com.ejianc.framework.core.response.CommonResponse;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.formula.functions.T;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialDataModelService")
public class MaterialDataModelService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ContractMapper contractMapper;
    @Autowired
    private IDutyApi dutyApi;
    @Autowired
    BatPlanMapper batPlanMapper;

    public List<MaterialDataModelVO> queryList(Long projectId, Long contractId, QueryWrapper<T> queryWrapper) {
        return this.contractMapper.queryMaterialDataModelList(projectId, contractId, queryWrapper);
    }

    public List<MaterialDataModelVO> queryContractByMaterialTypeIdList(Long projectId, Long contractId, QueryWrapper<T> queryWrapper) {
        return this.contractMapper.queryContractByMaterialTypeIdList(projectId, contractId, queryWrapper);
    }

    public List<MaterialDataModelVO> queryListByProjectId(JSONObject param) {
        this.logger.info("\u9879\u76ee\u6750\u6599\u60c5\u51b5\u5165\u53c2 : {}", (Object)param);
        Map<String, List<Long>> listMap = this.processData(param);
        this.logger.info("listMap\uff1a{}", (Object)JSONObject.toJSONString(listMap));
        Long projectId = param.getLong("projectId");
        String billTypeCode = param.getString("billTypeCode");
        boolean isTypeFlag = this.isMaterialTypeFlag(billTypeCode);
        List<Long> materialTypeIds = !isTypeFlag ? listMap.get("allMaterialTypeIds") : listMap.get("materialTypeIds");
        List<Long> materialIds = listMap.get("materialIds");
        this.logger.info("isTypeFlag:{}", (Object)isTypeFlag);
        this.logger.info("materialTypeIds:{}", (Object)JSONObject.toJSONString(materialTypeIds));
        this.logger.info("materialIds:{}", (Object)JSONObject.toJSONString(materialIds));
        List<MaterialDataModelVO> materialDataModelVOs = new ArrayList<MaterialDataModelVO>();
        if (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds)) {
            materialDataModelVOs = this.queryMaterialDataList(projectId, null, materialIds, materialTypeIds);
        }
        if (CollectionUtils.isNotEmpty(materialDataModelVOs = this.getChildrenData(param, materialDataModelVOs))) {
            CommonResponse mapCommonResponse = this.dutyApi.querySumPreTypeAmount(projectId);
            this.logger.info("\u67e5\u8be2\u76ee\u6807\u91cf\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)mapCommonResponse));
            if (mapCommonResponse.isSuccess()) {
                Map materialTypeMap = (Map)mapCommonResponse.getData();
                for (MaterialDataModelVO materialDataModelVO : materialDataModelVOs) {
                    if (materialTypeMap == null) continue;
                    BigDecimal mbNum = (BigDecimal)materialTypeMap.get(materialDataModelVO.getMaterialTypeId());
                    if (mbNum == null) {
                        mbNum = BigDecimal.ZERO;
                    }
                    materialDataModelVO.setMbNum(mbNum);
                }
            }
        }
        return materialDataModelVOs;
    }

    public List<MaterialDataModelVO> queryListByContractId(JSONObject param) {
        this.logger.info("\u5408\u540c\u6750\u6599\u60c5\u51b5\u5165\u53c2 : {}", (Object)param);
        Map<String, List<Long>> listMap = this.processData(param);
        Object bill = param.get((Object)"bill");
        JSONObject content = new JSONObject((Map)((HashMap)bill));
        String billTypeCode = (String)param.get((Object)"billTypeCode");
        boolean isTypeFlag = this.isMaterialTypeFlag(billTypeCode);
        Long contractId = null;
        if (DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode)) {
            contractId = content.getLong("id");
        } else if (content.get((Object)"contractId") != null) {
            JSONObject contract = new JSONObject((Map)((HashMap)content.get((Object)"contractId")));
            contractId = contract.getLong("id");
        }
        List<Long> materialTypeIds = !isTypeFlag ? listMap.get("allMaterialTypeIds") : listMap.get("materialTypeIds");
        List<Long> materialIds = listMap.get("materialIds");
        this.logger.info("isTypeFlag:{}", (Object)isTypeFlag);
        this.logger.info("materialTypeIds:{}", (Object)JSONObject.toJSONString(materialTypeIds));
        this.logger.info("materialIds:{}", (Object)JSONObject.toJSONString(materialIds));
        List<MaterialDataModelVO> materialDataModelVOs = new ArrayList<MaterialDataModelVO>();
        if (contractId != null && (CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds))) {
            materialDataModelVOs = this.queryMaterialDataList(null, contractId, materialIds, materialTypeIds);
        }
        materialDataModelVOs = this.getChildrenData(param, materialDataModelVOs);
        return materialDataModelVOs;
    }

    public List<MaterialDataModelVO> queryListByBatPlan(JSONObject param) {
        this.logger.info("\u6279\u6b21\u8ba1\u5212\u5165\u53c2 : {}", (Object)param);
        Map<String, List<Long>> listMap = this.processData(param);
        Long projectId = param.getLong("projectId");
        String billTypeCode = (String)param.get((Object)"billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        List<Long> materialTypeIds = listMap.get("materialTypeIds");
        List<Long> materialIds = listMap.get("materialIds");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in(CollectionUtils.isNotEmpty(materialIds), (Object)"material_id", materialIds);
        if (CollectionUtils.isNotEmpty(materialTypeIds)) {
            queryWrapper.or(wrapper -> (QueryWrapper)((QueryWrapper)wrapper.in((Object)"material_type_id", (Collection)materialTypeIds)).isNull((Object)"material_id"));
        }
        List<MaterialDataModelVO> materialDataModelVOs = new ArrayList<MaterialDataModelVO>();
        if ((CollectionUtils.isNotEmpty(materialIds) || CollectionUtils.isNotEmpty(materialTypeIds)) && CollectionUtils.isNotEmpty(materialDataModelVOs = this.batPlanMapper.queryBatPlanMaterialDataList(projectId, queryWrapper))) {
            CommonResponse commonResponse = this.dutyApi.queryDoc(projectId);
            this.logger.info("\u9879\u76eeid[{}]\u8c03\u7528\u76ee\u6807\u91cf\u67e5\u8be2\u7ed3\u679c1\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)projectId, (Object)JSONObject.toJSONString((Object)commonResponse));
            CommonResponse mapCommonResponse = this.dutyApi.querySumPreTypeAmount(projectId);
            this.logger.info("\u9879\u76eeid[{}]\u8c03\u7528\u76ee\u6807\u91cf\u67e5\u8be2\u7ed3\u679c2\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)projectId, (Object)JSONObject.toJSONString((Object)mapCommonResponse));
            if (commonResponse.isSuccess()) {
                Map map = (Map)commonResponse.getData();
                for (MaterialDataModelVO materialDataModelVO : materialDataModelVOs) {
                    if (materialDataModelVO.getMaterialId() != null) {
                        BigDecimal mbNum = (BigDecimal)map.get(materialDataModelVO.getMaterialId());
                        if (mbNum == null) {
                            mbNum = BigDecimal.ZERO;
                        }
                        materialDataModelVO.setMbNum(mbNum);
                        continue;
                    }
                    Map materialTypeMap = (Map)mapCommonResponse.getData();
                    if (materialTypeMap == null) continue;
                    BigDecimal mbNum = (BigDecimal)materialTypeMap.get(materialDataModelVO.getMaterialTypeId());
                    if (mbNum == null) {
                        mbNum = BigDecimal.ZERO;
                    }
                    materialDataModelVO.setMbNum(mbNum);
                }
            }
        }
        materialDataModelVOs = this.getChildrenData(param, materialDataModelVOs);
        return materialDataModelVOs;
    }

    private List<MaterialDataModelVO> queryMaterialDataList(Long projectId, Long contractId, List<Long> materialIdList, List<Long> materialTypeIdList) {
        this.logger.info("\u67e5\u8be2\u6570\u636e\u6a21\u578b\u53c2\u6570\uff1aprojectId:{},contractId:{}", (Object)projectId, (Object)contractId);
        this.logger.info("materialIdList\uff1a{}", (Object)JSONObject.toJSONString(materialIdList));
        this.logger.info("materialTypeIdList\uff1a{}", (Object)JSONObject.toJSONString(materialTypeIdList));
        ArrayList<MaterialDataModelVO> rtnList = new ArrayList<MaterialDataModelVO>();
        QueryWrapper materialWrapper = new QueryWrapper();
        materialWrapper.in(CollectionUtils.isNotEmpty(materialIdList), (Object)"material_id", materialIdList);
        List<MaterialDataModelVO> materialModelList = this.contractMapper.queryListByMaterialId(projectId, contractId, materialWrapper);
        rtnList.addAll(materialModelList);
        QueryWrapper materialTypeWrapper = new QueryWrapper();
        ((QueryWrapper)materialTypeWrapper.in(CollectionUtils.isNotEmpty(materialTypeIdList), (Object)"material_type_id", materialTypeIdList)).and(wer -> (QueryWrapper)((QueryWrapper)wer.notIn(CollectionUtils.isNotEmpty((Collection)materialIdList), (Object)"material_id", (Collection)materialIdList)).or(wor -> (QueryWrapper)wor.isNull((Object)"material_id")));
        List<MaterialDataModelVO> materialTypeModelList = this.contractMapper.queryListByMaterialTypeId(projectId, contractId, materialTypeWrapper);
        rtnList.addAll(materialTypeModelList);
        this.logger.info("\u67e5\u8be2\u6570\u636e\u6a21\u578b\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(rtnList));
        return rtnList;
    }

    private Map<String, List<Long>> processData(JSONObject param) {
        JSONArray jsonArray;
        HashMap<String, List<Long>> map = new HashMap<String, List<Long>>();
        String materialTypeId = "materialTypeId";
        ArrayList<Long> materialIds = new ArrayList<Long>();
        ArrayList<Long> materialTypeIds = new ArrayList<Long>();
        ArrayList<Long> allMaterialTypeIds = new ArrayList<Long>();
        String billTypeCode = (String)param.get((Object)"billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        Object bill = param.get((Object)"bill");
        JSONObject content = new JSONObject((Map)((HashMap)bill));
        if (content.get((Object)subTableName) != null && (jsonArray = content.getJSONArray(subTableName)) != null) {
            if (DataModelEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode)) {
                materialTypeId = "materialCategoryId";
            }
            for (Object o : jsonArray) {
                JSONObject subContent = new JSONObject((Map)((HashMap)o));
                if (subContent.get((Object)"materialId") != null) {
                    String materialId = (String)subContent.get((Object)"materialId");
                    materialIds.add(Long.parseLong(materialId));
                } else {
                    String materialCategoryId = (String)subContent.get((Object)materialTypeId);
                    materialTypeIds.add(Long.parseLong(materialCategoryId));
                }
                if (subContent.get((Object)materialTypeId) == null) continue;
                allMaterialTypeIds.add(Long.parseLong(subContent.getString(materialTypeId)));
            }
        }
        map.put("materialTypeIds", materialTypeIds);
        map.put("materialIds", materialIds);
        map.put("allMaterialTypeIds", allMaterialTypeIds);
        return map;
    }

    private List<MaterialDataModelVO> getChildrenData(JSONObject param, List<MaterialDataModelVO> materialDataModelVOs) {
        JSONArray jsonArray;
        this.logger.info("\u6570\u636e\u6a21\u578b\u5904\u7406\u8fd4\u56de\u6570\u636e\uff1aparam:{}", (Object)param);
        this.logger.info("materialDataModelVOs:{}", (Object)JSONObject.toJSONString(materialDataModelVOs));
        ArrayList<MaterialDataModelVO> list = new ArrayList<MaterialDataModelVO>();
        Long projectId = param.getLong("projectId");
        String materialTypeId = "materialTypeId";
        String materialTypeName = "materialTypeName";
        String unit = "unit";
        String billTypeCode = (String)param.get((Object)"billTypeCode");
        String subTableName = DataModelEnum.getByCode(billTypeCode).getName();
        Object bill = param.get((Object)"bill");
        JSONObject content = new JSONObject((Map)((HashMap)bill));
        Map materialMap = materialDataModelVOs.stream().filter(s -> s.getMaterialId() != null).collect(Collectors.toMap(MaterialDataModelVO::getMaterialId, Function.identity(), (key1, key2) -> key2));
        this.logger.info("\u6839\u636ematerialId\u7ec4\u88c5map\u7ed3\u679c:materialMap:{}", (Object)JSONObject.toJSONString(materialMap));
        Map materialTypeMap = materialDataModelVOs.stream().filter(s -> s.getMaterialId() == null).collect(Collectors.toMap(MaterialDataModelVO::getMaterialTypeId, Function.identity(), (key1, key2) -> key2));
        this.logger.info("\u6839\u636ematerialTypeId\u7ec4\u88c5map\u7ed3\u679c:materialTypeMap:{}", (Object)JSONObject.toJSONString(materialTypeMap));
        if (content.get((Object)subTableName) != null && (jsonArray = content.getJSONArray(subTableName)) != null) {
            if (DataModelEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode)) {
                materialTypeName = "materialCategoryName";
                materialTypeId = "materialCategoryId";
            }
            if (DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u53d8\u66f4.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u53d8\u66f4\u5408\u540c.getCode().equals(billTypeCode)) {
                unit = "unitName";
            }
            for (Object o : jsonArray) {
                JSONObject subContent = new JSONObject((Map)((HashMap)o));
                MaterialDataModelVO materialDataModelVO = new MaterialDataModelVO();
                long materialType = Long.parseLong(subContent.get((Object)materialTypeId).toString());
                long materialId = Long.parseLong(subContent.get((Object)"materialId") != null ? subContent.get((Object)"materialId").toString() : Long.toString(0L));
                this.logger.info("\u5faa\u73af\u5904\u7406\uff0cmaterialId:{},materialTypeId:{}", (Object)materialId, (Object)materialType);
                if (materialMap.containsKey(materialId)) {
                    materialDataModelVO = (MaterialDataModelVO)materialMap.get(materialId);
                    if (BigDecimal.ZERO.compareTo(materialDataModelVO.getContractNum()) == 0) {
                        MaterialDataModelVO typeModel = (MaterialDataModelVO)materialTypeMap.get(materialType);
                        this.logger.info("\u6839\u636e\u6750\u6599\u67e5\u8be2\u5408\u540c\u91cf\u4e3a0\uff0c\u53d6\u5206\u7c7b\u91cf\uff1a{}", (Object)JSONObject.toJSONString((Object)typeModel));
                        materialDataModelVO.setContractNum(typeModel == null ? BigDecimal.ZERO : typeModel.getContractNum());
                    }
                    this.logger.info("\u4ecematerialMap\u4e2d\u53d6\u503c\uff0c\u6b64\u65f6materialDataModelVO={}", (Object)JSONObject.toJSONString((Object)materialDataModelVO));
                }
                if (materialTypeMap.containsKey(materialType)) {
                    materialDataModelVO = (MaterialDataModelVO)materialTypeMap.get(materialType);
                    this.logger.info("\u4ecematerialTypeMap\u4e2d\u53d6\u503c\uff0c\u6b64\u65f6materialDataModelVO={}", (Object)JSONObject.toJSONString((Object)materialDataModelVO));
                }
                if (DataModelEnum.\u6750\u6599\u6279\u6b21\u8ba1\u5212.getCode().equals(billTypeCode)) {
                    materialDataModelVO.setBatPlanNum(subContent.getBigDecimal("num"));
                }
                if (!materialTypeMap.containsKey(materialType) && !materialMap.containsKey(materialId)) {
                    materialDataModelVO.setProjectId(projectId);
                    materialDataModelVO.setProjectName(content.get((Object)"projectName") != null ? content.get((Object)"projectName").toString() : "");
                    materialDataModelVO.setMaterialTypeId(Long.valueOf(materialType));
                    materialDataModelVO.setMaterialTypeName(subContent.get((Object)materialTypeName).toString());
                    materialDataModelVO.setMaterialName(subContent.get((Object)"materialName") != null ? subContent.get((Object)"materialName").toString() : "");
                    if (subContent.get((Object)"materialId") != null) {
                        materialDataModelVO.setMaterialId(Long.valueOf(Long.parseLong(subContent.get((Object)"materialId").toString())));
                    }
                    materialDataModelVO.setSpec(subContent.get((Object)"spec") != null ? subContent.get((Object)"spec").toString() : "");
                    String unitName = subContent.get((Object)unit) != null ? subContent.get((Object)unit).toString() : "";
                    materialDataModelVO.setUnitName(unitName);
                    materialDataModelVO.setContractNum(BigDecimal.ZERO);
                    materialDataModelVO.setMbNum(BigDecimal.ZERO);
                    materialDataModelVO.setPlanNum(BigDecimal.ZERO);
                    materialDataModelVO.setContractMny(BigDecimal.ZERO);
                    materialDataModelVO.setContractTaxMny(BigDecimal.ZERO);
                    materialDataModelVO.setOrderNum(BigDecimal.ZERO);
                    materialDataModelVO.setCheckNum(BigDecimal.ZERO);
                    materialDataModelVO.setCheckTaxMny(BigDecimal.ZERO);
                    materialDataModelVO.setCheckMny(BigDecimal.ZERO);
                    materialDataModelVO.setSettlementNum(BigDecimal.ZERO);
                    materialDataModelVO.setSettlementTaxMny(BigDecimal.ZERO);
                    materialDataModelVO.setSettlementMny(BigDecimal.ZERO);
                    materialDataModelVO.setAccountNum(BigDecimal.ZERO);
                    if (DataModelEnum.\u6750\u6599\u6279\u6b21\u8ba1\u5212.getCode().equals(billTypeCode)) {
                        materialDataModelVO.setTotalBatPlanNum(BigDecimal.ZERO);
                        materialDataModelVO.setBatPlanNum(subContent.getBigDecimal("num"));
                        materialDataModelVO.setSurplusPlanNum(BigDecimal.ZERO);
                    }
                    this.logger.info("\u4ece\u5176\u4ed6\u4e2d\u53d6\u503c\uff0c\u6b64\u65f6materialDataModelVO={}", (Object)JSONObject.toJSONString((Object)materialDataModelVO));
                }
                list.add(materialDataModelVO);
            }
        }
        this.logger.info("\u6570\u636e\u6a21\u578b\u5904\u7406\u8fd4\u56de\u6570\u636e,\u6700\u540e\u7ec4\u88c5\u7ed3\u679c:{}", (Object)JSONObject.toJSONString(list));
        return list;
    }

    private boolean isMaterialTypeFlag(String billTypeCode) {
        return DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u91c7\u8d2d\u5408\u540c.getCode().equals(billTypeCode) || DataModelEnum.\u7269\u8d44\u91c7\u8d2d\u5408\u540c\u53d8\u66f4.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u53d8\u66f4\u5408\u540c.getCode().equals(billTypeCode) || DataModelEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212.getCode().equals(billTypeCode) || DataModelEnum.\u6d88\u8017\u6750\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode) || DataModelEnum.\u6df7\u51dd\u571f\u603b\u8ba1\u5212\u53d8\u66f4.getCode().equals(billTypeCode);
    }
}

