package com.ejianc.business.promaterial.deBalance.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.procost.api.ICostSettingApi;
import com.ejianc.business.procost.vo.SettingVO;
import com.ejianc.business.proequipmentcorpout.util.DateUtil;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.deBalance.bean.DeBalanceDetailEntity;
import com.ejianc.business.promaterial.deBalance.mapper.DeBalanceMapper;
import com.ejianc.business.promaterial.deBalance.service.IDeBalanceDetailService;
import com.ejianc.business.promaterial.deBalance.vo.DeBalanceDetailVO;
import com.ejianc.business.promaterial.delivery.bean.ConcreteDeliveryAdmixtureEntity;
import com.ejianc.business.promaterial.out.bean.OutStoreEntity;
import com.ejianc.business.promaterial.out.bean.OutStoreSubEntity;
import com.ejianc.business.promaterial.out.service.IOutStoreService;
import com.ejianc.business.promaterial.out.service.IOutStoreSubService;
import com.ejianc.business.promaterial.plan.bean.MasterPlanEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementDetailEntity;
import com.ejianc.business.promaterial.settlement.bean.SettlementEntity;
import com.ejianc.business.promaterial.settlement.service.ISettlementDetailService;
import com.ejianc.business.promaterial.settlement.service.ISettlementService;
import com.ejianc.business.store.vo.AllotOutVO;
import com.ejianc.business.store.vo.HandleVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

import java.time.format.DateTimeFormatter;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.promaterial.deBalance.bean.DeBalanceEntity;
import com.ejianc.business.promaterial.deBalance.service.IDeBalanceService;
import com.ejianc.business.promaterial.deBalance.vo.DeBalanceVO;

/**
 * 物资收发耗用结存
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("deBalance")
public class DeBalanceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostSettingApi costSettingApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IDeBalanceService service;
    @Autowired
    private IDeBalanceDetailService detailService;
    @Autowired
    private ISettlementService settlementService;
    @Autowired
    private ISettlementDetailService settlementDetailService;
    @Autowired
    private IOutStoreService outStoreService;
    @Autowired
    private IOutStoreSubService outStoreSubService;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DeBalanceMapper mapper;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<DeBalanceVO> saveOrUpdate(@RequestBody DeBalanceVO saveOrUpdateVO) {
    	DeBalanceEntity entity = BeanMapper.map(saveOrUpdateVO, DeBalanceEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	DeBalanceVO vo = BeanMapper.map(entity, DeBalanceVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @RequestMapping(value = "/checkSave", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeBalanceVO> checkSave(@RequestParam Long projectId, @RequestParam Date month,@RequestParam String levyFlag,@RequestParam Long id) throws ParseException {
        /*--------------校验能否新增start-------------------*/
        //计算 开始月份 和 结束月份
        DateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = df.format(month);
        String[] dateArray = dateString.split("-");
        String startMonth = null;
        String endMonth = null;
        String startQueryMonth = null;
        String endQueryMonth = null;
        String queryMonth = dateArray[0]+ "-"  + dateArray[1]+ "-"  + "01";
        String queryPrevMonth = null;
        if (dateArray[1].equals("1")) {//2023-01
            Integer monthNumber = new Integer(12);
            Integer yearNumber = new Integer(dateArray[0])-1;
            startMonth = yearNumber + "-" + monthNumber;
            endMonth = dateArray[0] + "-" + dateArray[1];
            startQueryMonth = yearNumber + "-" + "11";
            endQueryMonth = dateArray[0] + "-" + "12";
            queryPrevMonth = yearNumber + "-" + "12" + "-" + "01";
        } else {
            Integer monthNumber = new Integer(dateArray[1])-1;
            startMonth = dateArray[0] + "-" + monthNumber;
            endMonth = dateArray[0] + "-" + dateArray[1];
            startQueryMonth = dateArray[0] + "-" + (new Integer(dateArray[1])-2);
            endQueryMonth = dateArray[0] + "-" + (new Integer(dateArray[1])-1);
            queryPrevMonth = dateArray[0]+ "-"  + (new Integer(dateArray[1])-1)+ "-"  + "01";
        }

        //查询成本期间设置信息
        CommonResponse<SettingVO> settingResp = costSettingApi.getSettingInfo(InvocationInfoProxy.getOrgId());
        if(!settingResp.isSuccess()) {
            return CommonResponse.error("查询失败，获取成本期间设置信息失败！");
        }
        SettingVO setting = settingResp.getData();
        if(null == setting) {
            return CommonResponse.error("查询失败，当前组织未设置进行成本其间设置！");
        }

        DeBalanceVO deBalanceVO = countDate(startMonth, endMonth, setting);//本期时间段

        List<DeBalanceEntity> entities1 = service.list(new QueryWrapper<DeBalanceEntity>().eq("project_id", projectId).eq("month", queryMonth).ne(id!=null,("id"),id));
        if (CollectionUtils.isNotEmpty(entities1)) {
            throw new BusinessException("相同项目相同月份不允许出现两份结存表!");
        }
        List<DeBalanceEntity> entities2 = service.list(new QueryWrapper<DeBalanceEntity>().eq("project_id", projectId).le("month", queryMonth).notIn("bill_state", 1, 3).ne(id!=null,("id"),id));
        if (CollectionUtils.isNotEmpty(entities2)) {
            throw new BusinessException("该项目存在未生效的结存表!");
        }
        List<DeBalanceEntity> entities3 = service.list(new QueryWrapper<DeBalanceEntity>().eq("project_id", projectId).gt("month", month).ne(id!=null,("id"),id));
        if (CollectionUtils.isNotEmpty(entities3)) {
            throw new BusinessException("该项目存在大于该月份的结存表!");
        }

        DeBalanceVO deBalanceQueryVO = countDate(startQueryMonth, endQueryMonth, setting);//上期时间段
        List<DeBalanceEntity> entities4 = service.list(new QueryWrapper<DeBalanceEntity>().eq("project_id", projectId).eq("month", queryPrevMonth));
        if (CollectionUtils.isEmpty(entities4)) {
            List<SettlementEntity> settlementEntities = settlementService.list(new QueryWrapper<SettlementEntity>().eq("project_id", projectId).ge("update_time", deBalanceQueryVO.getStartDate()).le("update_time", deBalanceQueryVO.getEndDate()).eq("settlement_type", 0).in("bill_state", 1, 3));
            List<OutStoreEntity> outStoreEntities = outStoreService.list(new QueryWrapper<OutStoreEntity>().eq("project_id", projectId).ge("update_time", deBalanceQueryVO.getStartDate()).le("update_time", deBalanceQueryVO.getEndDate()).in("bill_state", 1, 3));
            Integer allotOutCounts = mapper.queryAllotOut(projectId, deBalanceQueryVO.getStartDate(), deBalanceQueryVO.getEndDate());
            Integer allotInCounts = mapper.queryAllotIn(projectId, deBalanceQueryVO.getStartDate(), deBalanceQueryVO.getEndDate());
            Integer handleCounts = mapper.queryHandle(projectId, deBalanceQueryVO.getStartDate(), deBalanceQueryVO.getEndDate());
            Integer pickReturnCounts = mapper.queryPickReturn(projectId, deBalanceQueryVO.getStartDate(), deBalanceQueryVO.getEndDate());
            if (CollectionUtils.isNotEmpty(settlementEntities) || CollectionUtils.isNotEmpty(outStoreEntities) || allotOutCounts != 0 || allotInCounts != 0 || handleCounts != 0 || pickReturnCounts != 0) {
                throw new BusinessException("请先生成上月的结存表!");
            }
        }
        /*--------------校验能否新增end-------------------*/
        /*--------------获取新增数据start-------------------*/
        // 上期结存
        DeBalanceEntity deBalanceAddEntity = service.getOne(new QueryWrapper<DeBalanceEntity>().eq("project_id", projectId).in("bill_state", 1,3).orderByDesc("month").last("LIMIT 1"));
        List<DeBalanceDetailEntity> detailEntityList = new ArrayList<>();
        if (deBalanceAddEntity!=null) {
            detailEntityList = detailService.list(new QueryWrapper<DeBalanceDetailEntity>().eq("pid", deBalanceAddEntity.getId()));
        }
        Map<Long, DeBalanceDetailEntity> detailMap = new HashMap<>();//最终结果map
        if (CollectionUtils.isNotEmpty(detailEntityList)) {
            List<DeBalanceDetailEntity> deBalanceDetailEntities = new ArrayList<>();
            for (DeBalanceDetailEntity detailEntity : detailEntityList) {
                DeBalanceDetailEntity entity = new DeBalanceDetailEntity();
                entity.setMaterialId(detailEntity.getMaterialId());
                entity.setMaterialName(detailEntity.getMaterialName());
                entity.setMaterialCode(detailEntity.getMaterialCode());
                entity.setSpecs(detailEntity.getSpecs());
                entity.setUnit(detailEntity.getUnit());
                entity.setOpeningBalanceNum(detailEntity.getClosingBalanceTotalNum()!=null?detailEntity.getClosingBalanceTotalNum():BigDecimal.ZERO);
                entity.setOpeningBalanceMny(detailEntity.getClosingBalanceTotalMny()!=null?detailEntity.getClosingBalanceTotalMny():BigDecimal.ZERO);
                deBalanceDetailEntities.add(entity);
            }
            detailMap = deBalanceDetailEntities.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(DeBalanceDetailEntity::getMaterialId, Function.identity()));
        }
        //材料采购结算单
        List<SettlementEntity> settlementEntities = settlementService.list(new QueryWrapper<SettlementEntity>().eq("project_id", projectId).ge("update_time", deBalanceVO.getStartDate()).le("update_time", deBalanceVO.getEndDate()).eq("settlement_type", 0).in("bill_state", 1, 3));
        if (CollectionUtils.isNotEmpty(settlementEntities)) {
            List<Long> settlementIds = settlementEntities.stream().map(SettlementEntity::getId).collect(Collectors.toList());
            List<SettlementDetailEntity> settlementDetailEntities = settlementDetailService.list(new QueryWrapper<SettlementDetailEntity>().in("settlement_id", settlementIds));
            for (SettlementDetailEntity detailEntity : settlementDetailEntities) {
                if (detailMap.containsKey(detailEntity.getMaterialId())) {
                    detailMap.get(detailEntity.getMaterialId()).setCurrentIncomePurchaseNum(ComputeUtil.safeAdd(detailMap.get(detailEntity.getMaterialId()).getCurrentIncomePurchaseNum(),detailEntity.getNum()));
                    if (levyFlag.equals("0")) {// 取无税
                        detailMap.get(detailEntity.getMaterialId()).setCurrentIncomePurchaseMny(ComputeUtil.safeAdd(detailMap.get(detailEntity.getMaterialId()).getCurrentIncomePurchaseMny(), detailEntity.getMny()));
                    } else {
                        detailMap.get(detailEntity.getMaterialId()).setCurrentIncomePurchaseMny(ComputeUtil.safeAdd(detailMap.get(detailEntity.getMaterialId()).getCurrentIncomePurchaseMny(), detailEntity.getTaxMny()));
                    }
                } else {
                    DeBalanceDetailEntity deBalanceDetailEntity = new DeBalanceDetailEntity();
                    deBalanceDetailEntity.setMaterialId(detailEntity.getMaterialId());
                    deBalanceDetailEntity.setMaterialName(detailEntity.getMaterialName());
                    deBalanceDetailEntity.setMaterialCode(detailEntity.getMaterialCode());
                    deBalanceDetailEntity.setSpecs(detailEntity.getSpec());
                    deBalanceDetailEntity.setUnit(detailEntity.getUnit());
                    deBalanceDetailEntity.setCurrentIncomePurchaseNum(detailEntity.getNum());
                    if (levyFlag.equals("0")) {// 取无税
                        deBalanceDetailEntity.setCurrentIncomePurchaseMny(detailEntity.getMny());
                    } else {
                        deBalanceDetailEntity.setCurrentIncomePurchaseMny(detailEntity.getTaxMny());
                    }
                    detailMap.put(detailEntity.getMaterialId(), deBalanceDetailEntity);
                }
            }
        }
        //调拨入库
        List<DeBalanceDetailVO> allotInDetails = mapper.queryAllotInDetail(projectId, deBalanceVO.getStartDate(), deBalanceVO.getEndDate());
        if (CollectionUtils.isNotEmpty(allotInDetails)) {
            for (DeBalanceDetailVO detailVO : allotInDetails) {
                if (detailMap.containsKey(detailVO.getMaterialId())) {
                    detailMap.get(detailVO.getMaterialId()).setCurrentIncomeCallNum(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentIncomeCallNum(), detailVO.getNum()));
                    if (levyFlag.equals("0")) {// 取无税
                        detailMap.get(detailVO.getMaterialId()).setCurrentIncomeCallMny(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentIncomeCallMny(), detailVO.getMny()));
                    } else {
                        detailMap.get(detailVO.getMaterialId()).setCurrentIncomeCallMny(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentIncomeCallMny(), detailVO.getTaxMny()));
                    }
                } else {
                    detailVO.setCurrentIncomeCallNum(detailVO.getNum());
                    if (levyFlag.equals("0")) {// 取无税
                        detailVO.setCurrentIncomeCallMny(detailVO.getMny());
                    } else {
                        detailVO.setCurrentIncomeCallMny(detailVO.getTaxMny());
                    }
                    detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                }
            }
        }
        //领料出库-材料退库
        List<DeBalanceDetailVO> outStoreDetailVOS = mapper.queryOutStore(projectId, deBalanceVO.getStartDate(), deBalanceVO.getEndDate());
        List<DeBalanceDetailVO> pickReturnDetailVOS = mapper.queryPickReturnDetail(projectId, deBalanceVO.getStartDate(), deBalanceVO.getEndDate());
        for (DeBalanceDetailVO detailVO : outStoreDetailVOS) {
            if (detailMap.containsKey(detailVO.getMaterialId())) {
                switch (detailVO.getMaterialUse()) {
                    case "工程消耗":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureConsumeNum(ComputeUtil.safeAdd(detailVO.getNum(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureConsumeNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureConsumeMny(ComputeUtil.safeAdd(detailVO.getMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureConsumeMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureConsumeMny(ComputeUtil.safeAdd(detailVO.getTaxMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureConsumeMny()));
                        }
                        break;
                    case "安全施工":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureSecureNum(ComputeUtil.safeAdd(detailVO.getNum(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureSecureNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureSecureMny(ComputeUtil.safeAdd(detailVO.getMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureSecureMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureSecureMny(ComputeUtil.safeAdd(detailVO.getTaxMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureSecureMny()));
                        }
                        break;
                    case "文明施工":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureCivilizationNum(ComputeUtil.safeAdd(detailVO.getNum(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureCivilizationNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureCivilizationMny(ComputeUtil.safeAdd(detailVO.getMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureCivilizationMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureCivilizationMny(ComputeUtil.safeAdd(detailVO.getTaxMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureCivilizationMny()));
                        }
                        break;
                    case "临时设施":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureTemporaryNum(ComputeUtil.safeAdd(detailVO.getNum(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureTemporaryNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureTemporaryMny(ComputeUtil.safeAdd(detailVO.getMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureTemporaryMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureTemporaryMny(ComputeUtil.safeAdd(detailVO.getTaxMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureTemporaryMny()));
                        }
                        break;
                    case "其他措施费":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureOtherNum(ComputeUtil.safeAdd(detailVO.getNum(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureOtherNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureOtherMny(ComputeUtil.safeAdd(detailVO.getMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureOtherMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureOtherMny(ComputeUtil.safeAdd(detailVO.getTaxMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureOtherMny()));
                        }
                        break;
                    case "劳保、行政用品":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureArticlesNum(ComputeUtil.safeAdd(detailVO.getNum(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureArticlesNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureArticlesMny(ComputeUtil.safeAdd(detailVO.getMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureArticlesMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureArticlesMny(ComputeUtil.safeAdd(detailVO.getTaxMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureArticlesMny()));
                        }
                        break;
                    case "机械耗用":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureExpendNum(ComputeUtil.safeAdd(detailVO.getNum(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureExpendNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureExpendMny(ComputeUtil.safeAdd(detailVO.getMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureExpendMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureExpendMny(ComputeUtil.safeAdd(detailVO.getTaxMny(),detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureExpendMny()));
                        }
                        break;
                }
            } else {
                switch (detailVO.getMaterialUse()) {
                    case "工程消耗":
                        detailVO.setCurrentExpenditureConsumeNum(detailVO.getNum());
                        if (levyFlag.equals("0")) {
                            detailVO.setCurrentExpenditureConsumeMny(detailVO.getMny());
                        } else {
                            detailVO.setCurrentExpenditureConsumeMny(detailVO.getTaxMny());
                        }
                        detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "安全施工":
                        detailVO.setCurrentExpenditureSecureNum(detailVO.getNum());
                        if (levyFlag.equals("0")) {
                            detailVO.setCurrentExpenditureSecureMny(detailVO.getMny());
                        } else {
                            detailVO.setCurrentExpenditureSecureMny(detailVO.getTaxMny());
                        }
                        detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "文明施工":
                            detailVO.setCurrentExpenditureCivilizationNum(detailVO.getNum());
                            if (levyFlag.equals("0")) {
                                detailVO.setCurrentExpenditureCivilizationMny(detailVO.getMny());
                            } else {
                                detailVO.setCurrentExpenditureCivilizationMny(detailVO.getTaxMny());
                            }
                            detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "临时设施":
                            detailVO.setCurrentExpenditureTemporaryNum(detailVO.getNum());
                            if (levyFlag.equals("0")) {
                                detailVO.setCurrentExpenditureTemporaryMny(detailVO.getMny());
                            } else {
                                detailVO.setCurrentExpenditureTemporaryMny(detailVO.getTaxMny());
                            }
                            detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "其他措施费":
                            detailVO.setCurrentExpenditureOtherNum(detailVO.getNum());
                            if (levyFlag.equals("0")) {
                                detailVO.setCurrentExpenditureOtherMny(detailVO.getMny());
                            } else {
                                detailVO.setCurrentExpenditureOtherMny(detailVO.getTaxMny());
                            }
                            detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "劳保、行政用品":
                            detailVO.setCurrentExpenditureArticlesNum(detailVO.getNum());
                            if (levyFlag.equals("0")) {
                                detailVO.setCurrentExpenditureArticlesMny(detailVO.getMny());
                            } else {
                                detailVO.setCurrentExpenditureArticlesMny(detailVO.getTaxMny());
                            }
                            detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "机械耗用":
                            detailVO.setCurrentExpenditureExpendNum(detailVO.getNum());
                            if (levyFlag.equals("0")) {
                                detailVO.setCurrentExpenditureExpendMny(detailVO.getMny());
                            } else {
                                detailVO.setCurrentExpenditureExpendMny(detailVO.getTaxMny());
                            }
                            detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                }
            }

        }
        for (DeBalanceDetailVO detailVO : outStoreDetailVOS){
            logger.info("领料出库临时设施数量："+detailVO.getCurrentExpenditureTemporaryNum());
            logger.info("领料出库临时设施金额："+detailVO.getCurrentExpenditureTemporaryMny());
        }
        for (DeBalanceDetailVO detailVO : pickReturnDetailVOS){
            if (detailMap.containsKey(detailVO.getMaterialId())){
                switch (detailVO.getMaterialUse()){
                    case "工程消耗":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureConsumeNum(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureConsumeNum(),detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureConsumeMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureConsumeMny(),detailVO.getMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureConsumeMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureConsumeMny(),detailVO.getTaxMny()));
                        }
                        break;
                    case "安全施工":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureSecureNum(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureSecureNum(),detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureSecureMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureSecureMny(),detailVO.getMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureSecureMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureSecureMny(),detailVO.getTaxMny()));
                        }
                        break;
                    case "文明施工":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureCivilizationNum(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureCivilizationNum(),detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureCivilizationMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureCivilizationMny(),detailVO.getMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureCivilizationMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureCivilizationMny(),detailVO.getTaxMny()));
                        }
                        break;
                    case "临时设施":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureTemporaryNum(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureTemporaryNum(),detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureTemporaryMny(),detailVO.getMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureTemporaryMny(),detailVO.getTaxMny()));
                        }
                        break;
                    case "其他措施费":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureOtherNum(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureOtherNum(),detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureOtherMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureOtherMny(),detailVO.getMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureOtherMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureOtherMny(),detailVO.getTaxMny()));
                        }
                        break;
                    case "劳保、行政用品":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureArticlesNum(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureArticlesNum(),detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureArticlesMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureArticlesMny(),detailVO.getMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureArticlesMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureArticlesMny(),detailVO.getTaxMny()));
                        }
                        break;
                    case "机械耗用":
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureExpendNum(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureExpendNum(),detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureExpendMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureExpendMny(),detailVO.getMny()));
                        } else {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureExpendMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureExpendMny(),detailVO.getTaxMny()));
                        }
                        break;
                }
            }else {
                switch (detailVO.getMaterialUse()){
                    case "工程消耗":
                        detailVO.setCurrentExpenditureConsumeNum(ComputeUtil.safeSub(BigDecimal.ZERO,detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailVO.setCurrentExpenditureConsumeMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getMny()));
                        } else {
                            detailVO.setCurrentExpenditureConsumeMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getTaxMny()));
                        }
                        detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "安全施工":
                        detailVO.setCurrentExpenditureSecureNum(ComputeUtil.safeSub(BigDecimal.ZERO,detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailVO.setCurrentExpenditureSecureMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getMny()));
                        } else {
                            detailVO.setCurrentExpenditureSecureMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getTaxMny()));
                        }
                        detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "文明施工":
                        detailVO.setCurrentExpenditureCivilizationNum(ComputeUtil.safeSub(BigDecimal.ZERO,detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailVO.setCurrentExpenditureCivilizationMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getMny()));
                        } else {
                            detailVO.setCurrentExpenditureCivilizationMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getTaxMny()));
                        }
                        detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "临时设施":
                        if (detailMap.containsKey(detailVO.getMaterialId())) {
                            detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureTemporaryNum(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureTemporaryNum(),detailVO.getNum()));
                            if (levyFlag.equals("0")) {
                                detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureTemporaryMny(),detailVO.getMny()));
                            } else {
                                detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureTemporaryMny(),detailVO.getTaxMny()));
                            }
                        } else {
                            detailVO.setCurrentExpenditureTemporaryNum(ComputeUtil.safeSub(BigDecimal.ZERO,detailVO.getNum()));
                            if (levyFlag.equals("0")) {
                                detailVO.setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getMny()));
                            } else {
                                detailVO.setCurrentExpenditureTemporaryMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getTaxMny()));
                            }
                            detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        }
                        break;
                    case "其他措施费":
                        detailVO.setCurrentExpenditureOtherNum(ComputeUtil.safeSub(BigDecimal.ZERO,detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailVO.setCurrentExpenditureOtherMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getMny()));
                        } else {
                            detailVO.setCurrentExpenditureOtherMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getTaxMny()));
                        }
                        detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "劳保、行政用品":
                        detailVO.setCurrentExpenditureArticlesNum(ComputeUtil.safeSub(BigDecimal.ZERO,detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailVO.setCurrentExpenditureArticlesMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getMny()));
                        } else {
                            detailVO.setCurrentExpenditureArticlesMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getTaxMny()));
                        }
                        detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                    case "机械耗用":
                        detailVO.setCurrentExpenditureExpendNum(ComputeUtil.safeSub(BigDecimal.ZERO,detailVO.getNum()));
                        if (levyFlag.equals("0")) {
                            detailVO.setCurrentExpenditureExpendMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getMny()));
                        } else {
                            detailVO.setCurrentExpenditureExpendMny(ComputeUtil.safeSub(BigDecimal.ZERO, detailVO.getTaxMny()));
                        }
                        detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                        break;
                }
            }

        }
        //调拨出库
        List<DeBalanceDetailVO> allotOutDetails = mapper.queryAllotOutDetail(projectId, deBalanceVO.getStartDate(), deBalanceVO.getEndDate());
        if (CollectionUtils.isNotEmpty(allotOutDetails)) {
            for (DeBalanceDetailVO detailVO : allotOutDetails) {
                if (detailMap.containsKey(detailVO.getMaterialId())) {
                    detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureOutNum(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureOutNum(), detailVO.getNum()));
                    if (levyFlag.equals("0")) {// 取无税
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureOutMny(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureOutMny(), detailVO.getMny()));
                    } else {
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureOutMny(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureOutMny(), detailVO.getTaxMny()));
                    }
                } else {
                    detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureOutNum(detailVO.getNum());
                    if (levyFlag.equals("0")) {// 取无税
                        detailVO.setCurrentExpenditureOutMny(detailVO.getMny());
                    } else {
                        detailVO.setCurrentExpenditureOutMny(detailVO.getTaxMny());
                    }
                    detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                }
            }
        }
        //物资处理
        List<DeBalanceDetailVO> handleDetails = mapper.queryHandleDetail(projectId, deBalanceVO.getStartDate(), deBalanceVO.getEndDate());
        if (CollectionUtils.isNotEmpty(handleDetails)) {
            for (DeBalanceDetailVO detailVO : handleDetails) {
                if (detailMap.containsKey(detailVO.getMaterialId())) {
                    detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureMaterialNum(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureMaterialNum(),detailVO.getNum()));
                    if (levyFlag.equals("0")) {// 取无税
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureMaterialDifference(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureMaterialDifference(), detailVO.getDifference()));
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureMaterialMny(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureMaterialMny(), detailVO.getMny()));
                    } else {
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureMaterialDifference(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureMaterialDifference(), detailVO.getTaxDifference()));
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureMaterialMny(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureMaterialMny(), detailVO.getTaxMny()));
                    }
                } else {
                    detailVO.setCurrentExpenditureMaterialNum(detailVO.getNum());
                    if (levyFlag.equals("0")) {// 取无税
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureMaterialDifference(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureMaterialDifference()));
                        detailVO.setCurrentExpenditureMaterialMny(detailVO.getMny());
                    } else {
                        detailMap.get(detailVO.getMaterialId()).setCurrentExpenditureMaterialDifference(ComputeUtil.safeAdd(detailMap.get(detailVO.getMaterialId()).getCurrentExpenditureMaterialDifference()));
                        detailVO.setCurrentExpenditureMaterialMny(detailVO.getTaxMny());
                    }
                    detailMap.put(detailVO.getMaterialId(), BeanMapper.map(detailVO, DeBalanceDetailEntity.class));
                }
            }
        }

        DeBalanceVO vo = new DeBalanceVO();
        vo.setDeBalanceDetailList(BeanMapper.mapList(detailMap.values(), DeBalanceDetailVO.class));
        // 计算汇总值
        for (DeBalanceDetailVO detailVO : vo.getDeBalanceDetailList()) {
            detailVO.setId(IdWorker.getId());
            detailVO.setCurrentIncomeTotalNum(ComputeUtil.safeAdd(detailVO.getCurrentIncomePurchaseNum(), detailVO.getCurrentIncomeCallNum()));
            detailVO.setCurrentIncomeTotalMny(ComputeUtil.safeAdd(detailVO.getCurrentIncomePurchaseMny(), detailVO.getCurrentIncomeCallMny()));
            detailVO.setCurrentIncomePurchasePrice(ComputeUtil.safeDiv(detailVO.getCurrentIncomePurchaseMny(), detailVO.getCurrentIncomePurchaseNum()));
            detailVO.setCurrentIncomeCallPrice(ComputeUtil.safeDiv(detailVO.getCurrentIncomeCallMny(), detailVO.getCurrentIncomeCallNum()));
            detailVO.setCurrentExpenditureConsumePrice(ComputeUtil.safeDiv(detailVO.getCurrentExpenditureConsumeMny(), detailVO.getCurrentExpenditureConsumeNum()));
            detailVO.setCurrentExpenditureSecurePrice(ComputeUtil.safeDiv(detailVO.getCurrentExpenditureSecureMny(), detailVO.getCurrentExpenditureSecureNum()));
            detailVO.setCurrentExpenditureCivilizationPrice(ComputeUtil.safeDiv(detailVO.getCurrentExpenditureCivilizationMny(), detailVO.getCurrentExpenditureCivilizationNum()));
            detailVO.setCurrentExpenditureTemporaryPrice(ComputeUtil.safeDiv(detailVO.getCurrentExpenditureTemporaryMny(), detailVO.getCurrentExpenditureTemporaryNum()));
            detailVO.setCurrentExpenditureOtherPrice(ComputeUtil.safeDiv(detailVO.getCurrentExpenditureOtherMny(), detailVO.getCurrentExpenditureOtherNum()));
            detailVO.setCurrentExpenditureArticlesPrice(ComputeUtil.safeDiv(detailVO.getCurrentExpenditureArticlesMny(), detailVO.getCurrentExpenditureArticlesNum()));
            detailVO.setCurrentExpenditureExpendPrice(ComputeUtil.safeDiv(detailVO.getCurrentExpenditureExpendMny(), detailVO.getCurrentExpenditureExpendNum()));
            detailVO.setCurrentExpenditureOutPrice(ComputeUtil.safeDiv(detailVO.getCurrentExpenditureOutMny(), detailVO.getCurrentExpenditureOutNum()));
            detailVO.setCurrentExpenditureMaterialPrice(ComputeUtil.safeDiv(detailVO.getCurrentExpenditureMaterialMny(), detailVO.getCurrentExpenditureMaterialNum()));
            detailVO.setCurrentExpenditureTotalNum(countNum(detailVO));
            detailVO.setCurrentExpenditureTotalMny(countMny(detailVO));
            detailVO.setClosingBalanceTotalNum(ComputeUtil.safeSub(ComputeUtil.safeAdd(detailVO.getOpeningBalanceNum(), detailVO.getCurrentIncomeTotalNum()), detailVO.getCurrentExpenditureTotalNum()));
            detailVO.setClosingBalanceTotalMny(ComputeUtil.safeSub(ComputeUtil.safeAdd(detailVO.getOpeningBalanceMny(), detailVO.getCurrentIncomeTotalMny()), detailVO.getCurrentExpenditureTotalMny()));
        }
            /*--------------获取新增数据end-------------------*/
        return CommonResponse.success("校验成功！",vo);
    }

    private BigDecimal countMny(DeBalanceDetailVO detailVO) {
        BigDecimal currentExpenditureTotalMny = ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(detailVO.getCurrentExpenditureConsumeMny(), detailVO.getCurrentExpenditureSecureMny()), detailVO.getCurrentExpenditureCivilizationMny()), detailVO.getCurrentExpenditureTemporaryMny()), detailVO.getCurrentExpenditureOtherMny()), detailVO.getCurrentExpenditureArticlesMny()), detailVO.getCurrentExpenditureExpendMny()), detailVO.getCurrentExpenditureOutMny()), detailVO.getCurrentExpenditureMaterialMny());
        return currentExpenditureTotalMny;
    }

    private BigDecimal countNum(DeBalanceDetailVO detailVO) {
        BigDecimal currentExpenditureTotalNum = ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(ComputeUtil.safeAdd(detailVO.getCurrentExpenditureConsumeNum(), detailVO.getCurrentExpenditureSecureNum()), detailVO.getCurrentExpenditureCivilizationNum()), detailVO.getCurrentExpenditureTemporaryNum()), detailVO.getCurrentExpenditureOtherNum()), detailVO.getCurrentExpenditureArticlesNum()), detailVO.getCurrentExpenditureExpendNum()), detailVO.getCurrentExpenditureOutNum()), detailVO.getCurrentExpenditureMaterialNum());
        return currentExpenditureTotalNum;
    }

    private DeBalanceVO countDate(String startMonth, String endMonth, SettingVO setting) throws ParseException {
        DeBalanceVO deBalanceVO = new DeBalanceVO();
        if ("0".equals(setting.getPeriodRule())) {
            //固定日期
            int maxDaysOfEndDate = DateUtil.getDaysOfMonth(DateFormatUtil.parseDate("yyyy-MM", endMonth));
            int maxDaysOfStartDate = DateUtil.getDaysOfMonth(DateFormatUtil.parseDate("yyyy-MM", startMonth));
            endMonth += "-" + (maxDaysOfEndDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfEndDate);
            startMonth += "-" + (maxDaysOfStartDate > Integer.valueOf(setting.getEndDay()) ? setting.getEndDay() : maxDaysOfStartDate);
            startMonth = DateUtil.addDay(DateFormatUtil.parseDate("yyyy-MM-dd", DateUtil.getLastMonth(DateFormatUtil.parseDate("yyyy-MM-dd", endMonth), "yyyy-MM-dd")), 1);
        } else {
            //自然月
            startMonth = endMonth + "-01";
            endMonth += "-" + DateUtil.getDaysOfMonth(DateFormatUtil.parseDate("yyyy-MM", endMonth));
        }
        deBalanceVO.setStartDate(startMonth);
        deBalanceVO.setEndDate(endMonth);
        return deBalanceVO;
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<DeBalanceVO> queryDetail(Long id) {
    	DeBalanceEntity entity = service.selectById(id);
    	DeBalanceVO vo = BeanMapper.map(entity, DeBalanceVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<DeBalanceVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (DeBalanceVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(DeBalanceVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<DeBalanceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<DeBalanceEntity> page = service.queryPage(param,false);
        IPage<DeBalanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeBalanceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<DeBalanceEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("DeBalance-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refDeBalanceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<DeBalanceVO>> refDeBalanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<DeBalanceEntity> page = service.queryPage(param,false);
        IPage<DeBalanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), DeBalanceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
