package com.ejianc.business.promaterial.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.bean.ContractRelieveEntity;
import com.ejianc.business.promaterial.contract.enums.DraftTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.promaterial.contract.enums.SignatureStatusEnum;
import com.ejianc.business.promaterial.contract.service.IContractRelieveService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.contract.vo.ContractRelieveVO;
import com.ejianc.business.promaterial.contract.vo.ContractVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service("contractRelieve")
public class ContractRelieveBpmServiceImpl implements ICommonBusinessService {
	private final Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private SessionManager sessionManager;
	@Autowired
	private IContractRelieveService service;
	@Autowired
	private IContractService contractService;
	@Value("${common.env.base-host}")
	private String BaseHost;
	@Value("${refer.base-host:null}")
	private String BASE_HOST_FRONTEND;
	@Autowired
	private IExecutionApi executionApi;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	;

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		ContractRelieveEntity entity = service.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();
		entity.setCommitDate(new Date());
		entity.setCommitUserCode(userContext.getUserCode());
		entity.setCommitUserName(userContext.getUserName());
		service.saveOrUpdate(entity);
		logger.info("提交前回调：{}", JSONObject.toJSONString(entity));
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return bpmBackCheck(billId, state, billTypeCode);
	}

	;

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	;

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	}

	;

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		ContractRelieveEntity contractRelieveEntity = service.selectById(billId);
		if (contractRelieveEntity != null) {
			//起草方式 1、上传解除协议，2、已签章；
			if (contractRelieveEntity.getDraftType() == 2) {
				contractRelieveEntity.setSignatureStatus(SignatureStatusEnum.已签章.getCode());
				contractRelieveEntity.setPerformanceStatus(PerformanceStatusEnum.已解除.getCode());
				contractRelieveEntity.setEffectiveDate(new Date());
				service.saveOrUpdate(contractRelieveEntity, false);

				QueryParam queryParam = new QueryParam();
				queryParam.getParams().put("id", new Parameter(QueryParam.EQ, contractRelieveEntity.getContractId()));
				List<ContractEntity> contractList = contractService.queryList(queryParam);
				ContractEntity contractEntity = contractList.get(0);
				contractEntity.setPerformanceStatus(PerformanceStatusEnum.已解除.getCode());
				contractService.saveOrUpdate(contractEntity, false);
				// 推送合同池
				contractService.pushContract(BeanMapper.map(contractEntity, ContractVO.class));

				//目标成本推送
				String linkUrl;
				String frontendBaseHost="";
				if(StringUtils.isNotBlank(BASE_HOST_FRONTEND)&& !"null".equals(BASE_HOST_FRONTEND)){
					frontendBaseHost = BASE_HOST_FRONTEND;
				}else{
					frontendBaseHost = BaseHost;
				}

				if (contractEntity.getContractType() == 0) {
					linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractMaterial/contractRelieve/card?id=" + contractRelieveEntity.getId();
				}
				else {
					linkUrl = frontendBaseHost + "ejc-promaterial-frontend/#/contractConcrete/contractRelieve/card?id=" + contractRelieveEntity.getId();
				}
				if (contractEntity.getPurchaseType().equals("1")) {
					ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractRelieveEntity, ContractRelieveVO.class),linkUrl,contractEntity.getContractType());
					logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
					CommonResponse<String> response = executionApi.aggPush(executionVO);
					if (!response.isSuccess()) {
						throw new BusinessException("目标成本推送失败," + response.getMsg());
					}
				}
				logger.info("终审已签章处理完成！");
			}
			else if (contractRelieveEntity.getDraftType() == 1) {
				contractRelieveEntity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
				service.saveOrUpdate(contractRelieveEntity, false);
				logger.info("终审上传解除协议处理完成，初始化为未签章");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
//		return bpmBackCheck(billId, state, billTypeCode);
//		return CommonResponse.error("合同解除不允许撤回！");
		logger.info("合同解除进入弃审前事件，合同id：{}", billId);
		ContractRelieveEntity entity = service.selectById(billId);
		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		// 签章状态：1-待签章,2-待乙方签章,3-待甲方签章,4-已签章（已完成）,5-已退回（已拒签）,6-已撤回,7-已过期,8-其他已签章；  单据新增后默认为待签章
		// 审批可以撤回的签章状态集合
		ArrayList<String> statusList = new ArrayList<>();
		statusList.add(SignatureStatusEnum.未签章.getCode());
		statusList.add(SignatureStatusEnum.已退回.getCode());
		statusList.add(SignatureStatusEnum.已撤回.getCode());
		statusList.add(SignatureStatusEnum.已过期.getCode());
		if (DraftTypeEnum.线上起草.getCode().equals(entity.getDraftType())
				&& !statusList.contains(entity.getSignatureStatus())) {
			return CommonResponse.error("合同解除" + (SignatureStatusEnum.已签章.getCode()
					.equals(entity.getSignatureStatus()) ? "已生效" : "已有签章流程") + "，不允许弃审!");
		}
		else if (SignatureStatusEnum.已签章.getCode().equals(entity.getSignatureStatus())) {
			entity.setSignatureStatus(SignatureStatusEnum.未签章.getCode());
			service.saveOrUpdate(entity, false);
		}

		// 更新合同履约状态
		ContractEntity contractEntity = contractService.selectById(entity.getContractId());
		contractEntity.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());
		contractService.saveOrUpdate(contractEntity, false);
		// 重新推送合同池
		contractService.pushContract(BeanMapper.map(contractEntity,ContractVO.class));
		return CommonResponse.success("撤回前校验回调成功！");
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
		/**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
		 if(!resp.isSuccess()){
		 return CommonResponse.error("无法撤回！"+resp.getMsg());
		 }*/
		logger.info("合同解除进入弃审后事件，合同id：{}", billId);
		ContractRelieveEntity contractRelieveEntity = service.selectById(billId);
		ContractEntity contractEntity = contractService.selectById(contractRelieveEntity.getContractId());
		List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
		//目标成本推送
		if (contractEntity.getPurchaseType().equals("1")) {
			ExecutionVO executionVO = service.targetCost(BeanMapper.map(contractRelieveEntity, ContractRelieveVO.class),"",contractEntity.getContractType());
			logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
			totalExecutionVOList.add(executionVO.getTotalVO());
			CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
			if (!response.isSuccess()) {
				throw new BusinessException("目标成本推送失败," + response.getMsg());
			}
		}
		return CommonResponse.success();
	}

	private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {

		//合同是否被其他单据引用
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况" + res.isSuccess() + "----" + res.getMsg());

		if (!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能撤回！");
		}

		return CommonResponse.success("撤回前校验回调成功！");
	}

}
