package com.ejianc.business.promaterial.order.controller;

import java.io.Serializable;

import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.SupplierProVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.kit.collection.ListUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.ejianc.business.promaterial.order.bean.ConcreteOrderEntity;
import com.ejianc.business.promaterial.order.service.IConcreteOrderService;

/**
 * 混凝土-订单实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("concreteOrder")
@Api(value = "混凝土-订单实体", tags = {"混凝土-订单实体"})
public class ConcreteOrderController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    private final String billTypeCode = "BT220223000000001";
    @Autowired
    private IProSupplierApi proSupplierApi;
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/concreteOrder/card";

    @Autowired
    private IConcreteOrderService service;

    @Autowired
    private SessionManager sessionManager;

    @ApiOperation("新增或者修改")
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConcreteOrderVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody ConcreteOrderVO saveOrUpdateVO) {
        //校验供应商
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(saveOrUpdateVO.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", saveOrUpdateVO.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("获取供应商信息失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法新增订单。 请先到供应商库—生成协同账号再进行订单操作。");
        }
        ConcreteOrderVO vo = service.saveOrUpdates(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConcreteOrderVO> queryDetail(@RequestParam Long id) {
        ConcreteOrderVO vo = service.queryDetail(id);
        return CommonResponse.success("查询数据成功！",vo);
    }

    /**
     * @Description  订单关闭
     */
    @RequestMapping(value = "/updateOrderFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateOrderFlag(@RequestBody ConcreteOrderVO vo) {
        return service.updateOrderFlag(vo);
    }

    /**
     * @Description  更新接收状态
     */
    @RequestMapping(value = "/updateReceived", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> updateReceived(@RequestBody SupConcreteOrderVO saveorUpdateVO) {
        return service.updateReceived(saveorUpdateVO);
    }

    /**
     * @Description  更新接收状态
     */
    @RequestMapping(value = "/updateDeliverState", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OrderVO> updateDeliverState(@RequestBody SupConcreteOrderVO saveorUpdateVO) {
        return service.updateDeliverState(saveorUpdateVO);
    }
    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConcreteOrderVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (ConcreteOrderVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.OrderQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(ConcreteOrderVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConcreteOrderVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("parentOrgName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }

        IPage<ConcreteOrderEntity> page = service.queryPage(param,false);
        IPage<ConcreteOrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConcreteOrderVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("contractName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("parentOrgName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ConcreteOrderEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<OrderExportVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            for (ConcreteOrderEntity orderEntity : list) {
                OrderExportVO map = BeanMapper.map(orderEntity, OrderExportVO.class);
                map.setBillState(BillStateEnum.getEnumByStateCode(orderEntity.getBillState()).getDescription());
                if(null!=orderEntity.getOrderExpiryDate()){
                    map.setOrderExpiryDate(DateFormatUtil.formatDate("yyyy-MM-dd",orderEntity.getOrderExpiryDate()));
                }
                if(null!=orderEntity.getReceiveState()){
                    switch (orderEntity.getReceiveState()){
                        case  0:map.setReceiveState("待接收");break;
                        case  2:map.setReceiveState("部分接收");break;
                        case  1:map.setReceiveState("全部接收");break;
                        case  3:map.setReceiveState("不予接收");break;
                    }
                }
                if(null!=orderEntity.getDeliverState()){
                    switch (orderEntity.getDeliverState()){
                        case  0:map.setDeliverState("待送货");break;
                        case  1:map.setDeliverState("部分送货");break;
                        case  2:map.setDeliverState("已送货");break;
                    }
                }
                if(null!=orderEntity.getOrderFlag()){
                    switch (orderEntity.getOrderFlag()){
                        case  0:map.setOrderFlag("正常");break;
                        case  1:map.setOrderFlag("已关闭");break;
                    }
                }
                voList.add(map);
            }
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("ConcreteOrder-export.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refConcreteOrderData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConcreteOrderVO>> refConcreteOrderData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ConcreteOrderEntity> page = service.queryPage(param,false);
        IPage<ConcreteOrderVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConcreteOrderVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        ConcreteOrderEntity entity = service.selectById(id);
        return shareCooperateApi.getShareLink(id, billTypeCode, entity.getSupplierId().toString(), mobileBillShareFrontUrl,null);
    }
}
