/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.bean.PlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.PlanEntity;
import com.ejianc.business.promaterial.plan.mapper.PlanMapper;
import com.ejianc.business.promaterial.plan.service.IPlanService;
import com.ejianc.business.promaterial.plan.vo.PlanDetailRefVO;
import com.ejianc.business.promaterial.plan.vo.PlanVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="planService")
public class PlanServiceImpl
extends BaseServiceImpl<PlanMapper, PlanEntity>
implements IPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "XYPLAN_CODE";
    @Autowired
    private IPlanService service;

    @Override
    public CommonResponse<PlanVO> saveOrUpdate(PlanVO saveOrUpdateVO) {
        PlanEntity entity = (PlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, PlanEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<PlanDetailEntity> planDetailList = entity.getPlanDetailList();
        String materialName = "";
        if (CollectionUtils.isNotEmpty(planDetailList)) {
            ArrayList<PlanDetailEntity> list = new ArrayList<PlanDetailEntity>();
            for (PlanDetailEntity planDetail : planDetailList) {
                if (!"del".equals(planDetail.getRowState())) {
                    if (StringUtils.isNotBlank((CharSequence)planDetail.getMaterialName())) {
                        materialName = StringUtils.isNotBlank((CharSequence)materialName) ? materialName + "," + planDetail.getMaterialName() : planDetail.getMaterialName();
                    }
                    list.add(planDetail);
                }
                BigDecimal nums = planDetail.getNums() == null ? BigDecimal.ZERO : planDetail.getNums();
                BigDecimal occupyNums = planDetail.getOccupyNums() == null ? BigDecimal.ZERO : planDetail.getOccupyNums();
                BigDecimal surplusNums = nums.subtract(occupyNums);
                planDetail.setSurplusNums(surplusNums);
                planDetail.setOccupyNums(occupyNums);
                planDetail.setNums(nums);
            }
            Integer planFlag = entity.getPlanFlag() == null ? 1 : entity.getPlanFlag();
            entity.setPlanFlag(planFlag);
            entity.setMaterialName(materialName);
            if (CollectionUtils.isEmpty(list)) {
                throw new BusinessException("\u6700\u5c11\u6709\u4e00\u6761\u8ba1\u5212\u660e\u7ec6\uff01");
            }
        } else {
            throw new BusinessException("\u6700\u5c11\u6709\u4e00\u6761\u8ba1\u5212\u660e\u7ec6\uff01");
        }
        super.saveOrUpdate((Object)entity, false);
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public List<PlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper queryWrapper) {
        List<PlanDetailRefVO> planVOList = ((PlanMapper)this.baseMapper).getPlanByMaterialId(materialListId, queryWrapper);
        return planVOList;
    }
}

