package com.ejianc.business.promaterial.check.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 混凝土-验收明细子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_concrete_check_detail")
public class ConcreteCheckDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="check_id")
    private Long checkId; // 验收主键ID
    @TableField(value="delivery_id")
    private Long deliveryId; // 发货主键ID
    @TableField(value="delivery_detail_id")
    private Long deliveryDetailId; // 发货明细主键ID
    @TableField(value="order_id")
    private Long orderId; // 订单主键ID
    @TableField(value="order_detail_id")
    private Long orderDetailId; // 订单明细主键ID
    @TableField(value="material_id")
    private Long materialId; // 物资主键
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_type_id")
    private Long materialTypeId; // 物资类别
    @TableField(value="material_type_name")
    private String materialTypeName; // 物资类别名称
    @TableField(value="material_code")
    private String materialCode; // 物料编码
    @TableField(value="unit")
    private String unit; // 单位名称
    @TableField(value="unit_id")
    private Long unitId; // 单位主键
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="deliver_num")
    private BigDecimal deliverNum; // 发货数量
    @TableField(value="check_num")
    private BigDecimal checkNum; // 验收数量
    @TableField(value="check_mny")
    private BigDecimal checkMny; // 验收金额(无税)
    @TableField(value="check_tax_mny")
    private BigDecimal checkTaxMny; // 验收金额(含税)
    @TableField(value="check_price")
    private BigDecimal checkPrice; // 验收单价(无税)
    @TableField(value="check_tax_price")
    private BigDecimal checkTaxPrice; // 验收单价(含税)
    @TableField(value="check_price_overall")
    private BigDecimal checkPriceOverall; // 综合验收单价(无税)
    @TableField(value="check_tax_price_overall")
    private BigDecimal checkTaxPriceOverall; // 综合验收单价(含税)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 税额
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="construction")
    private String construction; // 使用部位
    @TableField(value="admixture_name")
    private String admixtureName; // 外加剂名称
    @TableField(value="admixture_id")
    private String admixtureId; // 外加剂id
    @TableField(value="check_admixture_name")
    private String checkAdmixtureName; // 外加剂名称
    @TableField(value="check_admixture_id")
    private String checkAdmixtureId; // 外加剂id
    @TableField(value="cast_date_time")
    private Date castDateTime; // 浇筑时间
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="source_type")
    private String sourceType; //  0-合同 1-大类
    @TableField(value="source_id")
    private Long sourceId; // 来源ID
    @TableField(value="wbs_id")
    private Long wbsId; // 核算对象主键
    @TableField(value="wbs_code")
    private String wbsCode; // 核算对象编码
    @TableField(value="wbs_name")
    private String wbsName; // 核算对象名称
    @TableField(value="subject_id")
    private Long subjectId; // 成本科目主键
    @TableField(value="subject_code")
    private String subjectCode; // 成本科目编码
    @TableField(value="subject_name")
    private String subjectName; // 成本科目名称
    @TableField(value="history_price_area")
    private String historyPriceArea;//历史价格区间（无税）
    @TableField(value="history_tax_price_area")
    private String historyTaxPriceArea;//历史价格区间（含税）
    @TableField(value="guide_price_area")
    private String guidePriceArea; // 公司指导价区间（无税）
    @TableField(value="guide_tax_price_area")
    private String guideTaxPriceArea; // 公司指导价区间（含税）
    @TableField(value="detail_coefficient")
    private BigDecimal detailCoefficient; // 换算系数
    @TableField(value="detail_net_weight")
    private BigDecimal detailNetWeight; // 净重
    @TableField(value="detail_net_weight_coefficient")
    private BigDecimal detailNetWeightCoefficient; // 单位换算后净重（千克）
    @TableField(value="detail_automatic_weigh")
    private Integer detailAutomaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    @TableField(value="pumping_mny")
    private BigDecimal pumpingMny; // 泵送费(无税)
    @TableField(value="pouring_method")
    private String pouringMethod; // 浇筑方式
    @TableField(value="manufacturer")
    private String manufacturer; // 生产厂家

    @TableField(value="bpo_order_id")
    private Long bpoOrderId; // 订单号
    @TableField(value="bpo_order_line_id")
    private Long bpoOrderLineId; // 订单行号
    @TableField(value="item_desc")
    private String itemDesc; // 物料短描述
    @TableField(value="item_desc_more")
    private String itemDescMore; // 物料长描述

    @TableField(value="bpo_delivery_id")
    private Long bpoDeliveryId; // 到货通知单号
    @TableField(value="bpo_delivery_line_id")
    private Long bpoDeliveryLineId; // 到货通知单行号
    @TableField(value="account_time")
    private Date accountTime; // 收货日期

    public Long getBpoOrderId() {
        return bpoOrderId;
    }

    public void setBpoOrderId(Long bpoOrderId) {
        this.bpoOrderId = bpoOrderId;
    }

    public Long getBpoOrderLineId() {
        return bpoOrderLineId;
    }

    public void setBpoOrderLineId(Long bpoOrderLineId) {
        this.bpoOrderLineId = bpoOrderLineId;
    }

    public String getItemDesc() {
        return itemDesc;
    }

    public void setItemDesc(String itemDesc) {
        this.itemDesc = itemDesc;
    }

    public String getItemDescMore() {
        return itemDescMore;
    }

    public void setItemDescMore(String itemDescMore) {
        this.itemDescMore = itemDescMore;
    }

    public Long getBpoDeliveryId() {
        return bpoDeliveryId;
    }

    public void setBpoDeliveryId(Long bpoDeliveryId) {
        this.bpoDeliveryId = bpoDeliveryId;
    }

    public Long getBpoDeliveryLineId() {
        return bpoDeliveryLineId;
    }

    public void setBpoDeliveryLineId(Long bpoDeliveryLineId) {
        this.bpoDeliveryLineId = bpoDeliveryLineId;
    }

    public Date getAccountTime() {
        return accountTime;
    }

    public void setAccountTime(Date accountTime) {
        this.accountTime = accountTime;
    }

    public String getManufacturer() {
        return manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public String getPouringMethod() {
        return pouringMethod;
    }

    public void setPouringMethod(String pouringMethod) {
        this.pouringMethod = pouringMethod;
    }

    public BigDecimal getPumpingMny() {
        return pumpingMny;
    }

    public void setPumpingMny(BigDecimal pumpingMny) {
        this.pumpingMny = pumpingMny;
    }

    public String getGuidePriceArea() {
        return guidePriceArea;
    }

    public void setGuidePriceArea(String guidePriceArea) {
        this.guidePriceArea = guidePriceArea;
    }

    public String getGuideTaxPriceArea() {
        return guideTaxPriceArea;
    }

    public void setGuideTaxPriceArea(String guideTaxPriceArea) {
        this.guideTaxPriceArea = guideTaxPriceArea;
    }

    public Integer getDetailAutomaticWeigh() {
        return detailAutomaticWeigh;
    }

    public void setDetailAutomaticWeigh(Integer detailAutomaticWeigh) {
        this.detailAutomaticWeigh = detailAutomaticWeigh;
    }

    public BigDecimal getDetailNetWeightCoefficient() {
        return detailNetWeightCoefficient;
    }

    public void setDetailNetWeightCoefficient(BigDecimal detailNetWeightCoefficient) {
        this.detailNetWeightCoefficient = detailNetWeightCoefficient;
    }


    public BigDecimal getDetailCoefficient() {
        return detailCoefficient;
    }

    public void setDetailCoefficient(BigDecimal detailCoefficient) {
        this.detailCoefficient = detailCoefficient;
    }

    public BigDecimal getDetailNetWeight() {
        return detailNetWeight;
    }

    public void setDetailNetWeight(BigDecimal detailNetWeight) {
        this.detailNetWeight = detailNetWeight;
    }

    public String getHistoryPriceArea() {
        return historyPriceArea;
    }

    public void setHistoryPriceArea(String historyPriceArea) {
        this.historyPriceArea = historyPriceArea;
    }

    public String getHistoryTaxPriceArea() {
        return historyTaxPriceArea;
    }

    public void setHistoryTaxPriceArea(String historyTaxPriceArea) {
        this.historyTaxPriceArea = historyTaxPriceArea;
    }

    public Long getWbsId() {
        return wbsId;
    }

    public void setWbsId(Long wbsId) {
        this.wbsId = wbsId;
    }

    public String getWbsCode() {
        return wbsCode;
    }

    public void setWbsCode(String wbsCode) {
        this.wbsCode = wbsCode;
    }

    public String getWbsName() {
        return wbsName;
    }

    public void setWbsName(String wbsName) {
        this.wbsName = wbsName;
    }

    public Long getSubjectId() {
        return subjectId;
    }

    public void setSubjectId(Long subjectId) {
        this.subjectId = subjectId;
    }

    public String getSubjectCode() {
        return subjectCode;
    }

    public void setSubjectCode(String subjectCode) {
        this.subjectCode = subjectCode;
    }

    public String getSubjectName() {
        return subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getCheckAdmixtureName() {
        return checkAdmixtureName;
    }

    public void setCheckAdmixtureName(String checkAdmixtureName) {
        this.checkAdmixtureName = checkAdmixtureName;
    }

    public String getCheckAdmixtureId() {
        return checkAdmixtureId;
    }

    public void setCheckAdmixtureId(String checkAdmixtureId) {
        this.checkAdmixtureId = checkAdmixtureId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public String getSourceType() {
        return sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }
    public String getAdmixtureId() {
        return admixtureId;
    }

    public void setAdmixtureId(String admixtureId) {
        this.admixtureId = admixtureId;
    }

    public Long getCheckId() {
        return checkId;
    }

    public void setCheckId(Long checkId) {
        this.checkId = checkId;
    }
    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    public Long getDeliveryDetailId() {
        return deliveryDetailId;
    }

    public void setDeliveryDetailId(Long deliveryDetailId) {
        this.deliveryDetailId = deliveryDetailId;
    }
    public Long getOrderId() {
        return orderId;
    }

    public void setOrderId(Long orderId) {
        this.orderId = orderId;
    }
    public Long getOrderDetailId() {
        return orderDetailId;
    }

    public void setOrderDetailId(Long orderDetailId) {
        this.orderDetailId = orderDetailId;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getMaterialTypeId() {
        return materialTypeId;
    }

    public void setMaterialTypeId(Long materialTypeId) {
        this.materialTypeId = materialTypeId;
    }
    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public BigDecimal getDeliverNum() {
        return deliverNum;
    }

    public void setDeliverNum(BigDecimal deliverNum) {
        this.deliverNum = deliverNum;
    }
    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }
    public BigDecimal getCheckMny() {
        return checkMny;
    }

    public void setCheckMny(BigDecimal checkMny) {
        this.checkMny = checkMny;
    }
    public BigDecimal getCheckTaxMny() {
        return checkTaxMny;
    }

    public void setCheckTaxMny(BigDecimal checkTaxMny) {
        this.checkTaxMny = checkTaxMny;
    }
    public BigDecimal getCheckPrice() {
        return checkPrice;
    }

    public void setCheckPrice(BigDecimal checkPrice) {
        this.checkPrice = checkPrice;
    }
    public BigDecimal getCheckTaxPrice() {
        return checkTaxPrice;
    }

    public void setCheckTaxPrice(BigDecimal checkTaxPrice) {
        this.checkTaxPrice = checkTaxPrice;
    }
    public BigDecimal getCheckPriceOverall() {
        return checkPriceOverall;
    }

    public void setCheckPriceOverall(BigDecimal checkPriceOverall) {
        this.checkPriceOverall = checkPriceOverall;
    }
    public BigDecimal getCheckTaxPriceOverall() {
        return checkTaxPriceOverall;
    }

    public void setCheckTaxPriceOverall(BigDecimal checkTaxPriceOverall) {
        this.checkTaxPriceOverall = checkTaxPriceOverall;
    }
    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }
    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
    public String getAdmixtureName() {
        return admixtureName;
    }

    public void setAdmixtureName(String admixtureName) {
        this.admixtureName = admixtureName;
    }
    public Date getCastDateTime() {
        return castDateTime;
    }

    public void setCastDateTime(Date castDateTime) {
        this.castDateTime = castDateTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    
}
