package com.ejianc.business.promaterial.out.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.out.bean.OutStoreEntity;
import com.ejianc.business.promaterial.out.service.IOutStoreService;
import com.ejianc.business.promaterial.out.vo.ClaimTypeEnum;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

@Service("outStore")
public class OutStoreBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;

	@Autowired
	private IOutStoreService service;

	@Autowired
	private IStoreManageApi storeManageApi;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private ICostDetailApi costDetailApi;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OutStoreEntity outStoreEntity = service.selectById(billId);
		//调用库存逻辑
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setStoreId(outStoreEntity.getStoreId());
		storeManageVO.setSourceId(outStoreEntity.getId());
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
		storeManageVO.setOutEffectiveON(true);
		ArrayList<FlowVO> flowVOS = new ArrayList<>();
		outStoreEntity.getOutStoreSubList().forEach(t->{
			FlowVO flowVO = StoreManageUtil.getFlowVO(InOutTypeEnum.领料出库, 0);
			flowVO.setStoreId(outStoreEntity.getStoreId());
			flowVO.setStoreName(outStoreEntity.getStoreName());
			flowVO.setProjectId(outStoreEntity.getProjectId());
			flowVO.setProjectName(outStoreEntity.getProjectName());
			flowVO.setOrgId(outStoreEntity.getOrgId());
			flowVO.setOrgName(outStoreEntity.getOrgName());
			flowVO.setParentOrgId(outStoreEntity.getParentOrgId());
			flowVO.setParentOrgName(outStoreEntity.getParentOrgName());
			flowVO.setEmployeeId(outStoreEntity.getEmployeeId());
			flowVO.setEmployeeName(outStoreEntity.getEmployeeName());
			flowVO.setSupplierId(outStoreEntity.getSubSupplierId());
			flowVO.setSupplierName(outStoreEntity.getSubSupplierName());
			flowVO.setMaterialCategoryId(t.getMaterialCategoryId());
			flowVO.setMaterialCategoryName(t.getMaterialCategoryName());
			flowVO.setMaterialId(t.getMaterialId());
			flowVO.setMaterialName(t.getMaterialName());
			flowVO.setMaterialSpec(t.getSpec());
			flowVO.setMaterialUnitId(t.getUnitId());
			flowVO.setMaterialUnitName(t.getUnit());
			flowVO.setSourceBillDetailRemark(t.getMemo());
			flowVO.setTaxPrice(t.getTaxPrice());
			flowVO.setPrice(t.getPrice());
			flowVO.setNum(t.getNum());
			flowVO.setTaxMny(t.getOutTax());
			flowVO.setMny(t.getMoney());
			flowVO.setTax(t.getOutTax());
			flowVO.setSubjectId(t.getSubjectId());
			flowVO.setSubjectName(t.getSubjectName());
			flowVO.setMaterialUseId(outStoreEntity.getMaterialUseId());
			flowVO.setMaterialUseName(outStoreEntity.getMaterialUseName());
			flowVO.setUseFor(outStoreEntity.getUseFor());
			flowVO.setSubEmployeeName(outStoreEntity.getSubEmployeeName());
			flowVO.setPickUnitId(outStoreEntity.getSubSupplierId());
			flowVO.setPickUnitName(outStoreEntity.getSubSupplierName());
			flowVO.setPickContractId(outStoreEntity.getSubContractId());
			flowVO.setPickContractName(outStoreEntity.getSubContractName());

			flowVO.setSourceId(outStoreEntity.getId());
			flowVO.setSourceDetailId(t.getId());
			flowVO.setSourceBillCode(outStoreEntity.getBillCode());
			flowVO.setSourceBillDate(outStoreEntity.getOutDate());
			flowVO.setSourceBillTypeCode("BT220215000000004");
			flowVO.setSourceBillTypeName("领料出库");
			flowVO.setSourceType(1);//  0-自制,1-订单
			flowVO.setRowState(t.getRowState());
			flowVO.setSourceBillRemark(outStoreEntity.getMemo());
			flowVO.setPickType(outStoreEntity.getClaimType());//claimType; // 领料方式，1-分包领料,2-内部领料
			flowVO.setPickTypeName(ClaimTypeEnum.getEnumByStateCode(outStoreEntity.getClaimType()).getDescription());
			flowVOS.add(flowVO);
		});
		boolean pushFlag = service.pushBillToSupCenter(outStoreEntity);
		logger.info("获取推送供方结果--"+pushFlag);
		if(!pushFlag){
			outStoreEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		}else{
			outStoreEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
		}
		logger.info("调用库存---");
		storeManageVO.setFlowVOList(flowVOS);
		CommonResponse<StoreManageVO> response = storeManageApi.inOutStore(storeManageVO);
		logger.info("库存结果"+ JSONObject.toJSONString(response));
		if(!response.isSuccess()) {
			return CommonResponse.error("调用库存管理失败,错误信息："+response.getMsg());
		}
		logger.info("推送成本---");
		if(outStoreEntity.getAttrFlag()!=null && outStoreEntity.getAttrFlag()!=2){//仓库属性 1-自购材；2-甲供材
			service.costPush(outStoreEntity);
		}
		service.updateById(outStoreEntity);
		return CommonResponse.success("");
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutStoreEntity outStoreEntity = service.selectById(billId);
		if(outStoreEntity.getSignStatus()==1){
			throw new BusinessException("已签字不能撤回！");
		}
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OutStoreEntity outStoreEntity = service.selectById(billId);

		if(BillPushStatusEnum.推送成功.getStatus().equals(outStoreEntity.getBillPushFlag())){
			CommonResponse<String> commonResponse = service.updatePushBill(outStoreEntity);
			logger.info("供方结果"+ JSONObject.toJSONString(commonResponse));
			if(!commonResponse.isSuccess()){
				return CommonResponse.error("弃审推送供方失败,错误信息："+commonResponse.getMsg());
			}
		}
		List<Long> ids = new ArrayList<>();
		ids.add(billId);
		StoreManageVO storeManageVO = new StoreManageVO();
		storeManageVO.setStoreId(outStoreEntity.getStoreId());
		storeManageVO.setSourceIdsForRollBack(ids);
		storeManageVO.setInOutTypeEnum(InOutTypeEnum.领料出库);
		storeManageVO.setOutEffectiveON(true);
		CommonResponse<StoreManageVO> response = storeManageApi.inOutStoreRollback(storeManageVO);
		logger.info("库存结果"+ JSONObject.toJSONString(response));
		if(!response.isSuccess()) {
			return CommonResponse.error("调用库存管理失败,错误信息："+response.getMsg());
		}
		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-领料出库Id---{}",outStoreEntity.getId());
		if(outStoreEntity.getAttrFlag()!=null && outStoreEntity.getAttrFlag()!=2){//仓库属性 1-自购材；2-甲供材
			CommonResponse<String> stringCommonResponse = costDetailApi.updateCostDetail(outStoreEntity.getId(),0);
			logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
			if(!stringCommonResponse.isSuccess()){
				throw new BusinessException(stringCommonResponse.getMsg());
			}
		}
		//更新是否关联
		LambdaUpdateWrapper<OutStoreEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(OutStoreEntity::getId, outStoreEntity.getId());
		updateWrapper.set(OutStoreEntity::getRelationFlag, "0");//(1:是，0：否)
		updateWrapper.set(OutStoreEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
		service.update(updateWrapper);
		return CommonResponse.success();
	}

}
