/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.order.service.impl;

import com.ejianc.business.promaterial.order.bean.OrderDetailEntity;
import com.ejianc.business.promaterial.order.bean.OrderEntity;
import com.ejianc.business.promaterial.order.service.IOrderService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="order")
public class OrderBpmServiceImpl
implements ICommonBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrderService service;
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialOrder/deleteOrder";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(billId));
        orderEntity.setCommitId(InvocationInfoProxy.getUserid());
        this.service.saveOrUpdate((Object)orderEntity, false);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(billId));
        if (CollectionUtils.isNotEmpty(orderEntity.getOrderDetailList())) {
            ArrayList<OrderDetailEntity> orderDetail = new ArrayList<OrderDetailEntity>();
            for (OrderDetailEntity orderDetailEntity : orderEntity.getOrderDetailList()) {
                if (orderDetailEntity.getLeafFlag().booleanValue()) continue;
                orderDetail.add(orderDetailEntity);
            }
            orderEntity.setOrderDetailList(orderDetail);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(billId));
        if (orderEntity.getReceiveState() == 0) {
            return CommonResponse.success();
        }
        return CommonResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u88ab\u4e0b\u6e38\u64cd\u4f5c\uff0c\u4e0d\u5141\u8bb8\u56de\u9000!");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OrderEntity orderEntity = (OrderEntity)((Object)this.service.selectById(billId));
        this.service.updatePushBill(orderEntity, billTypeCode, "/ejc-supbusiness-web/openapi/materialOrder/deleteOrder");
        orderEntity.setReceiveState(null);
        this.service.updateById((Object)orderEntity);
        return CommonResponse.success((String)"");
    }
}

