package com.ejianc.business.promaterial.plan.service.impl;

import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MonthPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.MonthPlanEntity;
import com.ejianc.business.promaterial.plan.mapper.MonthPlanMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMonthPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IMonthPlanService;
import com.ejianc.business.promaterial.plan.vo.MonthPlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.MonthPlanVO;
import com.ejianc.business.promaterial.plan.vo.PlanTypeEnum;
import com.ejianc.business.promaterial.utils.OrgUtil;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资月计划
 *
 * @author generator
 *
 */
@Service("monthPlanService")
public class MonthPlanServiceImpl extends BaseServiceImpl<MonthPlanMapper, MonthPlanEntity> implements IMonthPlanService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());


    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE_C = "MONTH_PLAN_CODE";//消耗材
    private static final String BILL_CODE_H = "HNTYJH01";//混凝土
    private static final String MASTER_PLAN_NUM_CTRL_PARAM_CODE = "P-2d6J670187";
    private static final String MASTER_PLAN_PRICE_CTRL_PARAM_CODE = "P-tK1XUi0188";

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IMonthPlanDetailService monthPlanDetailService;
    @Autowired
    private MonthPlanMapper mapper;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;

    @Autowired
    private OrgUtil orgUtil;


    @Override
    public IPage<MonthPlanVO> queryConcreteList(QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("operatorName");
        fuzzyFields.add("orgName");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        /** 计划类型隔离 */
        param.getParams().put("planType", new Parameter(QueryParam.EQ, PlanTypeEnum.混泥土.getCode()));
        if(!param.getParams().containsKey("orgId")){
            /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
            UserContext userContextCache =sessionManager.getUserContext();
            //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
            String authOrgIds = userContextCache.getAuthOrgIds();
            List<OrgVO> orgVOList = null;
            if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            }else {//pc端查询
                orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            }
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<MonthPlanEntity> page = super.queryPage(param,false);
        IPage<MonthPlanVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthPlanVO.class));
        return pageData;
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @Override
    public void excelConcreteExport(QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 计划类型隔离 */
        param.getParams().put("planType", new Parameter(QueryParam.EQ, PlanTypeEnum.混泥土.getCode()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MonthPlanEntity> list = super.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<MonthPlanVO> voList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)) {
            voList = BeanMapper.mapList(list, MonthPlanVO.class);
            voList.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
            });
        }
        beans.put("records", voList);
        ExcelExport.getInstance().export("ConcreteMonthPlan-export.xlsx", beans, response);
    }
//根据项目id,判断该月是否有计划
    @Override
    public boolean monthQueryPlan(Long projectId, Date planMonth,Integer planType,Long id) {
        try {
            String monthDate = DateFormatUtil.formatDate("yyyy-MM", planMonth);
            List<MonthPlanVO> list  = baseMapper.monthQueryPlan(projectId, monthDate,planType,id);
            if(CollectionUtils.isNotEmpty(list)){
                return true;
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("该项目本月已是否存在月计划校验失败！");
        }
        return false;
    }

    @Override
    public CommonResponse<MonthPlanVO> saveOrUpdate(MonthPlanVO saveorUpdateVO) {
        MonthPlanEntity entity = BeanMapper.map(saveorUpdateVO, MonthPlanEntity.class);
        if(null == entity.getPlanType()){
            entity.setPlanType(0);// 默认消耗材
        }
        if(StringUtils.isNotBlank(entity.getBillCode())) {
            //编码重复校验
            MonthPlanVO voByCode = queryByCode(entity.getBillCode(),entity.getPlanType());
            if(null != voByCode && (null == entity.getId() || !voByCode.getId().equals(entity.getId()))) {
                throw new BusinessException("保存失败，编码重复！");
            }
        } else {
            String BILL_CODE = "";
            switch (entity.getPlanType()){
                case 0:BILL_CODE = BILL_CODE_C;break;
                case 1:BILL_CODE =BILL_CODE_H;break;
            }
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveorUpdateVO);
            CommonResponse<String> codeResp = billCodeApi.generateBillCode(billCodeParam);
            if(!codeResp.isSuccess()) {
                throw new BusinessException("保存失败，获取自动编码失败！");
            }
            String code = orgUtil.getBillCodeByCorp(entity.getOrgId(), entity.getProjectId(), codeResp.getData());
            entity.setBillCode(code);
        }
//        if(entity.getId() == null || entity.getId() == 0){
//            //设置编制日期
//            String today = DateUtil.today();
//            Date date = DateUtil.parse(today);
//            entity.setBillDate(date);
//        }
        //boolean b = service.monthQueryPlan(entity.getProjectId(), entity.getPlanMonth(),entity.getPlanType(),entity.getId());
        //if(b){
        //    String msg = "";
        //    switch (entity.getPlanType()){
        //        case 0:msg = "保存失败，该项目本月已存在消耗材月计划，请勿重复添加！";break;
        //        case 1:msg ="保存失败，该项目本月已存在混凝土月计划，请勿重复添加！";break;
        //    }
        //    throw new BusinessException(msg);
        //}
        //name拼接
        entity.setName(DateFormatUtil.formatDate("yyyy-MM-dd",entity.getPlanMonth())+" "+entity.getBillCode());
        List<MonthPlanDetailEntity> monthPlanDetailEntities = entity.getMonthPlanDetailEntities();
        List<MasterPlanDetailEntity> masterDetailList = new ArrayList<>();
        for (MonthPlanDetailEntity monthPlanDetailEntitie: monthPlanDetailEntities){
            monthPlanDetailEntitie.setSurplusNums(monthPlanDetailEntitie.getMonthPlanNum());//对剩余量初始化
//            monthPlanDetailEntitie.setName(entity.getName());//子表name初始化
            monthPlanDetailEntitie.setName(entity.getBillCode());//子表name初始化
        }

        super.saveOrUpdate(entity, false);
        MonthPlanVO vo = BeanMapper.map(entity, MonthPlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }
    //根据编码查询
    @Override
    public MonthPlanVO queryByCode(String planCode,Integer planType) {
        MonthPlanVO resp = null;
        QueryWrapper<MonthPlanEntity> query = new QueryWrapper<>();
        query.eq("bill_code", planCode);
        query.eq("dr", BaseVO.DR_UNDELETE);
//        query.eq("plan_type", planType);
        MonthPlanEntity entity = mapper.selectOne(query);
        if(null != entity) {
            resp = BeanMapper.map(entity, MonthPlanVO.class);
        }
        return resp;
    }

    @Override
    public List<ParamsCheckVO> masterPlanNumCtrl(MonthPlanVO monthPlanVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MASTER_PLAN_NUM_CTRL_PARAM_CODE, monthPlanVO.getOrgId());

        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }

        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(billParamByCode));
        List<BillParamVO> checkParamData = billParamByCode.getData();

        List<MonthPlanDetailVO> detailList = monthPlanVO.getMonthPlanDetailEntities().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        List<Long> detailIds = detailList.stream().map(MonthPlanDetailVO::getMaterialId).collect(Collectors.toList());
        Map<Long, MonthPlanDetailVO> detailVONumMap = detailList.stream().collect(Collectors.toMap(MonthPlanDetailVO::getMaterialId, item -> item));

        if(CollectionUtils.isEmpty(detailIds)) {
            logger.info("待排查明细列表为空！");
            return paramsCheckVOList;
        }
        //获取当前月计划每个明细除自己外累计的月计划量
        List<Map<String, Object>> detailTotalNumInfo = monthPlanDetailService.countDetailTotalNum(monthPlanVO.getId(), detailIds, monthPlanVO.getProjectId());
        Map<Long, Map<String, BigDecimal>>  detailNumMap = new HashMap<>();
        Map<String, BigDecimal> detailCountMap = null;

        for(Map<String, Object> item : detailTotalNumInfo) {
            if(detailVONumMap.containsKey(Long.valueOf(item.get("materialId").toString()))) {
                detailCountMap = new HashMap<>();
                //计算得到当前明细总的量
                detailCountMap.put("totalPlanNum", ComputeUtil.safeAdd(detailVONumMap.get(Long.valueOf(item.get("materialId").toString())).getMonthPlanNum(), null != item.get("totalMonthPlanNum") ? new BigDecimal(item.get("totalMonthPlanNum").toString()) : BigDecimal.ZERO));
                //总计划量
                detailCountMap.put("masterPlanNum", new BigDecimal(item.get("masterPlanNum").toString()));
                detailNumMap.put(Long.valueOf(item.get("materialId").toString()), detailCountMap);
            }
        }

        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        List<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        MonthPlanDetailVO tempDetail= null;
        for (BillParamVO billParamVO : checkParamData){
            dataSource = new ArrayList<>();
            paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            roleValue = ComputeUtil.safeDiv(billParamVO.getRoleValue(), new BigDecimal("100"));
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            // 不是none时需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for (Long materialId : detailNumMap.keySet()) {
                    tempDetail =detailVONumMap.get(materialId);
                    detailCountMap = detailNumMap.get(materialId);
                    if(detailCountMap.get("masterPlanNum").compareTo(new BigDecimal("-1")) == 0) {
                        logger.info("明细：分类-{},名称-{},型号-{},id-{}在总计划不存在，不进行价控！",
                                tempDetail.getMaterialCategoryName(), tempDetail.getMaterialName(), tempDetail.getSpec(), tempDetail.getMaterialId());
                    }
                    if(detailCountMap.get("totalPlanNum").compareTo(ComputeUtil.safeMultiply(detailCountMap.get("masterPlanNum"), roleValue)) > 0) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem(tempDetail.getMaterialName() + tempDetail.getSpec());
                        paramsCheckDsVO.setWarnName("消耗材月计划量超过总计划量");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次月计划量：").append(tempDetail.getMonthPlanNum().setScale(2, RoundingMode.DOWN))
                                .append("，含本次累计月计划量：").append(detailCountMap.get("totalPlanNum").setScale(2, RoundingMode.DOWN))
                                .append("，总计划数量*").append(billParamVO.getRoleValue().setScale(2, RoundingMode.DOWN)).append("%：").append(detailCountMap.get("masterPlanNum").setScale(2, RoundingMode.DOWN))
                                .append("。超出：").append(ComputeUtil.safeSub(detailCountMap.get("totalPlanNum"), ComputeUtil.safeMultiply(detailCountMap.get("masterPlanNum"), roleValue)).setScale(2, RoundingMode.DOWN));
                        paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
            }

            paramsCheckVOList.add(paramsCheckVO);
        }


        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> masterPlanPriceCtrl(MonthPlanVO monthPlanVO) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(MASTER_PLAN_PRICE_CTRL_PARAM_CODE, monthPlanVO.getOrgId());

        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }

        logger.info("单据控制参数查询结果：{}", JSONObject.toJSONString(billParamByCode));
        List<BillParamVO> checkParamData = billParamByCode.getData();


        List<MonthPlanDetailVO> detailList = monthPlanVO.getMonthPlanDetailEntities().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());

        if(CollectionUtils.isEmpty(detailList)) {
            logger.info("待排查明细列表为空！");
            return paramsCheckVOList;
        }
        //查询总计划物料单价
        List<MasterPlanDetailEntity> masterPlanDetailList = masterPlanDetailService.getByProjectId(monthPlanVO.getProjectId(), 0);
        Map<Long, BigDecimal> masterDetailPriceNum = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, MasterPlanDetailEntity::getPrice));

        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        List<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        BigDecimal tmpPrice = null;
        for (BillParamVO billParamVO : checkParamData) {
            dataSource = new ArrayList<>();
            paramsCheckVO = new ParamsCheckVO();
            // 控制规则值  百分比
            roleValue = billParamVO.getRoleValue();
            // 默认控制方式为提醒
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }

            // 不是none时需要控制
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for(MonthPlanDetailVO detail : detailList) {
                    tmpPrice = masterDetailPriceNum.get(detail.getMaterialId());
                    if(null == tmpPrice) {
                        logger.info("明细：分类-{},名称-{},型号-{},id-{}在总计划不存在，不进行价控！",
                                detail.getMaterialCategoryName(), detail.getMaterialName(), detail.getSpec(), detail.getMaterialId());
                        continue;
                    }
                    if(null == detail.getMonthPlanPrice()) {
                        logger.info("明细：分类-{},名称-{},型号-{},id-{}单价为空，不进行价控！",
                                detail.getMaterialCategoryName(), detail.getMaterialName(), detail.getSpec(), detail.getMaterialId());
                        continue;
                    }
                    if(detail.getMonthPlanPrice().compareTo(ComputeUtil.safeMultiply(tmpPrice, roleValue)) > 0) {
                        paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setWarnItem(detail.getMaterialName() + detail.getSpec());
                        paramsCheckDsVO.setWarnName("消耗材月计划单价超过总计划单价");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次月计划单价：").append(detail.getMonthPlanNum().setScale(2, RoundingMode.DOWN))
                                .append("，总计划单价*X%：").append(ComputeUtil.safeMultiply(tmpPrice, roleValue).setScale(2, RoundingMode.DOWN))
                                .append("。超出：").append(ComputeUtil.safeSub(detail.getMonthPlanPrice(), ComputeUtil.safeMultiply(tmpPrice, roleValue)).setScale(2, RoundingMode.DOWN));
                        paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                        paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                        dataSource.add(paramsCheckDsVO);
                        paramsCheckVO.setDataSource(dataSource);
                    }
                }
            }

            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

}
