/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.promaterial.plan.bean.MasterPlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.SinglePlanDetailEntity;
import com.ejianc.business.promaterial.plan.bean.SinglePlanEntity;
import com.ejianc.business.promaterial.plan.mapper.SinglePlanMapper;
import com.ejianc.business.promaterial.plan.service.IMasterPlanDetailService;
import com.ejianc.business.promaterial.plan.service.IPlanDetailService;
import com.ejianc.business.promaterial.plan.service.ISinglePlanDetailService;
import com.ejianc.business.promaterial.plan.service.ISinglePlanService;
import com.ejianc.business.promaterial.plan.vo.SinglePlanDetailVO;
import com.ejianc.business.promaterial.plan.vo.SinglePlanVO;
import com.ejianc.business.promaterial.utils.OrgUtil;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="singlePlanService")
public class SinglePlanServiceImpl
extends BaseServiceImpl<SinglePlanMapper, SinglePlanEntity>
implements ISinglePlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "DX_PLAN_CODE";
    private static final String PLAN_NUM_CTRL_PARAM_CODE = "P-6b51900004";
    private static final String MASTER_PLAN_PRICE_CTRL_PARAM_CODE = "P-17X9z80191";
    private static final String CONTRACT_NUM_CTRL_PARAM_CODE = "P-7r6T9V0005";
    @Autowired
    private ISinglePlanService service;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private ISinglePlanDetailService detailService;
    @Autowired
    private IMasterPlanDetailService masterPlanDetailService;
    @Autowired
    private IPlanDetailService planDetailService;
    @Autowired
    private OrgUtil orgUtil;

    @Override
    public CommonResponse<SinglePlanVO> saveOrUpdate(SinglePlanVO saveOrUpdateVO) {
        SinglePlanEntity entity = (SinglePlanEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, SinglePlanEntity.class));
        if (StringUtils.isNotBlank((CharSequence)entity.getBillCode())) {
            SinglePlanVO voByCode = this.queryByCode(entity.getBillCode());
            if (!(null == voByCode || null != entity.getId() && voByCode.getId().equals(entity.getId()))) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u7f16\u7801\u91cd\u590d\uff01");
            }
        } else {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                String code = this.orgUtil.getBillCodeByCorp(entity.getOrgId(), entity.getProjectId(), (String)billCode.getData());
                entity.setBillCode(code);
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        List<SinglePlanDetailEntity> detailList = entity.getPlanDetailList();
        String materialName = "";
        if (CollectionUtils.isNotEmpty(detailList)) {
            ArrayList<SinglePlanDetailEntity> list = new ArrayList<SinglePlanDetailEntity>();
            for (SinglePlanDetailEntity detail : detailList) {
                if (!"del".equals(detail.getRowState())) {
                    if (StringUtils.isNotBlank((CharSequence)detail.getMaterialName())) {
                        materialName = StringUtils.isNotBlank((CharSequence)materialName) ? materialName + "," + detail.getMaterialName() : detail.getMaterialName();
                    }
                    list.add(detail);
                }
                BigDecimal nums = detail.getNums() == null ? BigDecimal.ZERO : detail.getNums();
                BigDecimal occupyNums = detail.getOccupyNums() == null ? BigDecimal.ZERO : detail.getOccupyNums();
                BigDecimal surplusNums = nums.subtract(occupyNums);
                detail.setSurplusNums(surplusNums);
                detail.setOccupyNums(occupyNums);
                detail.setNums(nums);
                detail.setActualNums(nums);
            }
            Integer planFlag = entity.getPlanFlag() == null ? 1 : entity.getPlanFlag();
            entity.setPlanFlag(planFlag);
            entity.setMaterialName(materialName);
            if (CollectionUtils.isEmpty(list)) {
                throw new BusinessException("\u6700\u5c11\u6709\u4e00\u6761\u8ba1\u5212\u660e\u7ec6\uff01");
            }
        } else {
            throw new BusinessException("\u6700\u5c11\u6709\u4e00\u6761\u8ba1\u5212\u660e\u7ec6\uff01");
        }
        SinglePlanEntity data = new SinglePlanEntity();
        if (null != entity.getId()) {
            data = (SinglePlanEntity)((Object)super.selectById((Serializable)entity.getId()));
        }
        Map<Long, SinglePlanDetailEntity> dataMap = data.getPlanDetailList().stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        HashMap<Long, BigDecimal> numMap = new HashMap<Long, BigDecimal>();
        for (SinglePlanDetailEntity detail : detailList) {
            detail.setActualNums(detail.getNums());
            detail.setSurplusNums(ComputeUtil.safeSub((BigDecimal)detail.getActualNums(), (BigDecimal)detail.getOccupyNums()));
            if ("del".equals(detail.getRowState())) {
                numMap.put(detail.getSourceId(), ComputeUtil.safeSub((BigDecimal)((BigDecimal)numMap.get(detail.getSourceId())), (BigDecimal)detail.getNums()));
                continue;
            }
            BigDecimal num = detail.getNums();
            if (dataMap.containsKey(detail.getId())) {
                num = ComputeUtil.safeSub((BigDecimal)detail.getNums(), (BigDecimal)dataMap.get(detail.getId()).getNums());
            }
            numMap.put(detail.getSourceId(), ComputeUtil.safeAdd((BigDecimal)((BigDecimal)numMap.get(detail.getSourceId())), (BigDecimal)num));
        }
        if (MapUtils.isNotEmpty(numMap)) {
            this.planDetailService.writeBackOccupyNum(numMap);
        }
        super.saveOrUpdate((Object)entity, false);
        SinglePlanVO vo = (SinglePlanVO)BeanMapper.map((Object)((Object)entity), SinglePlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    private SinglePlanVO queryByCode(String planCode) {
        SinglePlanVO resp = null;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"bill_code", (Object)planCode);
        query.eq((Object)"dr", (Object)BaseVO.DR_UNDELETE);
        SinglePlanEntity entity = (SinglePlanEntity)((Object)super.getOne((Wrapper)query));
        if (null != entity) {
            resp = (SinglePlanVO)BeanMapper.map((Object)((Object)entity), SinglePlanVO.class);
        }
        return resp;
    }

    @Override
    public List<SinglePlanDetailVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper queryWrapper) {
        List<SinglePlanDetailVO> planVOList = ((SinglePlanMapper)this.baseMapper).getPlanByMaterialId(materialListId, queryWrapper);
        return planVOList;
    }

    @Override
    public List<ParamsCheckVO> planNumCtrl(SinglePlanVO planVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(PLAN_NUM_CTRL_PARAM_CODE, planVO.getOrgId());
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)billParamByCode));
        List checkParamData = (List)billParamByCode.getData();
        List detailList = planVO.getPlanDetailList().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        List<Long> detailIds = detailList.stream().map(SinglePlanDetailVO::getMaterialId).collect(Collectors.toList());
        Map<Long, SinglePlanDetailVO> detailVONumMap = detailList.stream().collect(Collectors.toMap(SinglePlanDetailVO::getMaterialId, item -> item));
        List<Map<String, Object>> detailTotalNumInfo = this.detailService.countDetailTotalNum(planVO.getId(), detailIds, planVO.getProjectId());
        HashMap detailNumMap = new HashMap();
        Map detailCountMap = null;
        for (Map<String, Object> item2 : detailTotalNumInfo) {
            if (!detailVONumMap.containsKey(Long.valueOf(item2.get("materialId").toString()))) continue;
            detailCountMap = new HashMap<String, BigDecimal>();
            detailCountMap.put("totalPlanNum", ComputeUtil.safeAdd((BigDecimal)detailVONumMap.get(Long.valueOf(item2.get("materialId").toString())).getNums(), (BigDecimal)(null != item2.get("totalPlanNum") ? new BigDecimal(item2.get("totalPlanNum").toString()) : BigDecimal.ZERO)));
            detailCountMap.put("masterPlanNum", new BigDecimal(item2.get("masterPlanNum").toString()));
            detailNumMap.put(Long.valueOf(item2.get("materialId").toString()), detailCountMap);
        }
        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        ArrayList<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        SinglePlanDetailVO tempDetail = null;
        for (BillParamVO billParamVO : checkParamData) {
            dataSource = new ArrayList<ParamsCheckDsVO>();
            paramsCheckVO = new ParamsCheckVO();
            roleValue = ComputeUtil.safeDiv((BigDecimal)billParamVO.getRoleValue(), (BigDecimal)new BigDecimal("100"));
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for (Long materialId : detailNumMap.keySet()) {
                    detailCountMap = (Map)detailNumMap.get(materialId);
                    tempDetail = detailVONumMap.get(materialId);
                    if (((BigDecimal)detailCountMap.get("masterPlanNum")).compareTo(new BigDecimal("-1")) == 0) {
                        this.logger.info("\u660e\u7ec6\uff1a\u5206\u7c7b-{},\u540d\u79f0-{},\u578b\u53f7-{},id-{}\u5728\u603b\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u4ef7\u63a7\uff01", new Object[]{tempDetail.getMaterialCategoryName(), tempDetail.getMaterialName(), tempDetail.getSpec(), tempDetail.getMaterialId()});
                    }
                    if (((BigDecimal)detailCountMap.get("totalPlanNum")).compareTo(ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)detailCountMap.get("masterPlanNum")), (BigDecimal)roleValue)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(tempDetail.getMaterialName() + tempDetail.getSpec());
                    paramsCheckDsVO.setWarnName("\u5355\u9879\u91c7\u8d2d\u8ba1\u5212\u91cf\u8d85\u8fc7\u5206\u9879\u9700\u7528\u8ba1\u5212\u91cf");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5355\u9879\u91c7\u8d2d\u8ba1\u5212\u91cf\uff1a").append(tempDetail.getNums().setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5355\u9879\u91c7\u8d2d\u8ba1\u5212\u91cf\uff1a").append(((BigDecimal)detailCountMap.get("totalPlanNum")).setScale(2, RoundingMode.DOWN)).append("\uff0c\u5206\u9879\u9700\u7528\u8ba1\u5212\u91cf*").append(billParamVO.getRoleValue().setScale(2, RoundingMode.DOWN)).append("%\uff1a").append(((BigDecimal)detailCountMap.get("masterPlanNum")).setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)((BigDecimal)detailCountMap.get("totalPlanNum")), (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)detailCountMap.get("masterPlanNum")), (BigDecimal)roleValue)).setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> masterPlanPriceCtrl(SinglePlanVO planVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MASTER_PLAN_PRICE_CTRL_PARAM_CODE, planVO.getOrgId());
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)billParamByCode));
        List checkParamData = (List)billParamByCode.getData();
        List detailList = planVO.getPlanDetailList().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        List<MasterPlanDetailEntity> masterPlanDetailList = this.masterPlanDetailService.getByProjectId(planVO.getProjectId(), 0);
        Map<Long, BigDecimal> masterDetailPriceNum = masterPlanDetailList.stream().collect(Collectors.toMap(MasterPlanDetailEntity::getMaterialId, MasterPlanDetailEntity::getPrice));
        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        ArrayList<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        BigDecimal tmpPrice = null;
        for (BillParamVO billParamVO : checkParamData) {
            dataSource = new ArrayList<ParamsCheckDsVO>();
            paramsCheckVO = new ParamsCheckVO();
            roleValue = billParamVO.getRoleValue();
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for (SinglePlanDetailVO detail : detailList) {
                    tmpPrice = masterDetailPriceNum.get(detail.getMaterialId());
                    if (null == tmpPrice) {
                        this.logger.info("\u660e\u7ec6\uff1a\u5206\u7c7b-{},\u540d\u79f0-{},\u578b\u53f7-{},id-{}\u5728\u603b\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u4ef7\u63a7\uff01", new Object[]{detail.getMaterialCategoryName(), detail.getMaterialName(), detail.getSpec(), detail.getMaterialId()});
                        continue;
                    }
                    if (null == detail.getPrice()) {
                        this.logger.info("\u660e\u7ec6\uff1a\u5206\u7c7b-{},\u540d\u79f0-{},\u578b\u53f7-{},id-{}\u5355\u4ef7\u4e3a\u7a7a\uff0c\u4e0d\u8fdb\u884c\u4ef7\u63a7\uff01", new Object[]{detail.getMaterialCategoryName(), detail.getMaterialName(), detail.getSpec(), detail.getMaterialId()});
                        continue;
                    }
                    if (detail.getPrice().compareTo(ComputeUtil.safeMultiply((BigDecimal)tmpPrice, (BigDecimal)roleValue)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(detail.getMaterialName() + detail.getSpec());
                    paramsCheckDsVO.setWarnName("\u6d88\u8017\u6750\u9700\u7528\u8ba1\u5212\u5355\u4ef7\u8d85\u8fc7\u603b\u8ba1\u5212\u5355\u4ef7");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u9700\u7528\u8ba1\u5212\u5355\u4ef7\uff1a").append(detail.getNums().setScale(2, RoundingMode.DOWN)).append("\uff0c\u603b\u8ba1\u5212\u5355\u4ef7*X%\uff1a").append(ComputeUtil.safeMultiply((BigDecimal)tmpPrice, (BigDecimal)roleValue).setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\uff1a").append(ComputeUtil.safeSub((BigDecimal)detail.getPrice(), (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)tmpPrice, (BigDecimal)roleValue)).setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> contractNumCtrl(SinglePlanVO planVO) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CONTRACT_NUM_CTRL_PARAM_CODE, planVO.getOrgId());
        if (!billParamByCode.isSuccess() || null == billParamByCode.getData()) {
            return paramsCheckVOList;
        }
        this.logger.info("\u5355\u636e\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)billParamByCode));
        List checkParamData = (List)billParamByCode.getData();
        List detailList = planVO.getPlanDetailList().stream().filter(item -> !"del".equals(item.getRowState())).collect(Collectors.toList());
        List<Long> detailIds = detailList.stream().map(SinglePlanDetailVO::getMaterialId).collect(Collectors.toList());
        Map<Long, SinglePlanDetailVO> detailVONumMap = detailList.stream().collect(Collectors.toMap(SinglePlanDetailVO::getMaterialId, item -> item));
        List<Map<String, Object>> detailTotalNumInfo = this.detailService.contractNumCtrl(planVO.getId(), detailIds, planVO.getContractId());
        HashMap detailNumMap = new HashMap();
        Map detailCountMap = null;
        for (Map<String, Object> item2 : detailTotalNumInfo) {
            if (!detailVONumMap.containsKey(Long.valueOf(item2.get("materialId").toString()))) continue;
            detailCountMap = new HashMap<String, BigDecimal>();
            detailCountMap.put("totalPlanNum", ComputeUtil.safeAdd((BigDecimal)detailVONumMap.get(Long.valueOf(item2.get("materialId").toString())).getNums(), (BigDecimal)(null != item2.get("totalPlanNum") ? new BigDecimal(item2.get("totalPlanNum").toString()) : BigDecimal.ZERO)));
            detailCountMap.put("masterPlanNum", new BigDecimal(item2.get("masterPlanNum").toString()));
            detailNumMap.put(Long.valueOf(item2.get("materialId").toString()), detailCountMap);
        }
        StringBuilder sp = new StringBuilder();
        BigDecimal roleValue = null;
        ArrayList<ParamsCheckDsVO> dataSource = null;
        ParamsCheckVO paramsCheckVO = null;
        ParamsCheckDsVO paramsCheckDsVO = null;
        SinglePlanDetailVO tempDetail = null;
        for (BillParamVO billParamVO : checkParamData) {
            dataSource = new ArrayList<ParamsCheckDsVO>();
            paramsCheckVO = new ParamsCheckVO();
            roleValue = ComputeUtil.safeDiv((BigDecimal)billParamVO.getRoleValue(), (BigDecimal)new BigDecimal("100"));
            if (1 == billParamVO.getControlType()) {
                paramsCheckVO.setWarnType(paramsArray[1]);
            } else {
                paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
            }
            if (!"none".equals(paramsCheckVO.getWarnType())) {
                for (Long materialId : detailNumMap.keySet()) {
                    detailCountMap = (Map)detailNumMap.get(materialId);
                    tempDetail = detailVONumMap.get(materialId);
                    if (((BigDecimal)detailCountMap.get("masterPlanNum")).compareTo(new BigDecimal("-1")) == 0) {
                        this.logger.info("\u660e\u7ec6\uff1a\u5206\u7c7b-{},\u540d\u79f0-{},\u578b\u53f7-{},id-{}\u5728\u6708\u8ba1\u5212\u4e0d\u5b58\u5728\uff0c\u4e0d\u8fdb\u884c\u4ef7\u63a7\uff01", new Object[]{tempDetail.getMaterialCategoryName(), tempDetail.getMaterialName(), tempDetail.getSpec(), tempDetail.getMaterialId()});
                    }
                    if (((BigDecimal)detailCountMap.get("totalPlanNum")).compareTo(ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)detailCountMap.get("masterPlanNum")), (BigDecimal)roleValue)) <= 0) continue;
                    paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setWarnItem(tempDetail.getMaterialName() + tempDetail.getSpec());
                    paramsCheckDsVO.setWarnName("\u5355\u9879\u91c7\u8d2d\u8ba1\u5212\u91cf\u8d85\u8fc7\u5408\u540c\u91cf");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u5355\u9879\u91c7\u8d2d\u8ba1\u5212\u91cf\uff1a").append(tempDetail.getNums().setScale(2, RoundingMode.DOWN)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5355\u9879\u91c7\u8d2d\u8ba1\u5212\u91cf\uff1a").append(((BigDecimal)detailCountMap.get("totalPlanNum")).setScale(2, RoundingMode.DOWN)).append("\uff0c\u5408\u540c\u91cf*").append(billParamVO.getRoleValue().setScale(2, RoundingMode.DOWN)).append("%\uff1a").append(((BigDecimal)detailCountMap.get("masterPlanNum")).setScale(2, RoundingMode.DOWN)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)((BigDecimal)detailCountMap.get("totalPlanNum")), (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)((BigDecimal)detailCountMap.get("masterPlanNum")), (BigDecimal)roleValue)).setScale(2, RoundingMode.DOWN));
                    paramsCheckDsVO.setContent(String.valueOf(stringBuffer));
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    dataSource.add(paramsCheckDsVO);
                    paramsCheckVO.setDataSource(dataSource);
                }
            }
            paramsCheckVOList.add(paramsCheckVO);
        }
        return paramsCheckVOList;
    }
}

