/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.plan.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.order.vo.OrderDetailVO;
import com.ejianc.business.promaterial.plan.bean.SinglePlanDetailEntity;
import com.ejianc.business.promaterial.plan.mapper.SinglePlanDetailMapper;
import com.ejianc.business.promaterial.plan.service.IPlanDetailService;
import com.ejianc.business.promaterial.plan.service.ISinglePlanDetailService;
import com.ejianc.business.promaterial.plan.vo.SinglePlanDetailVO;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="singlePlanDetailService")
public class SinglePlanDetailServiceImpl
extends BaseServiceImpl<SinglePlanDetailMapper, SinglePlanDetailEntity>
implements ISinglePlanDetailService {
    @Autowired
    private IPlanDetailService planDetailService;

    @Override
    public List<SinglePlanDetailVO> geMaterialDetail(Page<SinglePlanDetailVO> page, QueryWrapper queryWrapper) {
        List<SinglePlanDetailVO> list = ((SinglePlanDetailMapper)this.baseMapper).geMaterialDetail(page, queryWrapper);
        return list;
    }

    @Override
    public List<OrderDetailVO> queryMaterialDetail(Long projectId, Long materialId) {
        List<OrderDetailVO> orderDetailVOS = ((SinglePlanDetailMapper)this.baseMapper).queryMaterialDetail(projectId, materialId);
        return orderDetailVOS;
    }

    @Override
    public BigDecimal getSurplusNumsSum(Long projectId, Long materialId) {
        BigDecimal surplusNumsSum = ((SinglePlanDetailMapper)this.baseMapper).getSurplusNumsSum(projectId, materialId);
        return surplusNumsSum;
    }

    @Override
    public List<Map<String, Object>> countDetailTotalNum(Long planId, List<Long> detailIds, Long projectId) {
        return ((SinglePlanDetailMapper)this.baseMapper).countDetailTotalNum(planId, detailIds, projectId);
    }

    @Override
    public List<Map<String, Object>> contractNumCtrl(Long planId, List<Long> detailIds, Long contractId) {
        return ((SinglePlanDetailMapper)this.baseMapper).contractNumCtrl(planId, detailIds, contractId);
    }

    @Override
    public Map<Long, BigDecimal> writeBackOccupyNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", new ArrayList<Long>(numMap.keySet())));
        List list = super.queryList(param);
        for (SinglePlanDetailEntity detail : list) {
            detail.setOccupyNums(ComputeUtil.safeAdd((BigDecimal)detail.getOccupyNums(), (BigDecimal)numMap.get(detail.getId())));
            detail.setSurplusNums(ComputeUtil.safeSub((BigDecimal)detail.getActualNums(), (BigDecimal)detail.getOccupyNums()));
        }
        super.saveOrUpdateBatch((Collection)list);
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x -> x.getId(), x -> x.getOccupyNums()));
        return result;
    }

    @Override
    public Map<Long, BigDecimal> writeBackActualNum(Map<Long, BigDecimal> numMap) {
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter("in", new ArrayList<Long>(numMap.keySet())));
        List list = super.queryList(param);
        HashMap<Long, BigDecimal> planMap = new HashMap<Long, BigDecimal>();
        for (SinglePlanDetailEntity detail : list) {
            detail.setOccupyNums(ComputeUtil.safeAdd((BigDecimal)detail.getOccupyNums(), (BigDecimal)numMap.get(detail.getId())));
            detail.setActualNums(ComputeUtil.safeAdd((BigDecimal)detail.getActualNums(), (BigDecimal)numMap.get(detail.getId())));
            detail.setSurplusNums(ComputeUtil.safeSub((BigDecimal)detail.getActualNums(), (BigDecimal)detail.getOccupyNums()));
            planMap.put(detail.getSourceId(), numMap.get(detail.getId()));
        }
        super.saveOrUpdateBatch((Collection)list);
        if (MapUtils.isNotEmpty(planMap)) {
            this.planDetailService.writeBackOccupyNum(planMap);
        }
        Map<Long, BigDecimal> result = list.stream().collect(Collectors.toMap(x -> x.getId(), x -> x.getOccupyNums()));
        return result;
    }
}

