package com.ejianc.business.promaterial.check.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.impl.CheckBpmServiceImpl;
import com.ejianc.business.promaterial.check.service.impl.ConcreteCheckBpmServiceImpl;
import com.ejianc.business.promaterial.check.vo.*;
import com.ejianc.business.promaterial.electronicFence.bean.ElectronicFenceConfigEntity;
import com.ejianc.business.promaterial.electronicFence.enums.FenceConfigChangeStatusEnum;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.different.vo.DifferentVO;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.promaterial.settlement.vo.SettlementVO;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.SupplierProVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 消耗材-验收主表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("check")
@Api(value = "消耗材-验收主表", tags = {"消耗材-验收主表"})
public class CheckController implements Serializable {
	private static final long serialVersionUID = 1L;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "XHC-CHECK-CODE";//此处需要根据实际修改
    private static final String BILL_TYPE = "BT220215000000006";//此处需要根据实际修改
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proMaterial/check/card";
    ;

    @Autowired
    private ICheckService service;
    @Autowired
    private CheckBpmServiceImpl checkBpmService;
    @Autowired
    private ConcreteCheckBpmServiceImpl concreteCheckBpmService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/materialCheck/saveCheck";
    @Autowired
    private IElectronicFenceConfigService electronicFenceConfigService;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private ICheckDetailService detailService;


    @Autowired
    ICommonBusinessService check;
    @Autowired
    private SessionManager sessionManager;
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> test(@RequestParam Long id) {
//        CommonResponse<String> stringCommonResponse = check.afterApprovalProcessor(id, null, null);
        CommonResponse<String> stringCommonResponse = concreteCheckBpmService.afterApprovalProcessor(id, null, null);
        return stringCommonResponse;
    }
    @ApiOperation("同步目标成本接口")
    @RequestMapping(value = "/syncCost", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> syncCost(@RequestParam Long id) {
        CheckEntity checkEntity = service.syncCost(id);
        return CommonResponse.success("同步成功");
    }


//    @ApiOperation("新增或者修改")
//    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
//    @ResponseBody
//    public CommonResponse<CheckVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CheckVO saveOrUpdateVO) {
//        //获取项目电子开启状态
//        ElectronicFenceConfigEntity electronicFenceConfig = electronicFenceConfigService.getOneByProjectId(saveOrUpdateVO.getProjectId(), true);
//        if(null != electronicFenceConfig) {
//            saveOrUpdateVO.setElectronicFenceEnableStatus(electronicFenceConfig.getEnable());
//            if(Integer.valueOf(0).equals(saveOrUpdateVO.getRecordFlag()) && Integer.valueOf(1).equals(electronicFenceConfig.getEnable()) && CollectionUtils.isNotEmpty(saveOrUpdateVO.getCheckImgList())) {
//                //若电子围栏，开启则判断是否存在异常验收图片，存在则无法进行保存操作
//                for(CheckImgDetailVO checkImg : saveOrUpdateVO.getCheckImgList()) {
//                    if(Integer.valueOf(0).equals(checkImg.getAbnormalImgFlag())) {
//                        return CommonResponse.error("操作失败，存在异常状态的验收图片");
//                    }
//                }
//            }
//        }
//        for (CheckDetailVO detailVO : saveOrUpdateVO.getCheckDetailList()) {
//            if (detailVO.getConsumableFlag() == 3) {
//                return CommonResponse.error("请选择低值易耗品标识！");
//            }
//        }
//        CheckVO vo = service.saveOrUpdates(saveOrUpdateVO, false);
//    	return CommonResponse.success("保存或修改单据成功！",vo);
//    }


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> saveOrUpdate(@RequestBody CheckVO saveOrUpdateVO) {
        CheckEntity entity = BeanMapper.map(saveOrUpdateVO, CheckEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(saveOrUpdateVO.getProjectShortName() + billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //收料入库
        if (null != entity.getBillState() && (1 == entity.getBillState() || 3 == entity.getBillState()) && entity.getStoreFlag() == 1 && entity.getStoreType() == 0){
            service.inStore(entity);
        }

        // 回写占用量
        CheckEntity data = new CheckEntity();
        if(null != entity.getId()){
            data = service.selectById(entity.getId());
        }
        Map<Long, CheckDetailEntity> dataMap = data.getCheckDetailList().stream().collect(Collectors.toMap(x->x.getId(), x->x));
        Map<Long, BigDecimal> numMap = new HashMap<>();
        for (CheckDetailEntity detail : entity.getCheckDetailList()) {
            if("del".equals(detail.getRowState())){
                numMap.put(detail.getSourceId(), ComputeUtil.safeSub(numMap.get(detail.getSourceId()), detail.getCheckNum()));
            } else {
                BigDecimal num = detail.getCheckNum();
                if(dataMap.containsKey(detail.getId())){
                    num = ComputeUtil.safeSub(detail.getCheckNum(), dataMap.get(detail.getId()).getCheckNum());
                }
                numMap.put(detail.getSourceId(), ComputeUtil.safeAdd(numMap.get(detail.getSourceId()), num));
            }
        }
        service.saveOrUpdate(entity, false);
        if(MapUtils.isNotEmpty(numMap)){
            orderDetailService.writeBackOccupyNum(numMap);
        }
        CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("消耗材-更新合同和物资明细返回税率和单价")
    @RequestMapping(value = "/getRateAndPrice", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> getRateAndPrice(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody CheckVO saveOrUpdateVO) {
        CheckVO vo = service.getRateAndPrice(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("混凝土-自制合同验收逻辑-更新合同和物资明细返回税率和单价")
    @RequestMapping(value = "/hntgetRateAndPrice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> hntgetRateAndPrice(@RequestParam Long sourceDetailId) {
        CheckVO vo = service.hntgetRateAndPrice(sourceDetailId);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("混凝土-基于订单验收逻辑-更新合同和物资明细返回税率和单价")
    @RequestMapping(value = "/hntOrderRateAndPrice", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> hntOrderRateAndPrice(@RequestParam Long sourceDetailId) {
        CheckVO vo = service.hntOrderRateAndPrice(sourceDetailId);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }


    @ApiOperation("查询详情")
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetail(@RequestParam Long id, Long shareId) {
    	CheckEntity entity = service.selectById(id);
//        List<CheckDetailEntity> detailEntityList = new ArrayList<>();
//        if (shareId != null && entity.getStoreType() == 1) {
//            for (CheckDetailEntity detailEntity : entity.getCheckDetailList()) {
//                if (detailEntity.getConsumableFlag() == 0) {
//                    detailEntityList.add(detailEntity);
//                }
//            }
//        }
//        if (CollectionUtils.isNotEmpty(detailEntityList)) {
//            entity.setCheckDetailList(detailEntityList);
//        }
    	CheckVO vo = BeanMapper.map(entity, CheckVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        CheckEntity entity = service.selectById(id);
        //校验供应商
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("获取供应商信息失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法协同验收。 请先到供应商库—生成协同账号再进行订单操作。");
        }

        // 没有推送成功，则需要重新推送数据
        if (BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(BILL_TYPE);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            }
            else {
                //未曾成功推送单据，则先向供方推送单据
                //推送供方处理
                SupplierPushCheckVO supplierPushCheckVO = BeanMapper.map(entity, SupplierPushCheckVO.class);
                supplierPushCheckVO.setSourceId(entity.getId());
                List<SupplierPushCheckDetailVO> checkDetailList = supplierPushCheckVO.getCheckDetailList();
                for (SupplierPushCheckDetailVO supplierPushCheckDetailVO : checkDetailList) {
                    supplierPushCheckDetailVO.setSourceId(entity.getId());
                    supplierPushCheckDetailVO.setSourcedetailId(supplierPushCheckDetailVO.getId());
                    supplierPushCheckDetailVO.setId(null);
                }
                //设置单据当前系统信息
                CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    return CommonResponse.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
                }
                //设置当前系统ID
                supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
                boolean pushResult = service
                        .pushBillToSupCenter(dataInfo, entity.getSupplierId(), entity.getId(), BILL_TYPE, cooperateResp
                                .getData(), PUSH_SAVE_URL);
                if (!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                }
                else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi
                .getShareLink(id, BILL_TYPE, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }
    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CheckVO> vos) {
//        service.deletes(vos);
        List<Long> ids = vos.stream().map(x->x.getId()).collect(Collectors.toList());
        // 回写占用量
        QueryParam param = new QueryParam();
        param.getParams().put("checkId", new Parameter(QueryParam.IN, ids));
        List<CheckDetailEntity> detailList = detailService.queryList(param);
        Map<Long, BigDecimal> numMap = new HashMap<>();
        for (CheckDetailEntity detail : detailList) {
            numMap.put(detail.getSourceId(), ComputeUtil.safeSub(numMap.get(detail.getSourceId()), detail.getCheckNum()));
        }
        service.removeByIds(ids,true);
        if(MapUtils.isNotEmpty(numMap)){
            orderDetailService.writeBackOccupyNum(numMap);
        }
        return CommonResponse.success("删除成功！");
    }
    @ApiOperation("根据明细信息填充数据,返回")
    @RequestMapping(value = "/getDetailListData", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> getDetailListData(@RequestBody CheckVO checkVO) {
        return CommonResponse.success("查询成功",service.getDetailListData(checkVO));
    }

    @ApiOperation("批量删除单据")
    @RequestMapping(value = "/deletssse", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> deletesss(@RequestParam Long billId) {
        checkBpmService.afterApprovalProcessor(billId,null,"BILL_TYPE");
//        concreteCheckBpmService.afterApprovalProcessor(billId,null,"BT220224000000004");
        return null;
    }
//    @ApiOperation("批量删除单据")
//    @RequestMapping(value = "/deletesss1", method = RequestMethod.GET)
//    @ResponseBody
//    public CommonResponse<String> deletesss1(@RequestParam Long billId) {
////        checkBpmService.afterAbstainingProcessor(billId,null,null);
//        concreteCheckBpmService.afterAbstainingProcessor(billId,null,null);
//        return null;
//    }


    @ApiOperation("查询列表")
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("employeeName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));


//        if (param.getParams().containsKey("hasContract")){
//            //1 有合同 2 无合同
//            String hasContract  = param.getParams().get("hasContract").getValue().toString();
//            if (hasContract.equals("1")){
//                param.getParams().put("contractId1", new Parameter(QueryParam.SQL,"contract_id is not null"));
//            }
//            if (hasContract.equals("2")){
//                param.getParams().put("contractId1", new Parameter(QueryParam.SQL,"contract_id is  null"));
//            }
//            param.getParams().remove("hasContract");
//
//        }

        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * 成本改造
     * 关联保存接口
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/pushCost", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> pushCost(@RequestBody CheckVO checkVO) {
        return service.pushCost(checkVO);
    }
    @ApiOperation("导出")
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("storeName");
        fuzzyFields.add("employeeName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));

        List<OrgVO> orgVOList = null;
        if(!param.getParams().containsKey("orgId")){//PC端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            //普通组织 id
            List<Long> commonOrgIds = new ArrayList<>();
            //项目部 id
            List<Long> departmentIds = new ArrayList<>();
            orgVOList.stream().forEach(org -> {
                if(5 == org.getOrgType()) {
                    //项目部
                    departmentIds.add(org.getId());
                } else {
                    //普通组织
                    commonOrgIds.add(org.getId());
                }
            });
            if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                /** 要求主表有orgId字段，保存单据所属组织 */
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
            }
            /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        }
        param.setPageIndex(1);
        param.setPageSize(-1);

        List<CheckEntity> list = service.queryList(param);
        List<CheckVO> listVo = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(list)){
            listVo = BeanMapper.mapList(list, CheckVO.class);
            listVo.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
                vo.setCheckTypeName("1".equals(vo.getCheckType()) ? "发票报销类" : "非发票报销类");
            });

        }
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("checkExport.xlsx", beans, response);
    }


    @ApiOperation("参照")
    @RequestMapping(value = "/refCheckData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<CheckVO>> refCheckData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("billState", new Parameter(QueryParam.IN, Arrays.asList(1, 3)));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(null != _con.get("projectId")) {
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if(null != _con.get("contractId")) {
                param.getParams().put("contractId", new Parameter(QueryParam.EQ, _con.get("contractId")));
            }
        }

        IPage<CheckEntity> page = service.queryPage(param,false);
        IPage<CheckVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), CheckVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/targetCostCtrl", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> targetCostCtrl(@RequestBody CheckVO checkVO) {
        return CommonResponse.success("目标成本控制成功！", service.targetCostCtrl(checkVO));
    }

    @GetMapping(value = "/viewTargetCostCtrlInfo")
    @ResponseBody
    public CommonResponse<ParamsCheckVO> viewTargetCostCtrlInfo(@RequestParam(value = "id") Long id) {
        return CommonResponse.success("目标成本控制成功！", service.viewTargetCostCtrlInfo(id));
    }
    /**
     * 单据管控-
     * @return
     */
    @RequestMapping(value = "/checkParams", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ParamsCheckVO> checkParams(@RequestBody CheckVO checkVO) {
        ParamsCheckVO paramsCheckVO = service.checkParams(checkVO,null);
        return CommonResponse.success("参数校验成功！",paramsCheckVO );
    }
    /**
     * 磅单验收
     * @return
     */
    @RequestMapping(value = "/queryDetailWeigh", method=RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CheckVO> queryDetailWeigh(@RequestBody CheckVO vo) {
        CheckVO checkVO = service.queryDetailWeigh(vo);
        return CommonResponse.success("参数校验成功！",checkVO );
    }
}
