package com.ejianc.business.promaterial.plan.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 单项采购计划子表
 * 
 * @author generator
 * 
 */
 @TableName("ejc_promaterial_single_plan_detail")
public class SinglePlanDetailEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="plan_id")
    private Long planId; // 主表主键
    @TableField(value="material_category_id")
    private Long materialCategoryId; // 物资分类Id
    @TableField(value="material_category_name")
    private String materialCategoryName; // 物资分类名称
    @TableField(value="material_id")
    private Long materialId; // 物料Id
    @TableField(value="material_name")
    private String materialName; // 物料名称
    @TableField(value="material_code")
    private String materialCode; // 物料编码
    @TableField(value="spec")
    private String spec; // 规格型号
    @TableField(value="unit")
    private String unit; // 计量单位
    @TableField(value="unit_id")
    private Long unitId; // 计量单位Id
    @TableField(value="nums")
    private BigDecimal nums; // 需用数量
    @TableField(value="source_type")
    private Long sourceType; // 来源类型 0：总计划，1：月计划 2:物料档案
    @TableField(value="source_id")
    private Long sourceId; // 来源Id
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="check_num")
    private BigDecimal checkNum; // 累计进场数量
    @TableField(value="occupy_nums")
    private BigDecimal occupyNums; // 占用数量
    @TableField(value="actual_nums")
    private BigDecimal actualNums; // 实际数量
    @TableField(value="surplus_nums")
    private BigDecimal surplusNums; // 剩余数量
    @TableField(value="plan_surplus_nums")
    private BigDecimal planSurplusNums; // 计划剩余数量（总计划/月计划-数量）
    @TableField(value="price")
    private BigDecimal price; // 单价(无税)
    @TableField(value="construction")
    private String construction; // 使用部位
    @TableField(value="plan_date")
    private Date planDate; // 需用日期              -- 到货日期
    @TableField(value="first_state")
    private Integer firstState; // 是否为一级采购目录清单：0-否，1-是
    @TableField(value="texture")
    private String texture; // 材质
    @TableField(value="standard")
    private String standard; // 技术标准
    @TableField(value="plan_code")
    private String planCode; // 需用计划编号
    @TableField(value="buyer_id")
    private Long buyerId; // 采购员
    @TableField(value="buyer_name")
    private String buyerName; // 采购员名称
    @TableField(value="tax_price")
    private BigDecimal taxPrice; // 单价
    @TableField(value="tax_rate")
    private BigDecimal taxRate; // 税率
    @TableField(value="mny")
    private BigDecimal mny; // 金额(无税)
    @TableField(value="tax_mny")
    private BigDecimal taxMny; // 金额


    public Long getPlanId() {
        return planId;
    }

    public void setPlanId(Long planId) {
        this.planId = planId;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }
    public Long getUnitId() {
        return unitId;
    }

    public void setUnitId(Long unitId) {
        this.unitId = unitId;
    }
    public BigDecimal getNums() {
        return nums;
    }

    public void setNums(BigDecimal nums) {
        this.nums = nums;
    }
    public Long getSourceType() {
        return sourceType;
    }

    public void setSourceType(Long sourceType) {
        this.sourceType = sourceType;
    }
    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public BigDecimal getCheckNum() {
        return checkNum;
    }

    public void setCheckNum(BigDecimal checkNum) {
        this.checkNum = checkNum;
    }
    public BigDecimal getOccupyNums() {
        return occupyNums;
    }

    public void setOccupyNums(BigDecimal occupyNums) {
        this.occupyNums = occupyNums;
    }
    public BigDecimal getActualNums() {
        return actualNums;
    }

    public void setActualNums(BigDecimal actualNums) {
        this.actualNums = actualNums;
    }
    public BigDecimal getSurplusNums() {
        return surplusNums;
    }

    public void setSurplusNums(BigDecimal surplusNums) {
        this.surplusNums = surplusNums;
    }
    public BigDecimal getPlanSurplusNums() {
        return planSurplusNums;
    }

    public void setPlanSurplusNums(BigDecimal planSurplusNums) {
        this.planSurplusNums = planSurplusNums;
    }
    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }
    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
    public Date getPlanDate() {
        return planDate;
    }

    public void setPlanDate(Date planDate) {
        this.planDate = planDate;
    }
    public Integer getFirstState() {
        return firstState;
    }

    public void setFirstState(Integer firstState) {
        this.firstState = firstState;
    }

    public String getTexture() {
        return texture;
    }

    public void setTexture(String texture) {
        this.texture = texture;
    }

    public String getStandard() {
        return standard;
    }

    public void setStandard(String standard) {
        this.standard = standard;
    }

    public String getPlanCode() {
        return planCode;
    }

    public void setPlanCode(String planCode) {
        this.planCode = planCode;
    }

    public Long getBuyerId() {
        return buyerId;
    }

    public void setBuyerId(Long buyerId) {
        this.buyerId = buyerId;
    }

    public String getBuyerName() {
        return buyerName;
    }

    public void setBuyerName(String buyerName) {
        this.buyerName = buyerName;
    }

    public BigDecimal getTaxPrice() {
        return taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxRate() {
        return taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public BigDecimal getMny() {
        return mny;
    }

    public void setMny(BigDecimal mny) {
        this.mny = mny;
    }

    public BigDecimal getTaxMny() {
        return taxMny;
    }

    public void setTaxMny(BigDecimal taxMny) {
        this.taxMny = taxMny;
    }
}
