package com.ejianc.business.promaterial.utils;

import com.alibaba.fastjson.JSONArray;

import java.util.List;

public class PageUtil<T> {

    /**
     * List转Page
     * @param list 所有记录
     * @param current 当前页，默认 1
     * @param size 当前分页总页数
     * @param <T> 泛型
     * @return
     */
    public static <T> List<T> listToPage(List<T> list, int current, int size) {
        if(size == -1){
            return list;
        }
        current = (current - 1) * size;// 每页的起始索引
        Integer total = list.size();// 记录总数
        if (current + size > total) {
            return list.subList(current, total);
        } else {
            return list.subList(current, total > size ? current + size : current + total);
        }
    }

    /**
     * JSONArray转Page
     * @param array 所有记录
     * @param current 当前页，默认 1
     * @param size 当前分页总页数
     * @return
     */
    public static JSONArray listToPage(JSONArray array, int current, int size) {
        if(size == -1){
            return array;
        }
        current = (current - 1) * size;// 每页的起始索引
        Integer total = array.size();// 记录总数
        if (current + size > total) {
            return new JSONArray(array.subList(current, total));
        } else {
            return new JSONArray(array.subList(current, total > size ? current + size : current + total));
        }
    }

    /**
     * 获取页数
     * @param total
     * @param size
     * @return
     */
    public static Integer getPages(Integer total, Integer size) {
        Integer pages = 0;
        if (size == -1) {
            pages = 1;
        } else if (total % size > 0) {
            pages = (total / size) + 1;
        } else if (total % size == 0) {
            pages = total / size;
        }
        return pages;
    }
}