/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.financeintegration.PMPayApply.api.IPMZZCRKDApi;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.CheckImgDetailEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.ICheckStoreService;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.electronicFence.service.IElectronicFenceConfigService;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="check")
public class CheckBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IAttachmentApi attachmentApi;
    private final String OPERATE = "XHC_CHECK_SYNC";
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IPMZZCRKDApi ipmzzcrkdApi;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "BT220215000000006";
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/materialCheck/deleteCheck";
    private final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/materialCheck/saveCheck";
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private IElectronicFenceConfigService electronicFenceConfigService;
    @Autowired
    private ICheckStoreService storeService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    private String checkHasAbnormalImg(CheckEntity e) {
        if (CollectionUtils.isNotEmpty((Collection)e.getCheckImgList().stream().filter(item -> Integer.valueOf(0).equals(item.getAbnormalImgFlag())).collect(Collectors.toList()))) {
            return "\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u9a8c\u6536\u5355\u5b58\u5728\u5f02\u5e38\u7167\u7247\uff01";
        }
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(e.getId(), null, "sceneImgs", null);
        if (!fileResp.isSuccess()) {
            return "\u83b7\u53d6\u4e0a\u4f20\u56fe\u7247\u5217\u8868\u5931\u8d25\uff0c\u64cd\u4f5c\u5931\u8d25\uff01";
        }
        List attachs = (List)fileResp.getData();
        if (!CollectionUtils.isNotEmpty((Collection)attachs)) {
            List imgIds = attachs.stream().map(AttachmentVO::getId).collect(Collectors.toList());
            List<CheckImgDetailEntity> imgList = e.getCheckImgList();
            if (CollectionUtils.isEmpty(imgList)) {
                return "\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u9a8c\u6536\u5355\u5b58\u5728\u5f02\u5e38\u7167\u7247\uff01";
            }
            List detailImgIds = imgList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            imgIds.removeAll(detailImgIds);
            if (CollectionUtils.isNotEmpty(imgIds)) {
                return "\u64cd\u4f5c\u5931\u8d25\uff0c\u5f53\u524d\u9a8c\u6536\u5355\u5b58\u5728\u5f02\u5e38\u7167\u7247\uff01";
            }
        }
        return null;
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        ContractEntity contractEntity = null;
        if (checkEntity.getContractId() != null) {
            contractEntity = (ContractEntity)((Object)this.contractService.selectById(checkEntity.getContractId()));
        }
        checkEntity.setCheckState(1);
        if (checkEntity.getStoreType() == 0) {
            this.storeService.pushToCheckStore(checkEntity);
        }
        if (checkEntity.getStoreType() == 1) {
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(checkEntity.getStoreId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            storeManageVO.setSourceId(checkEntity.getId());
            ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
            for (int i = 0; i < checkEntity.getCheckDetailList().size(); ++i) {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93, (Integer)0);
                this.getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO, contractEntity);
                flowVOS.add(flowVO);
            }
            storeManageVO.setFlowVOList(flowVOS);
            ArrayList<FlowVO> flowOutS = new ArrayList<FlowVO>();
            for (int i = 0; i < checkEntity.getCheckDetailList().size(); ++i) {
                FlowVO flowVO = StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u51fa\u5e93, (Integer)0);
                this.getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO, contractEntity);
                flowOutS.add(flowVO);
            }
            storeManageVO.setStraightOutFlowVOList(flowOutS);
            String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
            this.logger.info("\u6d88\u8017\u6750\u76f4\u5165\u76f4\u51fa\u53c2\u6570\uff1a" + stringInfo);
            CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
            this.logger.info("\u6d4b\u8bd5\u62a5\u951903" + response.getMsg());
            if (!response.isSuccess()) {
                this.logger.info("\u6d4b\u8bd5\u62a5\u951901");
                throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f" + response.getMsg());
            }
        }
        return CommonResponse.success();
    }

    private void getFlow(CheckEntity checkEntity, CheckDetailEntity t, FlowVO flowVO, ContractEntity contractEntity) {
        flowVO.setConsumableFlag(t.getConsumableFlag());
        flowVO.setProjectId(checkEntity.getProjectId());
        flowVO.setTaxRate(t.getTaxRate());
        flowVO.setProjectName(checkEntity.getProjectName());
        flowVO.setParentOrgId(checkEntity.getParentOrgId());
        flowVO.setParentOrgName(checkEntity.getParentOrgName());
        flowVO.setOrgId(checkEntity.getOrgId());
        flowVO.setOrgName(checkEntity.getOrgName());
        flowVO.setStoreId(checkEntity.getProjectId());
        flowVO.setStoreName(checkEntity.getProjectName());
        flowVO.setEmployeeId(checkEntity.getEmployeeId());
        flowVO.setEmployeeName(checkEntity.getEmployeeName());
        flowVO.setMaterialType(checkEntity.getCheckType());
        flowVO.setMaterialTypeName(checkEntity.getCheckTypeName());
        flowVO.setSupplierId(checkEntity.getSupplierId());
        flowVO.setSupplierName(checkEntity.getSupplierName());
        flowVO.setPurchaseContractId(checkEntity.getContractId());
        flowVO.setPurchaseContractName(checkEntity.getContractName());
        flowVO.setMaterialCategoryId(t.getMaterialTypeId());
        flowVO.setMaterialCategoryName(t.getMaterialTypeName());
        flowVO.setMaterialId(t.getMaterialId());
        flowVO.setMaterialName(t.getMaterialName());
        flowVO.setMaterialCode(t.getMaterialCode());
        flowVO.setMaterialSpec(t.getSpec());
        flowVO.setMaterialUnitId(t.getUnitId());
        flowVO.setMaterialUnitName(t.getUnit());
        flowVO.setCusDef8(null != t.getDeliveryDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)t.getDeliveryDate()) : null);
        flowVO.setTaxPrice(t.getCheckTaxPrice());
        flowVO.setPrice(t.getCheckPrice());
        flowVO.setNum(t.getCheckNum());
        flowVO.setTaxMny(t.getCheckTaxMny());
        flowVO.setMny(t.getCheckMny());
        flowVO.setTax(t.getTaxMny());
        flowVO.setPickUnitId(checkEntity.getSubSupplierId());
        flowVO.setPickUnitName(checkEntity.getSubSupplierName());
        flowVO.setPickContractId(checkEntity.getSubContractId());
        flowVO.setPickContractName(checkEntity.getSubContractName());
        flowVO.setSourceId(checkEntity.getId());
        flowVO.setSourceDetailId(t.getId());
        flowVO.setSourceBillCode(checkEntity.getBillCode());
        flowVO.setSourceBillDate(checkEntity.getCheckDate());
        flowVO.setSourceBillRemark(checkEntity.getMemo());
        flowVO.setSourceBillDetailRemark(t.getMemo());
        flowVO.setSourceBillTypeName("\u6750\u6599\u9a8c\u6536");
        flowVO.setSourceBillTypeCode(BILL_TYPE);
        flowVO.setSourceType(checkEntity.getSourceType());
        flowVO.setPickType(checkEntity.getSubOutType());
        flowVO.setLicensePlate(checkEntity.getLicensePlate());
        if (checkEntity.getSubOutType() != null && checkEntity.getSubOutType() == 1) {
            flowVO.setPickTypeName("\u5185\u90e8\u9886\u6599");
        }
        if (checkEntity.getSubOutType() != null && checkEntity.getSubOutType() == 2) {
            flowVO.setPickTypeName("\u5206\u5305\u9886\u6599");
        }
        if (null != checkEntity.getContractId() && null != contractEntity) {
            List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
            Map sourceIdMap = contractDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map DetailMaterialIdMap = contractDetailList.stream().filter(e -> e.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
            Map DetailMaterialIdTypeMap = contractDetailList.stream().filter(e -> e.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
            ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)sourceIdMap.get(t.getSourceId()));
            if (null != contractDetailEntity) {
                flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                flowVO.setContractPrice(contractDetailEntity.getPrice());
            } else {
                contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdMap.get(t.getMaterialId()));
                if (null != contractDetailEntity) {
                    flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                    flowVO.setContractPrice(contractDetailEntity.getPrice());
                } else {
                    contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdTypeMap.get(t.getMaterialTypeId()));
                    if (null != contractDetailEntity) {
                        flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                        flowVO.setContractPrice(contractDetailEntity.getPrice());
                    } else {
                        flowVO.setContractTaxPrice(BigDecimal.ZERO);
                        flowVO.setContractPrice(BigDecimal.ZERO);
                    }
                }
            }
        }
        flowVO.setRowState(t.getRowState());
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        if (checkEntity.getStoreType() == 1) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(billId);
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setStoreId(checkEntity.getStoreId());
            storeManageVO.setSourceId(checkEntity.getId());
            storeManageVO.setSourceIdsForRollBack(ids);
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u76f4\u5165\u76f4\u51fa\u5165\u5e93);
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
            this.logger.info("\u6d88\u8017\u6750\u64a4\u56de\u53c2\u6570\uff1a" + stringInfo);
            CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)response.getMsg());
            }
            this.logger.info("xhc\u63a8\u9001\u4ed3\u5e93\u6210\u529f:" + response.getMsg());
        }
        return CommonResponse.success();
    }
}

