/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.pro.income.api.IProincomeContractApi;
import com.ejianc.business.pro.income.vo.ContractRegisterVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.promaterial.check.bean.CheckDetailEntity;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.CheckWeighEntity;
import com.ejianc.business.promaterial.check.bean.ConcreteCheckEntity;
import com.ejianc.business.promaterial.check.mapper.CheckMapper;
import com.ejianc.business.promaterial.check.service.ICheckDetailService;
import com.ejianc.business.promaterial.check.service.ICheckImgDetailService;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.ICheckWeighService;
import com.ejianc.business.promaterial.check.service.IConcreteCheckService;
import com.ejianc.business.promaterial.check.vo.CheckDetailVO;
import com.ejianc.business.promaterial.check.vo.CheckVO;
import com.ejianc.business.promaterial.check.vo.CheckWeighTypeEnum;
import com.ejianc.business.promaterial.check.vo.CheckWeighVO;
import com.ejianc.business.promaterial.check.vo.WeighUnitEnum;
import com.ejianc.business.promaterial.contract.bean.ContractDetailEntity;
import com.ejianc.business.promaterial.contract.bean.ContractEntity;
import com.ejianc.business.promaterial.contract.enums.ChangeTypeEnum;
import com.ejianc.business.promaterial.contract.enums.PurchaseTypeEnum;
import com.ejianc.business.promaterial.contract.service.IContractDetailService;
import com.ejianc.business.promaterial.contract.service.IContractService;
import com.ejianc.business.promaterial.delivery.bean.DeliveryDetailEntity;
import com.ejianc.business.promaterial.delivery.bean.DeliveryEntity;
import com.ejianc.business.promaterial.delivery.service.IDeliveryDetailService;
import com.ejianc.business.promaterial.delivery.service.IDeliveryService;
import com.ejianc.business.promaterial.delivery.vo.DeliveryTypeEnum;
import com.ejianc.business.promaterial.enums.BillPushStatusEnum;
import com.ejianc.business.promaterial.order.bean.ConcreteOrderDetailEntity;
import com.ejianc.business.promaterial.order.service.IConcreteOrderDetailService;
import com.ejianc.business.promaterial.order.service.IOrderDetailService;
import com.ejianc.business.promaterial.pricelib.service.IPriceHistoryService;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceApiVO;
import com.ejianc.business.promaterial.pricelib.vo.MaterialCostPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceCheckTypeEnum;
import com.ejianc.business.promaterial.pricelib.vo.MaterialPriceHistoryApiVO;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.util.StoreManageUtil;
import com.ejianc.business.store.vo.FlowVO;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.enums.DocTypeEnum;
import com.ejianc.business.targetcost.vo.CostCtrlDetailVO;
import com.ejianc.business.targetcost.vo.CostCtrlVO;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.temporary.userecord.api.ITemporaryUseRecordApi;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private IPriceHistoryService priceHistoryService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IContractDetailService contractDetailService;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IConcreteOrderDetailService concreteOrderDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IWeighbillApi weighbillApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ICheckWeighService checkWeighService;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String CHECK_MNY_CODE = "P-2dnh8V0139";
    private static final String CHECK_SUB_MNY_CODE = "P-Tl9Zyr0141";
    private final String[] ALLOW_WEIGH_UNIT = new String[]{"\u5343\u514b", "\u516c\u65a4", "KG", "kg", "Kg", "T", "t", "\u5428"};
    @Autowired
    private IConcreteCheckService concreteCheckService;
    @Autowired
    private IProincomeContractApi proincomeContrantApi;
    @Autowired
    private ITemporaryUseRecordApi temporaryUseRecordApi;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private ICheckImgDetailService checkImgDetailService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private ICheckDetailService detailService;
    private static final String BILL_CODE = "XHC-CHECK-CODE";
    private final String OPERATE = "XHC_CHECK_SYNC";
    private static final String BILL_TYPE = "BT220215000000006";
    private static final String CHECK_PARAM_CODE = "P-44841Z56";
    private static final String CHECK_MNY_CON_CODE = "P-n01oAU0146";
    private static final String MNY_CHECK_PARAM_CODE = "P-89z9720001";
    private static final String CHECK_ORDER_PARAM_CODE = "P-J91EGy0002";

    @Override
    public CheckVO saveOrUpdate(CheckVO saveOrUpdateVO) {
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode(saveOrUpdateVO.getProjectShortName() + (String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        CheckEntity data = new CheckEntity();
        if (null != entity.getId()) {
            data = (CheckEntity)((Object)super.selectById((Serializable)entity.getId()));
        }
        Map<Long, CheckDetailEntity> dataMap = data.getCheckDetailList().stream().collect(Collectors.toMap(x -> x.getId(), x -> x));
        HashMap<Long, BigDecimal> numMap = new HashMap<Long, BigDecimal>();
        for (CheckDetailEntity detail : entity.getCheckDetailList()) {
            if ("del".equals(detail.getRowState())) {
                numMap.put(detail.getSourceId(), ComputeUtil.safeSub((BigDecimal)((BigDecimal)numMap.get(detail.getSourceId())), (BigDecimal)detail.getCheckNum()));
                continue;
            }
            BigDecimal num = detail.getCheckNum();
            if (dataMap.containsKey(detail.getId())) {
                num = ComputeUtil.safeSub((BigDecimal)detail.getCheckNum(), (BigDecimal)dataMap.get(detail.getId()).getCheckNum());
            }
            numMap.put(detail.getSourceId(), ComputeUtil.safeAdd((BigDecimal)((BigDecimal)numMap.get(detail.getSourceId())), (BigDecimal)num));
        }
        super.saveOrUpdate((Object)entity, false);
        if (MapUtils.isNotEmpty(numMap)) {
            this.orderDetailService.writeBackOccupyNum(numMap);
        }
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return vo;
    }

    @Override
    public Boolean delete(List<CheckVO> vos) {
        List ids = vos.stream().map(x -> x.getId()).collect(Collectors.toList());
        QueryParam param = new QueryParam();
        param.getParams().put("checkId", new Parameter("in", ids));
        List detailList = this.detailService.queryList(param);
        HashMap<Long, BigDecimal> numMap = new HashMap<Long, BigDecimal>();
        for (CheckDetailEntity detail : detailList) {
            numMap.put(detail.getSourceId(), ComputeUtil.safeSub((BigDecimal)((BigDecimal)numMap.get(detail.getSourceId())), (BigDecimal)detail.getCheckNum()));
        }
        super.removeByIds(ids, true);
        if (MapUtils.isNotEmpty(numMap)) {
            this.orderDetailService.writeBackOccupyNum(numMap);
        }
        return true;
    }

    @Override
    @Transactional
    public CheckVO saveOrUpdates(CheckVO saveOrUpdateVO, Boolean isControl) {
        OrgVO orgVO;
        CommonResponse orgResponse;
        if (!isControl.booleanValue() && saveOrUpdateVO.getId() != null) {
            CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
            Boolean isOldPush = false;
            if (checkEntity.getCheckType().equals("proMaterial-2")) {
                isOldPush = true;
            }
            if (!checkEntity.getCheckType().equals("proMaterial-2") && checkEntity.getAttrFlag().equals(1)) {
                isOldPush = true;
            }
            if (isOldPush.booleanValue()) {
                ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
                ExecutionVO executionVO = this.targetCost(checkEntity);
                totalExecutionVOList.add(executionVO.getTotalVO());
                CommonResponse responses = this.executionApi.aggDel(totalExecutionVOList);
                if (!responses.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u5220\u9664\u63a8\u9001\u5931\u8d25" + responses.getMsg());
                }
            }
        }
        if (StringUtils.isEmpty((String)saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
        }
        if (StringUtils.isEmpty((String)saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null && (orgResponse = this.iOrgApi.getOneById(saveOrUpdateVO.getOrgId())).isSuccess()) {
            orgVO = (OrgVO)orgResponse.getData();
            saveOrUpdateVO.setOrgCode(orgVO.getCode());
        }
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckEntity.class));
        if (!(isControl.booleanValue() || entity.getId() != null && entity.getId() != 0L)) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            if (null == entity.getCheckWeighType()) {
                entity.setCheckWeighType(CheckWeighTypeEnum.\u5426\u78c5\u5355\u9a8c\u6536.getCode());
            }
            if (null == entity.getAutomaticWeigh()) {
                entity.setAutomaticWeigh(1);
            }
        }
        entity.setSignStatus(0);
        entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        entity.setRelationFlag("0");
        entity.setProportionFlag("0");
        if (!isControl.booleanValue()) {
            if (null != entity.getId()) {
                this.checkImgDetailService.deleteByPid(entity.getId());
            }
            if (CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode().equals(entity.getCheckWeighType())) {
                ArrayList<CheckWeighEntity> checkWeighListDel = new ArrayList<CheckWeighEntity>();
                for (CheckWeighEntity checkWeighEntity : entity.getCheckWeighList()) {
                    if (!"del".equals(checkWeighEntity.getRowState())) continue;
                    checkWeighListDel.add(checkWeighEntity);
                }
                this.delWeighBill(checkWeighListDel);
            }
            if (entity.getStoreType() == 1) {
                entity.setPushCostMny(entity.getCheckDetailList().stream().filter(e -> 0 == e.getConsumableFlag() && e.getRowState() != "del").map(it -> it.getCheckMny()).reduce(BigDecimal.ZERO, BigDecimal::add));
                entity.setPushCostTaxMny(entity.getCheckDetailList().stream().filter(e -> 0 == e.getConsumableFlag() && e.getRowState() != "del").map(it -> it.getCheckTaxMny()).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            super.saveOrUpdate((Object)entity, false);
            if (CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode().equals(entity.getCheckWeighType())) {
                this.addOrUpdateWeighBill(entity.getCheckDetailList(), entity.getCheckWeighList());
            }
        } else {
            if (null == entity.getId()) {
                entity.setId(IdWorker.getId());
            }
            List<CheckDetailEntity> detailEntityList = entity.getCheckDetailList();
            ArrayList<CheckDetailEntity> detailEntityListNew = new ArrayList<CheckDetailEntity>();
            if (CollectionUtils.isNotEmpty(detailEntityList)) {
                for (CheckDetailEntity cdEntity : detailEntityList) {
                    if (null == cdEntity.getId()) {
                        cdEntity.setId(IdWorker.getId());
                    }
                    if ("del".equals(cdEntity.getRowState())) continue;
                    detailEntityListNew.add(cdEntity);
                }
                entity.setCheckDetailList(detailEntityListNew);
            }
        }
        if (entity.getSourceType() == 1 && !isControl.booleanValue()) {
            Integer checkStatus = 0;
            DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(entity.getDeliveryId()));
            LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
            lambdaQueryWrapper.eq(CheckDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
            List checkDetailEntityList = this.checkDetailService.list((Wrapper)lambdaQueryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)checkDetailEntityList)) {
                Map<Long, List<CheckDetailEntity>> checkMap = checkDetailEntityList.stream().collect(Collectors.groupingBy(CheckDetailEntity::getDeliveryDetailId));
                LambdaQueryWrapper lambdaDeliveryDetail = Wrappers.lambdaQuery();
                lambdaDeliveryDetail.eq(DeliveryDetailEntity::getDeliveryId, (Object)entity.getDeliveryId());
                List deliveryDetailEntityList = this.deliveryDetailService.list((Wrapper)lambdaDeliveryDetail);
                for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailEntityList) {
                    List<CheckDetailEntity> checkAllDetailEntityList = checkMap.get(deliveryDetailEntity.getId());
                    if (CollectionUtils.isNotEmpty(checkAllDetailEntityList)) {
                        BigDecimal checkNum = checkAllDetailEntityList.stream().map(CheckDetailEntity::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                        deliveryDetailEntity.setCheckNum(checkNum);
                    }
                    if (null != deliveryDetailEntity.getCheckNum()) continue;
                    deliveryDetailEntity.setCheckNum(BigDecimal.ZERO);
                }
                Boolean allCheck = deliveryDetailEntityList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
                Boolean anyCheck = deliveryDetailEntityList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getDeliveryNum()) == -1);
                if (allCheck.booleanValue()) {
                    checkStatus = 2;
                }
                if (anyCheck.booleanValue()) {
                    checkStatus = 1;
                }
                deliveryEntity.setCheckStatus(checkStatus);
                this.deliveryService.updateById((Object)deliveryEntity);
                this.deliveryDetailService.updateBatchById(deliveryDetailEntityList);
            }
            if (!DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(deliveryEntity.getDeliveryType())) {
                CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sourceId", deliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "XHC_CHECK_SYNC", BILL_TYPE);
                if (!updateSupplierStatus.booleanValue()) {
                    throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
                }
            }
        }
        if (!isControl.booleanValue()) {
            Long contractId = saveOrUpdateVO.getContractId();
            Integer attrFlag = saveOrUpdateVO.getAttrFlag();
            String string = saveOrUpdateVO.getCheckType();
            Boolean isPush = false;
            if (string.equals("proMaterial-2")) {
                isPush = true;
            }
            if (!string.equals("proMaterial-2") && attrFlag.equals(1)) {
                isPush = true;
            }
            if (isPush.booleanValue()) {
                ExecutionVO executionVO = this.targetCost(entity);
                this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
                CommonResponse response = this.executionApi.aggPush(executionVO);
                if (!response.isSuccess()) {
                    throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25:" + response.getMsg());
                }
            }
        }
        if (entity.getCheckType().equals("proMaterial-2")) {
            saveOrUpdateVO.setAttrFlag(Integer.valueOf(1));
        }
        if (saveOrUpdateVO.getAttrFlag().equals(1) && saveOrUpdateVO.getStoreType() == 1 && !isControl.booleanValue()) {
            this.saveCost(entity, 0);
        }
        CheckVO vo = (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
        return vo;
    }

    private void delWeighBill(List<CheckWeighEntity> checkWeighList) {
        ArrayList<WeighbillVO> upDateWeighBill = new ArrayList<WeighbillVO>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                weighbillVO.setCheckId(checkWeighEntity.getCheckId());
                weighbillVO.setCheckDetailId(checkWeighEntity.getId());
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(Integer.valueOf(0));
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            this.logger.info("\u4fdd\u5b58\u5220\u9664\u56de\u663e\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(upDateWeighBill));
            this.weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    private void addOrUpdateWeighBill(List<CheckDetailEntity> checkDetailList, List<CheckWeighEntity> checkWeighList) {
        ArrayList<WeighbillVO> upDateWeighBill = new ArrayList<WeighbillVO>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                if (CollectionUtils.isNotEmpty(checkDetailList)) {
                    for (CheckDetailEntity checkDetailEntity : checkDetailList) {
                        if (null == checkWeighEntity.getDeliveryDetailId() || !checkWeighEntity.getDeliveryDetailId().equals(checkDetailEntity.getDeliveryDetailId())) continue;
                        weighbillVO.setCheckId(checkDetailEntity.getCheckId());
                        weighbillVO.setCheckDetailId(checkDetailEntity.getId());
                        checkWeighEntity.setCheckDetailId(checkDetailEntity.getId());
                        checkWeighEntity.setCheckStatus(1);
                    }
                }
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(Integer.valueOf(1));
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            this.logger.info("\u65b0\u589e\u4fee\u6539\u66f4\u65b0\u9a8c\u6536\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(checkWeighList));
            this.checkWeighService.updateBatchById(checkWeighList);
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            this.logger.info("\u65b0\u589e\u4fee\u6539\u56de\u663e\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(upDateWeighBill));
            this.weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    private ExecutionVO targetCost(CheckEntity checkEntity) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList<DetailExecutionVO> detailList = new ArrayList<DetailExecutionVO>();
        totalVO.setSourceId(checkEntity.getId());
        totalVO.setTenantId(checkEntity.getTenantId());
        totalVO.setBillCode(checkEntity.getBillCode());
        totalVO.setBillType(BILL_TYPE);
        if (checkEntity.getCheckType().equals("proMaterial-1")) {
            totalVO.setBussinessType(BussinessTypeEnum.\u5927\u5b97\u6750\u9a8c\u6536\u5355.getCode());
        }
        if (checkEntity.getCheckType().equals("proMaterial-2")) {
            totalVO.setBussinessType(BussinessTypeEnum.\u5468\u8f6c\u6750\u9a8c\u6536\u5355.getCode());
        }
        if (checkEntity.getCheckType().equals("proMaterial-3")) {
            totalVO.setBussinessType(BussinessTypeEnum.\u96f6\u661f\u6750\u6599\u9a8c\u6536\u5355.getCode());
        }
        if (checkEntity.getCheckType().equals("proMaterial-4")) {
            totalVO.setBussinessType(null);
        }
        totalVO.setBillCategory(BillCategoryEnum.\u5165\u5e93.getCode());
        totalVO.setProjectId(checkEntity.getProjectId());
        totalVO.setOrgId(checkEntity.getOrgId());
        String url = null;
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((String)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        if (checkEntity.getContractId() == null) {
            url = frontendBaseHost + "ejc-promaterial-frontend/#/check/card?id=" + checkEntity.getId();
        }
        if (checkEntity.getContractId() != null) {
            url = frontendBaseHost + "ejc-promaterial-frontend/#/check/contractCard?id=" + checkEntity.getId();
        }
        totalVO.setLinkUrl(url);
        totalVO.setBillDate(checkEntity.getCheckDate() == null ? null : checkEntity.getCheckDate().toString());
        BigDecimal checkMoney = BigDecimal.ZERO;
        BigDecimal checkTaxMoney = BigDecimal.ZERO;
        for (CheckDetailEntity checkDetailEntity : checkEntity.getCheckDetailList()) {
            checkMoney = checkMoney.add(checkDetailEntity.getCheckMny());
            checkTaxMoney = checkTaxMoney.add(checkDetailEntity.getCheckTaxMny());
            DetailExecutionVO detailExecutionVO = new DetailExecutionVO();
            detailExecutionVO.setSourceId(Long.valueOf(checkDetailEntity.getId() == null ? IdWorker.getId() : checkDetailEntity.getId()));
            detailExecutionVO.setSourceBillId(checkEntity.getId());
            detailExecutionVO.setCategoryId(checkDetailEntity.getMaterialTypeId());
            detailExecutionVO.setCategoryName(checkDetailEntity.getMaterialTypeName());
            detailExecutionVO.setCategoryFlag(Boolean.valueOf(false));
            detailExecutionVO.setCode(checkDetailEntity.getMaterialCode());
            detailExecutionVO.setCategoryContainFlag(Boolean.valueOf(false));
            MaterialCategoryVO categoryVO = (MaterialCategoryVO)this.materialApi.queryCategoryById(checkDetailEntity.getMaterialTypeId()).getData();
            if (categoryVO == null) {
                detailExecutionVO.setCategoryInnerCode(null);
                detailExecutionVO.setCategoryCode(null);
            } else {
                detailExecutionVO.setCategoryInnerCode(categoryVO.getInnerCode());
                detailExecutionVO.setCategoryCode(categoryVO.getCode());
            }
            detailExecutionVO.setDocId(checkDetailEntity.getMaterialId());
            detailExecutionVO.setDocType(DocTypeEnum.\u7269\u6599\u6863\u6848.getCode());
            detailExecutionVO.setName(checkDetailEntity.getMaterialName());
            detailExecutionVO.setUnitId(checkDetailEntity.getUnitId());
            detailExecutionVO.setUnitName(checkDetailEntity.getUnit());
            detailExecutionVO.setSpec(checkDetailEntity.getSpec());
            detailExecutionVO.setNum(checkDetailEntity.getCheckNum());
            detailExecutionVO.setMoney(checkDetailEntity.getCheckMny());
            detailExecutionVO.setTaxMoney(checkDetailEntity.getCheckTaxMny());
            detailExecutionVO.setPrice(checkDetailEntity.getCheckPrice());
            detailExecutionVO.setTaxPrice(checkDetailEntity.getCheckTaxPrice());
            detailExecutionVO.setTaxRate(checkDetailEntity.getTaxRate());
            detailList.add(detailExecutionVO);
        }
        totalVO.setMoney(checkMoney);
        totalVO.setTaxMoney(checkTaxMoney);
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if (locked) {
                RedisTool.releaseLock((Jedis)jedis, (String)key, (String)OPERATE);
            }
        }
        finally {
            if (null != jedis) {
                jedis.close();
            }
        }
    }

    @Override
    @Transactional
    public void deletes(List<CheckVO> vos) {
        if (vos.size() > 1) {
            throw new BusinessException("\u9a8c\u6536\u5355\u4e0d\u5141\u8bb8\u6279\u91cf\u5220\u9664!");
        }
        CheckVO checkVO = vos.get(0);
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)checkVO.getId()));
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        List<CheckWeighEntity> checkWeighList = checkEntity.getCheckWeighList();
        DeliveryEntity deliveryEntity = (DeliveryEntity)((Object)this.deliveryService.selectById(checkEntity.getDeliveryId()));
        if (deliveryEntity != null) {
            List<DeliveryDetailEntity> deliveryDetailList = deliveryEntity.getDeliveryDetailList();
            Map checkDetailEntityMap = checkDetailList.stream().collect(Collectors.toMap(CheckDetailEntity::getDeliveryDetailId, Function.identity()));
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                if (!checkDetailEntityMap.containsKey(deliveryDetailEntity.getId())) continue;
                CheckDetailEntity checkDetailEntity = (CheckDetailEntity)((Object)checkDetailEntityMap.get(deliveryDetailEntity.getId()));
                deliveryDetailEntity.setCheckNum(deliveryDetailEntity.getCheckNum().subtract(checkDetailEntity.getCheckNum()));
            }
            Boolean allCheck = deliveryDetailList.stream().allMatch(e -> e.getCheckNum().compareTo(e.getDeliveryNum()) > -1);
            Boolean anyCheck = deliveryDetailList.stream().anyMatch(e -> e.getCheckNum().compareTo(BigDecimal.ZERO) == 1 && e.getCheckNum().compareTo(e.getDeliveryNum()) == -1);
            Integer checkStatus = 0;
            if (allCheck.booleanValue()) {
                checkStatus = 2;
            }
            if (anyCheck.booleanValue()) {
                checkStatus = 1;
            }
            deliveryEntity.setCheckStatus(checkStatus);
            this.deliveryService.updateById((Object)deliveryEntity);
            this.deliveryDetailService.updateBatchById(deliveryDetailList);
            if (!DeliveryTypeEnum.\u81ea\u5236\u9001\u8d27\u5355.getCode().equals(deliveryEntity.getDeliveryType())) {
                CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("sourceId", deliveryEntity.getSourceId());
                map.put("checkStatus", checkStatus);
                map.put("systemId", ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(map);
                Boolean updateSupplierStatus = this.deliveryService.updateSupplierStatus(deliveryEntity.getId(), dataInfo, "/ejc-supbusiness-web/openapi/materialDelivery/saveMaterialDeliveryState", RequestMethod.POST, deliveryEntity.getSupplierId().toString(), "XHC_CHECK_SYNC", BILL_TYPE);
                if (!updateSupplierStatus.booleanValue()) {
                    throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
                }
            }
        }
        if (CollectionUtils.isNotEmpty(vos)) {
            CommonResponse response;
            ArrayList<TotalExecutionVO> totalExecutionVOList = new ArrayList<TotalExecutionVO>();
            for (CheckVO checkVO1 : vos) {
                CheckEntity checkEntity1 = (CheckEntity)((Object)super.selectById((Serializable)checkVO1.getId()));
                ExecutionVO executionVO = this.targetCost(checkEntity1);
                totalExecutionVOList.add(executionVO.getTotalVO());
            }
            Boolean isOldPush = false;
            if (checkEntity.getCheckType().equals("proMaterial-2")) {
                isOldPush = true;
            }
            if (!checkEntity.getCheckType().equals("proMaterial-2") && checkEntity.getAttrFlag().equals(1)) {
                isOldPush = true;
            }
            this.logger.info("\u76ee\u6807\u6210\u672c\u5220\u9664\u6570\u636e" + JSON.toJSONString(totalExecutionVOList));
            if (isOldPush.booleanValue() && !(response = this.executionApi.aggDel(totalExecutionVOList)).isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25" + response.getMsg());
            }
        }
        if (checkEntity.getCheckType().equals("proMaterial-2")) {
            checkEntity.setAttrFlag(1);
        }
        if (checkEntity.getAttrFlag().equals(1) && checkEntity.getStoreType() == 1) {
            CommonResponse stringCommonResponse = this.costDetailApi.deleteSubject(checkEntity.getId());
            this.logger.info("\u7ed3\u679c" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
        this.delWeighBill(checkWeighList);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean pushBillToSupCenter(String datInfo, Long supplierId, Long sourceId, String billTypeCode, CooperateVO cooperate, String url) {
        boolean locked = false;
        boolean syncFlag = false;
        Jedis jedis = this.jedisPool.getResource();
        String key = billTypeCode + "::" + sourceId.toString();
        try {
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"XHC_CHECK_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff0c\u5355\u636e\u9501\u83b7\u53d6\u5931\u8d25\uff01");
                this.releaseLock(jedis, false, key, "XHC_CHECK_SYNC");
                boolean bl = false;
                return bl;
            }
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("transData", datInfo);
            CommonResponse fileResp = this.attachmentApi.queryListBySourceId(sourceId, null, null, null);
            if (fileResp.isSuccess()) {
                HashMap files = new HashMap();
                List fileList = (List)fileResp.getData();
                this.logger.info("\u5411\u4f9b\u5e94\u5546-{}\u63a8\u9001\u8ba1\u91cf\u5355\u636e\u53c2\u6570-{}", (Object)supplierId, (Object)JSONObject.toJSONString(paramMap));
                CommonResponse syncReqResp = this.systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(url, paramMap, supplierId.toString(), files);
                if (syncReqResp.isSuccess()) {
                    CommonResponse billPushResp = (CommonResponse)JSONObject.parseObject((String)((String)syncReqResp.getData()), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        this.logger.error("\u4f9b\u65b9id-{}\u5904\u7406\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u5931\u8d25, {}", new Object[]{supplierId, sourceId, billPushResp.getMsg()});
                    }
                } else {
                    this.logger.error("\u53d1\u9001\u8bf7\u6c42\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{}\u5931\u8d25, {}", new Object[]{sourceId, supplierId, syncReqResp.getMsg()});
                }
            } else {
                this.logger.error("\u83b7\u53d6\u9a8c\u6536\u5355\u636eid-{}\u5bf9\u5e94\u9644\u4ef6\u4fe1\u606f\u5931\u8d25, {}", (Object)sourceId, (Object)fileResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u63a8\u9001\u9a8c\u6536\u5355\u636eid-{}\u7ed9\u4f9b\u65b9id-{} \u5f02\u5e38\uff0c", new Object[]{sourceId, supplierId, e});
        }
        finally {
            this.releaseLock(jedis, locked, key, "XHC_CHECK_SYNC");
        }
        return syncFlag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;
        Jedis jedis = null;
        boolean locked = false;
        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map mp = (Map)JSONObject.parseObject((String)nameSourceTypeMapping, Map.class);
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)((Object)billId)));
        checkEntity.setSupOperateTime(supOperateTime);
        checkEntity.setSupOperatorName(supOperatorName);
        checkEntity.setSupOperatorPhone(supOperatorPhone);
        checkEntity.setSupOperatorUserCode(supOperatorUserCode);
        String key = "BT220215000000006::" + checkEntity.getId().toString();
        try {
            jedis = this.jedisPool.getResource();
            locked = RedisTool.tryLock((Jedis)jedis, (String)key, (String)"XHC_CHECK_SYNC", (int)600);
            if (!locked) {
                this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25\uff01", (Object)checkEntity.getId());
                this.releaseLock(jedis, false, key, "XHC_CHECK_SYNC");
                String string = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u52a0\u9501\u5931\u8d25";
                return string;
            }
            Map attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest)request, mp, BILL_TYPE, authority, checkEntity.getId().toString());
            ArrayList attchIdsList = new ArrayList();
            for (List attachIds : attachIdsMap.values()) {
                if (!CollectionUtils.isNotEmpty((Collection)attachIds)) continue;
                attchIdsList.addAll(attachIds);
            }
            checkEntity.setAttachIds(attchIdsList);
            checkEntity.setSignStatus(1);
            super.saveOrUpdate((Object)checkEntity, false);
        }
        catch (Exception e) {
            this.logger.error("\u5355\u636eid-{}\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5f02\u5e38\uff0c", (Object)checkEntity.getId(), (Object)e);
            msg = "\u5355\u636e\u7b7e\u5b57\u4fe1\u606f\u56de\u5199\u5931\u8d25\uff01";
        }
        finally {
            this.releaseLock(jedis, locked, key, "XHC_CHECK_SYNC");
        }
        return msg;
    }

    @Override
    public CheckVO getRateAndPrice(CheckVO checkVO) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(checkVO.getContractId()));
        LambdaQueryWrapper lambdaContractDetail = Wrappers.lambdaQuery();
        lambdaContractDetail.eq(ContractDetailEntity::getContractId, (Object)checkVO.getContractId());
        lambdaContractDetail.eq(ContractDetailEntity::getMaterialId, (Object)checkVO.getMaterialId());
        ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)this.contractDetailService.getOne((Wrapper)lambdaContractDetail));
        if (contractDetailEntity != null) {
            checkVO.setCheckPrice(contractDetailEntity.getPrice());
            checkVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
            checkVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
            checkVO.setContractNumsSum(contractDetailEntity.getNum());
            checkVO.setMemo(contractDetailEntity.getMemo());
            return checkVO;
        }
        LambdaQueryWrapper lambdaContractType = Wrappers.lambdaQuery();
        lambdaContractType.eq(ContractDetailEntity::getContractId, (Object)checkVO.getContractId());
        lambdaContractType.eq(ContractDetailEntity::getMaterialTypeId, (Object)checkVO.getMaterialTypeId());
        lambdaContractType.isNull(ContractDetailEntity::getMaterialId);
        ContractDetailEntity contractTypeEntity = (ContractDetailEntity)((Object)this.contractDetailService.getOne((Wrapper)lambdaContractType));
        if (contractTypeEntity != null) {
            checkVO.setCheckPrice(contractTypeEntity.getPrice());
            checkVO.setCheckTaxPrice(contractTypeEntity.getDetailTaxPrice());
            checkVO.setTaxRate(contractTypeEntity.getDetailTaxRate());
            checkVO.setContractNumsSum(contractTypeEntity.getNum());
            checkVO.setMemo(contractTypeEntity.getMemo());
            return checkVO;
        }
        checkVO.setTaxRate(contractEntity.getTaxRate());
        return checkVO;
    }

    @Override
    public CheckVO hntgetRateAndPrice(Long sourceDetailId) {
        ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)this.contractDetailService.selectById(sourceDetailId));
        CheckVO checkVO = new CheckVO();
        if (contractDetailEntity != null) {
            checkVO.setCheckPrice(contractDetailEntity.getPrice());
            checkVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
            checkVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
            checkVO.setContractNumsSum(contractDetailEntity.getNum());
        }
        return checkVO;
    }

    @Override
    public CheckVO hntOrderRateAndPrice(Long sourceDetailId) {
        ConcreteOrderDetailEntity concreteOrderDetailEntity = (ConcreteOrderDetailEntity)((Object)this.concreteOrderDetailService.selectById(sourceDetailId));
        ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)this.contractDetailService.selectById(concreteOrderDetailEntity.getSourceDetailId()));
        CheckVO checkVO = new CheckVO();
        if (contractDetailEntity != null) {
            checkVO.setCheckPrice(contractDetailEntity.getPrice());
            checkVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
            checkVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
            checkVO.setContractNumsSum(contractDetailEntity.getNum());
        }
        return checkVO;
    }

    private String sendMsg(CheckEntity checkEntity, String subject, String content) {
        PushMsgParameter msgParameter = new PushMsgParameter();
        msgParameter.setContent(content);
        msgParameter.setSubject(subject);
        msgParameter.setMsgType("notice");
        msgParameter.setTenantId(checkEntity.getTenantId().toString());
        msgParameter.setSaveFlag(true);
        msgParameter.setSendUserId(InvocationInfoProxy.getUserid());
        msgParameter.setChannel(new String[]{"sys"});
        CommonResponse msgSendResp = this.pushMessageApi.pushMessage(msgParameter);
        if (!msgSendResp.isSuccess()) {
            return msgSendResp.getMsg();
        }
        return null;
    }

    @Override
    public CommonResponse<CheckVO> pushCost(CheckVO checkVO) {
        CheckEntity checkEntity = (CheckEntity)((Object)((CheckMapper)this.baseMapper).selectById(checkVO.getId()));
        if (CollectionUtils.isNotEmpty((Collection)checkVO.getCheckDetailList())) {
            List checkDetailEntityList = BeanMapper.mapList((Iterable)checkVO.getCheckDetailList(), CheckDetailEntity.class);
            checkEntity.setCheckDetailList(checkDetailEntityList);
        }
        super.saveOrUpdate((Object)checkEntity, false);
        if (checkEntity.getAttrFlag().equals(1)) {
            this.costPush(checkEntity);
        }
        return CommonResponse.success((Object)BeanMapper.map((Object)((Object)checkEntity), CheckVO.class));
    }

    @Override
    public CheckVO getDetailListData(CheckVO checkVO) {
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(checkVO.getContractId()));
        List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
        List checkDetailListPC = checkVO.getCheckDetailList();
        Map contractDetailEntityMap = contractDetailList.stream().filter(t -> t.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
        Map contractDetailTypeEntityMap = contractDetailList.stream().filter(t -> t.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
        List materialIds = checkDetailListPC.stream().map(CheckDetailVO::getMaterialId).collect(Collectors.toList());
        for (CheckDetailVO checkDetailVO : checkDetailListPC) {
            ContractDetailEntity contractDetailEntity;
            if (contractDetailEntityMap.containsKey(checkDetailVO.getMaterialId())) {
                contractDetailEntity = (ContractDetailEntity)((Object)contractDetailEntityMap.get(checkDetailVO.getMaterialId()));
                checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                checkDetailVO.setContractNumsSum(contractDetailEntity.getNum());
                continue;
            }
            if (contractDetailTypeEntityMap.containsKey(checkDetailVO.getMaterialTypeId())) {
                contractDetailEntity = (ContractDetailEntity)((Object)contractDetailTypeEntityMap.get(checkDetailVO.getMaterialTypeId()));
                checkDetailVO.setCheckTaxPrice(contractDetailEntity.getDetailTaxPrice());
                checkDetailVO.setCheckPrice(contractDetailEntity.getPrice());
                checkDetailVO.setTaxRate(contractDetailEntity.getDetailTaxRate());
                checkDetailVO.setContractNumsSum(contractDetailEntity.getNum());
                continue;
            }
            checkDetailVO.setTaxRate(contractEntity.getTaxRate());
        }
        CommonResponse commonResponse = this.materialApi.queryMaterialItemByIds(materialIds);
        if (commonResponse.isSuccess()) {
            List materialVOList = (List)commonResponse.getData();
            Map materialVOMap = materialVOList.stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            for (CheckDetailVO checkDetailVO : checkDetailListPC) {
                if (!materialVOMap.containsKey(checkDetailVO.getMaterialId())) continue;
                MaterialVO materialVO = (MaterialVO)materialVOMap.get(checkDetailVO.getMaterialId());
                checkDetailVO.setSubjectId(materialVO.getSubjectId());
                checkDetailVO.setSubjectName(materialVO.getSubjectName());
            }
        }
        return checkVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)id));
        CheckVO checkVO = (CheckVO)BeanMapper.map((Object)((Object)checkEntity), CheckVO.class);
        Boolean executionFlag = false;
        CommonResponse response = new CommonResponse();
        if ("proMaterial-2".equals(checkVO.getCheckType())) {
            executionFlag = true;
        }
        if (!"proMaterial-2".equals(checkVO.getCheckType()) && checkVO.getAttrFlag() != null && checkVO.getAttrFlag() == 1) {
            executionFlag = true;
        }
        if (executionFlag.booleanValue()) {
            ExecutionVO executionVO = this.targetCost(checkEntity);
            this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
            response = this.executionApi.ctrlCheckVO(executionVO);
        }
        ParamsCheckVO paramsCheckVO = this.checkParams(checkVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO targetCostCtrl(CheckVO checkVO) {
        Boolean executionFlag = false;
        CommonResponse response = new CommonResponse();
        if ("proMaterial-2".equals(checkVO.getCheckType())) {
            executionFlag = true;
        }
        if (!"proMaterial-2".equals(checkVO.getCheckType()) && checkVO.getAttrFlag() != null && checkVO.getAttrFlag() == 1) {
            executionFlag = true;
        }
        if (executionFlag.booleanValue()) {
            CheckVO vo = this.saveOrUpdates(checkVO, true);
            ExecutionVO executionVO = this.targetCost((CheckEntity)((Object)BeanMapper.map((Object)vo, CheckEntity.class)));
            this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
            response = this.executionApi.ctrlCheckVO(executionVO);
            if (null != response && !response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u63a7\u5236\u5931\u8d25," + response.getMsg());
            }
        }
        ParamsCheckVO paramsCheckVO = this.checkParams(checkVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public void costPush(CheckEntity checkEntity) {
        this.logger.info("\u5f00\u59cbcostPush");
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkDetailList)) {
            for (CheckDetailEntity checkDetailEntity : checkDetailList) {
                if (null != checkDetailEntity.getSubjectId() && null != checkDetailEntity.getWbsId()) continue;
                newRelationFlag = "0";
                break;
            }
        }
        if (ListUtil.isEmpty(checkDetailList)) {
            newRelationFlag = "0";
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{checkEntity.getId()});
        updateWrapper.set(CheckEntity::getRelationFlag, (Object)newRelationFlag);
        super.update((Wrapper)updateWrapper);
        this.saveCost(checkEntity, 1);
    }

    private void saveCost(CheckEntity checkEntity, Integer effectiveStatus) {
        ArrayList<CostDetailVO> costDetailVOList = new ArrayList<CostDetailVO>();
        List<CheckDetailEntity> checkDetailList = checkEntity.getCheckDetailList();
        int a = 0;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(checkDetailList)) {
            for (CheckDetailEntity checkDetailEntity : checkDetailList) {
                if (checkEntity.getStoreType() != 1 || checkDetailEntity.getConsumableFlag() != 0) continue;
                this.logger.info("\u9a8c\u6536\u660e\u7ec6\u5df2\u63a8\u9001  " + ++a + "  \u6761");
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(checkDetailEntity.getSubjectId());
                costDetailVO.setSubjectCode(checkDetailEntity.getSubjectCode());
                costDetailVO.setSubjectName(checkDetailEntity.getSubjectName());
                costDetailVO.setWbsId(checkDetailEntity.getWbsId());
                costDetailVO.setWbsCode(checkDetailEntity.getWbsCode());
                costDetailVO.setWbsName(checkDetailEntity.getWbsName());
                costDetailVO.setSourceId(checkEntity.getId());
                costDetailVO.setSourceDetailId(checkDetailEntity.getId());
                costDetailVO.setHappenTaxMny(checkDetailEntity.getCheckTaxMny());
                costDetailVO.setHappenMny(checkDetailEntity.getCheckMny());
                costDetailVO.setNum(checkDetailEntity.getCheckNum());
                costDetailVO.setHappenDate(checkEntity.getCheckDate());
                costDetailVO.setCreateUserName(this.sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("CHECK");
                costDetailVO.setSourceTabType("CHECK_DETAIL");
                costDetailVO.setProjectId(checkEntity.getProjectId());
                costDetailVO.setSourceBillCode(checkEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.\u6750\u6599\u9a8c\u6536\u5355.getTypeName());
                costDetailVO.setMaterialId(checkDetailEntity.getMaterialId());
                costDetailVO.setMaterialName(checkDetailEntity.getMaterialName());
                costDetailVO.setMaterialCode(checkDetailEntity.getMaterialCode());
                costDetailVO.setMaterialTypeId(checkDetailEntity.getMaterialTypeId());
                costDetailVO.setMaterialTypeName(checkDetailEntity.getMaterialTypeName());
                costDetailVO.setUnit(checkDetailEntity.getUnit());
                costDetailVO.setUnitId(checkDetailEntity.getUnitId());
                costDetailVO.setSpec(checkDetailEntity.getSpec());
                String url = null;
                if (checkEntity.getContractId() == null) {
                    url = "/ejc-promaterial-frontend/#/check/card?id=" + checkEntity.getId();
                }
                if (checkEntity.getContractId() != null) {
                    url = "/ejc-promaterial-frontend/#/check/contractCard?id=" + checkEntity.getId();
                }
                costDetailVO.setSourceBillUrl(url);
                costDetailVO.setEffectiveStatus(effectiveStatus);
                costDetailVOList.add(costDetailVO);
            }
        }
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            this.logger.info("\u63a8\u9001\u6570\u636e--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse stringCommonResponse = this.costDetailApi.saveSubject(costDetailVOList);
            this.logger.info("\u63a8\u9001\u7ed3\u679c--------" + JSONObject.toJSONString((Object)stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    public List<ParamsCheckVO> checkParamsCheckDetailNum(CheckVO vo) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        List checkDetailList = vo.getCheckDetailList();
        HashMap<Long, CheckDetailVO> checkDetailVOMap = new HashMap<Long, CheckDetailVO>();
        for (CheckDetailVO checkDetailVO : checkDetailList) {
            if (!checkDetailVOMap.containsKey(checkDetailVO.getMaterialId())) {
                checkDetailVOMap.put(checkDetailVO.getMaterialId(), checkDetailVO);
                continue;
            }
            ((CheckDetailVO)checkDetailVOMap.get(checkDetailVO.getMaterialId())).setCheckNum(((CheckDetailVO)checkDetailVOMap.get(checkDetailVO.getMaterialId())).getCheckNum().add(checkDetailVO.getCheckNum()));
        }
        List<Long> materialIds = checkDetailList.stream().filter(e -> !"del".equals(e.getRowState())).map(CheckDetailVO::getMaterialId).distinct().collect(Collectors.toList());
        List<CheckDetailVO> detail = ((CheckMapper)this.baseMapper).getCheckDetail(vo.getProjectId(), materialIds, vo.getId());
        Map<Long, CheckDetailVO> detailMaterialMap = detail.stream().collect(Collectors.toMap(CheckDetailVO::getMaterialId, item -> item, (v1, v2) -> v2));
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_ORDER_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u5165\u5e93\u6570\u91cf\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (CollectionUtils.isNotEmpty(detailMaterialMap.values())) {
                        for (CheckDetailVO detailVO : checkDetailVOMap.values()) {
                            BigDecimal comNum;
                            BigDecimal num = detailMaterialMap.containsKey(detailVO.getMaterialId()) ? detailMaterialMap.get(detailVO.getMaterialId()).getCheckNum() : BigDecimal.ZERO;
                            BigDecimal totalNum = ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)detailVO.getCheckNum()).setScale(4, 4);
                            BigDecimal bigDecimal = comNum = detailMaterialMap.containsKey(detailVO.getMaterialId()) ? detailMaterialMap.get(detailVO.getMaterialId()).getOrderNumsSum() : BigDecimal.ZERO;
                            if (totalNum.compareTo(comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)comNum, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4)) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + "+" + detailVO.getSpec());
                            paramsCheckDsVO.setWarnName("\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u914d\u9001\u5355\u6570\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(detailVO.getCheckNum().setScale(4, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5165\u5e93\u6570\u91cf\uff1a").append(totalNum.setScale(4, 4)).append("\uff0c\u914d\u9001\u5355\u6570\u91cf*").append(roleValue).append("%:").append(comNum.setScale(4, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalNum, (BigDecimal)comNum).setScale(4, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public ParamsCheckVO checkParams(CheckVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        if (null != vo.getContractId()) {
            ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(vo.getContractId()));
            paramsCheckVOS.addAll(this.checkParamsMny(contractEntity, vo));
        }
        paramsCheckVOS.addAll(this.checkParamsCheckDetailNum(vo));
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    private List<ParamsCheckVO> checkParamsMny(ContractEntity contractEntity, CheckVO vo) {
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny();
        BigDecimal checkTaxMny = vo.getCheckAllTaxMny();
        BigDecimal allCheckTaxMny = BigDecimal.ZERO;
        List checkEntityList = new ArrayList();
        checkEntityList = null != vo.getId() ? super.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"contract_id", (Object)contractEntity.getId())).ne((Object)"id", (Object)vo.getId())) : super.list((Wrapper)new QueryWrapper().eq((Object)"contract_id", (Object)contractEntity.getId()));
        if (CollectionUtils.isNotEmpty(checkEntityList) && checkEntityList.size() > 0) {
            allCheckTaxMny = checkEntityList.stream().filter(e -> null != e.getCheckAllTaxMny()).map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        allCheckTaxMny = ComputeUtil.safeAdd((BigDecimal)checkTaxMny, (BigDecimal)allCheckTaxMny);
        this.logger.info("\u83b7\u53d6\u5408\u540c\u603b\u91d1\u989d\uff1a{}", (Object)contractTaxMny);
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(MNY_CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO billParamVO : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    this.logger.info("\u5408\u540c\u91d1\u989d*\u6bd4\u4f8b\u540e\u91d1\u989d\uff1a{}", (Object)comMny);
                    if (allCheckTaxMny.compareTo(comMny) <= 0) {
                        paramsCheckVO.setWarnType(paramsArray[0]);
                        paramsCheckVOList.add(paramsCheckVO);
                        return paramsCheckVOList;
                    }
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                    paramsCheckDsVO.setOrgName(billParamVO.getOrgName());
                    paramsCheckDsVO.setWarnItem("\u9a8c\u6536\u5355\u91d1\u989d\u8d85\u7269\u8d44\u91c7\u8d2d\u5408\u540c");
                    paramsCheckDsVO.setWarnName("\u9a8c\u6536\u5355\u91d1\u989d\u8d85\u7269\u8d44\u91c7\u8d2d\u5408\u540c");
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("\u672c\u6b21\u9a8c\u6536\u5355\u91d1\u989d\uff1a").append(checkTaxMny).append("\u5143\uff0c\u8be5\u5408\u540c\u4e0b\u9a8c\u6536\u5355\u603b\u91d1\u989d").append(allCheckTaxMny).append("\u5143\uff0c\u6d88\u8017\u6750\u5408\u540c\u91d1\u989d*").append(roleValue).append("% = ").append(comMny).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)allCheckTaxMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                    paramsCheckDsVO.setContent(stringBuffer.toString());
                    checkDsVOS.add(paramsCheckDsVO);
                    this.logger.info("paramsCheckDsVO:{}", (Object)JSONObject.toJSONString((Object)paramsCheckDsVO));
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    public CostCtrlVO sjCost(CheckVO vo) {
        List checkDetailList = vo.getCheckDetailList();
        if (CollectionUtils.isNotEmpty((Collection)checkDetailList)) {
            HashMap<Long, CostCtrlDetailVO> map = new HashMap<Long, CostCtrlDetailVO>();
            for (CheckDetailVO checkDetailVO : checkDetailList) {
                CostCtrlDetailVO costCtrlDetailVO;
                BigDecimal checkTaxMny;
                if (null == checkDetailVO.getSubjectId() || "del".equals(checkDetailVO.getRowState())) continue;
                BigDecimal checkMny = checkDetailVO.getCheckMny() == null ? BigDecimal.ZERO : checkDetailVO.getCheckMny();
                BigDecimal bigDecimal = checkTaxMny = checkDetailVO.getCheckTaxMny() == null ? BigDecimal.ZERO : checkDetailVO.getCheckTaxMny();
                if (map.containsKey(checkDetailVO.getSubjectId())) {
                    costCtrlDetailVO = (CostCtrlDetailVO)map.get(checkDetailVO.getSubjectId());
                    BigDecimal mny = costCtrlDetailVO.getMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getMny();
                    BigDecimal taxMny = costCtrlDetailVO.getTaxMny() == null ? BigDecimal.ZERO : costCtrlDetailVO.getTaxMny();
                    costCtrlDetailVO.setMny(mny.add(checkMny));
                    costCtrlDetailVO.setTaxMny(taxMny.add(checkTaxMny));
                    continue;
                }
                costCtrlDetailVO = new CostCtrlDetailVO();
                costCtrlDetailVO.setSubjectId(checkDetailVO.getSubjectId());
                costCtrlDetailVO.setMny(checkMny);
                costCtrlDetailVO.setTaxMny(checkTaxMny);
                map.put(checkDetailVO.getSubjectId(), costCtrlDetailVO);
            }
            if (null != map && map.size() > 0) {
                CostCtrlVO ctrlVO = new CostCtrlVO();
                if (null != vo.getId()) {
                    ctrlVO.setSourceId(vo.getId());
                }
                ctrlVO.setOrgId(vo.getOrgId());
                ctrlVO.setProjectId(vo.getProjectId());
                ctrlVO.setDetailList(new ArrayList(map.values()));
                return ctrlVO;
            }
            return null;
        }
        return null;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(CheckVO vo) {
        CommonResponse billParamByCode;
        List list;
        BigDecimal mny;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        BigDecimal contractTaxMny = BigDecimal.ZERO;
        BigDecimal totalMny = mny = null == vo.getCheckAllTaxMny() ? BigDecimal.ZERO : vo.getCheckAllTaxMny();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(CheckEntity::getProjectId, (Object)vo.getProjectId());
        wrapper.isNull(CheckEntity::getContractId);
        if (null != vo.getId()) {
            wrapper.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)wrapper)))) {
            BigDecimal totalTaxMny = list.stream().filter(e -> null != e.getCheckAllTaxMny()).map(CheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)totalTaxMny);
        }
        LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
        wrapper2.eq(ConcreteCheckEntity::getProjectId, (Object)vo.getProjectId());
        wrapper2.isNull(ConcreteCheckEntity::getContractId);
        List list2 = this.concreteCheckService.list((Wrapper)wrapper2);
        if (CollectionUtils.isNotEmpty((Collection)list2)) {
            BigDecimal totalTaxMny = list2.stream().filter(e -> null != e.getCheckAllTaxMny()).map(ConcreteCheckEntity::getCheckAllTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)totalTaxMny);
        }
        CommonResponse response = this.temporaryUseRecordApi.queryProTemporaryUseRecordMny(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee\uff1a{}-\u4e0b\u6240\u6709\u72b6\u6001\u7684\u3010\u4e34\u65f6\u8bbe\u5907\u4f7f\u7528\u8bb0\u5f55\u91d1\u989d\u3011\u91d1\u989d\u7ed3\u679c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)response));
        if (response.isSuccess() && null != response.getData()) {
            BigDecimal useMny = ((JSONObject)response.getData()).getBigDecimal("useMny");
            totalMny = ComputeUtil.safeAdd((BigDecimal)totalMny, (BigDecimal)useMny);
        }
        CommonResponse commonResponse = this.proincomeContrantApi.queryContranctMny(vo.getProjectId());
        this.logger.info("\u8be5\u9879\u76ee:{}-\u4e0b\u751f\u6548\u7684\u6700\u65b0\u6b63\u5f0f\u65bd\u5de5\u5408\u540c:{}", (Object)vo.getProjectId(), (Object)JSONObject.toJSONString((Object)commonResponse));
        if (commonResponse.isSuccess() && null != commonResponse.getData()) {
            BigDecimal bigDecimal = contractTaxMny = null == ((ContractRegisterVO)commonResponse.getData()).getContractTaxMny() ? BigDecimal.ZERO : ((ContractRegisterVO)commonResponse.getData()).getContractTaxMny();
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CON_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u3010\u65bd\u5de5\u5408\u540c\u91d1\u989d\u3011\u63a7\u3010\u65e0\u5408\u540c\u9a8c\u6536\u3001\u96f6\u661f\u673a\u68b0\u91d1\u989d\u3011\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100"));
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u65e0\u5408\u540c\u9a8c\u6536\u3001\u4e34\u673a\u8d39\u7528\u8d85\u65bd\u5de5\u5408\u540c\u989d");
                        paramsCheckDsVO.setWarnName("\u65e0\u5408\u540c\u9a8c\u6536\u3001\u4e34\u673a\u8d39\u7528\u7d2f\u8ba1\u91d1\u989d\u8d85\u65bd\u5de5\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(mny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u96f6\u6750\u3001\u96f6\u673a\u53d1\u751f\u91d1\u989d\uff1a").append(totalMny.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMny, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public ParamsCheckVO priceCheckParams(CheckVO vo) {
        MaterialPriceHistoryApiVO materialPriceHistoryApiVO = new MaterialPriceHistoryApiVO();
        materialPriceHistoryApiVO.setPriceCheckType(MaterialPriceCheckTypeEnum.\u6d88\u8017\u6750\u9a8c\u6536.getCode());
        ArrayList<MaterialPriceHistoryApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialPriceHistoryApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getCheckDetailList())) {
            for (CheckDetailVO detailVO : vo.getCheckDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialPriceHistoryApiVO priceHistoryApiVO = new MaterialPriceHistoryApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getCheckPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getCheckTaxPrice());
                priceHistoryApiVO.setHistoryTaxPriceArea(detailVO.getHistoryTaxPriceArea());
                priceHistoryApiVO.setHistoryPriceArea(detailVO.getHistoryPriceArea());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setMaterialPriceHistoryApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.priceHistoryService.priceCheckParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    public ParamsCheckVO costPriceCheckParams(CheckVO vo) {
        MaterialCostPriceApiVO materialPriceHistoryApiVO = new MaterialCostPriceApiVO();
        materialPriceHistoryApiVO.setPriceCheckType(MaterialCostPriceCheckTypeEnum.\u6d88\u8017\u6750\u9a8c\u6536.getCode());
        ArrayList<MaterialCostPriceApiVO> materialPriceHistoryApiVOS = new ArrayList<MaterialCostPriceApiVO>();
        if (CollectionUtil.isNotEmpty((Collection)vo.getCheckDetailList())) {
            for (CheckDetailVO detailVO : vo.getCheckDetailList()) {
                if ("del".equals(detailVO.getRowState()) || detailVO.getMaterialId() == null) continue;
                MaterialCostPriceApiVO priceHistoryApiVO = new MaterialCostPriceApiVO();
                priceHistoryApiVO.setMaterialId(detailVO.getMaterialId());
                priceHistoryApiVO.setMaterialName(detailVO.getMaterialName());
                priceHistoryApiVO.setSpec(detailVO.getSpec());
                priceHistoryApiVO.setPrice(detailVO.getCheckPrice());
                priceHistoryApiVO.setTaxPrice(detailVO.getCheckTaxPrice());
                materialPriceHistoryApiVOS.add(priceHistoryApiVO);
            }
        }
        materialPriceHistoryApiVO.setOrgId(vo.getOrgId());
        materialPriceHistoryApiVO.setProjectId(vo.getProjectId());
        materialPriceHistoryApiVO.setMaterialCostPriceApiVOList(materialPriceHistoryApiVOS);
        ParamsCheckVO paramsCheckVO = this.contractService.costPriceParams(materialPriceHistoryApiVO);
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsCheckNum(BigDecimal checkTaxMny, Long orgId) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_MNY_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6d88\u8017\u6750-\u5355\u6b21\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u63a7\u5236\u63a7\u5236\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (checkTaxMny.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u672c\u6b21\u9a8c\u6536\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u5355\u6b21\u65e0\u5408\u540c\u6750\u6599\u9a8c\u6536\u91d1\u989d\u8d85\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(checkTaxMny.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)checkTaxMny, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsCheckSubNum(BigDecimal currentMny, BigDecimal checkTaxMnyAll, Long orgId) {
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_SUB_MNY_CODE, orgId);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u6d88\u8017\u6750-\u5355\u4e2a\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u63a7\u5236\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (checkTaxMnyAll.compareTo(roleValue) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u4f9b\u5e94\u5546\u65e0\u5408\u540c\u9a8c\u6536\u91d1\u989d\u8d85\u8fc7\u9650\u5b9a\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u91d1\u989d\uff1a").append(currentMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u9a8c\u6536\u91d1\u989d\uff1a").append(checkTaxMnyAll.setScale(2, 4)).append("\u5143\uff0c\u9650\u5b9a\u91d1\u989d\uff1a").append(roleValue.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)checkTaxMnyAll, (BigDecimal)roleValue).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsNum(ContractEntity contractEntity, CheckVO vo) {
        String purchaseType = contractEntity.getPurchaseType();
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        if (PurchaseTypeEnum.\u516c\u53f8\u96c6\u91c7.getCode().equals(purchaseType)) {
            return paramsCheckVOS;
        }
        List<CheckDetailVO> detail = ((CheckMapper)this.baseMapper).getDetail(contractEntity.getId(), vo.getId());
        Map<Long, CheckDetailVO> detailSettleMap = detail.stream().collect(Collectors.toMap(CheckDetailVO::getMaterialId, item -> item, (v1, v2) -> v2));
        Map<Long, ContractDetailEntity> typeMap = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() == null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, item -> item, (v1, v2) -> v2));
        Map<Long, ContractDetailEntity> map = contractEntity.getContractDetailList().stream().filter(t -> t.getMaterialId() != null && !ChangeTypeEnum.\u4e2d\u6b62\u9879.toString().equals(t.getChangeType())).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, item -> item, (v1, v2) -> v2));
        HashMap<Long, BigDecimal> detailTypeMap = new HashMap<Long, BigDecimal>();
        if (CollectionUtils.isNotEmpty(detail)) {
            for (CheckDetailVO checkDetailVO : detail) {
                if (map.containsKey(checkDetailVO.getMaterialId())) continue;
                BigDecimal num = (BigDecimal)detailTypeMap.get(checkDetailVO.getMaterialTypeId());
                if (detailTypeMap.containsKey(checkDetailVO.getMaterialTypeId())) {
                    detailTypeMap.put(checkDetailVO.getMaterialTypeId(), ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)checkDetailVO.getCheckNum()));
                    continue;
                }
                detailTypeMap.put(checkDetailVO.getMaterialTypeId(), checkDetailVO.getCheckNum());
            }
        }
        HashMap<Long, CheckDetailVO> detailMap = new HashMap<Long, CheckDetailVO>();
        if (CollectionUtils.isNotEmpty((Collection)vo.getCheckDetailList())) {
            for (CheckDetailVO detailVO : vo.getCheckDetailList()) {
                if ("del".equals(detailVO.getRowState())) continue;
                CheckDetailVO mapVO = (CheckDetailVO)detailMap.get(detailVO.getMaterialId());
                if (Objects.nonNull(mapVO)) {
                    detailVO.setCheckNum(ComputeUtil.safeAdd((BigDecimal)mapVO.getCheckNum(), (BigDecimal)detailVO.getCheckNum()));
                    detailMap.put(detailVO.getMaterialId(), detailVO);
                } else {
                    detailMap.put(detailVO.getMaterialId(), detailVO);
                }
                if (map.containsKey(detailVO.getMaterialId())) continue;
                BigDecimal num = (BigDecimal)detailTypeMap.get(detailVO.getMaterialTypeId());
                if (detailTypeMap.containsKey(detailVO.getMaterialTypeId())) {
                    detailTypeMap.put(detailVO.getMaterialTypeId(), ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)detailVO.getCheckNum()));
                    continue;
                }
                detailTypeMap.put(detailVO.getMaterialTypeId(), detailVO.getCheckNum());
            }
        }
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u5165\u5e93\u6570\u91cf\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (CollectionUtils.isNotEmpty(detailMap.values())) {
                        for (CheckDetailVO detailVO : detailMap.values()) {
                            ContractDetailEntity detailEntity;
                            BigDecimal num = detailSettleMap.containsKey(detailVO.getMaterialId()) ? detailSettleMap.get(detailVO.getMaterialId()).getCheckNum() : BigDecimal.ZERO;
                            BigDecimal totalNum = ComputeUtil.safeAdd((BigDecimal)num, (BigDecimal)detailVO.getCheckNum()).setScale(4, 4);
                            BigDecimal numType = detailTypeMap.containsKey(detailVO.getMaterialTypeId()) ? (BigDecimal)detailTypeMap.get(detailVO.getMaterialTypeId()) : BigDecimal.ZERO;
                            BigDecimal comNum = BigDecimal.ZERO;
                            if (map.containsKey(detailVO.getMaterialId())) {
                                detailEntity = map.get(detailVO.getMaterialId());
                                comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailEntity.getNum(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                            } else if (typeMap.containsKey(detailVO.getMaterialTypeId())) {
                                detailEntity = typeMap.get(detailVO.getMaterialTypeId());
                                comNum = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)detailEntity.getNum(), (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(4, 4);
                                totalNum = numType;
                            } else {
                                comNum = BigDecimal.ZERO;
                            }
                            if (totalNum.compareTo(comNum) <= 0) continue;
                            ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                            paramsCheckDsVO.setOrgName(datum.getOrgName());
                            paramsCheckDsVO.setWarnItem(detailVO.getMaterialName() + "+" + detailVO.getSpec());
                            paramsCheckDsVO.setWarnName("\u5165\u5e93\u6570\u91cf\u5927\u4e8e\u5408\u540c\u6570\u91cf");
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("\u672c\u6b21\u5165\u5e93\u6570\u91cf\uff1a").append(detailVO.getCheckNum().setScale(4, 4)).append("\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5165\u5e93\u6570\u91cf\uff1a").append(totalNum.setScale(4, 4)).append("\uff0c\u5408\u540c\u6570\u91cf*").append(roleValue).append("%:").append(comNum.setScale(4, 4)).append("\u3002\u8d85\u51fa\u6570\u91cf\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalNum, (BigDecimal)comNum).setScale(4, 4));
                            paramsCheckDsVO.setContent(stringBuffer.toString());
                            checkDsVOS.add(paramsCheckDsVO);
                        }
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOS.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOS;
    }

    @Override
    public CheckEntity syncCost(Long id) {
        CheckEntity checkEntity = (CheckEntity)((Object)super.selectById((Serializable)id));
        ExecutionVO executionVO = this.targetCost(checkEntity);
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25:" + response.getMsg());
        }
        return checkEntity;
    }

    @Override
    public CheckVO queryDetailWeigh(CheckVO vo) {
        CheckVO checkVO = this.deliveryService.queryDetailToCheck(vo.getDeliveryId());
        this.logger.info("----\u78c5\u5355\u9a8c\u6536\u539f\u6570\u636e \uff1a{}", (Object)JSONObject.toJSONString((Object)checkVO));
        List checkDetailList = checkVO.getCheckDetailList();
        List checkWeighList = vo.getCheckWeighList();
        ArrayList<CheckWeighVO> checkWeighVOS = new ArrayList<CheckWeighVO>();
        if (CollectionUtils.isNotEmpty((Collection)checkWeighList)) {
            List collect = checkWeighList.stream().filter(item -> null != item.getId()).map(item -> item.getId()).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.weighbillApi.queryWeighbills(checkVO.getProjectId(), collect);
            if (!listCommonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u78c5\u5355\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + listCommonResponse.getMsg());
            }
            List data = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (WeighbillVO weighbillVO : data) {
                    CheckWeighVO checkWeighVO = (CheckWeighVO)BeanMapper.map((Object)weighbillVO, CheckWeighVO.class);
                    BigDecimal netWeight = weighbillVO.getNetWeight();
                    BigDecimal coefficient = weighbillVO.getCoefficient();
                    String weightUnit = weighbillVO.getWeightUnit();
                    Map<String, BigDecimal> checkNumMap = this.getCheckNum(weightUnit, netWeight, coefficient);
                    checkWeighVO.setCheckNum(checkNumMap.get("checkNum"));
                    checkWeighVO.setDetailNetWeightCoefficient(checkNumMap.get("detailNetWeightCoefficient"));
                    checkWeighVO.setWeightId(weighbillVO.getId());
                    checkWeighVO.setCheckId(null);
                    checkWeighVO.setId(null);
                    checkWeighVO.setWeighMemo(weighbillVO.getMemo());
                    checkWeighVO.setRowState("add");
                    checkWeighVOS.add(checkWeighVO);
                }
                Map<Long, List<CheckWeighVO>> weighMap = checkWeighVOS.stream().filter(t -> null != t.getDeliveryDetailId()).collect(Collectors.groupingBy(CheckWeighVO::getDeliveryDetailId));
                if (CollectionUtils.isNotEmpty((Collection)checkDetailList)) {
                    for (CheckDetailVO checkDetailVO : checkDetailList) {
                        List<CheckWeighVO> checkWeighS = weighMap.get(checkDetailVO.getDeliveryDetailId());
                        if (null != checkWeighS && CollectionUtils.isNotEmpty(checkWeighS)) {
                            BigDecimal checkNum = checkWeighS.stream().map(CheckWeighVO::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal detailNetWeightCoefficient = checkWeighS.stream().map(CheckWeighVO::getDetailNetWeightCoefficient).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal netWeight = checkWeighS.stream().map(CheckWeighVO::getNetWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            checkDetailVO.setDetailNetWeight(netWeight);
                            checkDetailVO.setDetailNetWeightCoefficient(detailNetWeightCoefficient);
                            checkDetailVO.setDetailCoefficient(ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)checkNum));
                            checkDetailVO.setCheckNum(checkNum);
                            continue;
                        }
                        checkDetailVO.setDetailNetWeightCoefficient(BigDecimal.ZERO);
                        checkDetailVO.setDetailNetWeight(BigDecimal.ZERO);
                        checkDetailVO.setDetailCoefficient(BigDecimal.ZERO);
                        checkDetailVO.setCheckNum(BigDecimal.ZERO);
                    }
                }
            }
        }
        checkVO.setCheckWeighType(CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode());
        checkVO.setCheckDetailList(checkDetailList);
        checkVO.setCheckWeighList(checkWeighVOS);
        return checkVO;
    }

    public Map<String, BigDecimal> getCheckNum(String weighUnit, BigDecimal netWeight, BigDecimal coefficient) {
        BigDecimal checkNum = BigDecimal.ZERO;
        BigDecimal detailNetWeightCoefficient = BigDecimal.ZERO;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (null == coefficient) {
            coefficient = BigDecimal.ZERO;
        }
        if (null == netWeight) {
            netWeight = BigDecimal.ZERO;
        }
        Integer billStateCode = 0;
        if (StringUtils.isNotEmpty((String)weighUnit)) {
            billStateCode = WeighUnitEnum.getEnumByStateCode((String)weighUnit).getBillStateCode();
        }
        switch (billStateCode) {
            case 0: {
                detailNetWeightCoefficient = netWeight;
                checkNum = ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)coefficient);
                break;
            }
            case 1: {
                detailNetWeightCoefficient = ComputeUtil.safeMultiply((BigDecimal)netWeight, (BigDecimal)new BigDecimal("1000"));
                checkNum = ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)coefficient);
            }
        }
        map.put("checkNum", checkNum);
        map.put("detailNetWeightCoefficient", detailNetWeightCoefficient);
        return map;
    }

    @Override
    public Map<String, Integer> countBillNum(Long projectId, Date checkDate) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(CheckEntity::getProjectId, (Object)projectId)).eq(CheckEntity::getCheckDate, (Object)checkDate);
        int checkCount = super.count((Wrapper)lambdaQuery);
        resultMap.put("\u6d88\u8017\u6750", checkCount);
        LambdaQueryWrapper lambdaQuery1 = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery1.eq(ConcreteCheckEntity::getProjectId, (Object)projectId)).eq(ConcreteCheckEntity::getCheckDate, (Object)checkDate);
        int concreteCheckCount = this.concreteCheckService.count((Wrapper)lambdaQuery1);
        resultMap.put("\u6df7\u51dd\u571f", concreteCheckCount);
        return resultMap;
    }

    @Override
    public BigDecimal getSupplierNoContractMny(Long projectId, Long supplierId) {
        List concreteCheckList;
        BigDecimal rtnBig = BigDecimal.ZERO;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("projectId", new Parameter("eq", (Object)projectId));
        queryParam.getParams().put("supplierId", new Parameter("eq", (Object)supplierId));
        queryParam.getParams().put("contractId", new Parameter("eq", null));
        List checkList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            rtnBig = checkList.stream().map(CheckEntity::getCheckAllTaxMny).reduce(rtnBig, BigDecimal::add);
        }
        if (CollectionUtils.isNotEmpty((Collection)(concreteCheckList = this.concreteCheckService.queryList(queryParam, false)))) {
            rtnBig = concreteCheckList.stream().map(ConcreteCheckEntity::getCheckAllTaxMny).reduce(rtnBig, BigDecimal::add);
        }
        return rtnBig;
    }

    @Override
    public void inStore(CheckEntity checkEntity) {
        ContractEntity contractEntity = null;
        if (checkEntity.getContractId() != null) {
            contractEntity = (ContractEntity)((Object)this.contractService.selectById(checkEntity.getContractId()));
        }
        StoreManageVO storeManageVO = new StoreManageVO();
        storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
        storeManageVO.setStoreId(checkEntity.getStoreId());
        storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
        storeManageVO.setSourceId(checkEntity.getId());
        ArrayList<FlowVO> flowVOS = new ArrayList<FlowVO>();
        for (int i = 0; i < checkEntity.getCheckDetailList().size(); ++i) {
            FlowVO flowVO = new FlowVO();
            flowVO = null != contractEntity && "proMaterial-2".equals(contractEntity.getContractPropertyCode()) ? StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u5468\u8f6c\u6750\u6536\u6599\u5165\u5e93, (Integer)0) : StoreManageUtil.getFlowVO((InOutTypeEnum)InOutTypeEnum.\u6536\u6599\u5165\u5e93, (Integer)0);
            this.getFlow(checkEntity, checkEntity.getCheckDetailList().get(i), flowVO, contractEntity);
            flowVOS.add(flowVO);
        }
        storeManageVO.setFlowVOList(flowVOS);
        String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
        this.logger.info("\u6d88\u8017\u6750\u9a8c\u6536\u5165\u5e93\u53c2\u6570\uff1a" + stringInfo);
        CommonResponse response = this.storeManageApi.inOutStore(storeManageVO);
        if (!response.isSuccess()) {
            this.logger.info("\u6d4b\u8bd5\u62a5\u951901");
            throw new BusinessException("\u8c03\u7528\u5e93\u5b58\u7ba1\u7406\u5931\u8d25,\u9519\u8bef\u4fe1\u606f" + response.getMsg());
        }
    }

    private void getFlow(CheckEntity checkEntity, CheckDetailEntity t, FlowVO flowVO, ContractEntity contractEntity) {
        flowVO.setConsumableFlag(t.getConsumableFlag());
        flowVO.setProjectId(checkEntity.getProjectId());
        flowVO.setTaxRate(t.getTaxRate());
        flowVO.setProjectName(checkEntity.getProjectName());
        flowVO.setParentOrgId(checkEntity.getParentOrgId());
        flowVO.setParentOrgName(checkEntity.getParentOrgName());
        flowVO.setOrgId(checkEntity.getOrgId());
        flowVO.setOrgName(checkEntity.getOrgName());
        flowVO.setStoreId(checkEntity.getStoreId());
        flowVO.setStoreName(checkEntity.getStoreName());
        flowVO.setEmployeeId(checkEntity.getEmployeeId());
        flowVO.setEmployeeName(checkEntity.getEmployeeName());
        flowVO.setMaterialType(checkEntity.getCheckType());
        flowVO.setMaterialTypeName(checkEntity.getCheckTypeName());
        flowVO.setSupplierId(checkEntity.getSupplierId());
        flowVO.setSupplierName(checkEntity.getSupplierName());
        flowVO.setPurchaseContractId(checkEntity.getContractId());
        flowVO.setPurchaseContractName(checkEntity.getContractName());
        flowVO.setMaterialCategoryId(t.getMaterialTypeId());
        flowVO.setMaterialCategoryName(t.getMaterialTypeName());
        flowVO.setMaterialId(t.getMaterialId());
        flowVO.setMaterialName(t.getMaterialName());
        flowVO.setMaterialCode(t.getMaterialCode());
        flowVO.setMaterialSpec(t.getSpec());
        flowVO.setMaterialUnitId(t.getUnitId());
        flowVO.setMaterialUnitName(t.getUnit());
        flowVO.setCusDef8(null != t.getDeliveryDate() ? DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)t.getDeliveryDate()) : null);
        flowVO.setTaxPrice(t.getCheckTaxPrice());
        flowVO.setPrice(t.getCheckPrice());
        flowVO.setNum(t.getCheckNum());
        flowVO.setTaxMny(t.getCheckTaxMny());
        flowVO.setMny(t.getCheckMny());
        flowVO.setTax(t.getTaxMny());
        flowVO.setPickUnitId(checkEntity.getSubSupplierId());
        flowVO.setPickUnitName(checkEntity.getSubSupplierName());
        flowVO.setPickContractId(checkEntity.getSubContractId());
        flowVO.setPickContractName(checkEntity.getSubContractName());
        flowVO.setSourceId(checkEntity.getId());
        flowVO.setSourceDetailId(t.getId());
        flowVO.setSourceBillCode(checkEntity.getBillCode());
        flowVO.setSourceBillDate(checkEntity.getCheckDate());
        flowVO.setSourceBillRemark(checkEntity.getMemo());
        flowVO.setSourceBillDetailRemark(t.getMemo());
        flowVO.setSourceBillTypeName("\u6750\u6599\u9a8c\u6536");
        flowVO.setSourceBillTypeCode(BILL_TYPE);
        flowVO.setSourceType(checkEntity.getSourceType());
        flowVO.setPickType(checkEntity.getSubOutType());
        flowVO.setLicensePlate(checkEntity.getLicensePlate());
        flowVO.setFinanceId(t.getFinanceId());
        flowVO.setFinanceName(t.getFinanceName());
        if (null != checkEntity.getContractId() && null != contractEntity) {
            List<ContractDetailEntity> contractDetailList = contractEntity.getContractDetailList();
            Map sourceIdMap = contractDetailList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            Map DetailMaterialIdMap = contractDetailList.stream().filter(e -> e.getMaterialId() != null).collect(Collectors.toMap(ContractDetailEntity::getMaterialId, Function.identity()));
            Map DetailMaterialIdTypeMap = contractDetailList.stream().filter(e -> e.getMaterialId() == null).collect(Collectors.toMap(ContractDetailEntity::getMaterialTypeId, Function.identity()));
            ContractDetailEntity contractDetailEntity = (ContractDetailEntity)((Object)sourceIdMap.get(t.getSourceId()));
            if (null != contractDetailEntity) {
                flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                flowVO.setContractPrice(contractDetailEntity.getPrice());
            } else {
                contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdMap.get(t.getMaterialId()));
                if (null != contractDetailEntity) {
                    flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                    flowVO.setContractPrice(contractDetailEntity.getPrice());
                } else {
                    contractDetailEntity = (ContractDetailEntity)((Object)DetailMaterialIdTypeMap.get(t.getMaterialTypeId()));
                    if (null != contractDetailEntity) {
                        flowVO.setContractTaxPrice(contractDetailEntity.getDetailTaxPrice());
                        flowVO.setContractPrice(contractDetailEntity.getPrice());
                    } else {
                        flowVO.setContractTaxPrice(BigDecimal.ZERO);
                        flowVO.setContractPrice(BigDecimal.ZERO);
                    }
                }
            }
        }
        flowVO.setRowState(t.getRowState());
    }
}

