/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.promaterial.check.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.promaterial.check.bean.CheckEntity;
import com.ejianc.business.promaterial.check.bean.CheckStoreEntity;
import com.ejianc.business.promaterial.check.service.ICheckService;
import com.ejianc.business.promaterial.check.service.ICheckStoreService;
import com.ejianc.business.store.api.IStoreManageApi;
import com.ejianc.business.store.consts.InOutTypeEnum;
import com.ejianc.business.store.vo.StoreManageVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkStore")
public class CheckStoreBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private ICheckStoreService service;
    @Autowired
    private IStoreManageApi storeManageApi;
    @Autowired
    private ICheckService checkService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CheckStoreEntity entity = (CheckStoreEntity)((Object)this.service.selectById(billId));
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        wrapper.set(CheckEntity::getStoreFlag, (Object)1);
        this.checkService.update((Wrapper)wrapper);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(CheckStoreEntity::getStoreFlag, (Object)1);
        this.service.update((Wrapper)updateWrapper);
        this.service.inStore(entity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CheckStoreEntity entity = (CheckStoreEntity)((Object)this.service.selectById(billId));
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        wrapper.set(CheckEntity::getStoreFlag, (Object)0);
        this.checkService.update((Wrapper)wrapper);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(BaseEntity::getId, new Object[]{entity.getId()});
        updateWrapper.set(CheckStoreEntity::getStoreFlag, (Object)0);
        this.service.update((Wrapper)updateWrapper);
        if (entity.getStoreType() == 0 && entity.getStoreFlag() == 1) {
            ArrayList<Long> ids = new ArrayList<Long>();
            ids.add(billId);
            StoreManageVO storeManageVO = new StoreManageVO();
            storeManageVO.setSourceId(entity.getId());
            storeManageVO.setInOutTypeEnum(InOutTypeEnum.\u6536\u6599\u5165\u5e93);
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setOutEffectiveON(Boolean.valueOf(true));
            String stringInfo = JSONObject.toJSONString((Object)storeManageVO);
            this.logger.info("\u6d88\u8017\u6750\u64a4\u56de\u53c2\u6570\uff1a" + stringInfo);
            CommonResponse response = this.storeManageApi.inOutStoreRollback(storeManageVO);
            if (!response.isSuccess()) {
                return CommonResponse.error((String)response.getMsg());
            }
            this.logger.info("xhc\u63a8\u9001\u4ed3\u5e93\u6210\u529f:" + response.getMsg());
        }
        return CommonResponse.success();
    }
}

